/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs.logs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import org.netbeans.modules.distributed.common.util.MyMemoryHandler;
import org.netbeans.modules.distributed.common.util.MyStreamHandler;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPLogCookie;
import org.netbeans.modules.distributed.remotefs.ftpfs.logs.FTPStopLogAction;
import org.netbeans.modules.project.ui.OpenProjectList;
import org.openide.actions.OpenAction;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileSystem;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class FTPLogNode
extends AbstractNode
implements Node.Cookie {
    private String logID;
    private String fsName;
    private SystemAction action;

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)OpenAction.class), SystemAction.get((Class)FTPStopLogAction.class)};
    }

    public Action getPreferredAction() {
        return new OpenAction();
    }

    public FTPLogNode(final String string) {
        super(Children.LEAF);
        this.logID = string;
        this.fsName = string.substring(0, string.lastIndexOf(File.separatorChar));
        this.setName(string.toString());
        if (string.endsWith("sync")) {
            this.setDisplayName("Synchronize");
        } else if (string.endsWith("getall")) {
            this.setDisplayName("Get All Files From the Server");
        } else if (string.endsWith("putall")) {
            this.setDisplayName("Put All Files to the Server");
        } else if (string.endsWith("refresh")) {
            this.setDisplayName("Refresh");
        }
        this.getCookieSet().add((Node.Cookie)new OpenCookie(){

            public void open() {
                if (string.endsWith("sync")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName((String)FTPLogNode.this.fsName, (String)"sync"));
                } else if (string.endsWith("putall")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName((String)FTPLogNode.this.fsName, (String)"putall"));
                } else if (string.endsWith("getall")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName((String)FTPLogNode.this.fsName, (String)"getall"));
                } else if (string.endsWith("refresh")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName((String)FTPLogNode.this.fsName, (String)"refresh"));
                }
            }
        });
        this.getCookieSet().add((Node.Cookie)new FTPLogCookie(){

            public String getName() {
                if (string.endsWith("sync")) {
                    return "sync";
                }
                if (string.endsWith("putall")) {
                    return "putall";
                }
                if (string.endsWith("getall")) {
                    return "getall";
                }
                return null;
            }

            public void stop() {
                block3: {
                    block5: {
                        block4: {
                            if (!string.endsWith("sync")) break block4;
                            Iterator iterator = OpenProjectList.getFsSet().iterator();
                            while (iterator.hasNext()) {
                                FileSystem fileSystem = (FileSystem)iterator.next();
                                if (!(fileSystem instanceof FTPFileSystem) || !((FTPFileSystem)fileSystem).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                                ((FTPFileSystem)fileSystem).setStopSyncAll(true);
                                break block3;
                            }
                            break block3;
                        }
                        if (!string.endsWith("putall")) break block5;
                        Iterator iterator = OpenProjectList.getFsSet().iterator();
                        while (iterator.hasNext()) {
                            FileSystem fileSystem = (FileSystem)iterator.next();
                            if (!(fileSystem instanceof FTPFileSystem) || !((FTPFileSystem)fileSystem).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                            ((FTPFileSystem)fileSystem).setStopUploadAll(true);
                            break block3;
                        }
                        break block3;
                    }
                    if (!string.endsWith("getall")) break block3;
                    Iterator iterator = OpenProjectList.getFsSet().iterator();
                    while (iterator.hasNext()) {
                        FileSystem fileSystem = (FileSystem)iterator.next();
                        if (!(fileSystem instanceof FTPFileSystem) || !((FTPFileSystem)fileSystem).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                        ((FTPFileSystem)fileSystem).setStopDownloadAll(true);
                        break;
                    }
                }
            }
        });
        this.getCookieSet().add((Node.Cookie)this);
    }

    private void displayToOutputPane(String string) {
        InputOutput inputOutput = IOProvider.getDefault().getIO(string, false);
        if (inputOutput != null) {
            try {
                inputOutput.getOut().reset();
                inputOutput.closeInputOutput();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        inputOutput = IOProvider.getDefault().getIO(string, true);
        inputOutput.select();
        inputOutput.setFocusTaken(true);
        inputOutput.setErrVisible(true);
        inputOutput.setOutputVisible(true);
        inputOutput.setErrSeparated(false);
        Logger logger = Logger.getLogger(this.logID);
        Handler[] handlerArray = logger.getHandlers();
        MyMemoryHandler myMemoryHandler = null;
        for (int i = 0; handlerArray != null && i < handlerArray.length; ++i) {
            if (!(handlerArray[i] instanceof MyMemoryHandler)) continue;
            myMemoryHandler = (MyMemoryHandler)handlerArray[i];
            MyStreamHandler myStreamHandler = (MyStreamHandler)myMemoryHandler.getHandler();
            myStreamHandler.setOutputStream((OutputStream)new OutputStreamOutputPane(inputOutput.getOut()));
            break;
        }
        if (myMemoryHandler != null) {
            myMemoryHandler.push();
            myMemoryHandler.setPushLevel(Level.ALL);
        }
    }

    public void setIcon(String string) {
        this.setIconBase(string);
    }

    public void destroy() throws IOException {
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    class OutputStreamOutputPane
    extends OutputStream {
        private OutputWriter io;

        public OutputStreamOutputPane(OutputWriter outputWriter) {
            this.io = outputWriter;
        }

        public void close() {
            this.io.close();
        }

        public void flush() {
            this.io.flush();
        }

        public void write(int n) {
            if (n == 10) {
                this.io.println();
            } else {
                this.io.print((char)n);
            }
        }
    }
}

