/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.ftpfs;

import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.common.util.FileUtility;
import org.netbeans.modules.distributed.common.util.Utils;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.explorer.LookupPanel;
import org.netbeans.modules.distributed.ideserverclient.explorer.PasswordPanel;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.remotefs.ftpfs.LogInfo;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteClient;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteDefaultAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileAttributes;
import org.netbeans.modules.distributed.remotefs.ftpfs.RemoteFileName;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.ConnectAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.FTPActions;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.FTPRecurseRefreshAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.FTPRefreshAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.actions.SynchResidenceAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.ftpclient.FTPLogInfo;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.AbstractFileSystem;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.ExtensionList;
import org.openide.util.RequestProcessor;
import org.openide.util.SharedClassObject;
import org.openide.util.actions.SystemAction;

public abstract class RemoteFileSystem
extends AbstractFileSystem
implements AbstractFileSystem.List,
AbstractFileSystem.Info,
AbstractFileSystem.Change,
RemoteFile.Notify,
RemoteFile.RequestProcessor,
Runnable {
    static final long serialVersionUID = 5562503683369874863L;
    private static final boolean DEBUG = true;
    private static final String DEVICE = "sys$disk:";
    protected transient RemoteClient client;
    protected transient RemoteFile rootFile;
    protected File cachedir = null;
    protected String startdir = "/";
    protected LogInfo loginfo;
    protected boolean readOnly;
    protected boolean confirmDeleteAlways = true;
    protected boolean autoSync = true;
    protected boolean displayStatus = true;
    protected boolean ignoreHiddenFiles = true;
    protected boolean keepItConnected = true;
    private Boolean useXtermCompile;
    private Boolean useXtermExecution;
    private Integer xDisplayNumber;
    protected boolean ftpPassiveMode;
    protected boolean SSHForwarding;
    private transient Object downloadAllLock = new Object();
    private transient Object uploadAllLock = new Object();
    private transient Object synchLock = new Object();
    private transient boolean stopDownloadAll = false;
    private transient boolean stopUploadAll = false;
    private transient boolean stopSyncAll = false;
    private transient boolean printDownloadStop = true;
    private transient boolean printUploadStop = true;
    private transient boolean printSyncAllStop = true;
    protected char[] password;
    private transient LookupPanel rpanel = null;
    protected transient RequestProcessor requestproc;
    private ExtensionList backupExtensions;
    private transient Dialog myDialog = null;
    private transient PasswordPanel passpanel = null;
    private static ExtensionList DEFAULT_EXTENSIONS = new ExtensionList();
    private static ExtensionList DEFAULT_SERVER_ONLY_EXTENSIONS = new ExtensionList();
    private static ExtensionList DEFAULT_ASCII_EXTENSIONS = new ExtensionList();
    public static final String BACKUP_EXT = System.getProperty("org.netbeans.core.ExLocalFileSystem.BACKUP_EXT", "~");
    private ExtensionList ignoredFiles;
    private ExtensionList ignoredFolders;
    private transient Pattern ignoredRE;
    private static final String IGNORED_FILES_PROP = "netbeans.ignored.files";
    private ExtensionList asciiFileExts;
    private ExtensionList serverOnlyFileExts;

    private static void setDefaultServerOnlyExtension() {
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("obj");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("exe");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("pen");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("tlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("bck");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("iis");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("pcsi");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("olb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("ana");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("r32");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("req");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("tif");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("mlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("nlb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("uid");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("stb");
        DEFAULT_SERVER_ONLY_EXTENSIONS.addExtension("esw");
    }

    private static void setDefaultAsciiExtension() {
        DEFAULT_ASCII_EXTENSIONS.addExtension("acf");
        DEFAULT_ASCII_EXTENSIONS.addExtension("ada");
        DEFAULT_ASCII_EXTENSIONS.addExtension("b32");
        DEFAULT_ASCII_EXTENSIONS.addExtension("b64");
        DEFAULT_ASCII_EXTENSIONS.addExtension("bas");
        DEFAULT_ASCII_EXTENSIONS.addExtension("bli");
        DEFAULT_ASCII_EXTENSIONS.addExtension("c");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cld");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cob");
        DEFAULT_ASCII_EXTENSIONS.addExtension("com");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cpp");
        DEFAULT_ASCII_EXTENSIONS.addExtension("cxx");
        DEFAULT_ASCII_EXTENSIONS.addExtension("dat");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f4");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f77");
        DEFAULT_ASCII_EXTENSIONS.addExtension("f90");
        DEFAULT_ASCII_EXTENSIONS.addExtension("fdl");
        DEFAULT_ASCII_EXTENSIONS.addExtension("for");
        DEFAULT_ASCII_EXTENSIONS.addExtension("h");
        DEFAULT_ASCII_EXTENSIONS.addExtension("hlp");
        DEFAULT_ASCII_EXTENSIONS.addExtension("htm");
        DEFAULT_ASCII_EXTENSIONS.addExtension("html");
        DEFAULT_ASCII_EXTENSIONS.addExtension("hxx");
        DEFAULT_ASCII_EXTENSIONS.addExtension("idl");
        DEFAULT_ASCII_EXTENSIONS.addExtension("inc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("java");
        DEFAULT_ASCII_EXTENSIONS.addExtension("lis");
        DEFAULT_ASCII_EXTENSIONS.addExtension("log");
        DEFAULT_ASCII_EXTENSIONS.addExtension("m32");
        DEFAULT_ASCII_EXTENSIONS.addExtension("m64");
        DEFAULT_ASCII_EXTENSIONS.addExtension("map");
        DEFAULT_ASCII_EXTENSIONS.addExtension("mar");
        DEFAULT_ASCII_EXTENSIONS.addExtension("mf");
        DEFAULT_ASCII_EXTENSIONS.addExtension("mms");
        DEFAULT_ASCII_EXTENSIONS.addExtension("opt");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pas");
        DEFAULT_ASCII_EXTENSIONS.addExtension("ppp");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pcsi$desc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pcsi$text");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pl");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pl1");
        DEFAULT_ASCII_EXTENSIONS.addExtension("pli");
        DEFAULT_ASCII_EXTENSIONS.addExtension("properties");
        DEFAULT_ASCII_EXTENSIONS.addExtension("ps");
        DEFAULT_ASCII_EXTENSIONS.addExtension("rno");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sc");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sco");
        DEFAULT_ASCII_EXTENSIONS.addExtension("sh");
        DEFAULT_ASCII_EXTENSIONS.addExtension("tex");
        DEFAULT_ASCII_EXTENSIONS.addExtension("txt");
        DEFAULT_ASCII_EXTENSIONS.addExtension("uil");
        DEFAULT_ASCII_EXTENSIONS.addExtension("xml");
    }

    public RemoteFileSystem() {
        RemoteFileSystem.setDefaultServerOnlyExtension();
        RemoteFileSystem.setDefaultAsciiExtension();
        this.ignoredRE = null;
        this.info = this;
        this.change = this;
        InnerAttrs innerAttrs = new InnerAttrs(this, this.info, this.change, this);
        this.attr = innerAttrs;
        this.list = innerAttrs;
    }

    public Object getSynchLock() {
        return this.synchLock;
    }

    public Object getFileAttribute(String string, String string2) {
        return this.attr.readAttribute(string.replace(File.separatorChar, '/'), string2);
    }

    public void setFileAttribute(String string, String string2, Object object) {
        try {
            this.attr.writeAttribute(string.replace(File.separatorChar, '/'), string2, object);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public char[] getOrPromptforPassword() {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        char[] cArray = remoteRuntimeType.getPassword();
        if (cArray == null && !remoteRuntimeType.getSavePassword()) {
            PromptNewPassword promptNewPassword = new PromptNewPassword();
            promptNewPassword.create();
            cArray = promptNewPassword.getPassword();
        }
        return cArray;
    }

    private File getFile(String string) {
        return new File(this.cachedir, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void backupIfNecessary(String string) throws IOException {
        block13: {
            ExtensionList extensionList;
            ExtensionList extensionList2 = extensionList = this.backupExtensions == null ? DEFAULT_EXTENSIONS : this.backupExtensions;
            if (extensionList.isRegistered(string) && !string.toLowerCase().endsWith(".nbattrs~")) {
                InputStream inputStream = null;
                try {
                    inputStream = this.inputStream(string);
                    if (inputStream == null) {
                        return;
                    }
                    String string2 = string + BACKUP_EXT;
                    RemoteFile remoteFile = this.getRemoteFile(string2);
                    OutputStream outputStream = null;
                    if (remoteFile == null) {
                        this.createData(string2);
                    }
                    if ((outputStream = this.outputStream(string2)) == null) break block13;
                    try {
                        FileUtil.copy((InputStream)inputStream, (OutputStream)outputStream);
                    }
                    finally {
                        outputStream.close();
                    }
                }
                catch (FileNotFoundException fileNotFoundException) {
                }
                finally {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
            }
        }
    }

    public void removedFS(FileSystem fileSystem) {
        if (fileSystem == this && this.isConnected()) {
            this.removeClient();
        }
    }

    protected void addedFS(FileSystem fileSystem) throws IOException {
        if (fileSystem == this && !this.isConnected()) {
            this.connectOnBackground();
        }
        Utils.createStatusLogger((String)this.getLocalRoot(), (String)"refresh");
    }

    public void addedFSProjectSwitch(FileSystem fileSystem) {
        if (fileSystem == this && !this.isConnected()) {
            this.connectOnBackground();
        }
    }

    public RemoteFileSystem(FileSystemCapability fileSystemCapability) {
        this();
        this.setCapability(fileSystemCapability);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.asciiFileExts == null) {
            RemoteFileSystem.setDefaultAsciiExtension();
            this.asciiFileExts = (ExtensionList)DEFAULT_ASCII_EXTENSIONS.clone();
        }
        if (this.serverOnlyFileExts == null) {
            RemoteFileSystem.setDefaultServerOnlyExtension();
            this.serverOnlyFileExts = (ExtensionList)DEFAULT_SERVER_ONLY_EXTENSIONS.clone();
        }
        if (this.downloadAllLock == null) {
            this.downloadAllLock = new Object();
        }
        if (this.uploadAllLock == null) {
            this.uploadAllLock = new Object();
        }
        if (this.synchLock == null) {
            this.synchLock = new Object();
        }
        this.stopDownloadAll = false;
        this.stopUploadAll = false;
        this.stopSyncAll = false;
        this.printDownloadStop = true;
        this.printUploadStop = true;
        this.printSyncAllStop = true;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
    }

    public SystemAction[] getActions() {
        SystemAction[] systemActionArray = super.getActions();
        SystemAction[] systemActionArray2 = new SystemAction[systemActionArray.length + 5];
        for (int i = 0; i < systemActionArray.length; ++i) {
            systemActionArray2[i] = systemActionArray[i];
        }
        systemActionArray2[systemActionArray.length] = this.getAction(FTPRefreshAction.class);
        systemActionArray2[systemActionArray.length + 1] = this.getAction(FTPRecurseRefreshAction.class);
        systemActionArray2[systemActionArray.length + 2] = this.getAction(FTPActions.class);
        systemActionArray2[systemActionArray.length + 3] = this.getAction(SynchResidenceAction.class);
        systemActionArray2[systemActionArray.length + 4] = this.getAction(ConnectAction.class);
        ((ConnectAction)systemActionArray2[systemActionArray.length + 4]).setFS(this);
        return systemActionArray2;
    }

    private SystemAction getAction(Class clazz) {
        return (SystemAction)SharedClassObject.findObject((Class)clazz, (boolean)true);
    }

    protected void removeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    public void connectOnBackground() {
        if (this.password == null) {
            this.password = this.getOrPromptforPassword();
        }
        this.setConnected(true, this.password);
        this.post(new Runnable(){

            public void run() {
                if (RemoteFileSystem.this.isConnected()) {
                    Enumeration enumeration = RemoteFileSystem.this.existingFileObjects(RemoteFileSystem.this.getRoot());
                    while (enumeration.hasMoreElements()) {
                        Object e = enumeration.nextElement();
                        if (!((FileObject)e).isFolder()) continue;
                        ((FileObject)e).refresh();
                    }
                }
                RemoteFileSystem.this.password = null;
            }
        }, "");
    }

    public void disconnectOnBackground() {
        this.setConnected(false, null);
    }

    public boolean isConnected() {
        if (this.client == null) {
            return false;
        }
        boolean bl = this.client.isConnected();
        return bl;
    }

    private synchronized void setConnected(boolean bl, char[] cArray) {
        if (cArray == null && bl) {
            return;
        }
        if (!bl) {
            if (this.client != null) {
                this.client.close();
            }
            this.keepItConnected = false;
            this.firePropertyChange("keepItConnected", null, Boolean.FALSE);
            this.firePropertyChange("displayName", null, this.getDisplayName());
        } else {
            boolean bl2 = false;
            try {
                ((FTPLogInfo)this.loginfo).setPassword(cArray);
                this.client = this.createClient(this.loginfo, this.cachedir, this.startdir);
                StatusDisplayer.getDefault().setStatusText("connecting to the FTP server : " + this.loginfo.displayName());
                if (this.client.isConnected()) {
                    this.client.disconnect();
                }
                this.client.connect();
                RemoteFileName remoteFileName = new RemoteFileName(){

                    public String getName() {
                        return RemoteFileSystem.this.startdir;
                    }

                    public void setName(String string) {
                    }

                    public String getFullName() {
                        return RemoteFileSystem.this.startdir;
                    }

                    public RemoteFileName createNew(String string, boolean bl) {
                        return null;
                    }

                    public boolean isDirectory() {
                        return true;
                    }
                };
                RemoteFileAttributes remoteFileAttributes = this.client.listFile("", remoteFileName);
                this.keepItConnected = true;
                this.firePropertyChange("keepItConnected", null, Boolean.TRUE);
                StatusDisplayer.getDefault().setStatusText("succeeded connecting to the FTP server : " + this.loginfo.displayName());
                this.firePropertyChange("displayName", null, this.getDisplayName());
            }
            catch (IOException iOException) {
                if (bl && this.client != null) {
                    this.client.close();
                }
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error while mounting " + RemoteFileSystem.this.getDisplayName() + "\nThe error message was : " + iOException.getMessage()), -1, 2));
                    }
                });
                bl2 = true;
            }
        }
        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, this.getRoot(), true, true));
        this.firePropertyChange("connected", null, this.isConnected() ? Boolean.TRUE : Boolean.FALSE);
    }

    public abstract RemoteClient createClient(LogInfo var1, File var2, String var3) throws IOException;

    protected abstract RemoteFile createRootFile(RemoteClient var1, File var2) throws IOException;

    public void setReadOnly(boolean bl) {
        if (bl != this.readOnly) {
            this.readOnly = bl;
            this.firePropertyChange("readOnly", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void prepareEnvironment(FileSystem.Environment environment) {
        environment.addClassPath(this.cachedir.toString());
    }

    protected abstract void isReadyToModify() throws IOException;

    protected abstract void isReadyToRead() throws IOException;

    protected abstract boolean isReady();

    public RemoteFile getRemoteFile(String string) throws IOException {
        RemoteFile remoteFile = this.rootFile.find(string);
        if (remoteFile == null && (string.endsWith("filesystem.attributes") || string.endsWith(".nbattrs") || string.endsWith(".nbattrs~"))) {
            this.createData(string);
            return this.rootFile.find(string);
        }
        return remoteFile;
    }

    public void synchronize(String string) {
    }

    private void doUploadDone(boolean bl) {
        if (bl) {
            StatusDisplayer.getDefault().setStatusText("Put File To Server Done");
        } else {
            StatusDisplayer.getDefault().setStatusText("Put All Files To Server Done");
        }
        Utils.getStatusLogger((String)this.getLocalRoot(), (String)"putall").info("Done");
        if (this.getRemoteRuntimeType() != null) {
            this.getRemoteRuntimeType().setRemoteServerError(false);
        }
        this.setStopUploadAll(false);
        this.setPrintUploadStop(true);
        this.run();
    }

    public void uploadAll(String string, final boolean bl, final boolean bl2) {
        if (!this.isReady()) {
            return;
        }
        final Logger logger = Utils.getStatusLogger((String)this.getLocalRoot(), (String)"putall");
        try {
            final RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = RemoteFileSystem.this.uploadAllLock;
                        synchronized (object) {
                            if (RemoteFileSystem.this.getStopUploadAll() || RemoteFileSystem.this.getRemoteRuntimeType() != null && RemoteFileSystem.this.getRemoteRuntimeType().getRemoteServerError() || RemoteFileSystem.this.getRemoteRuntimeType() == null) {
                                if (bl) {
                                    RemoteFileSystem.this.doUploadDone(bl2);
                                }
                                return;
                            }
                            try {
                                remoteFile.refresh();
                                if (remoteFile.getFileResidenceMode() == 1 || remoteFile.getFileResidenceMode() == 0) {
                                    if (bl2 && !remoteFile.isDirectory()) {
                                        remoteFile.uploadAll(null);
                                    }
                                } else {
                                    remoteFile.uploadAll(null);
                                }
                            }
                            catch (IOException iOException) {
                                RemoteFileSystem.this.setStopUploadAll(true);
                                RemoteFileSystem.this.setPrintUploadStop(true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 2));
                                    }
                                });
                            }
                            if (RemoteFileSystem.this.getStopUploadAll() && RemoteFileSystem.this.getPrintUploadStop()) {
                                logger.info("Stopped!");
                                RemoteFileSystem.this.setPrintUploadStop(false);
                            } else if ((RemoteFileSystem.this.getRemoteRuntimeType().getRemoteServerError() || RemoteFileSystem.this.getRemoteRuntimeType() == null) && RemoteFileSystem.this.getPrintUploadStop()) {
                                logger.info("Aborted due to disconnected server!");
                                RemoteFileSystem.this.setPrintUploadStop(false);
                            }
                            if (bl) {
                                RemoteFileSystem.this.doUploadDone(bl2);
                            }
                        }
                    }
                }, "putall");
            }
        }
        catch (IOException iOException) {
            logger.info("Stopped!");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 2));
                }
            });
        }
    }

    public boolean getStopDownloadAll() {
        return this.stopDownloadAll;
    }

    public void setStopDownloadAll(boolean bl) {
        this.stopDownloadAll = bl;
    }

    public boolean getStopUploadAll() {
        return this.stopUploadAll;
    }

    public void setStopUploadAll(boolean bl) {
        this.stopUploadAll = bl;
    }

    public boolean getPrintDownloadStop() {
        return this.printDownloadStop;
    }

    public void setPrintDownloadStop(boolean bl) {
        this.printDownloadStop = bl;
    }

    public boolean getPrintUploadStop() {
        return this.printUploadStop;
    }

    public void setPrintUploadStop(boolean bl) {
        this.printUploadStop = bl;
    }

    public boolean getPrintSyncAllStop() {
        return this.printSyncAllStop;
    }

    public void setPrintSyncAllStop(boolean bl) {
        this.printSyncAllStop = bl;
    }

    public boolean getStopSyncAll() {
        return this.stopSyncAll;
    }

    public void setStopSyncAll(boolean bl) {
        this.stopSyncAll = bl;
    }

    private void doDownloadDone(boolean bl) {
        if (bl) {
            StatusDisplayer.getDefault().setStatusText("Get File From Server Done");
        } else {
            StatusDisplayer.getDefault().setStatusText("Get All Files From Server Done");
        }
        Utils.getStatusLogger((String)this.getLocalRoot(), (String)"getall").info("Done");
        this.setStopDownloadAll(false);
        this.setPrintDownloadStop(true);
        this.run();
    }

    public void downloadAll(String string, final boolean bl, final boolean bl2) {
        if (!this.isReady()) {
            return;
        }
        try {
            final RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                this.post(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Object object = RemoteFileSystem.this.downloadAllLock;
                        synchronized (object) {
                            Logger logger = Utils.getStatusLogger((String)RemoteFileSystem.this.getLocalRoot(), (String)"getall");
                            if (RemoteFileSystem.this.getStopDownloadAll()) {
                                if (bl) {
                                    RemoteFileSystem.this.doDownloadDone(bl2);
                                }
                                return;
                            }
                            try {
                                remoteFile.refresh();
                                if (remoteFile.getFileResidenceMode() == 1 || remoteFile.getFileResidenceMode() == 0) {
                                    if (bl2 && !remoteFile.isDirectory()) {
                                        remoteFile.downloadAll(null);
                                    }
                                } else {
                                    remoteFile.downloadAll(null);
                                }
                            }
                            catch (IOException iOException) {
                                RemoteFileSystem.this.setStopDownloadAll(true);
                                RemoteFileSystem.this.setPrintUploadStop(true);
                                SwingUtilities.invokeLater(new Runnable(){

                                    public void run() {
                                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)iOException.getMessage(), 2));
                                    }
                                });
                            }
                            if (RemoteFileSystem.this.getStopDownloadAll() && RemoteFileSystem.this.getPrintDownloadStop()) {
                                logger.info("Stopped!");
                                RemoteFileSystem.this.setPrintDownloadStop(false);
                            }
                            if (bl) {
                                RemoteFileSystem.this.doDownloadDone(bl2);
                            }
                        }
                    }
                }, "getall");
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public void cleanCache(String string) {
        if (!this.isReady()) {
            return;
        }
        try {
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                remoteFile.cleanCache();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    public String[] children(String string) {
        String[] stringArray = new String[]{};
        if (!this.isReady()) {
            return stringArray;
        }
        try {
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null && remoteFile.isDirectory()) {
                stringArray = remoteFile.getStringChildren(this);
                this.statusChanged(string, true);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!(stringArray[i] != null && stringArray[i].endsWith(BACKUP_EXT) || stringArray[i] != null && this.ignoredFiles != null && this.ignoredFiles.isRegistered(stringArray[i]) || stringArray[i] != null && this.ignoreHiddenFiles && stringArray[i].startsWith(".")) && (stringArray[i] == null || this.ignoredFolders == null || !this.ignoredFolders.isRegistered(stringArray[i]))) continue;
            stringArray[i] = null;
        }
        return stringArray;
    }

    public abstract void statusChanged(String var1);

    public abstract void statusChanged(String var1, boolean var2);

    public abstract String getLocalRoot();

    public abstract RemoteRuntimeType getRemoteRuntimeType();

    public void createFolder(String string) throws IOException {
        this.isReadyToModify();
        RemoteFile remoteFile = null;
        String string2 = null;
        int n = string.lastIndexOf("/");
        if (n == -1) {
            string2 = string;
            remoteFile = this.rootFile;
        } else {
            string2 = string.substring(n + 1);
            remoteFile = this.rootFile.find(string.substring(0, n));
        }
        if (remoteFile != null) {
            remoteFile.createFolder(string2, this);
        }
    }

    public void createData(String string) throws IOException {
        this.isReadyToModify();
        RemoteFile remoteFile = null;
        String string2 = null;
        int n = string.lastIndexOf("/");
        if (n == -1) {
            string2 = string;
            remoteFile = this.rootFile;
        } else {
            string2 = string.substring(n + 1);
            remoteFile = this.rootFile.find(string.substring(0, n));
        }
        if (remoteFile != null) {
            remoteFile.createData(string2, this);
        }
    }

    public void rename(String string, String string2) throws IOException {
        if (string2.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML)) {
            new File(this.getLocalRoot(), string).renameTo(new File(this.getLocalRoot(), string2));
            return;
        }
        this.isReadyToModify();
        RemoteFile remoteFile = this.getRemoteFile(string);
        if (remoteFile != null) {
            int n;
            int n2;
            String string3 = null;
            String string4 = string;
            String string5 = string2;
            if (!string.startsWith("/")) {
                string4 = "/" + string;
            }
            if (!string2.startsWith("/")) {
                string5 = "/" + string2;
            }
            if ((n2 = string4.lastIndexOf(47)) != (n = string5.lastIndexOf(47)) || !string4.substring(0, n2).equals(string5.substring(0, n))) {
                IOException iOException = new IOException("Can't rename !!!!!!");
                iOException.printStackTrace();
                throw iOException;
            }
            string3 = n == -1 ? string2 : string5.substring(n + 1);
            remoteFile.rename(string3);
        }
    }

    public Date lastModified(String string) {
        Date date = new Date();
        if (!this.isReady()) {
            return date;
        }
        try {
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                date = remoteFile.lastModified();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return date;
    }

    public boolean folder(String string) {
        if (!this.isReady()) {
            return true;
        }
        try {
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                return remoteFile.isDirectory();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return true;
    }

    public boolean readOnly(String string) {
        if (!this.isReady()) {
            return false;
        }
        try {
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                return remoteFile.isReadOnly();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return false;
    }

    public String mimeType(String string) {
        return null;
    }

    public long size(String string) {
        try {
            if (string.endsWith("filesystem.attributes") || string.endsWith(".nbattrs") || string.endsWith(".nbattrs~")) {
                return new File(this.getLocalRoot() + File.separatorChar + string).length();
            }
            if (!this.isReady()) {
                return 0L;
            }
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                return remoteFile.getSize();
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
        return 0L;
    }

    public InputStream inputStream(String string) throws FileNotFoundException {
        InputStream inputStream = null;
        try {
            if (string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
                return new FileInputStream(new File(this.getLocalRoot(), string));
            }
            this.isReadyToRead();
            RemoteFile remoteFile = this.getRemoteFile(string);
            if (remoteFile != null) {
                inputStream = remoteFile.getInputStream();
                FileObject fileObject = this.findResource(string);
                if (fileObject != null) {
                    Object object;
                    if (fileObject.getExt().toLowerCase().equals("java") && (object = this.getRemoteFile(string.substring(0, string.lastIndexOf(46)) + ".form")) != null) {
                        ((RemoteFile)object).getInputStream();
                    }
                    object = new HashSet<FileObject>();
                    ((HashSet)object).add(fileObject);
                    this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, object, true, true));
                }
            }
        }
        catch (IOException iOException) {
            throw new FileNotFoundException(iOException.toString());
        }
        return inputStream;
    }

    public OutputStream outputStream(String string) throws IOException {
        if (string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML) || string.endsWith(RemoteDefaultAttributes.ATTR_NAME_EXT_XML + "~")) {
            return new FileOutputStream(new File(this.getLocalRoot(), string));
        }
        this.isReadyToModify();
        RemoteFile remoteFile = this.getRemoteFile(string);
        if (remoteFile != null) {
            this.backupIfNecessary(string);
            System.out.println(remoteFile.getName().getName());
            return remoteFile.getOutputStream();
        }
        return null;
    }

    public void lock(String string) throws IOException {
    }

    public void unlock(String string) {
    }

    public void markUnimportant(String string) {
    }

    protected abstract void startdirNotFound(String var1, String var2, String var3);

    protected abstract void errorConnect(String var1, String var2);

    public void post(Runnable runnable, String string) {
        this.requestproc = new RequestProcessor(string + " " + this.loginfo.displayName());
        this.requestproc.post(runnable);
    }

    public void post(Runnable runnable) {
        this.requestproc = new RequestProcessor("Remote File System Request Processor " + this.loginfo.displayName());
        this.requestproc.post(runnable);
    }

    public void setBackupExtensions(ExtensionList extensionList) {
        this.backupExtensions = extensionList;
        this.firePropertyChange("backupExtensions", null, null);
    }

    public ExtensionList getBackupExtensions() {
        if (this.backupExtensions == null) {
            return (ExtensionList)DEFAULT_EXTENSIONS.clone();
        }
        return this.backupExtensions;
    }

    public void setAsciiFileExts(ExtensionList extensionList) {
        this.asciiFileExts = extensionList;
        this.firePropertyChange("asciiFileExts", null, null);
        this.run();
    }

    public void run() {
        Enumeration enumeration = this.existingFileObjects(this.getRoot());
        while (enumeration.hasMoreElements()) {
            FileObject fileObject = (FileObject)enumeration.nextElement();
            if (!fileObject.isFolder()) continue;
            fileObject.refresh(true);
        }
    }

    public ExtensionList getServerOnlyFileExts() {
        if (this.serverOnlyFileExts == null) {
            return (ExtensionList)DEFAULT_SERVER_ONLY_EXTENSIONS.clone();
        }
        return this.serverOnlyFileExts;
    }

    public void setServerOnlyFileExts(ExtensionList extensionList) {
        this.serverOnlyFileExts = extensionList;
        this.firePropertyChange("serverOnlyFileExts", null, null);
        this.run();
    }

    public ExtensionList getAsciiFileExts() {
        if (this.asciiFileExts == null) {
            return (ExtensionList)DEFAULT_ASCII_EXTENSIONS.clone();
        }
        return this.asciiFileExts;
    }

    public void setIgnoreHiddenFiles(boolean bl) {
        if (bl != this.ignoreHiddenFiles) {
            this.ignoreHiddenFiles = bl;
            this.firePropertyChange("displayStatus", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public boolean getIgnoreHiddenFiles() {
        return this.ignoreHiddenFiles;
    }

    public void setDisplayStatus(boolean bl) {
        if (bl != this.displayStatus) {
            this.displayStatus = bl;
            this.firePropertyChange("displayStatus", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public boolean getDisplayStatus() {
        return this.displayStatus;
    }

    public void setAutoSync(boolean bl) {
        if (bl != this.autoSync) {
            this.autoSync = bl;
            this.firePropertyChange("autoSync", !bl ? Boolean.TRUE : Boolean.FALSE, bl ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean getAutoSync() {
        return this.autoSync;
    }

    public boolean getUseXtermCompile() {
        if (this.useXtermCompile == null) {
            return DistributedSettings.getDefault().getUseXtermCompile();
        }
        return this.useXtermCompile;
    }

    public int getXDisplayDeviceNumber() {
        if (this.xDisplayNumber == null) {
            return DistributedSettings.getDefault().getXDisplayDeviceNumber();
        }
        return this.xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        this.xDisplayNumber = new Integer(n);
        this.firePropertyChange("xDisplayNumber", null, this.xDisplayNumber);
    }

    public void setUseXtermCompile(boolean bl) {
        this.useXtermCompile = new Boolean(bl);
        this.firePropertyChange("useXtermCompile", null, this.useXtermCompile);
    }

    public boolean getUseXtermExecution() {
        if (this.useXtermExecution == null) {
            return DistributedSettings.getDefault().getUseXtermExecution();
        }
        return this.useXtermExecution;
    }

    public void setUseXtermExecution(boolean bl) {
        this.useXtermExecution = new Boolean(bl);
        this.firePropertyChange("useXtermExecution", null, this.useXtermExecution);
    }

    public ExtensionList getIgnoredFolders() {
        if (this.ignoredFolders == null) {
            this.ignoredFolders = new ExtensionList();
        }
        return this.ignoredFolders;
    }

    public synchronized void setIgnoredFolders(ExtensionList extensionList) throws IllegalArgumentException {
        if (!extensionList.equals((Object)this.ignoredFolders)) {
            this.ignoredFolders = extensionList;
            this.firePropertyChange("ignoredFolders", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public ExtensionList getIgnoredFiles() {
        if (this.ignoredFiles == null) {
            this.ignoredFiles = new ExtensionList();
        }
        return this.ignoredFiles;
    }

    public synchronized void setIgnoredFiles(ExtensionList extensionList) throws IllegalArgumentException {
        if (!extensionList.equals((Object)this.ignoredFiles)) {
            this.ignoredFiles = extensionList;
            this.firePropertyChange("ignoredFiles", null, null);
            RequestProcessor.getDefault().post((Runnable)this);
        }
    }

    public String getRootFile() {
        if (this.rootFile != null) {
            return FileUtility.unixPathToOpenVMSPath((String)this.rootFile.getName().getFullName(), (boolean)true);
        }
        return "<invalid>";
    }

    public boolean checkAndupdateRemoteServerError(final String string) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        if (remoteRuntimeType == null || remoteRuntimeType.getRemoteRuntime() == null) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + string + " to strmlf :\n" + "Remote server " + RemoteFileSystem.this.getRemoteRuntimeType().getHostName() + ":" + RemoteFileSystem.this.getRemoteRuntimeType().getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                }
            });
            if (remoteRuntimeType != null) {
                remoteRuntimeType.setRemoteServerError(true);
            }
            return true;
        }
        return remoteRuntimeType.getRemoteServerError();
    }

    public boolean changeBinFileToSTRMLF(String string) {
        RemoteRuntimeType remoteRuntimeType = this.getRemoteRuntimeType();
        try {
            if (remoteRuntimeType == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + string + " to strmlf : \n" + "No matching remote server is found.\nPlease go to the Runtime Tab and create a remote server"), 2));
                remoteRuntimeType.setRemoteServerError(true);
            } else {
                RemoteRuntime remoteRuntime = remoteRuntimeType.getRemoteRuntime();
                if (remoteRuntime == null) {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + string + " to strmlf :\n" + "Remote server " + remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                    remoteRuntimeType.setRemoteServerError(true);
                } else {
                    RemoteFileService remoteFileService = remoteRuntime.getRemoteFileService();
                    if (remoteFileService != null) {
                        remoteFileService.changeBinFileToSTRMLF(DEVICE, string);
                    } else {
                        DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)("Error while converting " + string + " to strmlf :\n" + "Remote server " + remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName() + " is disconnected.\nPlease go to the Runtime Tab and make a connection"), 2));
                        remoteRuntimeType.setRemoteServerError(true);
                    }
                }
            }
        }
        catch (RemoteException remoteException) {
            remoteRuntimeType.setRemoteServerError(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)remoteException.getMessage(), 2));
                }
            });
            return false;
        }
        return true;
    }

    class PromptNewPassword
    implements ActionListener {
        RemoteRuntimeType rrt;
        char[] password;

        PromptNewPassword() {
            this.rrt = RemoteFileSystem.this.getRemoteRuntimeType();
        }

        public void create() {
            RemoteFileSystem.this.passpanel = new PasswordPanel(this.rrt, false, RemoteFileSystem.this.cachedir.toString());
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)RemoteFileSystem.this.passpanel, "FTP Filesystem Password " + RemoteFileSystem.this.cachedir.toString(), true, (ActionListener)this);
            dialogDescriptor.setValid(false);
            RemoteFileSystem.this.passpanel.setDialogDescriptor(dialogDescriptor);
            RemoteFileSystem.this.myDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            RemoteFileSystem.this.myDialog.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    this.password = RemoteFileSystem.this.passpanel.getNewPassword();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        public char[] getPassword() {
            return this.password;
        }
    }

    private static class InnerAttrs
    extends RemoteDefaultAttributes {
        static final long serialVersionUID = 1257351369229921993L;
        RemoteFileSystem rfs;

        public InnerAttrs(RemoteFileSystem remoteFileSystem, AbstractFileSystem.Info info, AbstractFileSystem.Change change, AbstractFileSystem.List list) {
            super(info, change, list);
            this.rfs = remoteFileSystem;
        }

        public Object readAttribute(String string, String string2) {
            if (string2.equals("java.io.File")) {
                return this.rfs.getFile(string);
            }
            return super.readAttribute(string, string2);
        }

        public void writeAttribute(String string, String string2, Object object) throws IOException {
            super.writeAttribute(string, string2, object);
        }
    }
}

