/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.explorer.RemoteRuntimeNode;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class SvcBrowserChildren
extends Children.Keys
implements PropertyChangeListener {
    private transient RequestProcessor.Task task = null;
    private transient RefreshTaskAuto taskRunnable = null;
    private int timeout = 0;
    private transient HashSet addedNew = new HashSet(5);

    public SvcBrowserChildren() {
        DistributedSettings.getDefault().addPropertyChangeListener(this);
        this.timeout = DistributedSettings.getDefault().getTimeOut();
        this.scheduleRefreshTaskAuto(this.timeout);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SvcBrowserChildren.this.startRemoteServers();
            }
        });
    }

    private void startRemoteServers() {
        HashSet hashSet = DistributedSettings.getDefault().getRemoteRuntimes();
        if (hashSet != null) {
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)iterator.next();
                if (!remoteRuntimeType.getConnectNow() || !remoteRuntimeType.isConnectAtStartup()) continue;
                remoteRuntimeType.getRemoteRuntimeServerSafe();
            }
        }
    }

    protected void scheduleRefreshTask(int n) {
        RefreshTask refreshTask = new RefreshTask();
        RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)refreshTask);
        task.setPriority(10);
        task.schedule(n);
    }

    public void scheduleRefreshTaskAuto(int n) {
        if (this.task == null) {
            this.taskRunnable = new RefreshTaskAuto();
            this.task = RequestProcessor.getDefault().create((Runnable)this.taskRunnable);
            this.task.setPriority(1);
            this.task.schedule(n);
        }
    }

    private void addKeys() {
        HashSet hashSet = DistributedSettings.getDefault().getRemoteRuntimes();
        ArrayList arrayList = null;
        if (hashSet != null) {
            arrayList = new ArrayList(hashSet.size() + 1);
            arrayList.addAll(hashSet);
            this.setKeys(arrayList);
        }
        Node[] nodeArray = this.getNodes();
        for (int i = 0; nodeArray != null && i < nodeArray.length; ++i) {
            final RemoteRuntimeNode remoteRuntimeNode = (RemoteRuntimeNode)nodeArray[i];
            final RemoteRuntimeType remoteRuntimeType = remoteRuntimeNode.getRemoteRuntimeType();
            boolean bl = false;
            boolean bl2 = remoteRuntimeType.isServerFailed();
            if (remoteRuntimeType != null) {
                bl = remoteRuntimeType.isConnectedServerSafe();
                if (bl) {
                    remoteRuntimeNode.setConnectedState(0);
                } else if (remoteRuntimeType.isConnecting()) {
                    remoteRuntimeNode.setConnectedState(1);
                } else if (!remoteRuntimeType.isConnected()) {
                    remoteRuntimeNode.setConnectedState(2);
                }
            }
            if (remoteRuntimeType.getConnectNow() && !bl && !remoteRuntimeType.isConnecting()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        remoteRuntimeNode.setConnectedState(1);
                        RemoteRuntime remoteRuntime = remoteRuntimeType.getRemoteRuntimeServerSafe();
                        if (remoteRuntime != null) {
                            remoteRuntimeNode.setConnectedState(0);
                        } else {
                            remoteRuntimeNode.setConnectedState(2);
                            remoteRuntimeType.disconnect(false);
                            remoteRuntimeType.removeConnectionListener(remoteRuntimeNode);
                        }
                    }
                });
                continue;
            }
            if (!bl2 || bl || remoteRuntimeType.isConnecting()) continue;
            remoteRuntimeType.stopRemoteProcesses();
            remoteRuntimeType.disconnect(true);
        }
    }

    public void refreshNow() {
        this.scheduleRefreshTask(0);
    }

    protected void addNotify() {
        this.refreshNow();
    }

    protected void removeNotify() {
    }

    protected void refreshKeys() {
        this.addKeys();
    }

    protected void refreshKeys2() {
        this.addKeys();
    }

    protected Node[] createNodes(Object object) {
        if (object instanceof RemoteRuntimeType) {
            final RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)object;
            final RemoteRuntimeNode remoteRuntimeNode = new RemoteRuntimeNode(remoteRuntimeType);
            boolean bl = remoteRuntimeType.isConnectedServerSafe();
            boolean bl2 = remoteRuntimeType.isServerFailed();
            if (remoteRuntimeType != null) {
                if (remoteRuntimeType.isConnectedServerSafe()) {
                    remoteRuntimeNode.setConnectedState(0);
                } else if (remoteRuntimeType.isConnecting()) {
                    remoteRuntimeNode.setConnectedState(1);
                } else if (!remoteRuntimeType.isConnected()) {
                    remoteRuntimeNode.setConnectedState(2);
                }
            }
            if (remoteRuntimeType.getConnectNow() && !bl && !remoteRuntimeType.isConnecting() && !bl2) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        remoteRuntimeNode.setConnectedState(1);
                        RemoteRuntime remoteRuntime = remoteRuntimeType.getRemoteRuntimeServerSafe();
                        if (remoteRuntime != null) {
                            remoteRuntimeNode.setConnectedState(0);
                        } else {
                            remoteRuntimeNode.setConnectedState(2);
                            remoteRuntimeType.disconnect(false);
                            if (SvcBrowserChildren.this.addedNew.contains(remoteRuntimeType)) {
                                remoteRuntimeType.removeConnectionListener(remoteRuntimeNode);
                                SvcBrowserChildren.this.addedNew.remove(remoteRuntimeType);
                            }
                        }
                    }
                });
            } else if (bl2 && !bl && !remoteRuntimeType.isConnecting()) {
                remoteRuntimeType.stopRemoteProcesses();
                remoteRuntimeType.disconnect(true);
            }
            return new Node[]{remoteRuntimeNode};
        }
        if (object instanceof Node) {
            return new Node[]{(Node)object};
        }
        return null;
    }

    public void addRemoteRuntimeType(RemoteRuntimeType remoteRuntimeType) {
        DistributedSettings.getDefault().putRemoteRuntime(remoteRuntimeType);
        this.addedNew.add(remoteRuntimeType);
        this.refreshNow();
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if ("remoteRuntimes".equals(propertyChangeEvent.getPropertyName()) || propertyChangeEvent.getPropertyName() == null) {
            if (propertyChangeEvent.getOldValue() != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        SvcBrowserChildren.this.addNotify();
                    }
                });
            } else {
                this.refreshKeys2();
            }
        }
        if ("timeOut".equals(propertyChangeEvent.getPropertyName())) {
            this.timeout = DistributedSettings.getDefault().getTimeOut();
            this.task.schedule(this.timeout);
        }
    }

    private class RefreshTaskAuto
    implements Runnable {
        private RefreshTaskAuto() {
        }

        public void run() {
            if (SvcBrowserChildren.this.task != null) {
                SvcBrowserChildren.this.task.waitFinished();
            }
            SvcBrowserChildren.this.refreshKeys2();
            if (SvcBrowserChildren.this.task != null && SvcBrowserChildren.this.timeout > 0) {
                SvcBrowserChildren.this.task.schedule(SvcBrowserChildren.this.timeout);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            SvcBrowserChildren.this.refreshKeys();
        }
    }
}

