/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient.explorer;

import java.awt.Dialog;
import java.beans.PropertyEditor;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ResourceBundle;
import org.netbeans.modules.distributed.common.propertyeditors.PasswordEditor;
import org.netbeans.modules.distributed.ideserverclient.DistConnectionListener;
import org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType;
import org.netbeans.modules.distributed.ideserverclient.actions.ConnectAction;
import org.netbeans.modules.distributed.ideserverclient.actions.ConnectCtxCookie;
import org.netbeans.modules.distributed.ideserverclient.actions.DisconnectAction;
import org.netbeans.modules.distributed.ideserverclient.actions.DisconnectCtxCookie;
import org.netbeans.modules.distributed.ideserverclient.explorer.PasswordPanel;
import org.netbeans.modules.distributed.ideserverclient.explorer.RemoteRuntimeProperty;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.actions.DeleteAction;
import org.openide.actions.OpenLocalExplorerAction;
import org.openide.actions.PropertiesAction;
import org.openide.actions.ToolsAction;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class RemoteRuntimeNode
extends AbstractNode
implements DisconnectCtxCookie,
ConnectCtxCookie,
DistConnectionListener,
Node.Cookie {
    private RemoteRuntimeType rrt;
    private int state = 2;
    private SystemAction action;
    private Dialog myDialog = null;
    private PasswordPanel passpanel = null;
    private String newpassword = null;
    private boolean doConnect = false;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public RemoteRuntimeNode(RemoteRuntimeType remoteRuntimeType) {
        super(Children.LEAF);
        this.rrt = remoteRuntimeType;
        remoteRuntimeType.addConnectionListener(this);
        this.setConnectedState(2);
        this.setName(remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName());
        this.setDisplayName(remoteRuntimeType.getHostName() + ":" + remoteRuntimeType.getUserName());
        this.setShortDescription(NbBundle.getMessage((Class)RemoteRuntimeNode.class, (String)"HINT_remote_runtime_node"));
        this.getCookieSet().add((Node.Cookie)this);
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public void connected() {
        this.setConnectedState(0);
    }

    public void connecting() {
        this.setConnectedState(1);
    }

    public void disconnected() {
        this.setConnectedState(2);
    }

    public void setIcon(String string) {
        this.setIconBase(string);
    }

    public void setConnectedState(int n) {
        if (n == 1) {
            this.state = 1;
            this.setIcon("org/netbeans/modules/distributed/ideserverclient/resources/distConnecting");
        } else if (n == 0) {
            this.state = 0;
            this.setIcon("org/netbeans/modules/distributed/ideserverclient/resources/connected");
        } else {
            this.state = 2;
            this.setIcon("org/netbeans/modules/distributed/ideserverclient/resources/disconnected");
        }
    }

    protected Sheet createSheet() {
        ResourceBundle resourceBundle = NbBundle.getBundle((Class)RemoteRuntimeNode.class);
        Sheet sheet = super.createSheet();
        Sheet.Set set = sheet.get("properties");
        if (set == null) {
            set = Sheet.createPropertiesSet();
            sheet.put(set);
        }
        RemoteRuntimeProperty remoteRuntimeProperty = new HostNameProperty("hostName", this.rrt);
        remoteRuntimeProperty.setName("hostName");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_hostName"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_hostName"));
        set.put((Node.Property)remoteRuntimeProperty);
        if (this.rrt.getSavePassword()) {
            remoteRuntimeProperty = new PasswordProperty("password", this.rrt);
            remoteRuntimeProperty.setName("password");
            remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_password"));
            remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_password"));
            set.put((Node.Property)remoteRuntimeProperty);
        }
        remoteRuntimeProperty = new PortProperty("port", this.rrt);
        remoteRuntimeProperty.setName("port");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_port"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_port"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new SvrTimeOutProperty("svrTimeOut", this.rrt);
        remoteRuntimeProperty.setName("svrTimeOut");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_svrTimeOut"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_svrTimeOut"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new UserNameProperty("userName", this.rrt);
        remoteRuntimeProperty.setName("userName");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_userName"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_userName"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new JDKVersionProperty("JDKVersion", this.rrt);
        remoteRuntimeProperty.setName("JDKVersion");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_JDKVersion"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_JDKVersion"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new RemoteOSProperty("RemoteOS", this.rrt);
        remoteRuntimeProperty.setName("RemoteOS");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_remoteOS"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_remoteOS"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new ConnectAtStartupProperty("ConnectAtStartup", this.rrt);
        remoteRuntimeProperty.setName("ConnectAtStartup");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_connectAtStartup"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_connectAtStartup"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new ServerVersionProperty("ServerVersion", this.rrt);
        remoteRuntimeProperty.setName("ServerVersion");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_ServerVersion"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_ServerVersion"));
        set.put((Node.Property)remoteRuntimeProperty);
        remoteRuntimeProperty = new SetupCommandProperty("setupCommand", this.rrt);
        remoteRuntimeProperty.setName("setupCommand");
        remoteRuntimeProperty.setDisplayName(resourceBundle.getString("PROP_setupCommand"));
        remoteRuntimeProperty.setShortDescription(resourceBundle.getString("HINT_setupCommand"));
        set.put((Node.Property)remoteRuntimeProperty);
        return sheet;
    }

    private void disconnectImpl() {
        this.setConnectedState(1);
        this.rrt.stopRemoteProcesses();
        this.rrt.disconnect(false);
        this.setConnectedState(2);
    }

    public void disconnect() {
        if (this.rrt != null) {
            if (this.rrt.remoteProcessCount() > 0) {
                Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)"There are active remote operations still underway.\nDisconnecting will abort those operations", "Warning", 2, 2));
                if (NotifyDescriptor.OK_OPTION.equals(object)) {
                    this.disconnectImpl();
                }
            } else {
                this.disconnectImpl();
            }
        }
    }

    public void connect() {
        if (this.rrt != null) {
            this.setConnectedState(1);
            this.rrt.setConnectNow(true);
            RemoteRuntime remoteRuntime = this.rrt.getRemoteRuntimeServerSafe();
            if (remoteRuntime != null) {
                this.setConnectedState(0);
            } else {
                this.setConnectedState(2);
            }
        }
    }

    public int connectionState() {
        return this.state;
    }

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)OpenLocalExplorerAction.class), null, SystemAction.get((Class)ConnectAction.class), SystemAction.get((Class)DisconnectAction.class), SystemAction.get((Class)DeleteAction.class), null, SystemAction.get((Class)ToolsAction.class), null, SystemAction.get((Class)PropertiesAction.class)};
    }

    public void destroy() throws IOException {
        super.destroy();
        this.rrt.disconnect(false);
        this.rrt.removeConnectionListener(this);
        DistributedSettings.getDefault().removeRemoteRuntime(this.rrt);
    }

    public boolean canDestroy() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private class SavePasswordProperty
    extends RemoteRuntimeProperty {
        public SavePasswordProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RemoteRuntimeNode.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getSavePassword() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setSavePassword((Boolean)object);
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class ConnectAtStartupProperty
    extends RemoteRuntimeProperty {
        public ConnectAtStartupProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType, class$java$lang$Boolean == null ? (class$java$lang$Boolean = RemoteRuntimeNode.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().isConnectAtStartup() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            if (((Boolean)object).booleanValue()) {
                this.getRemoteRuntimeType().setConnectAtStartup(true);
            } else {
                this.getRemoteRuntimeType().setConnectAtStartup(false);
            }
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class PasswordProperty
    extends RemoteRuntimeProperty {
        public PasswordProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getPassword();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setPassword(((String)object).toCharArray());
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }

        public PropertyEditor getPropertyEditor() {
            return PasswordEditor.getInstance();
        }
    }

    private class SvrTimeOutProperty
    extends RemoteRuntimeProperty {
        public SvrTimeOutProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType, class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteRuntimeNode.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        public Object getValue() {
            return new Integer(this.getRemoteRuntimeType().getSvrTimeOut());
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            Integer n = (Integer)object;
            this.getRemoteRuntimeType().setSvrTimeOut(n);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class PortProperty
    extends RemoteRuntimeProperty {
        public PortProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType, class$java$lang$Integer == null ? (class$java$lang$Integer = RemoteRuntimeNode.class$("java.lang.Integer")) : class$java$lang$Integer);
        }

        public Object getValue() {
            return new Integer(this.getRemoteRuntimeType().getPort());
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            Integer n = (Integer)object;
            this.getRemoteRuntimeType().setPort(n);
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class UserNameProperty
    extends RemoteRuntimeProperty {
        public UserNameProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getUserName();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setUserName((String)object);
            RemoteRuntimeNode.this.setDisplayName(RemoteRuntimeNode.this.rrt.getHostName() + ":" + RemoteRuntimeNode.this.rrt.getUserName());
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class JDKVersionProperty
    extends RemoteRuntimeProperty {
        public JDKVersionProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getJDKVersion();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class ServerVersionProperty
    extends RemoteRuntimeProperty {
        public ServerVersionProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getServerVersion();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class RemoteOSProperty
    extends RemoteRuntimeProperty {
        public RemoteOSProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            String string = "";
            try {
                if (this.getRemoteRuntimeType().isConnected()) {
                    string = this.getRemoteRuntimeType().getRemoteRuntime().getOperatingSystem();
                }
            }
            catch (Exception exception) {
                string = "";
            }
            return string;
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
        }

        public boolean canWrite() {
            return false;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class SetupCommandProperty
    extends RemoteRuntimeProperty {
        public SetupCommandProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getSetupCommand();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setSetupCommand((String)object);
        }

        public boolean canWrite() {
            return true;
        }

        public boolean canRead() {
            return true;
        }
    }

    private class HostNameProperty
    extends RemoteRuntimeProperty {
        public HostNameProperty(String string, RemoteRuntimeType remoteRuntimeType) {
            super(string, remoteRuntimeType);
        }

        public Object getValue() {
            return this.getRemoteRuntimeType().getHostName();
        }

        public void setValue(Object object) throws IllegalArgumentException, InvocationTargetException {
            this.getRemoteRuntimeType().setHostName((String)object);
            RemoteRuntimeNode.this.setDisplayName(RemoteRuntimeNode.this.rrt.getHostName() + ":" + RemoteRuntimeNode.this.rrt.getUserName());
        }

        public boolean canWrite() {
            return RemoteRuntimeNode.this.state == 2;
        }

        public boolean canRead() {
            return true;
        }
    }
}

