/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.ideserverclient;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.SwingUtilities;
import org.netbeans.modules.distributed.ideserverclient.DistConnectionListener;
import org.netbeans.modules.distributed.ideserverclient.RemoteLoginClient;
import org.netbeans.modules.distributed.ideserverclient.childPasswordDialog;
import org.netbeans.modules.distributed.ideserverclient.explorer.PasswordPanel;
import org.netbeans.modules.distributed.ideserverclient.settings.DistributedSettings;
import org.netbeans.modules.distributed.rmi.protocol.Admin;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.rmi.protocol.SecurityContext;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.StatusDisplayer;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteRuntimeType
implements Serializable {
    static final long serialVersionUID = -5272304999227754317L;
    private static final String REMOTESVR_PROB = "Problem accessing the Remote IDE Server: {0}.\n\nThe error message was: {1}.\n\nPlease go to the Runtime Tab and reconnect the Remote IDE Server";
    private static final String REMOTESVR_NOT_CONN = "Remote IDE Server {0} is not connected.Please go to the Runtime Tab and make a connection";
    private String userName;
    private char[] charPassword;
    private String password = null;
    private String hostName;
    private String jdkVersion;
    private String setupCommand;
    private int port;
    private int svrTimeOut;
    private boolean connectAtStartup;
    private boolean connectNow;
    private transient SecurityContext securityContext;
    private transient RemoteLoginClient rtClient;
    private transient RemoteRuntime rt;
    private transient ArrayList remoteProcesses;
    private String lastStatusMsg;
    private transient HashSet connectionListeners;
    private transient boolean remoteServerError;
    private boolean savePassword;
    private transient PromptNewPassword promptnewpass = null;
    private boolean doConnect = false;
    private transient PasswordPanel passpanel = null;
    private transient PasswordPanel ftppasspanel = null;
    private transient Dialog myDialog = null;
    private boolean enableSavePass = false;
    private transient PromptFTPPassword promptftppassword = null;
    private transient boolean isCancel = false;
    private transient childPasswordDialog childpassworddialog = null;

    public RemoteRuntimeType() {
        this.remoteProcesses = new ArrayList(10);
        this.connectionListeners = new HashSet();
    }

    public RemoteRuntimeType(String string, char[] cArray, String string2, int n, String string3, String string4, int n2, boolean bl, boolean bl2) {
        this.userName = string;
        this.charPassword = cArray;
        this.hostName = string2;
        this.port = n;
        this.jdkVersion = string3;
        this.connectNow = bl;
        this.setupCommand = string4;
        this.svrTimeOut = n2;
        this.savePassword = bl2;
        this.rtClient = new RemoteLoginClient();
        this.remoteProcesses = new ArrayList(10);
        this.connectionListeners = new HashSet();
    }

    public void setRemoteServerError(boolean bl) {
        this.remoteServerError = bl;
    }

    public boolean getRemoteServerError() {
        return this.remoteServerError;
    }

    public synchronized boolean addRemoteProcess(Process process) {
        if (this.remoteProcesses == null) {
            this.remoteProcesses = new ArrayList(10);
        }
        return this.remoteProcesses.add(process);
    }

    public synchronized boolean removeRemoteProcess(Process process) {
        if (this.remoteProcesses == null) {
            return false;
        }
        return this.remoteProcesses.remove(process);
    }

    public synchronized int remoteProcessCount() {
        if (this.remoteProcesses != null) {
            return this.remoteProcesses.size();
        }
        return 0;
    }

    public synchronized void stopRemoteProcesses() {
        if (this.remoteProcesses == null) {
            return;
        }
        int n = this.remoteProcesses.size();
        for (int i = 0; i < n; ++i) {
            Process process = (Process)this.remoteProcesses.get(0);
            process.destroy();
        }
    }

    public void addConnectionListener(DistConnectionListener distConnectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        this.connectionListeners.add(distConnectionListener);
    }

    public void removeConnectionListener(DistConnectionListener distConnectionListener) {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        this.connectionListeners.remove(distConnectionListener);
    }

    void fireConnected() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator iterator = this.connectionListeners.iterator();
        while (iterator.hasNext()) {
            DistConnectionListener distConnectionListener = (DistConnectionListener)iterator.next();
            distConnectionListener.connected();
        }
    }

    void fireConnecting() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator iterator = this.connectionListeners.iterator();
        while (iterator.hasNext()) {
            DistConnectionListener distConnectionListener = (DistConnectionListener)iterator.next();
            distConnectionListener.connecting();
        }
    }

    void fireDisconnected() {
        if (this.connectionListeners == null) {
            this.connectionListeners = new HashSet();
        }
        Iterator iterator = this.connectionListeners.iterator();
        while (iterator.hasNext()) {
            DistConnectionListener distConnectionListener = (DistConnectionListener)iterator.next();
            distConnectionListener.disconnected();
        }
    }

    private RemoteLoginClient getRemoteLoginClient() {
        if (this.rtClient == null) {
            this.rtClient = new RemoteLoginClient();
        }
        return this.rtClient;
    }

    public Admin getAdminInterface(String string) {
        return this.getRemoteLoginClient().getAdminInterface(string);
    }

    public boolean getConnectNow() {
        return this.connectNow;
    }

    public void setConnectNow(boolean bl) {
        this.connectNow = bl;
        DistributedSettings.getDefault().setTimeOut(DistributedSettings.getDefault().getTimeOut());
    }

    public boolean getDoConnect() {
        return this.doConnect;
    }

    public void setDoConnect(boolean bl) {
        this.doConnect = bl;
    }

    public char[] getcharPassword() {
        return this.charPassword;
    }

    public void setcharPassword(char[] cArray) {
        this.charPassword = cArray;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    public String displayName() {
        return this.hostName + ":" + this.userName;
    }

    public String getUserName() {
        return this.userName;
    }

    public char[] getPassword() {
        return this.charPassword;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPortName() {
        return this.port;
    }

    public boolean getSavePassword() {
        return this.savePassword;
    }

    public char[] getFTPPassword() {
        return this.promptftppassword.getFTPPass();
    }

    public void setSavePassword(boolean bl) {
    }

    public String getSetupCommand() {
        if (this.setupCommand == null) {
            return "";
        }
        return this.setupCommand;
    }

    public String getJDKVersion() {
        return this.getRemoteLoginClient().getJDKVersion();
    }

    public String getServerVersion() {
        return this.getRemoteLoginClient().getServerVersion();
    }

    public boolean isConnected() {
        return this.getRemoteLoginClient().isConnected();
    }

    public boolean isConnecting() {
        return this.getRemoteLoginClient().isConnecting();
    }

    public boolean isConnectAtStartup() {
        return this.connectAtStartup;
    }

    public void setConnectAtStartup(boolean bl) {
        this.connectAtStartup = bl;
        DistributedSettings.getDefault().setConnectAtStartup(bl);
    }

    public synchronized void disconnect(boolean bl) {
        if (this.isConnected()) {
            this.getRemoteLoginClient().close();
        }
        if (!bl) {
            this.setConnectNow(false);
        }
    }

    private void errorMessage(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string, 2));
            }
        });
    }

    public boolean isFileSTRMLF(String string) {
        if (this.isConnected()) {
            RemoteFileService remoteFileService = this.getRemoteLoginClient().getRemoteFileService();
            if (remoteFileService == null) {
                this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
                return false;
            }
            try {
                return remoteFileService.isFileSTRMLF(string);
            }
            catch (RemoteException remoteException) {
                this.errorMessage(remoteException.getMessage());
                return false;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return false;
    }

    public boolean fileExists(String string) {
        if (this.isConnected()) {
            RemoteFileService remoteFileService = this.getRemoteLoginClient().getRemoteFileService();
            if (remoteFileService == null) {
                this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
                return false;
            }
            try {
                return remoteFileService.fileExists(string);
            }
            catch (RemoteException remoteException) {
                this.errorMessage(remoteException.getMessage());
                return false;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return false;
    }

    public ArrayList listRoots() {
        if (this.isConnected()) {
            RemoteFileService remoteFileService = this.getRemoteLoginClient().getRemoteFileService();
            if (remoteFileService == null) {
                this.errorMessage(MessageFormat.format(REMOTESVR_PROB, this.getHostName() + ":" + this.getUserName(), this.getRemoteLoginClient().getErrorMessage()));
                return null;
            }
            try {
                return remoteFileService.listRoots();
            }
            catch (RemoteException remoteException) {
                this.errorMessage(remoteException.getMessage());
                return null;
            }
        }
        this.errorMessage(MessageFormat.format(REMOTESVR_NOT_CONN, this.getHostName() + ":" + this.getUserName()));
        return null;
    }

    public byte[] getSecurityContext() {
        return this.getRemoteLoginClient().getTicket();
    }

    public String getID() {
        return this.getRemoteLoginClient().getID();
    }

    public int getPort() {
        return this.port;
    }

    public int getSvrTimeOut() {
        if (this.svrTimeOut <= 0) {
            return DistributedSettings.getDefault().getSvrTimeOut();
        }
        return this.svrTimeOut;
    }

    public void setSvrTimeOut(int n) {
        this.svrTimeOut = n;
    }

    public String getNetworkShareRoot(String string) {
        if (this.getRemoteLoginClient().findRemoteRuntime() == null) {
            return null;
        }
        String string2 = this.getRemoteLoginClient().getNetworkShareRoot(string);
        if (string2 == null) {
            this.errorMessage(this.getRemoteLoginClient().getErrorMessage());
        }
        return string2;
    }

    public boolean isConnectedServerSafe() {
        return this.getRemoteLoginClient().findRemoteRuntimeServerSafe() != null;
    }

    public char[] getFTPCredentials(Component component) {
        this.promptftppassword = new PromptFTPPassword(this);
        this.promptftppassword.create(component);
        return this.promptftppassword.getFTPPass();
    }

    public char[] getFTPCredentials() {
        this.promptftppassword = new PromptFTPPassword(this);
        this.promptftppassword.create();
        return this.promptftppassword.getFTPPass();
    }

    private void clearPassword() {
        if (this.charPassword != null) {
            for (int i = 0; i < this.charPassword.length; ++i) {
                this.charPassword[i] = '\u0000';
            }
            this.charPassword = null;
        }
    }

    private RemoteRuntime createRemoteRuntime(Component component) {
        return this.createRemoteRuntimeInner(component);
    }

    private RemoteRuntime createRemoteRuntime() {
        return this.createRemoteRuntimeInner(null);
    }

    private RemoteRuntime createRemoteRuntimeInner(Component component) {
        if (this.rt == null && this.getConnectNow()) {
            if (!this.savePassword && this.charPassword == null) {
                this.promptnewpass = component == null ? new PromptNewPassword(this) : new PromptNewPassword(this, component);
                this.promptnewpass.create();
                if (!this.doConnect) {
                    return null;
                }
            }
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("VERSION", "1.0");
            hashMap.put("USER", this.getUserName().toLowerCase());
            hashMap.put("PASSWD", this.getPassword());
            hashMap.put("JDK_VER_TAG", this.getJDKVersion());
            if (this.getSetupCommand() != null && !this.getSetupCommand().trim().equals("")) {
                hashMap.put("SETUP", this.getSetupCommand().trim());
            }
            StatusDisplayer.getDefault().setStatusText("Connecting to the remote server:" + this.getHostName() + ":" + this.getUserName());
            this.fireConnecting();
            hashMap.put("SVR_WAITTIME", new Integer(this.getSvrTimeOut()));
            if (!this.getRemoteLoginClient().connect(hashMap, this.getHostName(), this.getPort())) {
                this.lastStatusMsg = this.getRemoteLoginClient().getErrorMessage();
                if (this.lastStatusMsg != null && this.lastStatusMsg.indexOf(0) > 0) {
                    this.lastStatusMsg = this.lastStatusMsg.substring(0, this.lastStatusMsg.indexOf(0));
                }
                StatusDisplayer.getDefault().setStatusText("Connection attempt failed:" + this.getHostName() + ":" + this.getUserName());
                if (this.getRemoteLoginClient().isServerTimedOut() || !this.savePassword) {
                    this.setConnectNow(false);
                }
                final String string = NbBundle.getMessage((Class)RemoteRuntimeType.class, (String)"MSG_RMIServerErrorMsgTitle");
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)RemoteRuntimeType.this.getLastStatusMessage(), string, -1, 2));
                    }
                });
                this.fireDisconnected();
                if (!this.savePassword) {
                    this.clearPassword();
                }
                return null;
            }
            this.lastStatusMsg = null;
            StatusDisplayer.getDefault().setStatusText("Connection succeeded:" + this.getHostName() + ":" + this.getUserName());
            this.rt = this.getRemoteLoginClient().findRemoteRuntimeServerSafe();
            this.setConnectNow(true);
            this.fireConnected();
            this.getRemoteLoginClient().keepServerAlive();
            if (!this.savePassword) {
                this.clearPassword();
            }
            return this.rt;
        }
        if (!this.savePassword) {
            this.clearPassword();
        }
        return this.rt;
    }

    public synchronized RemoteRuntime getRemoteRuntimeServerSafe() {
        this.rt = this.getRemoteLoginClient().findRemoteRuntimeServerSafe();
        this.setConnectNow(true);
        return this.createRemoteRuntime();
    }

    public synchronized RemoteRuntime getRemoteRuntime() {
        this.rt = this.getRemoteLoginClient().findRemoteRuntime();
        return this.createRemoteRuntime();
    }

    public String getLastStatusMessage() {
        return this.lastStatusMsg;
    }

    protected void finalize() {
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public void setSetupCommand(String string) {
        this.setupCommand = string;
    }

    public void setPassword(char[] cArray) {
        this.charPassword = cArray;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public void setPort(int n) {
        this.port = n;
    }

    public String getAsText() {
        return this.hostName + ":" + this.userName;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = false;
        RemoteRuntimeType remoteRuntimeType = (RemoteRuntimeType)object;
        bl = this.userName.equalsIgnoreCase(remoteRuntimeType.userName);
        boolean bl2 = bl = !bl ? false : this.hostName.equalsIgnoreCase(remoteRuntimeType.hostName);
        bl = !bl ? false : this.port == remoteRuntimeType.port;
        return bl;
    }

    public boolean equals(String string, String string2) {
        boolean bl = false;
        bl = this.userName.equalsIgnoreCase(string2);
        bl = !bl ? false : this.hostName.equalsIgnoreCase(string);
        return bl;
    }

    public boolean isServerFailed() {
        return this.rtClient.isServerFailed();
    }

    public RemoteFileService getRemoteFileService() throws RemoteException {
        return this.getRemoteLoginClient().getRemoteFileService();
    }

    public void convertToCharPassword() {
        if (this.password != null) {
            this.charPassword = this.password.toCharArray();
            this.password = null;
        }
    }

    static /* synthetic */ char[] access$002(RemoteRuntimeType remoteRuntimeType, char[] cArray) {
        remoteRuntimeType.charPassword = cArray;
        return cArray;
    }

    class PromptFTPPassword
    implements ActionListener,
    Serializable {
        private transient Dialog newDialog = null;
        private transient PasswordPanel ftppasspanel = null;
        private transient RemoteRuntimeType rrt = null;

        public PromptFTPPassword(RemoteRuntimeType remoteRuntimeType2) {
            this.rrt = remoteRuntimeType2;
        }

        public void create(Component component) {
            this.ftppasspanel = new PasswordPanel(this.rrt, RemoteRuntimeType.this.enableSavePass);
        }

        public void create() {
            this.ftppasspanel = new PasswordPanel(this.rrt, RemoteRuntimeType.this.enableSavePass);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.ftppasspanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType == null ? (class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType = RemoteRuntimeType.class$("org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType")) : class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType), (String)"TITLE_FTP_PASS"), true, (ActionListener)this);
            dialogDescriptor.setValid(false);
            this.ftppasspanel.setDialogDescriptor(dialogDescriptor);
            this.newDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.newDialog.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.newDialog != null) {
                this.newDialog.dispose();
                this.newDialog = null;
            }
        }

        public char[] getFTPPass() {
            return null;
        }
    }

    class PromptNewPassword
    implements ActionListener,
    Serializable {
        private transient Dialog myDialog = null;
        private transient PasswordPanel passpanel = null;
        private transient RemoteRuntimeType rrt = null;

        public PromptNewPassword(RemoteRuntimeType remoteRuntimeType2) {
            this.rrt = remoteRuntimeType2;
        }

        public PromptNewPassword(RemoteRuntimeType remoteRuntimeType2, Component component) {
            this.rrt = remoteRuntimeType2;
        }

        public void create() {
            this.passpanel = new PasswordPanel(this.rrt);
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.passpanel, NbBundle.getMessage((Class)(class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType == null ? (class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType = RemoteRuntimeType.class$("org.netbeans.modules.distributed.ideserverclient.RemoteRuntimeType")) : class$org$netbeans$modules$distributed$ideserverclient$RemoteRuntimeType), (String)"TITLE_NEW_PASS"), true, (ActionListener)this);
            dialogDescriptor.setValid(false);
            this.passpanel.setDialogDescriptor(dialogDescriptor);
            this.myDialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            this.myDialog.show();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                if (actionEvent.getSource() == DialogDescriptor.OK_OPTION) {
                    RemoteRuntimeType.access$002(RemoteRuntimeType.this, this.passpanel.getNewPassword());
                    RemoteRuntimeType.this.doConnect = true;
                    if (this.passpanel.getSavePass()) {
                        RemoteRuntimeType.this.savePassword = true;
                        DistributedSettings.getDefault().removeRemoteRuntime(this.rrt);
                        this.rrt.setSavePassword(true);
                        DistributedSettings.getDefault().putRemoteRuntime(this.rrt);
                    }
                }
                if (actionEvent.getSource() == DialogDescriptor.CANCEL_OPTION) {
                    RemoteRuntimeType.this.doConnect = false;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

