/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remoteexecute;

import java.awt.Toolkit;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.remoteexecute.RemoteOutputStreamParse;
import org.openide.ErrorManager;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.ExternalCompiler;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.WeakSet;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class OutputWriterOutputStream
extends RemoteOutputStreamParse {
    private OutputWriter writer;
    private static final Set hyperlinks = new WeakSet();
    static /* synthetic */ Class class$org$openide$cookies$EditorCookie;

    public OutputWriterOutputStream(OutputWriter outputWriter, ExternalCompiler.ErrorExpression errorExpression) {
        super(errorExpression);
        this.writer = outputWriter;
    }

    protected void handleClose() throws IOException {
        this.writer.flush();
        this.writer.close();
    }

    protected void writeLine(String string, FileObject fileObject, int n, int n2, int n3, int n4, String string2) throws IOException {
        Hyperlink hyperlink = new Hyperlink(fileObject, n, n2, n3, n4, string2);
        String string3 = fileObject.getPath();
        this.writer.println(this.formatMessage(string3, string2, n, n2, n3, n4), (OutputListener)hyperlink);
    }

    protected void writeLine(String string) throws IOException {
        this.writer.println(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void detachAllAnnotations() {
        Set set = hyperlinks;
        synchronized (set) {
            Iterator iterator = hyperlinks.iterator();
            while (iterator.hasNext()) {
                ((Hyperlink)iterator.next()).destroy();
            }
        }
    }

    public static final class Hyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Hyperlink(FileObject fileObject, int n, int n2, int n3, int n4, String string) {
            this.file = fileObject;
            this.line1 = n;
            this.col1 = n2;
            this.line2 = n3;
            this.col2 = n4;
            this.message = string;
            Set set = hyperlinks;
            synchronized (set) {
                hyperlinks.add(this);
            }
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWriterOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie != null) {
                    if (this.line1 == -1) {
                        editorCookie.open();
                    } else {
                        editorCookie.openDocument();
                        Line line = editorCookie.getLineSet().getOriginal(this.line1);
                        if (!line.isDeleted()) {
                            this.attachAsNeeded(line);
                            if (this.col1 == -1) {
                                line.show(2);
                            } else {
                                line.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWriterOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie != null) {
                    Line line;
                    if (editorCookie.getDocument() == null) {
                        return;
                    }
                    if (this.line1 != -1 && !(line = editorCookie.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(line);
                        if (this.col1 == -1) {
                            line.show(0);
                        } else {
                            line.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
        }

        private synchronized void attachAsNeeded(Line line) {
            if (this.getAttachedAnnotatable() == null) {
                Object object;
                boolean bl = true;
                String string = line.getText();
                if (string != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    int n = this.convertTabColumnsToCharacterColumns(string, this.col1, 8);
                    int n2 = this.convertTabColumnsToCharacterColumns(string, this.col2, 8);
                    object = n2 != -1 && n2 >= n && n2 < string.length() ? line.createPart(n, n2 - n + 1) : (n < string.length() ? line.createPart(n, string.length() - n - 1) : line);
                } else {
                    object = line;
                }
                this.attach((Annotatable)object);
                Iterator iterator = hyperlinks.iterator();
                while (iterator.hasNext()) {
                    Hyperlink hyperlink = (Hyperlink)iterator.next();
                    if (hyperlink == this) continue;
                    hyperlink.doDetach();
                }
                object.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private int convertTabColumnsToCharacterColumns(String string, int n, int n2) {
            int n3;
            char[] cArray = string.toCharArray();
            int n4 = 0;
            for (n3 = 0; n3 < cArray.length && n4 < n; ++n3) {
                if (cArray[n3] == '\t') {
                    n4 += n2 - n4 % n2;
                    continue;
                }
                ++n4;
            }
            return n3;
        }

        private synchronized void doDetach() {
            Annotatable annotatable = this.getAttachedAnnotatable();
            if (annotatable != null) {
                annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.dead) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("text") || string.equals("deleted")) {
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-apache-tools-ant-module-error";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "Hyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }

    public static final class InlineHyperlink
    extends Annotation
    implements OutputListener,
    PropertyChangeListener {
        private FileObject file;
        private int line1;
        private int col1;
        private int line2;
        private int col2;
        private String message;
        private boolean dead = false;

        public InlineHyperlink(FileObject fileObject, int n, int n2, int n3, int n4, String string) {
            this.file = fileObject;
            this.line1 = n;
            this.col1 = n2;
            this.line2 = n3;
            this.col2 = n4;
            this.message = string;
        }

        public boolean equals(Object object) {
            if (!(object instanceof InlineHyperlink)) {
                return false;
            }
            InlineHyperlink inlineHyperlink = (InlineHyperlink)object;
            return this.file.equals(inlineHyperlink.file) && this.line1 == inlineHyperlink.line1;
        }

        public int hashCode() {
            return this.file.hashCode() + this.line1;
        }

        public FileObject getFileObject() {
            return this.file;
        }

        public int getLine1() {
            return this.line1;
        }

        void destroy() {
            this.doDetach();
            this.dead = true;
        }

        public void outputLineAction(OutputEvent outputEvent) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                Toolkit.getDefaultToolkit().beep();
                return;
            }
            if (this.message != null) {
                StatusDisplayer.getDefault().setStatusText(this.message);
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWriterOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie != null) {
                    if (this.line1 == -1) {
                        editorCookie.open();
                    } else {
                        editorCookie.openDocument();
                        Line line = editorCookie.getLineSet().getOriginal(this.line1);
                        if (!line.isDeleted()) {
                            this.attachAsNeeded(line);
                            if (this.col1 == -1) {
                                line.show(2);
                            } else {
                                line.show(2, this.col1);
                            }
                        }
                    }
                } else {
                    Toolkit.getDefaultToolkit().beep();
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(16, (Throwable)iOException);
            }
        }

        public void outputLineSelected(OutputEvent outputEvent) {
            if (this.dead) {
                return;
            }
            if (!this.file.isValid()) {
                return;
            }
            try {
                DataObject dataObject = DataObject.find((FileObject)this.file);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(class$org$openide$cookies$EditorCookie == null ? (class$org$openide$cookies$EditorCookie = OutputWriterOutputStream.class$("org.openide.cookies.EditorCookie")) : class$org$openide$cookies$EditorCookie);
                if (editorCookie != null) {
                    Line line;
                    if (editorCookie.getDocument() == null) {
                        return;
                    }
                    if (this.line1 != -1 && !(line = editorCookie.getLineSet().getOriginal(this.line1)).isDeleted()) {
                        this.attachAsNeeded(line);
                        if (this.col1 == -1) {
                            line.show(0);
                        } else {
                            line.show(0, this.col1);
                        }
                    }
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                ErrorManager.getDefault().notify(16, (Throwable)dataObjectNotFoundException);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ErrorManager.getDefault().notify(16, (Throwable)indexOutOfBoundsException);
            }
        }

        private synchronized void attachAsNeeded(Line line) {
            if (this.getAttachedAnnotatable() == null) {
                Object object;
                boolean bl = true;
                String string = line.getText();
                if (string != null && (this.line2 == -1 || this.line1 == this.line2) && this.col1 != -1) {
                    int n = this.convertTabColumnsToCharacterColumns(string, this.col1, 8);
                    int n2 = this.convertTabColumnsToCharacterColumns(string, this.col2, 8);
                    object = n2 != -1 && n2 >= n && n2 < string.length() ? line.createPart(n, n2 - n + 1) : (n < string.length() ? line.createPart(n, string.length() - n - 1) : line);
                } else {
                    object = line;
                }
                this.attach((Annotatable)object);
                object.addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private int convertTabColumnsToCharacterColumns(String string, int n, int n2) {
            int n3;
            char[] cArray = string.toCharArray();
            int n4 = 0;
            for (n3 = 0; n3 < cArray.length && n4 < n; ++n3) {
                if (cArray[n3] == '\t') {
                    n4 += n2 - n4 % n2;
                    continue;
                }
                ++n4;
            }
            return n3;
        }

        private synchronized void doDetach() {
            Annotatable annotatable = this.getAttachedAnnotatable();
            if (annotatable != null) {
                annotatable.removePropertyChangeListener((PropertyChangeListener)this);
                this.detach();
            }
        }

        public void outputLineCleared(OutputEvent outputEvent) {
            this.doDetach();
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (this.dead) {
                return;
            }
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("text") || string.equals("deleted")) {
                this.doDetach();
            }
        }

        public String getAnnotationType() {
            return "org-netbeans-modules-java-parser_annotation";
        }

        public String getShortDescription() {
            return this.message;
        }

        public String toString() {
            return "inLineHyperlink[" + this.file + ":" + this.line1 + ":" + this.col1 + ":" + this.line2 + ":" + this.col2 + "]";
        }
    }
}

