/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import java.io.File;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.VcsAdditionalCommand;
import org.netbeans.modules.vcscore.commands.CommandDataOutputListener;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class RemoteFileChooserSelector
implements VcsAdditionalCommand {
    private VcsFileSystem fileSystem;
    public static final String LIB_LOCAL_ROOT = "LIB_LOCAL_ROOT";
    public static final String LIB_REMOTE_ROOT = "LIB_REMOTE_ROOT";
    public static final String WORK_LOCAL_ROOT = "WORK_LOCAL_ROOT";
    public static final String WORK_REMOTE_ROOT = "WORK_REMOTE_ROOT";
    public static final String VAR_AUTO_FILL = "AUTO_FILL_VARS";
    public static final String HIDE = "HIDE";
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSListCommand") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");

    public void setFileSystem(VcsFileSystem fileSystem) {
        this.fileSystem = fileSystem;
    }

    private void startDialog(CommandDataOutputListener stdoutListener, String arg) {
        boolean showHide = false;
        Vector vars = this.fileSystem.getVariables();
        if (arg.equals("runtime")) {
            RemoteRuntimeType rrt = CMSRemoteUtil.createRemoteRuntimeDialog("Select Remote Runtime Server");
            if (rrt != null) {
                if (debug) {
                    System.out.println("rrt:" + rrt.getAsText());
                }
                stdoutListener.outputData(new String[]{rrt.getAsText()});
            }
        } else {
            String rrtString = CMSRemoteUtil.findFVSVar(vars, "REMOTERUNTIME");
            if (rrtString == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server is not selected.\nPlease select Remote Server first", 2));
                return;
            }
            if (debug) {
                System.out.println("rrt:" + rrtString);
            }
            RemoteRuntimeType rrt = null;
            HashSet runtimes = DistributedSettings.getDefault().getRemoteRuntimes();
            Iterator itr = runtimes.iterator();
            boolean firstItem = true;
            while (itr.hasNext()) {
                RemoteRuntimeType curRrt = (RemoteRuntimeType)itr.next();
                if (!curRrt.isConnected() || !rrtString.equalsIgnoreCase(curRrt.getAsText())) continue;
                rrt = curRrt;
                break;
            }
            if (rrt == null) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Selected Remote server is invalid.\nPlease select Remote Server again", 2));
            } else {
                String[] roots = null;
                if (arg.equals("work")) {
                    if (CMSRemoteUtil.isUseFTP(vars)) {
                        roots = CMSRemoteUtil.createRemoteFTPRootDialog("Select Remote Working Directory", rrt, false);
                        if (roots != null) {
                            if (roots[0] == null || roots[0].equals("")) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Local FTP Directory Root of the FTP filesystem is not specified.", 2));
                                return;
                            }
                            if (roots[1] == null || roots[1].equals("")) {
                                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote FTP Directory Root of the FTP filesystem is not specified.", 2));
                                return;
                            }
                            try {
                                this.fileSystem.setRootDirectory(new File(roots[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                            CMSRemoteUtil.updateFVSVar(vars, "ROOTDIR", roots[0]);
                            CMSRemoteUtil.updateFVSVar(vars, WORK_REMOTE_ROOT, roots[1]);
                            CMSRemoteUtil.updateFVSVar(vars, "USE_FTP", "true");
                            CMSRemoteUtil.updateFVSVar(vars, "FTP_PORT", roots[2]);
                            CMSRemoteUtil.updateFVSVar(vars, "FTP_READ_ONLY", roots[3]);
                            CMSRemoteUtil.updateFVSVar(vars, "USE_PORT_FORWARD", roots[4]);
                            CMSRemoteUtil.updateFVSVar(vars, "PASSIVE_MODE", roots[5]);
                        }
                    } else {
                        roots = CMSRemoteUtil.createRemoteRootDialog("Select Remote Working Directory", rrt, false);
                        if (roots != null) {
                            try {
                                this.fileSystem.setRootDirectory(new File(roots[0]));
                            }
                            catch (Exception e) {
                                e.printStackTrace(System.err);
                            }
                            CMSRemoteUtil.updateFVSVar(vars, "ROOTDIR", roots[0]);
                            CMSRemoteUtil.updateFVSVar(vars, WORK_REMOTE_ROOT, roots[1]);
                            CMSRemoteUtil.updateFVSVar(vars, HIDE, "False");
                        }
                    }
                } else {
                    String remoteRoot = CMSRemoteUtil.createRemoteLibDialog("Select Remote CMS Library", rrt);
                    if (remoteRoot != null) {
                        CMSRemoteUtil.updateFVSVar(vars, LIB_REMOTE_ROOT, remoteRoot);
                        roots = new String[]{remoteRoot};
                    }
                }
                if (roots != null) {
                    stdoutListener.outputData(new String[]{roots[0]});
                }
            }
        }
    }

    public boolean exec(Hashtable vars, String[] args, CommandOutputListener stdoutNRListener, CommandOutputListener stderrNRListener, CommandDataOutputListener stdoutListener, String dataRegex, CommandDataOutputListener stderrListener, String errorRegex) {
        this.startDialog(stdoutListener, args[0]);
        return true;
    }
}

