/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.FileUtility;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Vector;
import org.openide.TopManager;

public class DCLExecutor {
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    private static final int MAX_CMD_LEN = 234;
    public static final int DCL_EXECUTION_DECTERM = 0;
    public static final int DCL_EXECUTION_STDOUT = 1;
    public static final char QUOTE_REPLACEMENT_CHAR = '\u0080';

    private static String composeDCLCmd(int idx, String cmd) {
        return "$ s" + idx + " := " + "\"" + cmd + "\"";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createDCLFile(String fname, Vector dclCmds) throws IOException {
        PrintWriter pout = null;
        try {
            FileOutputStream outFile = new FileOutputStream(fname);
            BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
            pout = new PrintWriter((Writer)out, true);
            for (int i = 0; i < dclCmds.size(); ++i) {
                pout.print((String)dclCmds.get(i) + '\n');
                if (!debug) continue;
                System.out.println("Writing DCL command line: " + dclCmds.get(i));
            }
        }
        finally {
            if (pout != null) {
                pout.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Process execute(String fname, int executionType) throws IOException {
        if (executionType == 0) {
            PrintWriter pout = null;
            File tmpDCLFile = File.createTempFile("compilerparams", ".bat");
            tmpDCLFile.deleteOnExit();
            try {
                FileOutputStream outFile = new FileOutputStream(tmpDCLFile.getAbsolutePath());
                BufferedWriter out = new BufferedWriter(new OutputStreamWriter(outFile));
                pout = new PrintWriter((Writer)out, true);
                pout.println("$ create/term/wait @" + FileUtility.unixPathToOpenVMSPath(fname, false));
                pout.println("$ exit %X10000000");
            }
            finally {
                if (pout != null) {
                    pout.close();
                }
            }
            return Runtime.getRuntime().exec(tmpDCLFile.getAbsolutePath());
        }
        return Runtime.getRuntime().exec(fname);
    }

    public static Vector preprocessDCLCmds(String[] DCLCmds, int executionType) {
        Vector<String> newDCLCmds = new Vector<String>();
        if (DCLCmds.length > 0) {
            newDCLCmds.add("$ set noon");
            newDCLCmds.add("$ unix_spec = P1");
            newDCLCmds.add("$ gosub UnixtoVMS");
            newDCLCmds.add("$ defdir = vms_dev_spec + vms_dir_spec");
            newDCLCmds.add("$ set default 'defdir'");
            newDCLCmds.add("$ pname =  \"CMS\" + f$getjpi(\"\", \"PID\") + \"_1\"");
            newDCLCmds.add("$ c0 := \"spawn/nonoti/nowait/nolog/proc=\"\"''pname'\"\" \"");
            for (int i = 0; i < DCLCmds.length; ++i) {
                if (DCLCmds[i] == null) continue;
                DCLExecutor.preprocessDCLCmd(DCLCmds[i], newDCLCmds);
            }
            if (executionType == 0) {
                DCLExecutor.preprocessDCLCmd("inquire/local check \"\"Press enter to exit\"\"", newDCLCmds);
                newDCLCmds.add("$ exit %X10000000");
            } else {
                newDCLCmds.add("$ open/write/error=no_data outfile 'pname'.dat");
                newDCLCmds.add("$ index = 1");
                newDCLCmds.add("$outloop:");
                newDCLCmds.add("$ if (f$type(s'index') .nes. \"\")");
                newDCLCmds.add("$ then");
                newDCLCmds.add("$   write outfile s'index'");
                newDCLCmds.add("$   index = index + 1");
                newDCLCmds.add("$   goto outloop");
                newDCLCmds.add("$ endif");
                newDCLCmds.add("$ close outfile");
                newDCLCmds.add("$'c0' 's0'");
                newDCLCmds.add("$ timeout_count = 1200");
                newDCLCmds.add("$ pid = f$pid(ctx)");
                newDCLCmds.add("$ if (f$type(ctx) .eqs. \"PROCESS_CONTEXT\")");
                newDCLCmds.add("$ then");
                newDCLCmds.add("$   temp = f$context(\"PROCESS\", ctx, \"CANCEL\")");
                newDCLCmds.add("$ else");
                newDCLCmds.add("$   exit");
                newDCLCmds.add("$ endif");
                newDCLCmds.add("$poll_loop:");
                newDCLCmds.add("$ wait 00:00:00.10");
                newDCLCmds.add("$ temp = f$context(\"PROCESS\", ctx, \"PRCNAM\", \"''pname'\", \"EQL\")");
                newDCLCmds.add("$ temppid = f$pid(ctx)");
                newDCLCmds.add("$ if (f$type(ctx) .nes. \"PROCESS_CONTEXT\") then goto completed");
                newDCLCmds.add("$ temp = f$context(\"PROCESS\", ctx, \"CANCEL\")");
                newDCLCmds.add("$ timeout_count = timeout_count - 1");
                newDCLCmds.add("$ if (timeout_count .gt. 0) then goto poll_loop");
                newDCLCmds.add("$ if (f$pid(ctx) .nes. \"\") then stop/id='pid'");
                newDCLCmds.add("$ write sys$error \"Spawned CMS command has timed out\"");
                newDCLCmds.add("$ exit %X10000004");
                newDCLCmds.add("$UnixtoVMS:");
                newDCLCmds.add("$ vms_dev_spec = f$element(1, \"/\", unix_spec) + \":\"");
                newDCLCmds.add("$ vms_dir_spec = \"\"");
                newDCLCmds.add("$ vms_file_spec = \"\"");
                newDCLCmds.add("$ element_count = 2");
                newDCLCmds.add("$parse_loop:");
                newDCLCmds.add("$ vms_dir_element = f$element(element_count, \"/\", unix_spec)");
                newDCLCmds.add("$ if ((vms_dir_element .eqs. \"/\") .or. (vms_dir_element .eqs. \"\")) then goto done_parse");
                newDCLCmds.add("$ if (f$locate(\".\", vms_dir_element) .ne. f$length(vms_dir_element))");
                newDCLCmds.add("$ then");
                newDCLCmds.add("$   vms_file_spec = vms_dir_element");
                newDCLCmds.add("$   goto done_parse");
                newDCLCmds.add("$ endif");
                newDCLCmds.add("$ if (vms_dir_spec .nes. \"\")");
                newDCLCmds.add("$ then");
                newDCLCmds.add("$   vms_dir_spec = vms_dir_spec + \".\" + vms_dir_element");
                newDCLCmds.add("$ else");
                newDCLCmds.add("$   vms_dir_spec = vms_dir_element");
                newDCLCmds.add("$ endif");
                newDCLCmds.add("$ element_count = element_count + 1");
                newDCLCmds.add("$ if (element_count .ge. 10) then goto done_parse");
                newDCLCmds.add("$ goto parse_loop");
                newDCLCmds.add("$done_parse:");
                newDCLCmds.add("$ vms_dir_spec = \"[\" + vms_dir_spec + \"]\"");
                newDCLCmds.add("$ return");
                newDCLCmds.add("$completed:");
                newDCLCmds.add("$ if (f$search(\"''pname'.sts\") .eqs. \"\") then goto no_status");
                newDCLCmds.add("$ open/read/error=no_status infile 'pname'.sts");
                newDCLCmds.add("$ read infile severity");
                newDCLCmds.add("$ read infile status");
                newDCLCmds.add("$ close infile");
                newDCLCmds.add("$ dele/noconf 'pname'.sts;*");
                newDCLCmds.add("$ done :");
                newDCLCmds.add("$ exit status");
                newDCLCmds.add("$no_data:");
                newDCLCmds.add("$ write sys$error \"Error creating data file for CMS command\"");
                newDCLCmds.add("$ exit %X10018294");
                newDCLCmds.add("$no_status:");
                newDCLCmds.add("$ write sys$error \"Spawned CMS command did not return status\"");
                newDCLCmds.add("$ exit %X10018294");
            }
        }
        return newDCLCmds;
    }

    public static Process execute(String fname, String[] DCLCmds, int executionType) throws IOException {
        Vector newDCLCmds = DCLExecutor.preprocessDCLCmds(DCLCmds, executionType);
        try {
            DCLExecutor.createDCLFile(fname, newDCLCmds);
        }
        catch (Exception e) {
            TopManager.getDefault().getErrorManager().notify((Throwable)e);
            throw new IOException(e.toString());
        }
        return DCLExecutor.execute(fname, executionType);
    }

    public static void preprocessDCLCmd(String cmd, Vector dclCmds) {
        String fcmd = "$'c0'";
        int idx = 0;
        int qidx = 0;
        int eidx = 0;
        int i = 0;
        while (true) {
            eidx = cmd.indexOf(" ", idx + 1) == -1 ? cmd.length() : cmd.indexOf(" ", idx + 1);
            qidx = cmd.indexOf("\"", idx);
            if (qidx != -1 && qidx < eidx) {
                eidx = cmd.indexOf("\"", qidx + 1) == -1 ? cmd.length() : cmd.indexOf("\"", qidx + 1) + 1;
                dclCmds.add(DCLExecutor.composeDCLCmd(i, DCLExecutor.quadrupleQuote(cmd.substring(qidx, eidx))));
            } else {
                dclCmds.add(DCLExecutor.composeDCLCmd(i, cmd.substring(idx, eidx).trim()));
            }
            idx = ++eidx;
            if (eidx >= cmd.length()) break;
            ++i;
        }
    }

    private static String quadrupleQuote(String str) {
        StringBuffer newstr = new StringBuffer(str.length());
        if (debug) {
            System.out.println("Entering quadrupleQuote...");
            System.out.println("Input string = " + str + " length = " + str.length());
        }
        String repstr = str.replace('\u0080', '\"');
        if (debug) {
            System.out.println("Reconstituted string = " + repstr);
        }
        for (int index = 1; index < str.length() - 1; ++index) {
            char tmpchar = repstr.charAt(index);
            newstr.append(tmpchar);
            if (tmpchar != '\"') continue;
            if (debug) {
                System.out.println("Quadrupling quote at index: " + index);
            }
            newstr.append("\"\"\"");
        }
        if (debug) {
            System.out.println("Returning string: " + newstr.toString());
            System.out.println("...Leaving quadrupleQuote");
        }
        return newstr.toString();
    }
}

