/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.CMSRemoteUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.KeyStroke;
import javax.swing.filechooser.FileSystemView;
import org.openide.util.NbBundle;

public class ChooseDirDialog
extends JDialog {
    private JFileChooser chooser = null;
    private File initialDir = null;
    private File selectedDir = null;
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSCommandProcessor") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    static final long serialVersionUID = 3391153941140021894L;
    static /* synthetic */ Class class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$ChooseDirDialog;

    public ChooseDirDialog(Frame owner, File initialDir) {
        super(owner, "", true);
        this.setTitle(ChooseDirDialog.g("CTL_Select_directory"));
        this.initialDir = initialDir;
        this.initComponents();
        this.pack();
    }

    private void initComponents() {
        HashMap map = CMSRemoteUtil.getRemoteRoots();
        this.chooser = new JFileChooser(new RemoteFileSystemView(map));
        this.chooser.setFileSelectionMode(1);
        this.chooser.setFileHidingEnabled(false);
        this.chooser.setApproveButtonText(ChooseDirDialog.g("CTL_Select"));
        this.chooser.setApproveButtonToolTipText(ChooseDirDialog.g("CTL_SelectToolTip"));
        this.getRootPane().registerKeyboardAction(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ChooseDirDialog.this.selectedDir = null;
                ChooseDirDialog.this.close();
            }
        }, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent evt) {
                if (evt.getKeyCode() == 27) {
                    ChooseDirDialog.this.selectedDir = null;
                    ChooseDirDialog.this.close();
                }
            }
        });
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.chooser, "Center");
        this.chooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if ("ApproveSelection".equals(evt.getActionCommand())) {
                    File f = ChooseDirDialog.this.chooser.getSelectedFile();
                    ChooseDirDialog.this.selectedDir = f;
                    ChooseDirDialog.this.close();
                } else if ("CancelSelection".equals(evt.getActionCommand())) {
                    ChooseDirDialog.this.selectedDir = null;
                    ChooseDirDialog.this.close();
                }
            }
        });
    }

    private void close() {
        this.setVisible(false);
        this.dispose();
    }

    public String getSelectedDir() {
        String path = null;
        if (this.selectedDir == null) {
            return "";
        }
        try {
            path = this.selectedDir.getCanonicalPath();
        }
        catch (IOException e) {
            if (debug) {
                e.printStackTrace(System.out);
            }
            path = null;
        }
        return path;
    }

    private static String g(String s) {
        return NbBundle.getMessage((Class)(class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$ChooseDirDialog == null ? (class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$ChooseDirDialog = ChooseDirDialog.class$("com.compaq.openvms.netbeans.cmsprofile.vcs.commands.ChooseDirDialog")) : class$com$compaq$openvms$netbeans$cmsprofile$vcs$commands$ChooseDirDialog), (String)s);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class RemoteFileSystemView
    extends FileSystemView {
        HashMap fmap = null;

        public RemoteFileSystemView(HashMap fmap) {
            this.fmap = fmap;
        }

        public File createNewFolder(File containingDir) throws IOException {
            File folder = new File(containingDir, "New Folder");
            int i = 0;
            while (!folder.mkdir()) {
                folder = new File(containingDir, "New Folder" + ++i);
            }
            return folder;
        }

        public File[] getRoots() {
            if (this.fmap == null || this.fmap.size() == 0) {
                return new File[0];
            }
            File[] files = new File[this.fmap.size()];
            System.arraycopy(this.fmap.keySet().toArray(), 0, files, 0, this.fmap.size());
            return files;
        }

        public File getDefaultDirectory() {
            if (this.fmap == null || this.fmap.size() == 0) {
                return null;
            }
            return (File)this.fmap.keySet().toArray()[0];
        }

        public String getSystemDisplayName(File f) {
            String ret = (String)this.fmap.get(f);
            if (ret == null) {
                return super.getSystemDisplayName(f);
            }
            return ret;
        }
    }
}

