/*
 * Decompiled with CFR 0.152.
 */
package com.compaq.openvms.netbeans.cmsprofile.vcs.commands;

import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteExecuteCommand;
import com.compaq.openvms.netbeans.cmsprofile.vcs.commands.RemoteUserCommandSupport;
import java.beans.PropertyVetoException;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.JFileChooser;
import org.netbeans.api.vcs.VcsManager;
import org.netbeans.api.vcs.commands.Command;
import org.netbeans.api.vcs.commands.CommandTask;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.property.RemoteRootProperty;
import org.netbeans.modules.distributed.propertyeditors.FileEditor;
import org.netbeans.modules.distributed.propertyeditors.RemoteRootCustomEditor;
import org.netbeans.modules.distributed.propertyeditors.RemoteRootEditor;
import org.netbeans.modules.distributed.propertyeditors.RemoteRuntimeTypeCustomEditor;
import org.netbeans.modules.distributed.propertyeditors.RemoteRuntimeTypeEditor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFile;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.FileUtility;
import org.netbeans.modules.distributed.util.Utils;
import org.netbeans.modules.vcscore.VcsConfigVariable;
import org.netbeans.modules.vcscore.VcsFileSystem;
import org.netbeans.modules.vcscore.cmdline.UserCommand;
import org.netbeans.modules.vcscore.commands.CommandExecutionContext;
import org.netbeans.modules.vcscore.commands.CommandOutputListener;
import org.netbeans.modules.vcscore.commands.VcsCommand;
import org.netbeans.modules.vcscore.commands.VcsCommandExecutor;
import org.netbeans.modules.vcscore.commands.VcsDescribedCommand;
import org.netbeans.spi.vcs.commands.CommandSupport;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;
import org.openide.windows.WindowManager;

public class CMSRemoteUtil {
    public static final String CMS_IDE_PATH = "/ide$cms/";
    public static final String CMS_JAVA_TEMP = "CMSINFO" + File.separatorChar + "JAVA";
    private static boolean debug = Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.CMSListCommand") | Boolean.getBoolean("VCS.OpenVMS.cmsprofile.debug.ALL");
    public static final int PREPROCESS_CANCELLED = 0;
    public static final int PREPROCESS_NEXT_FILE = 1;
    public static final int PREPROCESS_DONE = 2;
    private static RequestProcessor fsMounter = null;
    private static HashMap listenerMap = new HashMap();
    static /* synthetic */ Class class$org$openide$cookies$CloseCookie;
    static /* synthetic */ Class class$org$openide$cookies$OpenCookie;
    static /* synthetic */ Class class$org$openide$cookies$EditCookie;

    private static synchronized RequestProcessor requestProcessor() {
        if (fsMounter == null) {
            fsMounter = new RequestProcessor("CMSFS-mounter");
        }
        return fsMounter;
    }

    private static DataFolder findFolder(boolean template) {
        return CMSRemoteUtil.findFolder("Mount", "", template);
    }

    private static String prefTemplates(String root) {
        return "Templates/" + root;
    }

    private static String prefObjects(String root) {
        return root;
    }

    static DataFolder findFolder(String root, String name, boolean template) {
        try {
            FileSystem fs = Repository.getDefault().getDefaultFileSystem();
            name = template ? '/' + CMSRemoteUtil.prefTemplates(root) + name : '/' + CMSRemoteUtil.prefObjects(root) + name;
            FileObject fo = fs.findResource(name);
            if (fo == null && template) {
                name = CMSRemoteUtil.prefTemplates(root);
            }
            if (fo == null) {
                fo = FileUtil.createFolder((FileObject)fs.getRoot(), (String)name);
            }
            return DataFolder.findFolder((FileObject)fo);
        }
        catch (IOException ex) {
            IllegalStateException e = new IllegalStateException(ex.getMessage());
            ErrorManager.getDefault().annotate((Throwable)e, (Throwable)ex);
            throw e;
        }
    }

    public static HashMap getRemoteRoots() {
        Enumeration efs = Repository.getDefault().fileSystems();
        HashMap<String, String> map = new HashMap<String, String>();
        while (efs.hasMoreElements()) {
            Object fs = efs.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
            map.put(nfs.getRemoteRoot(), nfs.getDisplayName());
        }
        return map;
    }

    public static RemoteRuntimeType getRemoteRuntimeType(Hashtable vars) {
        String dir = (String)vars.get("LOCALROOTDIR");
        if (dir != null && dir.length() > 0) {
            Enumeration remoteFs = Repository.getDefault().getFileSystems();
            while (remoteFs.hasMoreElements()) {
                AbstractNetworkFileSystem nfs;
                String fsRoot;
                Object obj = remoteFs.nextElement();
                if (!(obj instanceof AbstractNetworkFileSystem) || !(fsRoot = (nfs = (AbstractNetworkFileSystem)obj).getLocalRoot()).toLowerCase().startsWith(dir.toLowerCase()) && !dir.toLowerCase().startsWith(fsRoot.toLowerCase())) continue;
                return nfs.getRemoteRuntimeType();
            }
        }
        return null;
    }

    public static boolean createRemoteTempFile(Hashtable vars, String path) throws IOException {
        RemoteRuntimeType rrt = CMSRemoteUtil.getRemoteRuntimeType(vars);
        if (rrt == null) {
            throw new IOException("RemoteRuntime is null");
        }
        RemoteRuntime rt = rrt.getRemoteRuntime();
        RemoteFileService rfs = rt.getRemoteFileService();
        try {
            rfs.createFile(path);
            return true;
        }
        catch (RemoteException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static ArrayList getRemoteFilesInfo(Hashtable vars, String dir, String pattern) throws IOException {
        RemoteRuntimeType rrt = CMSRemoteUtil.getRemoteRuntimeType(vars);
        if (rrt == null) {
            throw new IOException("RemoteRuntime is null");
        }
        RemoteRuntime rt = rrt.getRemoteRuntime();
        RemoteFileService rfs = rt.getRemoteFileService();
        try {
            return rfs.findFilesDates(dir, pattern);
        }
        catch (RemoteException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static void refreshRoot(String root) {
        Enumeration efs = Repository.getDefault().fileSystems();
        if (debug) {
            System.out.println("Entering refreshRoot");
        }
        while (efs.hasMoreElements()) {
            Object fs = efs.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            final AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
            String rootPath = nfs.getLocalRoot();
            if (rootPath.endsWith(File.separator)) {
                rootPath = rootPath.substring(0, rootPath.length() - 1);
            }
            if (root.endsWith(File.separator)) {
                root = root.substring(0, root.length() - 1);
            }
            if (debug) {
                System.out.println(root + " " + rootPath);
            }
            if (!root.equalsIgnoreCase(rootPath)) continue;
            final AbstractNetworkFileSystem nfsf = nfs;
            CMSRemoteUtil.requestProcessor().post(new Runnable(){

                public void run() {
                    int loopCount = nfs instanceof NetworkFileSystem ? 15 : 0;
                    for (int i = 0; i < loopCount; ++i) {
                        nfsf.getFSRoot().refresh(false);
                        try {
                            Thread.currentThread();
                            Thread.sleep(1000L);
                            continue;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            });
            if (!debug) break;
            System.out.println("refreshing root " + root);
            break;
        }
    }

    public static FileObject getJavaTempFO(String path) {
        Enumeration efs = Repository.getDefault().fileSystems();
        while (efs.hasMoreElements()) {
            FileObject fobj;
            Object fs = efs.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
            String rootPath = nfs.getLocalRoot();
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!path.toLowerCase().startsWith(rootPath.toLowerCase()) || path.charAt(rootPath.length() - 1) != File.separatorChar) continue;
            String resrc = path.substring(rootPath.length());
            if ((resrc = resrc.replace(File.separatorChar, '/')).endsWith("/")) {
                resrc = resrc.substring(0, resrc.length() - 1);
            }
            if (resrc.startsWith("/")) {
                resrc = resrc.substring(1);
            }
            if (debug) {
                System.out.println("refreshing:" + resrc);
            }
            if ((fobj = ((FileSystem)nfs).findResource(resrc)) == null) continue;
            FileObject[] fobjs = fobj.getChildren();
            if (fobjs != null) {
                for (int i = 0; i < fobjs.length; ++i) {
                    try {
                        fobjs[i].getInputStream().close();
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            fobj.refresh(false);
            return fobj;
        }
        return null;
    }

    public static FileObject getTempFile(String path, boolean open) {
        Enumeration efs = Repository.getDefault().fileSystems();
        while (efs.hasMoreElements()) {
            Object fs = efs.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
            String rootPath = nfs.getLocalRoot();
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (!path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!path.toLowerCase().startsWith(rootPath.toLowerCase()) || path.charAt(rootPath.length() - 1) != File.separatorChar) continue;
            String resrc = path.substring(rootPath.length());
            if ((resrc = resrc.replace(File.separatorChar, '/')).endsWith("/")) {
                resrc = resrc.substring(0, resrc.length() - 1);
            }
            if (resrc.startsWith("/")) {
                resrc = resrc.substring(1);
            }
            if (debug) {
                System.out.println("refreshing:" + resrc);
            }
            FileObject fobj = ((FileSystem)nfs).findResource(resrc);
            try {
                if (fobj == null) continue;
                if (open) {
                    fobj.getInputStream().close();
                }
                return fobj;
            }
            catch (Exception e) {
            }
        }
        return null;
    }

    public static FileObject refreshLocalDir(String path, boolean isDir) {
        Enumeration efs = Repository.getDefault().fileSystems();
        while (efs.hasMoreElements()) {
            FileObject fobj;
            Object fs = efs.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            AbstractNetworkFileSystem nfs = (AbstractNetworkFileSystem)fs;
            String rootPath = nfs.getLocalRoot();
            if (!rootPath.endsWith(File.separator)) {
                rootPath = rootPath + File.separator;
            }
            if (isDir && !path.endsWith(File.separator)) {
                path = path + File.separator;
            }
            if (!path.toLowerCase().startsWith(rootPath.toLowerCase()) || path.charAt(rootPath.length() - 1) != File.separatorChar) continue;
            String resrc = path.substring(rootPath.length());
            resrc = resrc.replace(File.separatorChar, '/');
            if (!isDir && resrc.indexOf(47) >= 0) {
                resrc = resrc.substring(0, resrc.lastIndexOf(47));
            }
            if (resrc.endsWith("/")) {
                resrc = resrc.substring(0, resrc.length() - 1);
            }
            if (resrc.startsWith("/")) {
                resrc = resrc.substring(1);
            }
            if (debug) {
                System.out.println("refreshing:" + resrc);
            }
            if ((fobj = ((FileSystem)nfs).findResource(resrc)) == null) continue;
            fobj.getChildren();
            fobj.refresh(false);
            return fobj;
        }
        return null;
    }

    public static String unixToOpenVMSUNIXPath(String unixPath, boolean isDir) {
        String vmsPath = CMSRemoteUtil.unixToOpenVMSPath(unixPath, isDir);
        String _unixPath = FileUtility.openVMSPathToUnixPath((String)vmsPath, (boolean)isDir);
        return _unixPath;
    }

    public static String unixToOpenVMSPath(String unixPath, boolean isDir) {
        CMSRemoteUtil.refreshLocalDir(unixPath, isDir);
        String vmsPath = FileUtility.__unixPathToOpenVMSPath((String)unixPath, (boolean)isDir);
        for (int i = 0; i < 15; ++i) {
            if (debug) {
                System.out.println("vmsPath:" + vmsPath);
            }
            if (unixPath.equals(vmsPath)) {
                if (i == 0 || i == 5) {
                    CMSRemoteUtil.refreshLocalDir(unixPath, isDir);
                } else {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            } else {
                return vmsPath;
            }
            vmsPath = FileUtility.__unixPathToOpenVMSPath((String)unixPath, (boolean)isDir);
        }
        return vmsPath;
    }

    public static String windowToOpenVMSUNIXPath(String winPath, boolean isDir) {
        String vmsPath = CMSRemoteUtil.windowToOpenVMSPath(winPath, isDir);
        String unixPath = FileUtility.openVMSPathToUnixPath((String)vmsPath, (boolean)isDir);
        return unixPath;
    }

    public static String windowToOpenVMSPath(String winPath, boolean isDir) {
        CMSRemoteUtil.refreshLocalDir(winPath, isDir);
        String vmsPath = FileUtility.__winPathToOpenVMSPath((String)winPath, (boolean)isDir);
        for (int i = 0; i < 15; ++i) {
            if (debug) {
                System.out.println("vmsPath:" + vmsPath);
            }
            if (winPath.equals(vmsPath)) {
                if (i == 0 || i == 5) {
                    CMSRemoteUtil.refreshLocalDir(winPath, isDir);
                } else {
                    try {
                        Thread.currentThread();
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {}
                }
            } else {
                return vmsPath;
            }
            vmsPath = FileUtility.__winPathToOpenVMSPath((String)winPath, (boolean)isDir);
        }
        return vmsPath;
    }

    public static void changeVariablesIntoUnixSpec(Hashtable vars, VcsFileSystem fileSystem) {
        String unixPath;
        String unixPath2;
        String vmsPath;
        String dir = (String)vars.get("LIBRARY");
        if (dir != null && dir.length() > 0) {
            vmsPath = Utilities.isWindows() ? FileUtility.__winPathToOpenVMSPath((String)dir, (boolean)true) : FileUtility.__unixPathToOpenVMSPath((String)dir, (boolean)true);
            unixPath2 = FileUtility.openVMSPathToUnixPath((String)vmsPath, (boolean)true);
            vars.put("LIBRARY", unixPath2);
            if (debug) {
                System.out.println("library:" + unixPath2);
            }
        }
        dir = (String)vars.get("ROOTDIR");
        vars.put("LOCALROOTDIR", dir);
        if (dir != null && dir.length() > 0) {
            vmsPath = Utilities.isWindows() ? FileUtility.__winPathToOpenVMSPath((String)dir, (boolean)true) : FileUtility.__unixPathToOpenVMSPath((String)dir, (boolean)true);
            if (debug) {
                System.out.println("vmspath:" + vmsPath);
            }
            unixPath2 = FileUtility.openVMSPathToUnixPath((String)vmsPath, (boolean)true);
            vars.put("ROOTDIR", unixPath2);
            if (debug) {
                System.out.println("rootdir:" + unixPath2);
            }
        }
        dir = (String)vars.get("DIR");
        vars.put("LOCALDIR", dir);
        if (dir != null && dir.length() > 0) {
            unixPath = dir.replace(File.separatorChar, '/');
            vars.put("DIR", unixPath);
            if (debug) {
                System.out.println("dir:" + unixPath);
            }
        }
        dir = (String)vars.get("MODULE");
        vars.put("LOCALMODULE", dir);
        if (dir != null && dir.length() > 0) {
            unixPath = dir.replace(File.separatorChar, '/');
            vars.put("MODULE", unixPath);
            if (debug) {
                System.out.println("module:" + unixPath);
            }
        }
        vars.put("PS", "/");
    }

    public static int preprocessCommand(VcsCommandExecutor vce, Hashtable vars, VcsFileSystem fileSystem) {
        if (vce instanceof RemoteExecuteCommand) {
            VcsDescribedCommand cmd = ((RemoteExecuteCommand)vce).getDescribedCommand();
            return VcsManager.getDefault().showCustomizer((Command)cmd) ? 2 : 0;
        }
        return 2;
    }

    public static void startExecutor(VcsCommandExecutor vce) {
        CMSRemoteUtil.startExecutor(vce, null);
    }

    public static void startExecutor(VcsCommandExecutor vce, VcsFileSystem fileSystem) {
        if (!(vce instanceof RemoteExecuteCommand)) {
            return;
        }
        VcsDescribedCommand cmd = ((RemoteExecuteCommand)vce).getDescribedCommand();
        cmd.execute();
    }

    public static void waitToFinish(VcsCommandExecutor vce) throws InterruptedException {
        if (!(vce instanceof RemoteExecuteCommand)) {
            return;
        }
        CommandTask task = ((RemoteExecuteCommand)vce).getTask();
        task.waitFinished(0);
    }

    public static void kill(VcsCommandExecutor vce) {
        if (!(vce instanceof RemoteExecuteCommand)) {
            return;
        }
        CommandTask task = ((RemoteExecuteCommand)vce).getTask();
        task.stop();
    }

    public static VcsCommandExecutor getCommandExecutor(VcsCommand command, Hashtable variables, VcsFileSystem fileSystem) {
        if (command instanceof UserCommand) {
            if (fileSystem == null) {
                return null;
            }
            UserCommand ucmd = (UserCommand)command;
            CommandSupport cmdSupp = fileSystem.getCommandSupport(command.getName());
            cmdSupp = new RemoteUserCommandSupport(ucmd, (CommandExecutionContext)fileSystem, CMSRemoteUtil.getRemoteRuntimeType(variables));
            Command cmd = cmdSupp.createCommand();
            if (cmd instanceof VcsDescribedCommand) {
                ((VcsDescribedCommand)cmd).setAdditionalVariables((Map)variables);
            }
            RemoteExecuteCommand executor = new RemoteExecuteCommand((CommandExecutionContext)fileSystem, (UserCommand)command, variables, CMSRemoteUtil.getRemoteRuntimeType(variables));
            if (cmd instanceof VcsDescribedCommand) {
                executor.setDescribedCommand((VcsDescribedCommand)cmd);
                ((VcsDescribedCommand)cmd).setExecutor((VcsCommandExecutor)executor);
            }
            return executor;
        }
        return null;
    }

    public static FileSystem isMounted(String root) {
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            String lroot;
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem) || !(lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(root)) continue;
            return fs;
        }
        return null;
    }

    public static FileSystem mount(Hashtable vars, String localRoot, String remoteRoot, RemoteRuntimeType remoteRuntime, CommandOutputListener stderrNRListener, boolean hide, boolean useFTP) {
        if (useFTP) {
            try {
                int ftpPort;
                try {
                    ftpPort = Integer.parseInt((String)vars.get("FTP_PORT"));
                }
                catch (Exception e) {
                    ftpPort = 21;
                }
                String readOnlyS = (String)vars.get("FTP_READ_ONLY");
                boolean readOnly = false;
                if (readOnlyS != null && readOnlyS.equals(Boolean.TRUE.toString())) {
                    readOnly = true;
                }
                boolean portForward = false;
                boolean isPassive = false;
                if (((String)vars.get("USE_PORT_FORWARD")).equals(Boolean.TRUE.toString())) {
                    portForward = true;
                }
                if (((String)vars.get("PASSIVE_MODE")).equals(Boolean.TRUE.toString())) {
                    isPassive = true;
                }
                final FTPFileSystem fs = new FTPFileSystem(remoteRuntime, ftpPort, localRoot, remoteRoot, portForward, isPassive);
                fs.setReadOnly(readOnly);
                fs.setAutoSync(true);
                RequestProcessor.Task task = CMSRemoteUtil.requestProcessor().post(new Runnable(){

                    public void run() {
                        Repository.getDefault().addFileSystem((FileSystem)fs);
                    }
                });
                task.waitFinished();
                return fs;
            }
            catch (IOException e) {
                if (stderrNRListener != null) {
                    stderrNRListener.outputLine("Can't mount FileSystem:" + e.getMessage());
                }
                return null;
            }
        }
        final NetworkFileSystem fs = new NetworkFileSystem(remoteRuntime);
        fs.setRemoteRoot(new RemoteRootProperty(fs, remoteRoot, localRoot, hide));
        try {
            fs.setHidden(hide);
            fs.setRootDirectory(new File(localRoot));
            RequestProcessor.Task task = CMSRemoteUtil.requestProcessor().post(new Runnable(){

                public void run() {
                    Repository.getDefault().addFileSystem((FileSystem)fs);
                }
            });
            task.waitFinished();
        }
        catch (PropertyVetoException e) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("Can't mount FileSystem:" + e.getMessage());
            }
            return null;
        }
        catch (IOException e) {
            if (stderrNRListener != null) {
                stderrNRListener.outputLine("Can't mount FileSystem:" + e.getMessage());
            }
            return null;
        }
        return fs;
    }

    public static void removeCMSFS(List fs) {
        for (int i = 0; i < fs.size(); ++i) {
            if (((AbstractNetworkFileSystem)fs.get(i)).getRefCount() < 2) {
                FSRemover rem = new FSRemover((FileSystem)fs.get(i));
                CMSRemoteUtil.requestProcessor().post((Runnable)rem);
                continue;
            }
            ((AbstractNetworkFileSystem)fs.get(i)).decRefCount();
        }
    }

    public static RemoteRuntimeType createRemoteRuntimeDialog(String title) {
        RemoteRuntimeTypeCustomEditor editor = new RemoteRuntimeTypeCustomEditor(new RemoteRuntimeTypeEditor());
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editor, title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
            if (editor.getPropertyValue() != null && debug) {
                System.out.println(editor.getPropertyValue().toString());
            }
            return (RemoteRuntimeType)editor.getPropertyValue();
        }
        return null;
    }

    public static String[] createRemoteRootDialog(String title, RemoteRuntimeType rrt, boolean alwaysHide) {
        RemoteRootEditor peditor = new RemoteRootEditor();
        NetworkFileSystem fs = new NetworkFileSystem(rrt);
        RemoteRootProperty remoteRoot = new RemoteRootProperty(fs, "", "", alwaysHide);
        peditor.setValue((Object)remoteRoot);
        RemoteRootCustomEditor editor = new RemoteRootCustomEditor(peditor, alwaysHide);
        if (debug) {
            System.out.println("boolean:" + editor.isHideChecked());
        }
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editor, title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
            if (debug) {
                System.out.println(((RemoteRootProperty)editor.getPropertyValue()).getLocalRoot());
            }
            RemoteRootProperty prop = (RemoteRootProperty)editor.getPropertyValue();
            String[] roots = new String[]{prop.getLocalRoot(), prop.getRemoteRoot()};
            return roots;
        }
        return null;
    }

    public static String createRemoteLibDialog(String title, RemoteRuntimeType rrt) {
        JFileChooser chooser = FileEditor.createRemoteFileChooser((RemoteRuntimeType)rrt);
        chooser.setFileSelectionMode(1);
        chooser.setDialogTitle(title);
        chooser.setControlButtonsAreShown(true);
        if (chooser.showDialog(WindowManager.getDefault().getMainWindow(), "OK") == 0) {
            System.out.println(chooser.getSelectedFile().getName());
            return chooser.getSelectedFile().getName();
        }
        return null;
    }

    public static String[] createRemoteFTPRootDialog(String title, RemoteRuntimeType rrt, boolean alwaysHide) {
        RemoteFTPSelectVisualPanel editor = new RemoteFTPSelectVisualPanel(rrt);
        editor.disableAutoSync();
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)editor, title);
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor).equals(NotifyDescriptor.OK_OPTION)) {
            String[] roots = new String[]{editor.getLocalCacheRoot(), editor.getRemoteFTPRoot(), editor.getFTPPortValue().toString(), editor.getReadOnly().toString(), editor.getUseSSHForwarding().toString(), editor.getUsePassiveMode().toString()};
            return roots;
        }
        return null;
    }

    public static void cleanUp(FileObject fobj, String name, String ext) {
        try {
            FileObject fo;
            if (fobj != null && (fo = fobj.getFileObject(name, ext)) != null) {
                fo.delete();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void cleanUpAll(FileObject fobj) {
        if (fobj != null) {
            FileObject[] fobjs = fobj.getChildren();
            if (fobjs != null) {
                for (int i = 0; i < fobjs.length; ++i) {
                    try {
                        if (fobjs[i].isFolder() || fobjs[i].getNameExt().equalsIgnoreCase("file_info.cms")) continue;
                        fobjs[i].delete();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            fobj.refresh(false);
        }
    }

    public static String findRemoteRoot(RemoteRuntimeType rrt, String localDirectory) {
        String share = FileUtility.getRemoteDirectoryShare((RemoteRuntimeType)rrt, (String)localDirectory);
        if (share != null && share.length() > 0) {
            return share;
        }
        return null;
    }

    private static String createRemoteDirectory(String remoteRoot, String localDirectory) {
        StringBuffer localDir = new StringBuffer(localDirectory);
        StringBuffer remoteDir = new StringBuffer(remoteRoot);
        if (localDirectory.length() == 3) {
            return remoteRoot;
        }
        if (localDirectory.endsWith("\\")) {
            localDir.deleteCharAt(localDirectory.length() - 1);
        }
        localDir.delete(0, 2);
        String relRemoteDir = localDir.toString().replace('\\', '.');
        if (remoteRoot.endsWith("]")) {
            remoteDir.deleteCharAt(remoteRoot.length() - 1);
        } else {
            remoteDir.append('[');
        }
        remoteDir.append(relRemoteDir);
        remoteDir.append("]");
        return remoteDir.toString();
    }

    public static boolean mountCMSFS(Hashtable vars, VcsFileSystem vfs, Vector fvars, CommandOutputListener stderrNRListener) {
        String hide = (String)vars.get("HIDE");
        if (hide == null) {
            hide = "True";
        }
        String rrtID = (String)vars.get("REMOTERUNTIME");
        boolean useFTP = CMSRemoteUtil.isUseFTP(fvars);
        if (rrtID == null || rrtID.equals("")) {
            stderrNRListener.outputLine("Can't mount CMS library. Check the Remote Server or the file system where the library is mounted");
            return false;
        }
        RemoteRuntimeType runtime = null;
        HashSet runtimes = DistributedSettings.getDefault().getRemoteRuntimes();
        Iterator itr = runtimes.iterator();
        String localdir = (String)vars.get("ROOTDIR");
        String remotedir = (String)vars.get("WORK_REMOTE_ROOT");
        rrtID = (String)vars.get("REMOTERUNTIME");
        if (localdir == null || localdir.equals("") || rrtID == null || rrtID.equals("")) {
            stderrNRListener.outputLine("Can't mount CMS working directory. Check the Remote Server or the file system where the directory is mounted");
            return false;
        }
        runtime = null;
        itr = runtimes.iterator();
        if (debug) {
            System.out.println("mountng work:" + localdir);
        }
        FileSystem nfs = null;
        nfs = CMSRemoteUtil.isMounted(localdir);
        if (nfs == null) {
            while (itr.hasNext()) {
                RemoteRuntimeType curRrt = (RemoteRuntimeType)itr.next();
                if (!curRrt.displayName().equalsIgnoreCase(rrtID)) continue;
                runtime = curRrt;
            }
            if (remotedir == null || remotedir.equals("")) {
                remotedir = CMSRemoteUtil.findRemoteRoot(runtime, localdir);
            }
            if (remotedir == null || localdir == null || remotedir.equals("") || localdir.equals("")) {
                if (stderrNRListener != null) {
                    stderrNRListener.outputLine("Can't mount CMS working directory " + localdir + "\nPlease mount the Remote File System for CMS working directory");
                }
                return false;
            }
            if (runtime != null) {
                nfs = CMSRemoteUtil.mount(vars, localdir, remotedir, runtime, stderrNRListener, hide.equalsIgnoreCase("true"), useFTP);
                if (nfs == null) {
                    if (stderrNRListener != null) {
                        stderrNRListener.outputLine("Can't mount CMS working directory " + localdir);
                    }
                    return false;
                }
                CMSRemoteUtil.updateFVSVar(fvars, "WORK_REMOTE_ROOT", "");
                String prevMountDir = (String)vars.get("WORK_LOCAL_ROOT");
                if (debug) {
                    System.out.println("prevmountdir:" + prevMountDir);
                }
                if (prevMountDir != null && !prevMountDir.equals("")) {
                    CMSRemoteUtil.decNetworkFSRefCount(prevMountDir);
                }
                CMSRemoteUtil.updateFVSVar(fvars, "WORK_LOCAL_ROOT", localdir);
            } else {
                if (stderrNRListener != null) {
                    stderrNRListener.outputLine("Can't mount CMS working directory " + localdir + " Check the Remote Server " + rrtID + " from the Runtime tab");
                }
                return false;
            }
        }
        if (nfs != null && listenerMap.get(vfs) == null) {
            listenerMap.put(vfs, nfs);
        }
        return true;
    }

    public static void notifySisterFS(String path, VcsFileSystem vfs) {
        block10: {
            FileSystem fs = (FileSystem)listenerMap.get(vfs);
            if (fs != null && fs instanceof FTPFileSystem) {
                try {
                    boolean closed;
                    FTPFileSystem ffs = (FTPFileSystem)fs;
                    RemoteFile rf = ffs.getRemoteFile(path);
                    if (rf != null) {
                        rf.refresh();
                    }
                    ffs.refresh(false);
                    FileObject fobj = ffs.findResource(path);
                    if (fobj == null || !(closed = Utils.closeEditorFileObj((FileObject)fobj))) break block10;
                    DataObject dobj = null;
                    CloseCookie cc = null;
                    try {
                        dobj = DataObject.find((FileObject)fobj);
                        if (dobj != null) {
                            cc = (CloseCookie)dobj.getCookie(class$org$openide$cookies$CloseCookie == null ? (class$org$openide$cookies$CloseCookie = CMSRemoteUtil.class$("org.openide.cookies.CloseCookie")) : class$org$openide$cookies$CloseCookie);
                        }
                    }
                    catch (DataObjectNotFoundException e) {
                        DistributedModule.err.notify((Throwable)e);
                    }
                    if (dobj == null) {
                        Object obj = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)("Error Opening " + path + ". Please close it now. The file can be corrupted if continue using"), -1, 2));
                        return;
                    }
                    OpenCookie oc = (OpenCookie)dobj.getCookie(class$org$openide$cookies$OpenCookie == null ? (class$org$openide$cookies$OpenCookie = CMSRemoteUtil.class$("org.openide.cookies.OpenCookie")) : class$org$openide$cookies$OpenCookie);
                    if (oc == null) {
                        EditCookie ec = (EditCookie)dobj.getCookie(class$org$openide$cookies$EditCookie == null ? (class$org$openide$cookies$EditCookie = CMSRemoteUtil.class$("org.openide.cookies.EditCookie")) : class$org$openide$cookies$EditCookie);
                        ec.edit();
                    } else {
                        oc.open();
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }
    }

    public static String findFVSVar(Vector vars, String varName) {
        for (int i = 0; i < vars.size(); ++i) {
            VcsConfigVariable var = (VcsConfigVariable)vars.get(i);
            if (!var.getName().equals(varName)) continue;
            return var.getValue();
        }
        return null;
    }

    public static void incNetworkFSRefCount(String fsName) {
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            String lroot;
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem) || !(lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(fsName) || !fs.isValid()) continue;
            ((AbstractNetworkFileSystem)fs).incRefCount();
        }
    }

    public static void decNetworkFSRefCount(String fsName) {
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof AbstractNetworkFileSystem)) continue;
            String lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot();
            if (debug) {
                System.out.println(fsName + " " + lroot + " " + ((AbstractNetworkFileSystem)fs).getRefCount());
            }
            if (!lroot.equalsIgnoreCase(fsName) || !fs.isValid() || ((AbstractNetworkFileSystem)fs).getRefCount() >= 2) continue;
            FSRemover rem = new FSRemover(fs);
            CMSRemoteUtil.requestProcessor().post((Runnable)rem);
        }
    }

    public static boolean isUseFTP(Vector vars) {
        for (int i = 0; i < vars.size(); ++i) {
            VcsConfigVariable var = (VcsConfigVariable)vars.get(i);
            if (!var.getName().equals("USE_FTP")) continue;
            if (var.getValue() == null || var.getValue().toString().equals("")) {
                return false;
            }
            if (!var.getValue().toString().equals("true")) continue;
            return true;
        }
        return true;
    }

    public static void updateFVSVar(Vector vars, String varName, String value) {
        for (int i = 0; i < vars.size(); ++i) {
            VcsConfigVariable var = (VcsConfigVariable)vars.get(i);
            if (!var.getName().equals(varName)) continue;
            var.setValue(value);
            if (debug) {
                System.out.println("updating again:" + varName + " " + value);
            }
            return;
        }
        if (debug) {
            System.out.println("updating:" + varName + " " + value);
        }
        VcsConfigVariable var = new VcsConfigVariable(varName, null, value, false, false, false, null);
        vars.add(var);
    }

    public static long getFileTime(String date, String month, String year, String hour, String min, String sec, String mili) {
        Calendar cal = Calendar.getInstance();
        cal.clear();
        int nmonth = 0;
        int ndate = 0;
        int nyear = 0;
        int nhour = 0;
        int nmin = 0;
        int nmili = 0;
        int nsec = 0;
        if (month.equalsIgnoreCase("JAN")) {
            nmonth = 0;
        } else if (month.equalsIgnoreCase("FEB")) {
            nmonth = 1;
        } else if (month.equalsIgnoreCase("MAR")) {
            nmonth = 2;
        } else if (month.equalsIgnoreCase("APR")) {
            nmonth = 3;
        } else if (month.equalsIgnoreCase("MAY")) {
            nmonth = 4;
        } else if (month.equalsIgnoreCase("JUN")) {
            nmonth = 5;
        } else if (month.equalsIgnoreCase("JUL")) {
            nmonth = 6;
        } else if (month.equalsIgnoreCase("AUG")) {
            nmonth = 7;
        } else if (month.equalsIgnoreCase("SEP")) {
            nmonth = 8;
        } else if (month.equalsIgnoreCase("OCT")) {
            nmonth = 9;
        } else if (month.equalsIgnoreCase("NOV")) {
            nmonth = 10;
        } else if (month.equalsIgnoreCase("DEC")) {
            nmonth = 11;
        }
        try {
            nhour = Integer.parseInt(hour);
            nmin = Integer.parseInt(min);
            nsec = Integer.parseInt(sec);
            nyear = Integer.parseInt(year);
            nmili = Integer.parseInt(mili);
            ndate = Integer.parseInt(date);
        }
        catch (NumberFormatException e) {
            return 0L;
        }
        cal.set(11, nhour);
        cal.set(12, nmin);
        cal.set(13, nsec);
        cal.set(1, nyear);
        cal.set(2, nmonth);
        cal.set(5, ndate);
        Date d = cal.getTime();
        long modifedTime = cal.getTimeInMillis();
        return modifedTime;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class FSRemover
    implements FileSystem.AtomicAction,
    Runnable {
        FileSystem rem;

        public FSRemover(FileSystem f) {
            this.rem = f;
        }

        public void run() {
            try {
                Repository.getDefault().removeFileSystem(this.rem);
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
            }
        }
    }

    static class FileChangeListenerImpl
    extends FileChangeAdapter {
        private String status = null;
        FileSystem fs;

        public FileChangeListenerImpl(FileSystem fs) {
            this.fs = fs;
        }

        public void fileDeleted(FileEvent fe) {
        }

        public void fileRenamed(FileRenameEvent fe) {
        }

        public void fileFolderCreated(FileEvent fe) {
        }

        public void fileChanged(FileEvent fe) {
            if (this.fs instanceof FTPFileSystem) {
                try {
                    if (fe.getFile().getName().equals("main")) {
                        FTPFileSystem ffs = (FTPFileSystem)this.fs;
                        RemoteFile rf = ffs.getRemoteFile(fe.getFile().getPackageNameExt('/', '.'));
                        rf.refresh();
                    }
                }
                catch (IOException e) {
                    ErrorManager.getDefault().notify((Throwable)e);
                }
            }
        }

        public void fileDataCreated(FileEvent fe) {
        }
    }
}

