/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.fortransupport.fortran;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerGroup;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompiler;
import com.hp.openvms.netbeans.fortransupport.fortran.FortranCompilerType;
import com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport;
import com.hp.openvms.netbeans.utils.DCLExecutor;
import com.hp.openvms.netbeans.utils.FileUtility;
import com.hp.openvms.netbeans.utils.OrderedMap;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.compiler.Compiler;
import org.openide.compiler.ExternalCompiler;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public class FortranCompilerGroup
extends AlphaVMSCompilerGroup {
    private FortranCompilerType compilerSvcType = null;
    protected boolean isRemote = false;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$fortransupport$fortran$datasys$FortranCompilerSupport;

    public boolean getIsRemote() {
        return this.isRemote;
    }

    public void add(Compiler c) throws IllegalArgumentException {
        super.add(c);
        this.compilerSvcType = ((FortranCompiler)c).getCompilerSvcType();
        this.isRemote = ((FortranCompiler)c).isRemote();
    }

    protected Process createProcess(NbProcessDescriptor desc, String[] files) throws IOException {
        AbstractNetworkFileSystem nfs;
        ExternalCompiler[] ec = this.getAllCompilers();
        DataObject[] dobj = new DataObject[ec.length];
        String[] fnames = new String[ec.length];
        RemoteRuntimeType rrt = null;
        boolean useX = false;
        FileSystem fs = null;
        FileObject fo = null;
        for (int i = 0; i < ec.length; ++i) {
            try {
                fo = ((FortranCompiler)ec[i]).getFileObject0();
                dobj[i] = DataObject.find((FileObject)fo);
                fs = fo.getFileSystem();
                if (this.getIsRemote()) {
                    nfs = (AbstractNetworkFileSystem)fs;
                    rrt = nfs.getRemoteRuntimeType();
                    Boolean bobj = (Boolean)fo.getAttribute("useXtermCompile");
                    useX = bobj != null ? bobj.booleanValue() : nfs.getUseXtermCompile();
                }
                fnames[i] = ec[i].getFileName();
                continue;
            }
            catch (DataObjectNotFoundException ex) {
                // empty catch block
            }
        }
        FortranFormat fFormat = new FortranFormat(dobj, fnames, this.getIsRemote());
        if (this.getIsRemote()) {
            IOException ioe;
            String cmd;
            nfs = (AbstractNetworkFileSystem)fs;
            String clientIP = Utils.getIntendedHostAddress();
            int displayNumber = 0;
            if (useX) {
                Integer iobj = (Integer)fo.getAttribute("xDisplayDeviceNumber");
                displayNumber = iobj != null ? iobj.intValue() : nfs.getXDisplayDeviceNumber();
                clientIP = clientIP + ":" + displayNumber;
            }
            if (fFormat.getUseDECterm() && Utilities.isWindows() && (cmd = DistributedSettings.getDefault().getXServer()) != null && cmd.length() > 0) {
                try {
                    Runtime.getRuntime().exec(cmd);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            try {
                Thread.currentThread();
                Thread.sleep(fs != null && fs instanceof NetworkFileSystem ? 5000L : 1000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            if (rrt == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"No matching remote server is found.\nPlease go to Runtime Tab and create remote server", 2));
                DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            if (rrt.getRemoteRuntime() == null) {
                ioe = new IOException("");
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)"Remote server is diconnected.\nPlease go to Runtime Tab and make connection", 2));
                DistributedModule.err.annotate((Throwable)ioe, 1, null, null, null, null);
                throw ioe;
            }
            RemoteProcessDescriptor rpd = new RemoteProcessDescriptor("", "");
            return rpd.exec(fFormat.getCmds(), rrt, null, null, useX, clientIP, rrt.getSecurityContext());
        }
        File tmpDCLFile = File.createTempFile("compilerparams", ".bat");
        tmpDCLFile.deleteOnExit();
        return DCLExecutor.execute((String)tmpDCLFile.getAbsolutePath(), (String[])fFormat.getCmds(), (int)(fFormat.getUseDECterm() ? 0 : 1));
    }

    public void makeAbstract() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class FortranFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_BUILD_DIRECTORY = "buildDirectory";
        public static final String TAG_F77 = "f77";
        public static final String TAG_OBJECT_DIRECTORY = "objectDirectory";
        public static final String TAG_ANALYSIS_DATA = "analysisData";
        public static final String TAG_INCLUDE = "include";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_DEBUG = "debug";
        public static final String TAG_INTEGER_SIZE = "integerSize";
        public static final String TAG_FLOAT = "float";
        public static final String TAG_MODULE = "module";
        public static final String TAG_OTHER_OPTIONS = "otherOptions";
        public static final String TAG_SOURCE_FORM = "Source Form";
        public static final String TAG_EXTEND_SOURCE = "Extend Source";
        public static final String TAG_FILE = "file";
        public static final String TAG_MAKEFILE = "command file";
        public static final String TAG_GLOBAL_QUALIFIER = "Global Qualifiers";
        public static final String TAG_LOCAL_QUALIFIER = "Local Qualifiers";
        public static final String TAG_FILENAME = "file name";
        public static final String TAG_EXT = "file extension";
        public static final String TAG_DEVICE = "device";
        public static final String TAG_DIRECTORY = "directory";
        String[] FortranCmds;
        private boolean useDECterm = false;
        private boolean isRemote;

        public FortranFormat(boolean isRemote) {
            super(new String[0]);
            this.isRemote = isRemote;
        }

        public FortranFormat(DataObject[] files, String[] fnames, boolean isRemote) {
            super(new String[0]);
            this.isRemote = isRemote;
            this.composeCmds(files, fnames);
        }

        private void fillMap(FortranCompilerSupport fortranSupport, String vmsPath, String unixPath, DataObject dobj) {
            Map map = this.getMap();
            map.put(TAG_SOURCE_FORM, fortranSupport.getSourceForm().toUpperCase().equals("FIXED") ? "/SOURCE_FORM=FIXED" : "/SOURCE_FORM=FREE");
            map.put(TAG_EXTEND_SOURCE, fortranSupport.getExtendSource().equals(Boolean.TRUE) && fortranSupport.getSourceForm().toUpperCase().equals("FIXED") ? "/EXTEND_SOURCE" : "");
            String makefileString = fortranSupport.getMakefileCompiler() == null ? "" : fortranSupport.getMakefileCompiler().getAbsolutePath();
            if (makefileString != null && makefileString.length() > 0) {
                makefileString = this.isRemote ? FileUtility.unixPathToOpenVMSPath((String)makefileString, (boolean)false) : FileUtility.unixPathToOpenVMSPath((String)makefileString, (boolean)false);
            }
            String ext = dobj.getPrimaryFile().getExt();
            map.put(TAG_EXT, ext);
            String fname = vmsPath.substring(0, vmsPath.length() - ext.length());
            if (fname.endsWith(".")) {
                fname = fname.substring(0, fname.length() - 1);
            }
            map.put(TAG_FILENAME, fname);
            map.put(TAG_DEVICE, vmsPath.substring(0, vmsPath.indexOf(":")));
            map.put(TAG_DIRECTORY, vmsPath.substring(0, vmsPath.length() - dobj.getPrimaryFile().getNameExt().length()));
            map.put(TAG_FILE, vmsPath);
            map.put(TAG_MAKEFILE, makefileString);
            map.put(TAG_GLOBAL_QUALIFIER, fortranSupport.getGlobalQualifier());
            map.put(TAG_LOCAL_QUALIFIER, fortranSupport.getLocalQualifier());
        }

        private String calculateObjectDir(String buildDir, DataObject dobj, String filePath) {
            String buildDirectory = buildDir.trim();
            FileObject fobj = dobj.getPrimaryFile();
            if ((buildDirectory.equals("") || buildDirectory.equals(".")) && filePath != null && !filePath.equals("")) {
                if (this.isRemote && Utilities.isWindows()) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtility._winPathToOpenVMSPath((String)pfile.getAbsolutePath(), (boolean)true, (FileObject)fobj.getParent());
                    }
                } else if (this.isRemote) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtility.unixPathToOpenVMSPath((String)pfile.getAbsolutePath(), (boolean)true, (FileObject)fobj.getParent());
                    }
                } else {
                    int slashIndex = filePath.lastIndexOf(47);
                    if (slashIndex > 0) {
                        return FileUtility.unixPathToOpenVMSPath((String)filePath.substring(0, slashIndex), (boolean)true);
                    }
                }
            } else if (this.isRemote) {
                if (buildDirectory.startsWith("/")) {
                    buildDirectory = FileUtility.unixPathToOpenVMSPath((String)buildDirectory, (boolean)true);
                }
            } else {
                buildDirectory = FileUtility.unixPathToOpenVMSPath((String)buildDirectory, (boolean)true);
            }
            return buildDirectory;
        }

        private String createArguments(String arguments) {
            return this.format(arguments);
        }

        private String createProcessName(String procNameString) {
            String procName = this.format(procNameString);
            if (procName.indexOf(47) >= 0) {
                if (procName.charAt(0) == '@') {
                    procName = procName.substring(1);
                    procName = "@" + FileUtility.unixPathToOpenVMSPath((String)procName, (boolean)false);
                } else {
                    procName = FileUtility.unixPathToOpenVMSPath((String)procName, (boolean)false);
                }
            }
            return procName;
        }

        private String createDCLProcessName(String procNameString) {
            String procName = this.format(procNameString);
            return procName;
        }

        protected void composeCmds(DataObject[] files, String[] fnames) {
            OrderedMap oMap = new OrderedMap();
            for (int i = 0; i < files.length; ++i) {
                boolean useMakefile = false;
                FileObject fobj = files[i].getPrimaryFile();
                File file = FileUtil.toFile((FileObject)fobj);
                String filePath = this.isRemote ? (Utilities.getOperatingSystem() == 8192 || Utilities.isUnix() ? FileUtility.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fobj) : FileUtility._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fobj)) : fnames[i];
                Node.Cookie cookie = files[i].getCookie(class$com$hp$openvms$netbeans$fortransupport$fortran$datasys$FortranCompilerSupport == null ? FortranCompilerGroup.class$("com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport") : class$com$hp$openvms$netbeans$fortransupport$fortran$datasys$FortranCompilerSupport);
                if (cookie == null && (cookie = files[i].getCookie(class$com$hp$openvms$netbeans$fortransupport$fortran$datasys$FortranCompilerSupport == null ? FortranCompilerGroup.class$("com.hp.openvms.netbeans.fortransupport.fortran.datasys.FortranCompilerSupport") : class$com$hp$openvms$netbeans$fortransupport$fortran$datasys$FortranCompilerSupport)) == null) continue;
                FortranCompilerSupport fortranSupport = (FortranCompilerSupport)cookie;
                NbProcessDescriptor desc = null;
                if (fortranSupport.getBuildOption().equals(Boolean.TRUE)) {
                    desc = new NbProcessDescriptor(fortranSupport.getBuildCommand(), "");
                    useMakefile = true;
                    this.useDECterm = fortranSupport.getOutputSwitch();
                } else {
                    this.useDECterm = false;
                    desc = fortranSupport.getExternalCompiler();
                }
                this.fillMap(fortranSupport, filePath, fnames[i], files[i]);
                String procName = useMakefile ? this.createDCLProcessName(desc.getProcessName()) : this.createProcessName(desc.getProcessName());
                String arguments = this.createArguments(desc.getArguments());
                String cmdLine = procName + " " + arguments;
                cmdLine = cmdLine.trim();
                if (cmdLine.length() == 0) continue;
                String buildDirectory = null;
                buildDirectory = this.calculateObjectDir(fortranSupport.getBuildDirectory() == null ? "" : fortranSupport.getBuildDirectory().getAbsolutePath(), files[i], fnames[i]);
                oMap.put((Object)cmdLine, (Object)buildDirectory);
            }
            Iterator itr = oMap.iterator();
            this.FortranCmds = new String[oMap.size() * 2];
            int i = 0;
            while (itr.hasNext()) {
                OrderedMap.Pair mapEntry = (OrderedMap.Pair)itr.next();
                String key = (String)mapEntry.getKey();
                if (mapEntry.getValue() != null) {
                    this.FortranCmds[i++] = "set default " + mapEntry.getValue();
                    this.FortranCmds[i] = key;
                } else {
                    this.FortranCmds[i] = (String)mapEntry.getKey();
                }
                ++i;
            }
        }

        public boolean getUseDECterm() {
            return this.useDECterm;
        }

        public String[] getCmds() {
            return this.FortranCmds;
        }
    }
}

