/*
 * Decompiled with CFR 0.152.
 */
package com.hp.openvms.netbeans.cppsupport.ccpp;

import com.hp.openvms.netbeans.baseclasses.compiler.AlphaVMSCompilerGroup;
import com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CCppCompilerSupport;
import com.hp.openvms.netbeans.utils.FileUtility;
import com.hp.openvms.netbeans.utils.OrderedMap;
import java.io.File;
import java.util.Iterator;
import java.util.Map;
import org.openide.compiler.ExternalCompilerGroup;
import org.openide.execution.NbProcessDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Utilities;

public abstract class CCppCompilerGroup
extends AlphaVMSCompilerGroup {
    protected boolean isRemote = false;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CppCompilerSupport;
    static /* synthetic */ Class class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CCompilerSupport;

    public boolean getIsRemote() {
        return this.isRemote;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CCppFormat
    extends ExternalCompilerGroup.Format {
        public static final String TAG_DEFINE = "defines";
        public static final String TAG_UNDEFINE = "undefines";
        public static final String TAG_INCLUDE = "include";
        public static final String TAG_LIBRARY = "library";
        public static final String TAG_OPTIMIZE = "optimize";
        public static final String TAG_OBJECT = "object";
        public static final String TAG_DEBUG = "debug";
        public static final String TAG_WARNING = "warnings";
        public static final String TAG_OPTION = "other options";
        public static final String TAG_MAKEFILE = "command file";
        public static final String TAG_FILE = "file";
        public static final String TAG_GLOBAL_QUALIFIER = "Global Qualifiers";
        public static final String TAG_LOCAL_QUALIFIER = "Local Qualifiers";
        public static final String TAG_FILENAME = "file name";
        public static final String TAG_EXT = "file extension";
        public static final String TAG_DEVICE = "device";
        public static final String TAG_DIRECTORY = "directory";
        String[] CCppCmds;
        private boolean isRemote;
        private boolean useDECterm = false;

        public CCppFormat(boolean isRemote) {
            super(new String[0]);
            this.isRemote = isRemote;
        }

        private void fillMap(CCppCompilerSupport cppSupport, String vmsPath, String filePath, DataObject dobj) {
            Map map = this.getMap();
            FileObject fobj = dobj.getPrimaryFile();
            String makefileString = cppSupport.getMakefileCompiler() == null ? "" : cppSupport.getMakefileCompiler().getAbsolutePath();
            if (makefileString != null && makefileString.length() > 0) {
                if (this.isRemote) {
                    if (makefileString.startsWith("/")) {
                        makefileString = FileUtility.unixPathToOpenVMSPath((String)makefileString, (boolean)false);
                    }
                } else {
                    makefileString = FileUtility.unixPathToOpenVMSPath((String)makefileString, (boolean)false);
                }
            }
            String ext = dobj.getPrimaryFile().getExt();
            map.put(TAG_EXT, ext);
            String fname = vmsPath.substring(0, vmsPath.length() - ext.length());
            if (fname.endsWith(".")) {
                fname = fname.substring(0, fname.length() - 1);
            }
            map.put(TAG_FILENAME, fname);
            map.put(TAG_DEVICE, vmsPath.substring(0, vmsPath.indexOf(":")));
            map.put(TAG_DIRECTORY, vmsPath.substring(0, vmsPath.length() - dobj.getPrimaryFile().getNameExt().length()));
            map.put(TAG_MAKEFILE, makefileString);
            map.put(TAG_FILE, vmsPath);
            map.put(TAG_GLOBAL_QUALIFIER, cppSupport.getGlobalQualifier());
            map.put(TAG_LOCAL_QUALIFIER, cppSupport.getLocalQualifier());
        }

        private String calculateObjectDir(String buildDir, DataObject dobj, String filePath) {
            String buildDirectory = buildDir.trim();
            FileObject fobj = dobj.getPrimaryFile();
            if ((buildDirectory.equals("") || buildDirectory.equals(".")) && filePath != null && !filePath.equals("")) {
                if (this.isRemote && Utilities.isWindows()) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtility._winPathToOpenVMSPath((String)pfile.getAbsolutePath(), (boolean)true, (FileObject)fobj.getParent());
                    }
                } else if (this.isRemote) {
                    String curDir = (String)fobj.getAttribute("REMOTE_FILEPATH");
                    if (curDir == null || curDir.length() == 0) {
                        File pfile = FileUtil.toFile((FileObject)fobj.getParent());
                        return FileUtility.unixPathToOpenVMSPath((String)pfile.getAbsolutePath(), (boolean)true, (FileObject)fobj.getParent());
                    }
                } else {
                    int slashIndex = filePath.lastIndexOf(47);
                    if (slashIndex > 0) {
                        return FileUtility.unixPathToOpenVMSPath((String)filePath.substring(0, slashIndex), (boolean)true);
                    }
                }
            } else if (this.isRemote) {
                if (buildDirectory.startsWith("/")) {
                    buildDirectory = FileUtility.unixPathToOpenVMSPath((String)buildDirectory, (boolean)true);
                }
            } else {
                buildDirectory = FileUtility.unixPathToOpenVMSPath((String)buildDirectory, (boolean)true);
            }
            return buildDirectory;
        }

        private String createArguments(String arguments) {
            return this.format(arguments);
        }

        private String createProcessName(String procNameString) {
            String procName = this.format(procNameString);
            if (procName.indexOf(47) >= 0) {
                if (procName.charAt(0) == '@') {
                    procName = procName.substring(1);
                    procName = "@" + FileUtility.unixPathToOpenVMSPath((String)procName, (boolean)false);
                } else {
                    procName = FileUtility.unixPathToOpenVMSPath((String)procName, (boolean)false);
                }
            }
            return procName;
        }

        private String createDCLProcessName(String procNameString) {
            String procName = this.format(procNameString);
            return procName;
        }

        protected void composeCmds(DataObject[] files, String[] fnames) {
            OrderedMap oMap = new OrderedMap();
            for (int i = 0; i < files.length; ++i) {
                boolean useMakefile = false;
                Node.Cookie cookie = files[i].getCookie(class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CppCompilerSupport == null ? CCppCompilerGroup.class$("com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CppCompilerSupport") : class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CppCompilerSupport);
                Object curDir = null;
                FileObject fobj = files[i].getPrimaryFile();
                File file = FileUtil.toFile((FileObject)fobj);
                String filePath = this.isRemote ? (Utilities.getOperatingSystem() == 8192 || Utilities.isUnix() ? FileUtility.unixPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fobj) : FileUtility._winPathToOpenVMSPath((String)file.getAbsolutePath(), (boolean)false, (FileObject)fobj)) : fnames[i];
                if (cookie == null && (cookie = files[i].getCookie(class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CCompilerSupport == null ? CCppCompilerGroup.class$("com.hp.openvms.netbeans.cppsupport.ccpp.datasys.CCompilerSupport") : class$com$hp$openvms$netbeans$cppsupport$ccpp$datasys$CCompilerSupport)) == null) continue;
                CCppCompilerSupport cppSupport = (CCppCompilerSupport)cookie;
                NbProcessDescriptor desc = null;
                if (cppSupport.getBuildOption().equals(Boolean.TRUE)) {
                    desc = new NbProcessDescriptor(cppSupport.getBuildCommand(), "");
                    useMakefile = true;
                    this.useDECterm = cppSupport.getOutputSwitch();
                } else {
                    this.useDECterm = false;
                    desc = cppSupport.getExternalCompiler();
                }
                this.fillMap(cppSupport, filePath, fnames[i], files[i]);
                String procName = useMakefile ? this.createDCLProcessName(desc.getProcessName()) : this.createProcessName(desc.getProcessName());
                String arguments = this.createArguments(desc.getArguments());
                String cmdLine = procName + " " + arguments;
                cmdLine = cmdLine.trim();
                if (cmdLine.length() == 0) continue;
                String buildDirectory = null;
                buildDirectory = this.calculateObjectDir(cppSupport.getBuildDirectory() == null ? "" : cppSupport.getBuildDirectory().getAbsolutePath(), files[i], fnames[i]);
                oMap.put((Object)cmdLine, (Object)buildDirectory);
            }
            Iterator itr = oMap.iterator();
            this.CCppCmds = new String[oMap.size() * 2];
            int i = 0;
            while (itr.hasNext()) {
                OrderedMap.Pair mapEntry = (OrderedMap.Pair)itr.next();
                String key = (String)mapEntry.getKey();
                if (mapEntry.getValue() != null) {
                    this.CCppCmds[i++] = "set default " + mapEntry.getValue();
                    this.CCppCmds[i] = key;
                } else {
                    this.CCppCmds[i] = (String)mapEntry.getKey();
                }
                ++i;
            }
        }

        public boolean getUseDECterm() {
            return this.useDECterm;
        }

        public String[] getCmds() {
            return this.CCppCmds;
        }
    }
}

