/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.vmsanttask;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.tools.ant.types.Path;
import org.netbeans.modules.distributed.vmsanttask.VMSCC;

public class CCTask
extends MatchingTask {
    private static final String FAIL_MSG = "";
    private Path src;
    private File destDir;
    private boolean debug = false;
    protected boolean failOnError = false;
    protected boolean listFiles = false;
    private boolean noon = false;
    protected File[] compileList = new File[0];
    private String qualifiers = "";
    private String objdir = "";
    private String srcext = "";
    private String[] srcExtList = new String[]{"c", "cc"};
    private String objext = "";
    private String[] objExtList = new String[]{"obj"};
    private String cmd = "";
    private List filesets = new LinkedList();
    private Path compileSourcepath;

    public Path createSrc() {
        if (this.src == null) {
            this.src = new Path(this.getProject());
        }
        return this.src.createPath();
    }

    protected Path recreateSrc() {
        this.src = null;
        return this.createSrc();
    }

    public void setSrcdir(Path path) {
        if (this.src == null) {
            this.src = path;
        } else {
            this.src.append(path);
        }
    }

    public Path getSrcdir() {
        return this.src;
    }

    public void setDestdir(File file) {
        this.destDir = file;
    }

    public File getDestdir() {
        return this.destDir;
    }

    public void setQualifiers(String string) {
        this.qualifiers = string;
    }

    public String getQualifiers() {
        return this.qualifiers;
    }

    public String getCmd() {
        return this.cmd;
    }

    public void setCmd(String string) {
        this.cmd = string;
    }

    public boolean getNoon() {
        return this.noon;
    }

    public void setNoon(boolean bl) {
        this.noon = bl;
    }

    public String getSrcext() {
        return this.srcext;
    }

    public void setSrcext(String string) {
        this.srcext = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.srcExtList = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.srcExtList[n++] = stringTokenizer.nextToken().trim();
        }
    }

    public String getObjext() {
        return this.objext;
    }

    public void setObjext(String string) {
        this.objext = string;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        this.objExtList = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            this.objExtList[n++] = stringTokenizer.nextToken().trim();
        }
    }

    public void setListfiles(boolean bl) {
        this.listFiles = bl;
    }

    public boolean getListfiles() {
        return this.listFiles;
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setProceed(boolean bl) {
        this.failOnError = !bl;
    }

    public boolean getFailonerror() {
        return this.failOnError;
    }

    public boolean getDebug() {
        return this.debug;
    }

    public void execute() throws BuildException {
        this.checkParameters();
        this.resetFileLists();
        String[] stringArray = this.src.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file = this.getProject().resolveFile(stringArray[i]);
            if (!file.exists()) {
                throw new BuildException("srcdir \"" + file.getPath() + "\" does not exist!", this.getLocation());
            }
            DirectoryScanner directoryScanner = this.getDirectoryScanner(file);
            String[] stringArray2 = directoryScanner.getIncludedFiles();
            this.scanDir(file, this.destDir != null ? this.destDir : file, stringArray2);
        }
        this.compile();
    }

    protected void resetFileLists() {
        this.compileList = new File[0];
    }

    protected void scanDir(File file, File file2, String[] stringArray) {
        List<File> list = Collections.synchronizedList(new ArrayList(stringArray.length));
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            block1: for (int j = 0; j < this.srcExtList.length; ++j) {
                if (!string.toLowerCase().endsWith(this.srcExtList[j].toLowerCase())) continue;
                File file3 = new File(file2.getAbsolutePath() + File.separatorChar + string);
                for (int k = 0; k < this.objExtList.length; ++k) {
                    String string2 = string.substring(0, string.lastIndexOf(46) + 1) + this.objExtList[k];
                    File file4 = new File(file2.getAbsolutePath() + File.separatorChar + string2);
                    if (file4.exists() && file3.lastModified() >= file4.lastModified()) {
                        list.add(file3);
                        continue block1;
                    }
                    if (file4.exists() && file4.length() != 0L) continue;
                    list.add(file3);
                    continue block1;
                }
            }
        }
        Iterator iterator = list.iterator();
        this.compileList = new File[list.size()];
        int n = 0;
        while (iterator.hasNext()) {
            this.compileList[n++] = (File)iterator.next();
        }
    }

    public File[] getFileList() {
        return this.compileList;
    }

    protected void checkParameters() throws BuildException {
        if (this.src == null) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.src.size() == 0) {
            throw new BuildException("srcdir attribute must be set!", this.getLocation());
        }
        if (this.destDir != null && !this.destDir.isDirectory()) {
            throw new BuildException("destination directory \"" + this.destDir + "\" does not exist " + "or is not a directory", this.getLocation());
        }
    }

    protected void compile() {
        if (this.compileList.length > 0) {
            this.log("Compiling " + this.compileList.length + " source file" + (this.compileList.length == 1 ? FAIL_MSG : "s") + (this.destDir != null ? " to " + this.destDir : FAIL_MSG));
            VMSCC vMSCC = new VMSCC(this);
            if (!vMSCC.execute() && this.failOnError) {
                throw new BuildException(FAIL_MSG, this.getLocation());
            }
        }
    }

    public class ImplementationSpecificArgument
    extends org.apache.tools.ant.util.facade.ImplementationSpecificArgument {
        public void setCompiler(String string) {
            super.setImplementation(string);
        }
    }
}

