/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.settings;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.options.SystemOption;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class DistributedSettings
extends SystemOption {
    static final long serialVersionUID = 5377810353790672705L;
    public String version = "1.0";
    public static final String PROP_REMOTE_RUNTIMES = "remoteRuntimes";
    public static final String PROP_TRUST_STORE = "trustStore";
    public static final String PROP_TRUST_STORE_PASSWORD = "trustStorePassword";
    public static final String PROP_USERNAME = "userName";
    public static final String PROP_PASSWD = "passwd";
    public static final String PROP_HOSTNAME = "hostName";
    public static final String PROP_PORT = "port";
    public static final String PROP_SAVEALL = "saveAll";
    public static final String PROP_TIME_OUT = "timeOut";
    public static final String PROP_XSVR = "xServer";
    public static final String PROP_JAVAHOME = "javaHome";
    public static final String PROP_JDKHOME = "JDKHome";
    public static final String PROP_USEX_COMPILE = "useXtermCompile";
    public static final String PROP_USEX_EXECUTION = "useXtermExecution";
    public static final String PROP_CONNECT_AT_STARTUP = "connectAtStartup";
    public static String JAVA_HOME_141_OVMS = "/SYS$COMMON/java$141/jre";
    public static String JDK_HOME_141_OVMS = "/SYS$COMMON/java$141";
    public static final String PROP_ASCII_EXT = "asciiExtensions";
    public static final String PROP_BINARY_EXT = "binaryExtensions";
    public static final String PROP_X_DISPLAY_NUMBER = "xDisplayNumber";
    public static final String PROP_SETUP_COMMAND = "setupCommand";
    public static final String PROP_SVR_TIMEOUT = "svrTimeOut";
    private HashMap remoteRuntimes = new HashMap(8);
    private static String trustStore;
    private static String trustStorePassword;
    private static int timeout;
    private static boolean saveAll;
    private static String userName;
    private static String hostName;
    private static String passwd;
    private static String port;
    private static String setupCommand;
    private static int svrTimeOut;
    private static String xServer;
    private static boolean useXtermCompile;
    private static boolean useXtermExecution;
    private static int xDisplayNumber;
    private static boolean connectAtStartup;
    private static File setupScript;
    private static Set remoteObjs;
    private static transient boolean firstTime;
    private transient Set mountableFS = new HashSet();

    private void initializeme() {
        this.setRemoteRuntimes(new HashSet());
        this.setUserName("");
        this.setHostName("");
        this.setPort("1099");
        this.setTrustStorePassword("_keystore");
        String userTrustStore = System.getProperty("netbeans.user") + File.separatorChar + "distributed" + File.separatorChar + "_truststore";
        File ut = new File(userTrustStore);
        if (!ut.exists()) {
            userTrustStore = System.getProperty("netbeans.home") + File.separatorChar + "distributed" + File.separatorChar + "_truststore";
        }
        this.setTrustStore(userTrustStore);
        this.setSaveAll(true);
        this.setTimeOut(60000);
        this.setXServer("");
        this.setUseXtermCompile(false);
        this.setUseXtermExecution(false);
        remoteObjs = new HashSet();
        this.addToRemoteObjList(new String[]{"java"});
        this.setConnectAtStartup(false);
        this.setSvrTimeOut(120);
        this.setSetupCommand("");
    }

    public DistributedSettings() {
        this.initializeme();
    }

    public String displayName() {
        return NbBundle.getMessage((Class)DistributedSettings.class, (String)"LBL_settings");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    private static void startRemoteServers(final DistributedSettings settings) {
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                HashSet keys = settings.getRemoteRuntimes();
                if (keys != null) {
                    Iterator itr = keys.iterator();
                    while (itr.hasNext()) {
                        RemoteRuntimeType rrt = (RemoteRuntimeType)itr.next();
                        if (!rrt.getConnectNow() || !rrt.isConnectAtStartup()) continue;
                        rrt.getRemoteRuntimeServerSafe();
                    }
                }
            }
        });
    }

    public static DistributedSettings getDefault() {
        DistributedSettings settings = (DistributedSettings)DistributedSettings.findObject((Class)DistributedSettings.class, (boolean)true);
        String ipaddr = null;
        ipaddr = System.getProperty("java.rmi.server.hostname") != null ? System.getProperty("java.rmi.server.hostname") : Utils.getUsableInetAddress();
        if (ipaddr != null) {
            System.setProperty("java.rmi.server.hostname", ipaddr);
        }
        System.setProperty("javax.net.ssl.trustStore", settings.getTrustStore());
        System.setProperty("javax.net.ssl.trustStorePassword", settings.getTrustStorePassword());
        if (firstTime) {
            DistributedSettings.startRemoteServers(settings);
            firstTime = false;
        }
        return settings;
    }

    public String getTrustStore() {
        return trustStore;
    }

    public void setTrustStore(String tstore) {
        trustStore = tstore;
        this.firePropertyChange(PROP_TRUST_STORE, null, tstore);
        System.setProperty("javax.net.ssl.trustStore", trustStore);
    }

    public String getXServer() {
        return xServer;
    }

    public void setXServer(String x) {
        xServer = x;
        this.firePropertyChange(PROP_XSVR, null, x);
    }

    public boolean getSaveAll() {
        return saveAll;
    }

    public void setSaveAll(boolean saveAll) {
        DistributedSettings.saveAll = saveAll;
        this.firePropertyChange(PROP_SAVEALL, null, new Boolean(saveAll));
    }

    public int getTimeOut() {
        return timeout;
    }

    public void setTimeOut(int tOut) {
        timeout = tOut;
        this.firePropertyChange(PROP_TIME_OUT, null, new Integer(tOut));
    }

    public String getTrustStorePassword() {
        return trustStorePassword;
    }

    public void setTrustStorePassword(String tStorePass) {
        trustStorePassword = tStorePass;
        System.setProperty("javax.net.ssl.trustStorePassword", trustStorePassword);
        this.firePropertyChange(PROP_TRUST_STORE_PASSWORD, null, tStorePass);
    }

    public synchronized HashSet getRemoteRuntimes() {
        Collection col = this.remoteRuntimes.values();
        HashSet set = new HashSet();
        Iterator itr = col.iterator();
        while (itr.hasNext()) {
            set.add(itr.next());
        }
        return set;
    }

    public synchronized void setRemoteRuntimes(HashSet newRemoteRuntimes) {
        Iterator itr = newRemoteRuntimes.iterator();
        HashMap map = new HashMap();
        while (itr.hasNext()) {
            Object obj = itr.next();
            map.put(obj, obj);
        }
        HashMap oldRemoteRuntimes = this.remoteRuntimes;
        this.remoteRuntimes = map;
        this.firePropertyChange(PROP_REMOTE_RUNTIMES, oldRemoteRuntimes, this.remoteRuntimes);
    }

    public synchronized RemoteRuntimeType finRemoteRuntime(RemoteRuntimeType type) {
        HashSet set = this.getRemoteRuntimes();
        RemoteRuntimeType retType = null;
        Iterator itr = set.iterator();
        while (itr.hasNext()) {
            RemoteRuntimeType rt = (RemoteRuntimeType)itr.next();
            if (rt.equals(type) && rt.isConnected()) {
                return rt;
            }
            if (!rt.equals(type)) continue;
            retType = rt;
        }
        if (retType != null) {
            return retType;
        }
        return null;
    }

    public void flushRemoteRuntimes() {
        HashSet set = this.getRemoteRuntimes();
        this.setRemoteRuntimes(set);
    }

    public synchronized void putRemoteRuntime(RemoteRuntimeType rt) {
        HashSet set = this.getRemoteRuntimes();
        set.add(rt);
        this.setRemoteRuntimes(set);
    }

    public synchronized void removeRemoteRuntime(RemoteRuntimeType rt) {
        HashSet set = this.getRemoteRuntimes();
        set.remove(rt);
        this.setRemoteRuntimes(set);
    }

    public String getUserName() {
        return userName;
    }

    public void setPasswd(String passwd) {
        DistributedSettings.passwd = passwd;
        this.firePropertyChange(PROP_PASSWD, null, passwd);
    }

    public void setUserName(String user) {
        userName = user;
        this.firePropertyChange(PROP_USERNAME, null, userName);
    }

    public String getSetupCommand() {
        return setupCommand;
    }

    public void setSetupCommand(String setupCommand) {
        DistributedSettings.setupCommand = setupCommand;
        this.firePropertyChange(PROP_SETUP_COMMAND, null, setupCommand);
    }

    public String getHostName() {
        return hostName;
    }

    public void setHostName(String host) {
        hostName = host;
        this.firePropertyChange(PROP_HOSTNAME, null, hostName);
    }

    public String getPort() {
        return port;
    }

    public void setPort(String port) {
        DistributedSettings.port = port;
        this.firePropertyChange(PROP_PORT, null, port);
    }

    public boolean getUseXtermCompile() {
        return useXtermCompile;
    }

    public void setUseXtermCompile(boolean useX) {
        useXtermCompile = useX;
        this.firePropertyChange(PROP_USEX_COMPILE, null, useX ? Boolean.TRUE : Boolean.FALSE);
    }

    public int getXDisplayDeviceNumber() {
        return xDisplayNumber;
    }

    public void setXDisplayDeviceNumber(int n) {
        xDisplayNumber = n;
        this.firePropertyChange(PROP_X_DISPLAY_NUMBER, null, new Integer(n));
    }

    public int getSvrTimeOut() {
        return svrTimeOut;
    }

    public void setSvrTimeOut(int n) {
        svrTimeOut = n;
        this.firePropertyChange(PROP_SVR_TIMEOUT, null, new Integer(n));
    }

    public boolean getUseXtermExecution() {
        return useXtermExecution;
    }

    public void setConnectAtStartup(boolean connect) {
        connectAtStartup = connect;
        this.firePropertyChange(PROP_CONNECT_AT_STARTUP, null, connect ? Boolean.TRUE : Boolean.FALSE);
    }

    public boolean getConnectAtStartup() {
        return connectAtStartup;
    }

    public void setUseXtermExecution(boolean useX) {
        useXtermExecution = useX;
        this.firePropertyChange(PROP_USEX_EXECUTION, null, useX ? Boolean.TRUE : Boolean.FALSE);
    }

    public File getSetupScript() {
        return setupScript;
    }

    public void setSetupScript(File setup) {
        setupScript = setup;
    }

    public void addToRemoteObjList(String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            remoteObjs.add(extensions[i]);
        }
    }

    public void removeFromRemoteObjList(String[] extensions) {
        for (int i = 0; i < extensions.length; ++i) {
            remoteObjs.remove(extensions[i]);
        }
    }

    public boolean isRemoteObj(String extension) {
        return remoteObjs.contains(extension);
    }

    public void addUnMountableFS(String fs) {
        this.mountableFS.add(fs);
    }

    public boolean getUnMountableFS(String fs) {
        return this.mountableFS.contains(fs);
    }

    static {
        xDisplayNumber = 0;
        firstTime = true;
    }
}

