/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.wizard.RemoteFTPSelectVisualPanel;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.LocalFileSystem;
import org.openide.filesystems.Repository;
import org.openide.util.HelpCtx;

public class RemoteFTPSelectPanel
implements WizardDescriptor.Panel {
    private RemoteFTPSelectVisualPanel component;
    private RemoteRuntimeType rrt;
    private ArrayList listeners = new ArrayList();

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new RemoteFTPSelectVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValidLocal() {
        String localCache = this.component.getLocalCacheRoot();
        if (localCache == null || localCache.length() == 0) {
            return false;
        }
        if (!new File(localCache).exists()) {
            return false;
        }
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            String lroot;
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(localCache) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(localCache))) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        String localCache = this.component.getLocalCacheRoot();
        String remoteRoot = this.component.getRemoteFTPRoot();
        if (localCache == null || localCache.length() == 0 || remoteRoot == null || remoteRoot.length() == 0) {
            return false;
        }
        if (!new File(localCache).exists()) {
            return false;
        }
        Enumeration fse = Repository.getDefault().getFileSystems();
        while (fse.hasMoreElements()) {
            String lroot;
            FileSystem fs = (FileSystem)fse.nextElement();
            if (!(fs instanceof LocalFileSystem && !(fs instanceof AbstractNetworkFileSystem) ? (lroot = ((LocalFileSystem)fs).getRootDirectory().getAbsolutePath()).equalsIgnoreCase(localCache) : fs instanceof AbstractNetworkFileSystem && (lroot = ((AbstractNetworkFileSystem)fs).getLocalRoot()).equalsIgnoreCase(localCache))) continue;
            return false;
        }
        return true;
    }

    public final void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList list;
        RemoteFTPSelectPanel remoteFTPSelectPanel = this;
        synchronized (remoteFTPSelectPanel) {
            list = (ArrayList)this.listeners.clone();
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        this.rrt = (RemoteRuntimeType)wiz.getProperty("remote_runtime");
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        wiz.putProperty("remote_directory", (Object)this.component.getRemoteFTPRoot());
        wiz.putProperty("local_directory", (Object)this.component.getLocalCacheRoot());
        wiz.putProperty("FTP_PORT", (Object)this.component.getFTPPortValue());
        wiz.putProperty("AUTO_SYNC", (Object)this.component.getAutoSync());
        wiz.putProperty("READ_ONLY", (Object)this.component.getReadOnly());
        wiz.putProperty("IS_PASSIVE", (Object)this.component.getUsePassiveMode());
        wiz.putProperty("SSH_FORWARD", (Object)this.component.getUseSSHForwarding());
    }
}

