/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.wizard;

import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.Password;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.openide.ErrorManager;
import org.openide.WizardDescriptor;
import org.openide.cookies.InstanceCookie;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.nodes.BeanNode;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class RemoteFTPPanel
implements WizardDescriptor.Panel {
    protected Object instance;
    private RemoteRuntimeType rrt;
    private ArrayList listeners = new ArrayList();
    private PropertySheet sheet;
    private Node node;

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public Component getComponent() {
        Component c;
        if (this.node != null && this.node.hasCustomizer() && !((c = this.node.getCustomizer()) instanceof Window)) {
            return c;
        }
        if (this.sheet == null) {
            this.sheet = new PropertySheet();
            this.sheet.setName(NbBundle.getMessage((Class)RemoteFTPPanel.class, (String)"TITLE_ftp"));
        }
        if (this.node != null) {
            this.sheet.setNodes(new Node[]{this.node});
        }
        return this.sheet;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    private boolean isValidString(String token) {
        return token != null && token.length() > 0;
    }

    public boolean isValid() {
        FTPFileSystem ffs = (FTPFileSystem)this.instance;
        return ffs.isConnected();
    }

    public final void addChangeListener(ChangeListener l) {
        if (this.listeners == null) {
            this.listeners = new ArrayList();
        }
        this.listeners.add(l);
    }

    public final void removeChangeListener(ChangeListener l) {
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeState() {
        ArrayList list;
        RemoteFTPPanel remoteFTPPanel = this;
        synchronized (remoteFTPPanel) {
            list = (ArrayList)this.listeners.clone();
        }
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ((ChangeListener)list.get(i)).stateChanged(event);
        }
    }

    public void readSettings(Object settings) {
        WizardDescriptor wwiz = (WizardDescriptor)settings;
        this.rrt = (RemoteRuntimeType)wwiz.getProperty("remote_runtime");
        try {
            TemplateWizard wiz = (TemplateWizard)settings;
            wiz.putProperty("WizardPanel_contentSelectedIndex", (Object)new Integer(2));
            DataObject obj = wiz.getTemplate();
            InstanceCookie ic = (InstanceCookie)obj.getCookie(InstanceCookie.class);
            if (ic == null) {
                ErrorManager.getDefault().log(16, NbBundle.getMessage((Class)RemoteFTPPanel.class, (String)"ERR_InvalidFilesystemTemplate"));
                return;
            }
            this.instance = ic.instanceCreate();
            ((FTPFileSystem)this.instance).setRemoteRuntimeType(this.rrt);
            ((FTPFileSystem)this.instance).setServer(this.rrt.getHostName());
            ((FTPFileSystem)this.instance).setUsername(this.rrt.getUserName());
            ((FTPFileSystem)this.instance).setPassword(new Password(this.rrt.getPassword()));
            ((FTPFileSystem)this.instance).connectOnBackgroundFirstTime(true, true);
            this.node = new BeanNode(this.instance);
        }
        catch (Exception ex) {
            ErrorManager.getDefault().notify((Throwable)ex);
        }
    }

    public void storeSettings(Object settings) {
        WizardDescriptor wiz = (WizardDescriptor)settings;
        System.out.println("storeSettings " + ((FTPFileSystem)this.instance).getCache().getAbsolutePath());
        wiz.putProperty("ftp_filesystem", this.instance);
    }
}

