/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.remotefs.core;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URI;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.ArrayList;
import org.netbeans.modules.distributed.remotefs.core.RemoteFSNode;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileInfoExt;
import org.netbeans.modules.distributed.rmi.protocol.RemoteFileService;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.util.FileUtility;

public class RemoteFSFile
extends File {
    static final long serialVersionUID = -6784375681189513452L;
    private boolean canRead;
    private boolean canWrite;
    private boolean isDir;
    private boolean isHidden;
    private boolean isExist;
    private String absName;
    private String name;
    private String parent;
    private File parentFile;
    private long lastModified;
    private long size;
    private RemoteRuntimeType rrt;
    private RemoteFileService rfs;
    private boolean isVMSFileSpec;

    private RemoteFSFile() {
        super("", "");
    }

    public RemoteFSFile(String str) {
        super(str);
        this.name = str;
        this.absName = str;
        this.isVMSFileSpec = false;
    }

    public RemoteFSFile(String str, boolean isVmsPath) {
        this(str);
        this.isVMSFileSpec = isVmsPath;
    }

    public boolean getIsVMSFileSpec() {
        return this.isVMSFileSpec;
    }

    public RemoteFSFile(String parent, File parentFile, String name, RemoteRuntimeType rrt, boolean isDir, long lastModified, long size) {
        super(parent, name);
        this.rrt = rrt;
        this.parent = parent;
        this.parentFile = parentFile;
        this.name = name;
        this.canWrite = true;
        this.canRead = true;
        this.isDir = isDir;
        this.isHidden = false;
        this.absName = (parent == null || parent.startsWith("(") ? "" : parent + "/") + name;
        this.lastModified = lastModified;
        this.size = size;
        this.isExist = true;
        try {
            this.rfs = rrt.getRemoteFileService();
        }
        catch (RemoteException e) {
            return;
        }
    }

    public RemoteFSFile(String parent, File parentFile, String name, RemoteRuntimeType rrt) {
        super(parent, name);
        this.rrt = rrt;
        this.parent = parent;
        this.parentFile = parentFile;
        this.name = name;
        RemoteFileInfoExt rf = null;
        try {
            this.rfs = rrt.getRemoteFileService();
            if (parent != null && name.indexOf(parent) == 0 && name.length() > parent.length() && (name = name.substring(parent.length(), name.length())).startsWith("/")) {
                name = name.substring(1, name.length());
            }
            String sname = name;
            if (name != null && !name.startsWith("/") && name.indexOf(58) > 0 && name.charAt(name.indexOf(58) - 1) != '^') {
                sname = FileUtility.openVMSPathToUnixPath(name, name.endsWith("]") || name.endsWith(":"));
                rf = this.rfs.findFileDate(sname);
            } else {
                rf = this.rfs.findFileDate((parent == null ? "" : parent + "/") + sname);
            }
        }
        catch (RemoteException e) {
            return;
        }
        if (rf != null) {
            this.canWrite = true;
            this.canRead = true;
            this.isDir = rf.isDirectory();
            this.isHidden = false;
            this.absName = (parent == null || parent.startsWith("(") ? "" : parent + "/") + name;
            this.lastModified = rf.lastModified();
            this.size = rf.getSize();
            this.isExist = true;
        } else {
            this.absName = (parent == null ? "" : parent + "/") + name;
            this.isDir = true;
        }
    }

    public RemoteRuntimeType getRemoteRuntimeType() {
        return this.rrt;
    }

    public boolean canRead() {
        return this.canRead;
    }

    public boolean canWrite() {
        return this.canWrite;
    }

    public int compareTo(File pathname) {
        return this.absName.compareTo(pathname.getAbsolutePath());
    }

    public int compareTo(Object o) {
        return this.absName.compareTo(o.toString());
    }

    public boolean createNewFile() {
        return false;
    }

    public static File createTempFile(String prefix, String suffix) {
        return null;
    }

    public static File createTempFile(String prefix, String suffix, File directory) {
        return null;
    }

    public boolean delete() {
        try {
            this.rfs.delete(this.absName);
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public void deleteOnExit() {
    }

    public boolean equals(Object o) {
        if (this.toString() == null || o == null || o.toString() == null) {
            return false;
        }
        return this.compareTo(o) == 0;
    }

    public boolean exists() {
        return this.isExist;
    }

    public File getAbsoluteFile() {
        return this;
    }

    public String getAbsolutePath() {
        if (this.absName == null) {
            return this.parent;
        }
        return this.absName;
    }

    public File getCanonicalFile() {
        return this.getAbsoluteFile();
    }

    public String getCanonicalPath() {
        return this.getAbsolutePath();
    }

    public String getName() {
        return this.name;
    }

    public String getParent() {
        return this.parent;
    }

    public File getParentFile() {
        if (this.parent != null && this.parent.length() > 0) {
            if (this.parent.startsWith("(")) {
                return new RemoteFSNode(this.rrt);
            }
            if (this.parent.lastIndexOf(47) > 0) {
                return this.parentFile;
            }
            return new RemoteFSNode(this.rrt);
        }
        return null;
    }

    public String getPath() {
        if (this.isVMSFileSpec) {
            return this.getAbsolutePath();
        }
        return FileUtility.unixPathToOpenVMSPath(this.getAbsolutePath(), this.isDirectory());
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean isAbsolute() {
        return false;
    }

    public boolean isDirectory() {
        return this.isDir;
    }

    public boolean isFile() {
        return !this.isDirectory();
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public long lastModified() {
        return this.lastModified;
    }

    public long length() {
        return this.size;
    }

    public String[] list() {
        ArrayList remoteFiles = null;
        try {
            remoteFiles = this.rfs.findFilesDates(this.parent, "*.*");
        }
        catch (RemoteException e) {
            // empty catch block
        }
        String[] files = new String[remoteFiles == null ? 0 : remoteFiles.size()];
        for (int i = 0; i < files.length; ++i) {
            files[i] = (this.parent == null ? "" : this.parent + "/") + ((RemoteFileInfoExt)remoteFiles.get(i)).getFileName();
        }
        return files;
    }

    public String[] list(FilenameFilter filter) {
        return null;
    }

    public File[] listFiles() {
        ArrayList remoteFiles = null;
        if (!this.isDirectory()) {
            return null;
        }
        try {
            remoteFiles = this.rfs.findFilesDates(this.parent == null ? this.name : this.absName, "(.*)");
        }
        catch (RemoteException e) {
            e.printStackTrace(System.out);
        }
        ArrayList<RemoteFSFile> remoteFSFiles = new ArrayList<RemoteFSFile>();
        for (int i = 0; i < (remoteFiles == null ? 0 : remoteFiles.size()); ++i) {
            RemoteFSFile nrf = new RemoteFSFile(this.parent == null ? this.name : this.absName, this, ((RemoteFileInfoExt)remoteFiles.get(i)).getFileName(), this.rrt, ((RemoteFileInfoExt)remoteFiles.get(i)).isDirectory(), ((RemoteFileInfoExt)remoteFiles.get(i)).lastModified(), ((RemoteFileInfoExt)remoteFiles.get(i)).getSize());
            remoteFSFiles.add(nrf);
        }
        return remoteFSFiles.toArray(new File[0]);
    }

    public File[] listFiles(FilenameFilter filter) {
        return null;
    }

    public static File[] listRoots() {
        return null;
    }

    public boolean mkdir() {
        try {
            this.rfs.mkdirs(this.absName);
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean mkdirs() {
        return this.mkdir();
    }

    public boolean renameTo(File dest) {
        try {
            this.rfs.renameTo(this.absName, dest.getAbsolutePath());
        }
        catch (RemoteException e) {
            return false;
        }
        return true;
    }

    public boolean setLastModified(long time) {
        return false;
    }

    public boolean setReadOnly() {
        return false;
    }

    public String toString() {
        return this.absName;
    }

    public URI toURI() {
        return null;
    }

    public URL toURL() {
        return null;
    }
}

