/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.propertyeditors;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.StringTokenizer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.netbeans.modules.distributed.property.CCppListQualifier;
import org.netbeans.modules.distributed.propertyeditors.CCppListQualifierEditor;
import org.netbeans.modules.distributed.propertyeditors.SimpleJDialog;
import org.netbeans.modules.distributed.propertyeditors.StringCustomEditor;
import org.netbeans.modules.distributed.propertyeditors.StringEditor;
import org.openide.explorer.propertysheet.editors.EnhancedCustomPropertyEditor;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

class CCppListQualifierCustomEditor
extends JPanel
implements EnhancedCustomPropertyEditor {
    private static File lastDirFolder = null;
    private static File lastJarFolder = null;
    private CCppListQualifierEditor editor;
    private DefaultListModel listModel = new DefaultListModel();
    private StringEditor stringEditor;
    private JPanel innerPanel;
    private JLabel pathLabel;
    private JButton upButton;
    private JButton addDirButton;
    private JList pathList;
    private JButton downButton;
    private JScrollPane pathScrollPane;
    private JButton removeButton;

    public CCppListQualifierCustomEditor() {
        this.initComponents();
        this.pathList.setModel(this.listModel);
        this.pathScrollPane.setViewportView(this.pathList);
        this.pathLabel.setDisplayedMnemonic(CCppListQualifierCustomEditor.getString("CTL_Classpath.Border_Mnemonic").charAt(0));
        this.addDirButton.setMnemonic(CCppListQualifierCustomEditor.getString("CTL_AddDirectory_Mnemonic").charAt(0));
        this.upButton.setMnemonic(CCppListQualifierCustomEditor.getString("CTL_MoveUp_Mnemonic").charAt(0));
        this.downButton.setMnemonic(CCppListQualifierCustomEditor.getString("CTL_MoveDown_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(CCppListQualifierCustomEditor.getString("CTL_Remove_Mnemonic").charAt(0));
        this.removeButton.setMnemonic(CCppListQualifierCustomEditor.getString("CTL_Default_Mnemonic").charAt(0));
        this.pathList.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_PathList"));
        this.addDirButton.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_AddDirectory"));
        this.upButton.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_MoveUp"));
        this.downButton.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_MoveDown"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_Remove"));
        this.getAccessibleContext().setAccessibleDescription(CCppListQualifierCustomEditor.getString("ACSD_CCppListQualifierCustomEditor"));
    }

    CCppListQualifierCustomEditor(CCppListQualifierEditor propEd) {
        this();
        this.editor = propEd;
        Object value = propEd.getValue();
        if (value instanceof CCppListQualifier) {
            this.setCCppListQualifier(((CCppListQualifier)value).getPlainList());
        }
        HelpCtx.setHelpIDString((JComponent)this, (String)this.editor.getHelpID());
    }

    private void disableButtons() {
        this.removeButton.setEnabled(false);
        this.downButton.setEnabled(false);
        this.upButton.setEnabled(false);
        this.addDirButton.setEnabled(false);
    }

    private void initComponents() {
        this.innerPanel = new JPanel();
        this.addDirButton = new JButton();
        this.upButton = new JButton();
        this.downButton = new JButton();
        this.removeButton = new JButton();
        this.pathScrollPane = new JScrollPane();
        this.pathList = new JList();
        this.pathLabel = new JLabel();
        this.setLayout(new BorderLayout());
        this.innerPanel.setLayout(new GridBagLayout());
        this.innerPanel.setBorder(new EmptyBorder(new Insets(12, 12, 0, 11)));
        this.addDirButton.setText(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_AddDirectory"));
        this.addDirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CCppListQualifierCustomEditor.this.addDirButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.addDirButton, gridBagConstraints);
        this.upButton.setText(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_MoveUp"));
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CCppListQualifierCustomEditor.this.upButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.innerPanel.add((Component)this.upButton, gridBagConstraints);
        this.downButton.setText(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_MoveDown"));
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CCppListQualifierCustomEditor.this.downButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.innerPanel.add((Component)this.downButton, gridBagConstraints);
        this.removeButton.setText(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_Remove"));
        this.removeButton.setEnabled(false);
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                CCppListQualifierCustomEditor.this.removeButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 11, 0);
        this.innerPanel.add((Component)this.removeButton, gridBagConstraints);
        this.pathList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                CCppListQualifierCustomEditor.this.pathListValueChanged(evt);
            }
        });
        this.pathList.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                CCppListQualifierCustomEditor.this.pathListMouseClicked(evt);
            }
        });
        this.pathScrollPane.setViewportView(this.pathList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 11);
        this.innerPanel.add((Component)this.pathScrollPane, gridBagConstraints);
        this.pathLabel.setLabelFor(this.pathList);
        this.pathLabel.setText(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_Classpath.Border_Title"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.innerPanel.add((Component)this.pathLabel, gridBagConstraints);
        this.add((Component)this.innerPanel, "Center");
    }

    private void pathListMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() != 2) {
            return;
        }
        this.triggerEdit(this.pathList.getSelectedIndex());
    }

    private void pathListValueChanged(ListSelectionEvent evt) {
        this.enableButtons();
    }

    private void removeButtonActionPerformed(ActionEvent evt) {
        int index = this.pathList.getSelectedIndex();
        Object[] selectedValues = this.pathList.getSelectedValues();
        for (int i = 0; i < selectedValues.length; ++i) {
            this.listModel.removeElement(selectedValues[i]);
            this.fireValueChanged();
        }
        int size = this.listModel.getSize();
        if (index >= 0 && size > 0) {
            if (size == index) {
                this.pathList.setSelectedIndex(index - 1);
            } else if (size > index) {
                this.pathList.setSelectedIndex(index);
            } else {
                this.pathList.setSelectedIndex(0);
            }
        }
        this.enableButtons();
    }

    private void downButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i);
        this.pathList.setSelectedIndex(i + 1);
    }

    private void upButtonActionPerformed(ActionEvent evt) {
        int i = this.pathList.getSelectedIndex();
        this.swap(i - 1);
        this.pathList.setSelectedIndex(i - 1);
    }

    private StringEditor getStringEditor() {
        if (this.stringEditor == null) {
            this.stringEditor = new StringEditor();
        }
        return this.stringEditor;
    }

    private void addDirButtonActionPerformed(ActionEvent evt) {
        String str;
        StringCustomEditor sEditor = (StringCustomEditor)this.getStringEditor().getCustomEditor();
        JFrame frame = new JFrame();
        final SimpleJDialog modal = new SimpleJDialog(frame, sEditor, true);
        modal.setDefaultCloseOperation(0);
        modal.getContentPane().setLayout(new BorderLayout());
        modal.getContentPane().add((Component)sEditor, "Center");
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout());
        JButton cancelButton = new JButton(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_Cancel_Button_Title"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                modal.setCanceled(true);
                modal.hide();
            }
        });
        JButton okButton = new JButton(NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString("CTL_Approve_Button_Title"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                modal.hide();
            }
        });
        panel.add(okButton);
        panel.add(cancelButton);
        modal.getContentPane().add((Component)panel, "South");
        modal.pack();
        modal.show();
        if (!modal.getCanceled() && (str = (String)sEditor.getPropertyValue()) != null && str.trim().length() > 0) {
            this.listModel.addElement(str);
            this.fireValueChanged();
            this.pathList.setSelectedIndex(this.listModel.size() - 1);
        }
        modal.dispose();
    }

    private void fireValueChanged() {
        if (this.editor != null) {
            this.editor.setValue(this.getPropertyValue());
        }
    }

    private void triggerEdit(int index) {
        if (index < 0) {
            return;
        }
        String selectedItem = (String)this.listModel.elementAt(index);
    }

    private void swap(int index) {
        if (index < 0 || index >= this.listModel.size() - 1) {
            return;
        }
        Object value = this.listModel.elementAt(index);
        this.listModel.removeElement(value);
        this.listModel.add(index + 1, value);
        this.fireValueChanged();
    }

    private void enableButtons() {
        this.addDirButton.setEnabled(true);
        this.removeButton.setEnabled(this.pathList.getSelectedIndices().length > 0);
        if (this.pathList.getSelectedIndices().length == 1) {
            this.downButton.setEnabled(this.pathList.getSelectedIndices()[0] < this.pathList.getModel().getSize() - 1);
            this.upButton.setEnabled(this.pathList.getSelectedIndices()[0] > 0);
        } else {
            this.downButton.setEnabled(false);
            this.upButton.setEnabled(false);
        }
    }

    private void setCCppListQualifier(String fileList) {
        StringTokenizer tok = new StringTokenizer(fileList, ",");
        while (tok.hasMoreTokens()) {
            String s = tok.nextToken();
            if (s.startsWith("(")) {
                s = s.substring(1);
            }
            if (s.endsWith(")")) {
                s = s.substring(0, s.length() - 1);
            }
            this.listModel.addElement(s.trim());
        }
    }

    public Object getPropertyValue() throws IllegalStateException {
        ArrayList list = new ArrayList();
        Enumeration e = this.listModel.elements();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        String[] arr = list.toArray(new String[list.size()]);
        return new CCppListQualifier(arr);
    }

    private static final String getString(String s) {
        return NbBundle.getBundle((Class)CCppListQualifierCustomEditor.class).getString(s);
    }
}

