/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.explorer.ftplogs;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.MemoryHandler;
import org.netbeans.modules.distributed.actions.FTPLogCookie;
import org.netbeans.modules.distributed.actions.FTPStopLogAction;
import org.netbeans.modules.distributed.explorer.ftplogs.CommandOutputViewAction;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.util.MyMemoryHandler;
import org.netbeans.modules.distributed.util.MyStreamHandler;
import org.netbeans.modules.distributed.util.Utils;
import org.openide.TopManager;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.Repository;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.SystemAction;
import org.openide.windows.InputOutput;
import org.openide.windows.OutputWriter;

public class FTPLogNode
extends AbstractNode
implements Node.Cookie {
    private String logID;
    private String fsName;
    private SystemAction action;

    protected SystemAction[] createActions() {
        return new SystemAction[]{SystemAction.get((Class)FTPStopLogAction.class)};
    }

    public FTPLogNode(final String logID) {
        super(Children.LEAF);
        this.logID = logID;
        this.fsName = logID.substring(0, logID.lastIndexOf(File.separatorChar));
        this.setName(logID.toString());
        this.setIconBase("org/netbeans/modules/text/txtObject");
        if (logID.endsWith("sync")) {
            this.setDisplayName("Synchronize");
        } else if (logID.endsWith("getall")) {
            this.setDisplayName("Get All Files From the Server");
        } else if (logID.endsWith("putall")) {
            this.setDisplayName("Put All Files to the Server");
        } else if (logID.endsWith("refresh")) {
            this.setDisplayName("Refresh");
        }
        this.getCookieSet().add((Node.Cookie)new OpenCookie(){

            public void open() {
                if (logID.endsWith("sync")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName(FTPLogNode.this.fsName, "sync"));
                } else if (logID.endsWith("putall")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName(FTPLogNode.this.fsName, "putall"));
                } else if (logID.endsWith("getall")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName(FTPLogNode.this.fsName, "getall"));
                } else if (logID.endsWith("refresh")) {
                    FTPLogNode.this.displayToOutputPane(Utils.getStatusLoggerOutputPaneName(FTPLogNode.this.fsName, "refresh"));
                }
            }
        });
        this.getCookieSet().add((Node.Cookie)new FTPLogCookie(){

            public String getName() {
                if (logID.endsWith("sync")) {
                    return "sync";
                }
                if (logID.endsWith("putall")) {
                    return "putall";
                }
                if (logID.endsWith("getall")) {
                    return "getall";
                }
                return null;
            }

            public void stop() {
                block3: {
                    block5: {
                        block4: {
                            if (!logID.endsWith("sync")) break block4;
                            Enumeration enums = Repository.getDefault().getFileSystems();
                            while (enums.hasMoreElements()) {
                                FileSystem fs = (FileSystem)enums.nextElement();
                                if (!(fs instanceof FTPFileSystem) || !((FTPFileSystem)fs).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                                ((FTPFileSystem)fs).setStopSyncAll(true);
                                break block3;
                            }
                            break block3;
                        }
                        if (!logID.endsWith("putall")) break block5;
                        Enumeration enums = Repository.getDefault().getFileSystems();
                        while (enums.hasMoreElements()) {
                            FileSystem fs = (FileSystem)enums.nextElement();
                            if (!(fs instanceof FTPFileSystem) || !((FTPFileSystem)fs).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                            ((FTPFileSystem)fs).setStopUploadAll(true);
                            break block3;
                        }
                        break block3;
                    }
                    if (!logID.endsWith("getall")) break block3;
                    Enumeration enums = Repository.getDefault().getFileSystems();
                    while (enums.hasMoreElements()) {
                        FileSystem fs = (FileSystem)enums.nextElement();
                        if (!(fs instanceof FTPFileSystem) || !((FTPFileSystem)fs).getLocalRoot().equals(FTPLogNode.this.fsName)) continue;
                        ((FTPFileSystem)fs).setStopDownloadAll(true);
                        break;
                    }
                }
            }
        });
        this.getCookieSet().add((Node.Cookie)this);
    }

    private void displayToOutputPane(String title) {
        InputOutput io = TopManager.getDefault().getIO(title, false);
        io.select();
        io.setFocusTaken(true);
        io.setErrVisible(false);
        io.setErrSeparated(false);
        Logger logger = Logger.getLogger(this.logID);
        Handler[] handlers = logger.getHandlers();
        MemoryHandler mh = null;
        for (int i = 0; handlers != null && i < handlers.length; ++i) {
            if (!(handlers[i] instanceof MyMemoryHandler)) continue;
            mh = (MyMemoryHandler)handlers[i];
            MyStreamHandler sh = (MyStreamHandler)((MyMemoryHandler)mh).getHandler();
            sh.setOutputStream(new OutputStreamOutputPane(io.getOut()));
            break;
        }
        if (mh != null) {
            mh.push();
            mh.setPushLevel(Level.INFO);
        }
    }

    public SystemAction getDefaultAction() {
        return new CommandOutputViewAction();
    }

    public void setIcon(String icon) {
        this.setIconBase(icon);
    }

    public void destroy() throws IOException {
        super.destroy();
    }

    public boolean canDestroy() {
        return true;
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    class OutputStreamOutputPane
    extends OutputStream {
        private OutputWriter io;

        public OutputStreamOutputPane(OutputWriter io) {
            this.io = io;
        }

        public void close() {
            this.io.close();
        }

        public void flush() {
            this.io.flush();
        }

        public void write(int b) {
            this.io.print((char)b);
        }
    }
}

