/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.explorer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import org.netbeans.modules.distributed.explorer.RemoteRuntimeNode;
import org.netbeans.modules.distributed.rmi.protocol.RemoteRuntime;
import org.netbeans.modules.distributed.services.RemoteRuntimeType;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.RequestProcessor;

public class SvcBrowserChildren
extends Children.Keys
implements PropertyChangeListener {
    private transient RequestProcessor.Task task = null;
    private transient RefreshTaskAuto taskRunnable = null;
    private int timeout = 0;
    private transient HashSet addedNew = new HashSet(5);

    public SvcBrowserChildren() {
        DistributedSettings.getDefault().addPropertyChangeListener(this);
        this.timeout = DistributedSettings.getDefault().getTimeOut();
        this.scheduleRefreshTaskAuto(this.timeout);
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                SvcBrowserChildren.this.startRemoteServers();
            }
        });
    }

    private void startRemoteServers() {
        HashSet keys = DistributedSettings.getDefault().getRemoteRuntimes();
        if (keys != null) {
            Iterator itr = keys.iterator();
            while (itr.hasNext()) {
                RemoteRuntimeType rrt = (RemoteRuntimeType)itr.next();
                if (!rrt.getConnectNow() || !rrt.isConnectAtStartup()) continue;
                rrt.getRemoteRuntime();
            }
        }
    }

    protected void scheduleRefreshTask(int millis) {
        RefreshTask taskRunnable = new RefreshTask();
        RequestProcessor.Task task = RequestProcessor.getDefault().create((Runnable)taskRunnable);
        task.setPriority(1);
        task.schedule(millis);
    }

    public void scheduleRefreshTaskAuto(int millis) {
        if (this.task == null) {
            this.taskRunnable = new RefreshTaskAuto();
            this.task = RequestProcessor.getDefault().create((Runnable)this.taskRunnable);
            this.task.setPriority(1);
            this.task.schedule(millis);
        }
    }

    private void addKeys() {
        HashSet keys = DistributedSettings.getDefault().getRemoteRuntimes();
        ArrayList list = null;
        if (keys != null) {
            list = new ArrayList(keys.size() + 1);
            list.addAll(keys);
            this.setKeys(list);
        }
        Node[] nodes = this.getNodes();
        for (int i = 0; nodes != null && i < nodes.length; ++i) {
            final RemoteRuntimeNode rtNode = (RemoteRuntimeNode)nodes[i];
            final RemoteRuntimeType rtInfo = rtNode.getRemoteRuntimeType();
            boolean isConnectedServerSafe = rtInfo.isConnectedServerSafe();
            boolean isServerFailed = rtInfo.isServerFailed();
            if (rtInfo != null) {
                if (rtInfo.isConnectedServerSafe()) {
                    rtNode.setConnectedState(0);
                } else if (rtInfo.isConnecting()) {
                    rtNode.setConnectedState(1);
                } else {
                    rtNode.setConnectedState(2);
                }
            }
            if (rtInfo.getConnectNow() && !isConnectedServerSafe && !rtInfo.isConnecting()) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        rtNode.setConnectedState(1);
                        RemoteRuntime rt = rtInfo.getRemoteRuntimeServerSafe();
                        if (rt != null) {
                            rtNode.setConnectedState(0);
                        } else {
                            rtNode.setConnectedState(2);
                            rtInfo.disconnect(false);
                            rtInfo.removeConnectionListener(rtNode);
                        }
                    }
                });
                continue;
            }
            if (!isServerFailed) continue;
            rtInfo.stopRemoteProcesses();
            rtInfo.disconnect(true);
        }
    }

    public void refreshNow() {
        this.scheduleRefreshTask(0);
    }

    protected void addNotify() {
        this.refreshNow();
    }

    protected void removeNotify() {
    }

    protected void refreshKeys() {
        this.addKeys();
    }

    protected void refreshKeys2() {
        this.addKeys();
    }

    protected Node[] createNodes(Object key) {
        if (key instanceof RemoteRuntimeType) {
            final RemoteRuntimeType rtInfo = (RemoteRuntimeType)key;
            final RemoteRuntimeNode rtNode = new RemoteRuntimeNode(rtInfo);
            boolean isConnectedServerSafe = rtInfo.isConnectedServerSafe();
            boolean isServerFailed = rtInfo.isServerFailed();
            if (rtInfo != null) {
                if (rtInfo.isConnectedServerSafe()) {
                    rtNode.setConnectedState(0);
                } else if (rtInfo.isConnecting()) {
                    rtNode.setConnectedState(1);
                } else {
                    rtNode.setConnectedState(2);
                }
            }
            if (rtInfo.getConnectNow() && !isConnectedServerSafe && !rtInfo.isConnecting() && !isServerFailed) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        rtNode.setConnectedState(1);
                        RemoteRuntime rt = rtInfo.getRemoteRuntimeServerSafe();
                        if (rt != null) {
                            rtNode.setConnectedState(0);
                        } else {
                            rtNode.setConnectedState(2);
                            rtInfo.disconnect(false);
                            if (SvcBrowserChildren.this.addedNew.contains(rtInfo)) {
                                rtInfo.removeConnectionListener(rtNode);
                                SvcBrowserChildren.this.addedNew.remove(rtInfo);
                            }
                        }
                    }
                });
            } else if (isServerFailed) {
                rtInfo.stopRemoteProcesses();
                rtInfo.disconnect(true);
            }
            return new Node[]{rtNode};
        }
        if (key instanceof Node) {
            return new Node[]{(Node)key};
        }
        return null;
    }

    public void addRemoteRuntimeType(RemoteRuntimeType rtt) {
        DistributedSettings.getDefault().putRemoteRuntime(rtt);
        this.addedNew.add(rtt);
        this.refreshNow();
    }

    public void propertyChange(PropertyChangeEvent e) {
        if ("remoteRuntimes".equals(e.getPropertyName()) || e.getPropertyName() == null) {
            if (e.getOldValue() != null) {
                RequestProcessor.getDefault().post(new Runnable(){

                    public void run() {
                        SvcBrowserChildren.this.addNotify();
                    }
                });
            } else {
                this.refreshKeys2();
            }
        }
        if ("timeOut".equals(e.getPropertyName())) {
            this.timeout = DistributedSettings.getDefault().getTimeOut();
            this.task.schedule(this.timeout);
        }
    }

    private class RefreshTaskAuto
    implements Runnable {
        private RefreshTaskAuto() {
        }

        public void run() {
            SvcBrowserChildren.this.refreshKeys2();
            if (SvcBrowserChildren.this.task != null && SvcBrowserChildren.this.timeout > 0) {
                SvcBrowserChildren.this.task.schedule(SvcBrowserChildren.this.timeout);
            }
        }
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        public void run() {
            SvcBrowserChildren.this.refreshKeys();
        }
    }
}

