/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.execute;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteJavaExecutor;
import org.netbeans.modules.distributed.execute.RemoteProcessDescriptor;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.util.FileUtility;
import org.openide.compiler.ExternalCompiler;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;
import org.openide.util.NbBundle;

public class RemoteJavaDebugger
extends RemoteExecutor {
    private static final long serialVersionUID = 4921782425419448314L;
    private static final String PROP_OPTIONS = "debuggerOptions";
    private static final String PROP_JAVASWITCH = "javaExecuterOptions";
    private static final String PROP_USE_CLASSIC_VM = "useClassicVM";
    private static final String DEBUG_CMD_JDK_PREFIX = "-Xdebug\" \"-Xnoagent\" \"-Djava.compiler=NONE\"";
    private static final String DEBUG_CMD_JDK_SUFFIX_14 = "\"-Xrunjdwp:transport=dt_socket,server=y,address=";
    private static final String DEBUG_CMD_JDK_SUFFIX_15 = "\"-agentlib:jdwp=transport=dt_socket,server=y,address=";
    private String debuggerOptions;
    private String javaExecuterOptions;
    private boolean useClassicVM = true;
    private boolean debugCommandChanged = false;
    private transient int tcpPort = -1;

    public RemoteJavaDebugger() {
        this.setRemoteExecutor(this.getExternalExecutor());
        this.setErrorExpression(ExternalCompiler.JAVAC);
    }

    public int getTCPPort() {
        return this.tcpPort;
    }

    protected void finalize() throws Throwable {
    }

    public String getDebuggerOptions() {
        if (this.debugCommandChanged) {
            return this.debuggerOptions;
        }
        return DEBUG_CMD_JDK_PREFIX;
    }

    public void setDebuggerOptions(String option) {
        this.debugCommandChanged = true;
        String old = this.debuggerOptions;
        this.debuggerOptions = option;
        this.firePropertyChange(PROP_OPTIONS, old, this.debuggerOptions);
    }

    public boolean getUseClassicVM() {
        return this.useClassicVM;
    }

    public void setUseClassicVM(boolean b) {
        boolean old = this.useClassicVM;
        this.useClassicVM = b;
        this.firePropertyChange(PROP_USE_CLASSIC_VM, old ? Boolean.TRUE : Boolean.FALSE, this.useClassicVM ? Boolean.TRUE : Boolean.FALSE);
    }

    public String getJavaExecuterOptions() {
        if (this.javaExecuterOptions != null) {
            return this.javaExecuterOptions;
        }
        RemoteJavaExecutor jext = (RemoteJavaExecutor)DistributedProjectSettings.getDefault().getRemoteExecutorType();
        this.javaExecuterOptions = jext.getRemoteExecutor().getArguments();
        return this.javaExecuterOptions;
    }

    public void setJavaExecuterOptions(String option) {
        String old = this.javaExecuterOptions;
        this.javaExecuterOptions = option;
        this.firePropertyChange(PROP_OPTIONS, old, this.javaExecuterOptions);
    }

    public synchronized RemoteProcessDescriptor getExternalExecutor() {
        if (this.remoteExecutor == null) {
            this.remoteExecutor = new RemoteProcessDescriptor("{java.home}{/}bin{/}java", "{debuggerOptions}{address} {javaExecuterOptions} ", NbBundle.getBundle((Class)RemoteJavaDebugger.class).getString("MSG_RemoteJavaDebuggerHint"));
        }
        return this.remoteExecutor;
    }

    public RemoteProcessDescriptor getRemoteExecutor() {
        return this.getExternalExecutor();
    }

    public void setRemoteExecutor(RemoteProcessDescriptor re) {
        this.remoteExecutor = re;
        this.firePropertyChange("remoteExecutor", null, re);
    }

    private RemoteJavaExecutor getRemoteJavaExecutor() {
        return (RemoteJavaExecutor)DistributedProjectSettings.getDefault().getRemoteExecutorType();
    }

    private String getRemoteJavaExecutorArg(DataObject obj) throws IOException {
        RemoteJavaExecutor rme = this.getRemoteJavaExecutor();
        String pattern = rme.getRemoteExecutor().getArguments();
        AbstractNetworkFileSystem nfs = null;
        try {
            nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
            Map map = super.createMapFormat(obj, nfs).getMap();
            String className = (String)map.get("java class");
            String arg = (String)map.get("arguments");
            String remoteRoot = FileUtility.openVMSPathToUnixPath(nfs.getRemoteRoot(), true);
            String fileName = (String)map.get("file");
            fileName = FileUtility.openVMSPathToUnixPath(fileName, false);
            map.put("file", fileName);
            RemoteJavaExecutor.JFormat frmt = new RemoteJavaExecutor.JFormat(className, new String[]{arg}, rme.getClassPath(), rme.getBootClassPath(), rme.getRepositoryPath(), rme.getLibraryPath(), rme.isAssertEnabled(), true, obj);
            return frmt.format(pattern);
        }
        catch (FileStateInvalidException exp) {
        }
        catch (IOException e) {
            throw e;
        }
        return "";
    }

    protected void createDefaultMapFormat(DataObject obj) throws IOException {
        String jdkVersion;
        AbstractNetworkFileSystem nfs = null;
        nfs = (AbstractNetworkFileSystem)obj.getPrimaryFile().getFileSystem();
        if (nfs.getRemoteRuntimeType() != null && nfs.getRemoteRuntimeType().getRemoteRuntime() != null) {
            this.tcpPort = nfs.getRemoteRuntimeType().getRemoteRuntime().findFreeTCPPort();
        }
        String debugCommand = this.getDebuggerOptions() + " " + DEBUG_CMD_JDK_SUFFIX_14;
        if (nfs.getRemoteRuntimeType() != null && (jdkVersion = nfs.getRemoteRuntimeType().getJDKVersion()) != null && jdkVersion.startsWith("1.5")) {
            debugCommand = this.getDebuggerOptions() + " " + DEBUG_CMD_JDK_SUFFIX_15;
        }
        this.format = new JFormat(debugCommand, this.getRemoteJavaExecutorArg(obj), this.tcpPort, this.getUseClassicVM());
    }

    public File getWorkingDirectory() {
        return this.getRemoteJavaExecutor().getWorkingDirectory();
    }

    public ExecutorTask execute(DataObject obj) throws IOException {
        this.createDefaultMapFormat(obj);
        if (this.getRemoteJavaExecutor().getWorkingDirectory() != null) {
            this.workingDirectory = this.getWorkingDirectory();
            this.setChangeWorkingDir(true);
        } else {
            this.setChangeWorkingDir(false);
        }
        ExecutorTask task = super.execute(obj);
        return task;
    }

    public static class JFormat
    extends MapFormat {
        public static final String TAG_PATHSEPARATOR = ":";
        static final long serialVersionUID = -1524637220865300001L;
        public static final String TAG_OPTIONS = "debuggerOptions";
        public static final String TAG_JAVASWITCH = "javaExecuterOptions";
        public static final String TAG_ADDRESS = "address";
        public static final String TAG_USE_CLASSIC_VM = "classic";

        public JFormat(String debuggerOption, String javaExecuterOptions, int tcpPort, boolean useClassicVM) {
            super(new HashMap());
            Map map = this.getMap();
            map.put("debuggerOptions", debuggerOption);
            map.put("javaExecuterOptions", javaExecuterOptions);
            map.put(TAG_ADDRESS, Integer.toString(tcpPort));
            map.put("/", "/");
        }
    }
}

