/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.distributed.actions;

import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import org.netbeans.modules.distributed.DistributedModule;
import org.netbeans.modules.distributed.execute.RemoteExecutor;
import org.netbeans.modules.distributed.execute.RemoteJavaCompiler;
import org.netbeans.modules.distributed.remotefs.AbstractNetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.NetworkFileSystem;
import org.netbeans.modules.distributed.remotefs.core.RemoteFileSystem;
import org.netbeans.modules.distributed.remotefs.ftpfs.FTPFileSystem;
import org.netbeans.modules.distributed.settings.DistributedProjectSettings;
import org.netbeans.modules.distributed.settings.DistributedSettings;
import org.netbeans.modules.distributed.util.RemoteCompileCookie;
import org.openide.LifecycleManager;
import org.openide.ServiceType;
import org.openide.actions.AbstractCompileAction;
import org.openide.awt.StatusDisplayer;
import org.openide.compiler.Compiler;
import org.openide.compiler.CompilerJob;
import org.openide.cookies.CompilerCookie;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileSystemCapability;
import org.openide.filesystems.Repository;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.NodeAction;
import org.openide.util.enum.ArrayEnumeration;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;

public class RemoteCompileAction
extends NodeAction {
    static /* synthetic */ Class class$org$netbeans$modules$distributed$util$RemoteCookie;

    public String getName() {
        return "Remote Compile";
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected Class[] cookieClasses() {
        return new Class[]{CompilerCookie.class};
    }

    protected final Class cookie() {
        return DataObject.class;
    }

    protected String iconResource() {
        return "org/netbeans/modules/distributed/resources/remcompile.gif";
    }

    private static void refreshFS() {
        Enumeration fss = FileSystemCapability.COMPILE.fileSystems();
        FileSystem defaultFS = Repository.getDefault().getDefaultFileSystem();
        while (fss.hasMoreElements()) {
            FileSystem fs = (FileSystem)fss.nextElement();
            if (fs.isReadOnly() || fs == defaultFS || !(fs instanceof AbstractNetworkFileSystem)) continue;
            fs.refresh(false);
        }
    }

    public static int doAction(Node[] activatedNodes, boolean wait) {
        int res = 1;
        if (DistributedSettings.getDefault().getSaveAll()) {
            LifecycleManager.getDefault().saveAll();
        }
        DistributedModule.logger.info("Invoking remote compile command ");
        for (int i = 0; i < activatedNodes.length; ++i) {
            DataObject dobj = (DataObject)activatedNodes[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dobj.getCookie(class$org$netbeans$modules$distributed$util$RemoteCookie == null ? RemoteCompileAction.class$("org.netbeans.modules.distributed.util.RemoteCookie") : class$org$netbeans$modules$distributed$util$RemoteCookie) != null || !dobj.getPrimaryFile().getExt().equals("java")) continue;
            boolean skip = true;
            FileObject folder = null;
            if (dobj instanceof MultiDataObject) {
                MultiDataObject mdobj = (MultiDataObject)dobj;
                try {
                    DataObject mdo = DataObject.find((FileObject)dobj.getPrimaryFile());
                    if (mdo.isModified()) {
                        skip = false;
                    }
                    FileObject primary = mdo.getPrimaryFile();
                    folder = primary.getParent();
                    FileSystem target = ((RemoteJavaCompiler)DistributedProjectSettings.getDefault().getRemoteCompilerType()).getTargetFileSystem();
                    FileSystem fileSystem = target = RemoteJavaCompiler.TARGET_INVALID == target ? null : target;
                    if (target != null && (folder = target.find(folder.getPackageName('.'), null, null)) == null) {
                        skip = false;
                    }
                    if (skip) {
                        FileObject clazz = folder.getFileObject(primary.getName(), "class");
                        if (clazz != null) {
                            primary.refresh();
                            clazz.refresh();
                            if (clazz.getSize() <= 0L || clazz.lastModified().compareTo(primary.lastModified()) < 0) {
                                clazz.delete();
                                skip = false;
                            }
                        } else {
                            skip = false;
                        }
                    }
                }
                catch (DataObjectNotFoundException e) {
                    skip = false;
                }
                catch (IOException e) {
                    skip = false;
                }
                if (skip) {
                    InputOutput io = IOProvider.getDefault().getIO("Remote Java Compiler (" + dobj.getPrimaryFile().getNameExt() + ")", false);
                    try {
                        io.getOut().reset();
                        io.select();
                        io.setFocusTaken(true);
                        io.setErrVisible(false);
                        io.setErrSeparated(false);
                        io.getOut().println("Command completed. No files needed to be created, changed, or deleted. Finished " + dobj.getName(), null);
                        StatusDisplayer.getDefault().setStatusText("Finished " + dobj.getName());
                    }
                    catch (IOException e) {}
                    continue;
                }
            }
            RemoteExecutor ret = null;
            Object obj = dobj.getPrimaryFile().getAttribute("remoteCompilerType");
            if (obj == null) {
                ret = (RemoteExecutor)DistributedProjectSettings.getDefault().getRemoteCompilerType();
            } else {
                ServiceType.Handle handle = (ServiceType.Handle)obj;
                ret = (RemoteExecutor)handle.getServiceType();
            }
            if (ret == null) {
                DistributedModule.err.notify((Throwable)new Exception("Remote Compile Action Failed"));
                res = 0;
                return res;
            }
            try {
                ExecutorTask task = ret.execute(dobj);
                res = task.result();
                continue;
            }
            catch (IOException ioe) {
                DistributedModule.err.notify((Throwable)ioe);
            }
        }
        return res;
    }

    private static void refreshPackage(FileObject pfile) {
        pfile.refresh();
        FileObject[] contents = pfile.getChildren();
        for (int i = 0; i < contents.length; ++i) {
            FileObject fobj = contents[i];
            if (!"class".equals(fobj.getExt())) continue;
            fobj.refresh();
        }
    }

    protected void performAction(Node[] activatedNodes) {
        DistributedModule.logger.info("Invoking remote compile command ");
        final Node[] anodes = activatedNodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.doAction(anodes, false);
                RemoteCompileAction.this.compile3GL(anodes);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    static String findName(Node[] nodes) {
        String name = "";
        if (nodes.length > 0) {
            Node n = nodes[0];
            Node.Cookie ck = null;
            do {
                if ((ck = n.getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject)) == null) continue;
                DataObject d = (DataObject)ck;
                name = d.isValid() ? d.getNodeDelegate().getDisplayName() : "";
                break;
            } while ((n = n.getParentNode()) != null);
        }
        return NbBundle.getMessage((Class)Compiler.class, (String)"FMT_Compile", (Object)new Integer(nodes.length), (Object)name);
    }

    public void actionPerformed(ActionEvent ev) {
        Object s = ev == null ? null : ev.getSource();
        Node[] nodes = null;
        if (s instanceof Node) {
            Node node = (Node)s;
            nodes = new Node[]{node};
        } else {
            nodes = s instanceof Node[] ? (Node[])s : super.getActivatedNodes();
        }
        final Node[] anodes = nodes;
        RequestProcessor.getDefault().post(new Runnable(){

            public void run() {
                RemoteCompileAction.refreshFS();
                RemoteCompileAction.doAction(anodes, false);
                RemoteCompileAction.this.compile3GL(anodes);
                RemoteCompileAction.refreshFS();
            }
        });
    }

    public static CompilerJob createJob(Enumeration en, Compiler.Depth depth) {
        CompilerJob job = new CompilerJob(depth);
        AbstractCompileAction.prepareJobFor((CompilerJob)job, (Enumeration)en, (Class)RemoteCompileCookie.class, (Compiler.Depth)depth);
        return job;
    }

    private void compile3GL(Node[] nodes) {
        HashSet<CompilerCookie> compile = new HashSet<CompilerCookie>();
        for (int i = 0; i < nodes.length; ++i) {
            CompilerCookie comp = (CompilerCookie)nodes[i].getCookie(class$org$netbeans$modules$distributed$util$RemoteCompileCookie == null ? RemoteCompileAction.class$("org.netbeans.modules.distributed.util.RemoteCompileCookie") : class$org$netbeans$modules$distributed$util$RemoteCompileCookie);
            if (comp == null) continue;
            compile.add(comp);
        }
        if (compile.size() == 0) {
            return;
        }
        this.compileNodes2(nodes);
    }

    protected String message() {
        return NbBundle.getMessage((Class)Compiler.class, (String)"CTL_CompilationStarted");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compileNodes2(Node[] nodes) {
        CompilerJob job;
        StatusDisplayer.getDefault().setStatusText(this.message());
        try {
            job = new CompilerJob(Compiler.DEPTH_ONE);
            AbstractCompileAction.prepareJobFor((CompilerJob)job, (Enumeration)new ArrayEnumeration((Object[])nodes), (Class)RemoteCompileCookie.class, (Compiler.Depth)Compiler.DEPTH_ONE);
        }
        finally {
            StatusDisplayer.getDefault().setStatusText("");
        }
        job.setDisplayName(RemoteCompileAction.findName(nodes));
        job.start();
    }

    protected boolean enable(Node[] node) {
        int nodeCnt = 0;
        if (node.length == 0) {
            return false;
        }
        for (int i = 0; i < node.length; ++i) {
            DataObject dobj = (DataObject)node[i].getCookie(class$org$openide$loaders$DataObject == null ? RemoteCompileAction.class$("org.openide.loaders.DataObject") : class$org$openide$loaders$DataObject);
            if (dobj == null) {
                return false;
            }
            if (dobj.getPrimaryFile().isFolder() || dobj.getPrimaryFile().isRoot()) {
                return false;
            }
            try {
                if (!(dobj.getPrimaryFile().getFileSystem() instanceof NetworkFileSystem) && !(dobj.getPrimaryFile().getFileSystem() instanceof FTPFileSystem)) {
                    return false;
                }
                if (dobj.getPrimaryFile().getFileSystem() instanceof RemoteFileSystem && !((RemoteFileSystem)dobj.getPrimaryFile().getFileSystem()).isConnected()) {
                    return false;
                }
            }
            catch (FileStateInvalidException e) {
                return false;
            }
            if (dobj.getCookie(class$org$netbeans$modules$distributed$util$RemoteCompileCookie == null ? RemoteCompileAction.class$("org.netbeans.modules.distributed.util.RemoteCompileCookie") : class$org$netbeans$modules$distributed$util$RemoteCompileCookie) != null) {
                ++nodeCnt;
            }
            if (!dobj.getPrimaryFile().getExt().toLowerCase().equals("java")) continue;
            ++nodeCnt;
        }
        return nodeCnt == node.length;
    }

    protected boolean asynchronous() {
        return false;
    }
}

