 #pragma module WHOIS "V1.5" & char *whois_version  = "V1.5 by JFM" ; /**   **   **      WHOIS Utility@  **	Copyright 2002, Jean-Franois Mezei, Vaxination Informatique$  **	Contact: vaxination@videotron.ca  ** !  **	To compile: CC/UNSIGNED WHOIS   ** >  **	Permission is granted to use and distribute this utility.   **   **	Modification history: (  **	27-SEP-2002	V1.5	Productized version  **   **   **/         #include <ssdef.h> #include <iodef.h> #include <stdio.h> #include <ctype.h> #include <stdlib.h>  #include <string.h>  #include <descrip.h> #include <tcpip$inetdef.h> #include <in.h>                     #include <starlet.h> #include <lib$routines.h>  #include <cli$routines.h>  #include <climsgdef.h>   #include "servers.h"      $ /****** parameters ****************// static $DESCRIPTOR(CLI_HOST_NAME, "HOST_NAME"); ( static $DESCRIPTOR(CLI_SERVER,"SERVER");( static $DESCRIPTOR(CLI_OUTPUT,"OUTPUT");$ static $DESCRIPTOR(CLI_LIST,"LIST");$ static $DESCRIPTOR(CLI_FULL,"FULL");& static $DESCRIPTOR(CLI_BRIEF,"BRIEF");$ static $DESCRIPTOR(CLI_PORT,"PORT");    ! static int cli_host_name_present;  static int cli_server_present ;  static int cli_output_present ;  static int cli_list_present ;  static int cli_full_present ;  static int cli_brief_present ; static int cli_port_present ;   ( static unsigned short cli_host_name_len;% static unsigned short cli_server_len; % static unsigned short cli_output_len;   # static char cli_host_name_str[256];   static char cli_server_str[256];  static char cli_output_str[256]; static int  cli_port_int ;    9 static $DESCRIPTOR(CLI_HOST_NAME_DESC,cli_host_name_str); 3 static $DESCRIPTOR(CLI_SERVER_DESC,cli_server_str); 3 static $DESCRIPTOR(CLI_OUTPUT_DESC,cli_output_str);      struct buffer_struct {#                         long used ; $                         long alloc ;%                         long remain ; $                         char *data ;:                         char *ptr ;  /* working pointer */                      } ;   #define BUFFER_ALLOC_INIT 2000    F /****************** TCPIP stuff *************************************/     struct tcpip_iosb_struct {/                         unsigned short status ; .                         unsigned short count ;'                         void *pointer ;                    } ;   . /* taken from in.h  - for easy reference only   *  *struct sockaddr_in {4  *                       unsigned short  sin_family;2  *                       unsigned short  sin_port;I  *                       struct  in_addr sin_addr; S_addr is unsigned int -  *                       char    sin_zero[8];   *                  };  *  */    struct ipstatus_struct	         { %           unsigned short ip_channel ;            short host_port ; )           struct tcpip_iosb_struct iosb ; -           struct dsc$descriptor_s host_desc ; #           struct sockaddr_in host ;          } ;    struct SocketParamStruct	         {           unsigned short protocol;         unsigned char  type;         unsigned char  family;         }  ;    6 /* name of the module defined in the WHOIS.CLD file */   extern char CLI_WHOIS[] ;      /* routines defined below */   int   get_params();  int  my_exit(long status);0 int  show_content(struct buffer_struct *buffer);* int  get_whois( char *server , int port );J int  ip_sendline(struct ipstatus_struct *ipstatus, char *data, int size) ;O int  ip_readline(struct ipstatus_struct *ipstatus, char *data, long max_size) ; / int  ip_init(struct ipstatus_struct *ipstatus); 2 int  ip_connect(struct ipstatus_struct *ipstatus);5 int  ip_disconnect(struct ipstatus_struct *ipstatus);                 FILE *out_file ;  ' static struct ipstatus_struct ipstatus;  struct buffer_struct response ;     B /****************************************************************/	   main () B /****************************************************************/ {  int status, found_flag ;# char *redirect_name, *redirect_ip ;  int continue_flag ;    char *ptr1, *ptr2 , *ptr3 ; 2 struct servers_struct *server_info, *server_temp ;4 struct servers_struct server_arg , server_redirect ;   $DESCRIPTOR(server_desc,"");   int alpha_host , count ; char host_tld[25] ;  char new_server[256];  char visited_servers[512];      % /** first step, get the parameters */  	get_params();    ! /** now, open the output file **/   ' out_file = fopen( cli_output_str, "w");   6 if(!out_file) { printf("Error opening output file\n");
 		my_exit(2); 	 	      }	       6 /* if a /LIST operation, dump the contents and exit */   if(cli_list_present & 1) { E 	fprintf(out_file,"----------- LIST OF WHOIS SERVERS --------%s--\n",  				whois_version); = 	server_info = &server_array[0] ;  /* defined in servers.h */  	while( server_info->tld ) 	{  4 	     if (server_info->server == NONE ) ptr1 = "" ; A 	else if (server_info->server == WEB ) ptr1 = server_info->http ; + 	else				      ptr1 = server_info->server ;  	 '         if(server_info->server != NONE) ( 		fprintf(out_file," %-7s %-30s [%s]\n",1 			server_info->tld, ptr1, server_info->country);  	 server_info ++ ;  % 	} /* end of while server_info.tld */   H 	fprintf(out_file,"\n\n----------- REVERSE LOOKUPS  ---------------\n");? 	server_info = &server_reverse[0] ;  /* defined in servers.h */  	while( server_info->tld ) 	{  4 	     if (server_info->server == NONE ) ptr1 = "" ; A 	else if (server_info->server == WEB ) ptr1 = server_info->http ; + 	else				      ptr1 = server_info->server ;  	 '         if(server_info->server != NONE) ( 		fprintf(out_file," %-7s %-30s [%s]\n",1 			server_info->tld, ptr1, server_info->country);  	 server_info ++ ;  % 	} /* end of while server_info.tld */   H 	fprintf(out_file,"\n\n--------------------------------------------\n");   	fclose(out_file); 	my_exit(1);   } /* end of /LIST */        / /* Now, take the host name and isolate the TLD  F  * check if ip number or host name (presencee of alphabetic character)  */  	ptr1 = cli_host_name_str ;  	ptr2 = 0 ;  	alpha_host = 0 ; " 	while (*ptr1 && !isspace(*ptr1))  		{  		*ptr1 = tolower(*ptr1) ;( 	      	if(ispunct(*ptr1)) ptr2 = ptr1 ;& 		if( isalpha(*ptr1)) alpha_host = 1 ; 		ptr1 ++ ; 
            	}   D 	if(!ptr2) { strcpy(host_tld,"***");  /* probably a whois command */ 		  }          else 	{A         if(alpha_host)	/* copy the tld if alphabetic host name */  	   { # 	     ptr2 ++ ;  /* skip the dot */  	     ptr1 = host_tld ;	 	     count = 1 ; -              while (*ptr2 && !isspace(*ptr2))  		 { 		   *ptr1 = tolower(*ptr2);5 		   count ++ ; if(count >= sizeof(host_tld)) break ;  		   ptr1 ++ ; ptr2 ++ ; 		 } 	     *ptr1 = 0x00 ; 	   } 8 	else   /* put in a fake tld when IP address is given */ 	   {  		strcpy(host_tld, "999");	 	   }	    %         } /* end of else (! ptr2 ) */   C /* now, scan though the servers structure to find the right info */      if(alpha_host) { = 	server_info = &server_array[0] ;  /* defined in servers.h */  	found_flag = 0 ;  	while( server_info->tld ) 	{, 	 if(! strcmp( host_tld, server_info->tld)) " 					{ found_flag = 1 ; break; } ; 	 server_info ++ ;  % 	} /* end of while server_info.tld */    } /* end of if alpha_host */   else { J 	server_info = &server_reverse[0];  /* main/default iana reverse lookup */ 	found_flag = 1 ;    } /* end of else alpha host*/       > if( cli_server_present & 1 )  /* override any found servers */ 	{ 	server_arg.tld = host_tld ;E 	server_arg.server = cli_server_str ;   /* override anything found */ F 	if (server_info->country) server_arg.country = server_info->country ;* 	else			  server_arg.country = "UNKNOWN" ;@ 	if (server_info->http)    server_arg.http = server_info->http ;  	else			  server_arg.http = "" ;   	server_info = &server_arg ;         found_flag = 1 ; 	}       if(!found_flag) 	         { E 	fprintf(out_file, "No whois server could be found to resolve: %s\n",  						cli_host_name_str); b 	fprintf(out_file, "Try http://www.iana.org to locate the autority for the tld: %s\n", host_tld ); 	my_exit(4); 	}  ! if (server_info->server == NONE)   	{W 	fprintf(out_file, "The tld: %s [%s] doesn't seem to have a whois or http interface\n", $ 			host_tld, server_info->country );U 	fprintf(out_file, "Try http://www.iana.org to locate the autority for this tld:\n");  	my_exit(6); 	}    if (server_info->server == WEB)  	{O 	fprintf(out_file, "The tld: %s [%s] doesn't seem to have a whois interface\n", $ 			host_tld, server_info->country );J 	fprintf(out_file, "Try the web interface at: %s \n", server_info->http ); 	my_exit(7); 	}                         E /******************************************************************** H  * now we have collected and validated all the info, time to connect to -  * the whois server and fetch the information   */    response.used = 0 ; % response.alloc =  BUFFER_ALLOC_INIT ; ( response.data = malloc(response.alloc) ;  > /*   ip_init is now done each time, inside the get_whois loop  status = ip_init(&ipstatus);R if(status != 1) { fprintf(out_file, "Could not initialise internet connection\n"); 		  my_exit(8);  		}    */   continue_flag = 1 ;    while(continue_flag) {    response.ptr = response.data ; response.used = 0 ; " response.remain = response.alloc ;- strcat(visited_servers, server_info->server);  strcat(visited_servers, " ");   7 status = get_whois( server_info->server, cli_port_int);   $ if(status != 1) { fprintf(out_file, A 			  "WHOIS-E-NOCONNECT Could not get response from server %s\n",  			   server_info->server);  		  fclose(out_file);                    my_exit(10); 		}   G /* now we have the response in response.data, check if there is need to $  * redirect to another whois server   */    new_server[0] = 0x00 ;   if(alpha_host) 	{< 	if( redirect_name = strstr(response.data, "Whois Server:")) 	{ 	ptr1 = redirect_name ;  	ptr2 = new_server ;* 	while (*ptr1 && (*ptr1 != ':')) ptr1 ++ ; 	if(*ptr1) ptr1 ++ ;+ 	while (*ptr1 &&  isspace(*ptr1)) ptr1 ++ ; 3 	while (*ptr1 && !isspace(*ptr1)) { *ptr2 = *ptr1 ;  					   ptr2 ++; ptr1 ++;  					 }  	*ptr2 = 0x00 ;  	server_redirect.tld = "" ; & 	server_redirect.server = new_server ; 	server_redirect.country = "" ;  	server_redirect.http = "" ;  * 	} /* end of if Whois Server: was found */# 	} /* end of if alphabetic  host */  else 	{3 	if( redirect_ip = strstr(response.data, "OrgID:"))  	{ 	ptr1 = redirect_ip ;  	ptr2 = new_server ;* 	while (*ptr1 && (*ptr1 != ':')) ptr1 ++ ; 	if(*ptr1) ptr1 ++ ;+ 	while (*ptr1 &&  isspace(*ptr1)) ptr1 ++ ; < 	while (*ptr1 && !isspace(*ptr1)) { *ptr2 = toupper(*ptr1) ; 					   ptr2 ++; ptr1 ++;  					 }  	*ptr2 = 0x00 ; E 	 /* now, lookup name into table of reverse lookups to find server */   ? 	server_temp = &server_reverse[0] ;  /* defined in servers.h */ D 	while(  server_temp->tld  && strcmp(new_server, server_temp->tld))  	{ 	 server_temp ++ ;   	} 	if(server_temp->tld)  		{ ) 		strcpy(new_server,server_temp->server); + 		server_redirect.tld = server_temp->tld  ; 1 		server_redirect.server = server_temp->server  ; 2 		server_redirect.country = server_temp->country ;, 		server_redirect.http = server_temp->http ;                 }  	 else 		{ = 		 new_server[0] = 0x00 ; /* redirected to an unknown server,  					 * consider it a dead end 					 */ 		}   " 	} /* end of if OrgID was found */ 	} /* end of if numeric host */     % /** check for loop in server list **/   < if(new_server[0] &&  strstr(  visited_servers, new_server )) 	{ fprintf(out_file,  A 		  "WARNING: redirected to %s which has already been visited\n",  		   new_server ); 	  new_server[0] = 0x00 ;  	}      7 if( (cli_full_present & 1) || (new_server[0] == 0x00) ) 	         { ! 	/** display this transaction **/ < 	fprintf(out_file, "----Server:  %s [%s] response for %s\n", 		server_info->server, 		server_info->country,  		cli_host_name_str);  	show_content(&response);          } 	  else 	{; 	fprintf(out_file, "----Server: %s [%s] redirects to %s\n",  		server_info->server, 		server_info->country,  		new_server); 		 	} 	      if( new_server[0] )  	{" 		server_info = &server_redirect ; 		continue_flag = 1 ;  		/* check here for loop */  	} else	{ 	continue_flag = 0 ;
         }   " } /* end of while continue_flag */    " /* zap contents of the response */   fclose(out_file);   + exit(1);  /* no need to use my_exit here */      } /* end of main */ B /****************************************************************/      B /****************************************************************/#   get_whois(char *server, int port) B /****************************************************************/ {    int status;  char host[256]; ' int host_len, server_len, server_port ;  int num_errors = 0 ; char *ptr1 , *ptr2 ;  @ 	if( !strncmp(server, "rwhois", 6) &&  !( cli_port_present & 1)) 		port = 4321 ;     > 	ptr1 = server ; while (*ptr1 && (*ptr1 != ':')) { ptr1 ++ ; } 	server_len = ptr1 - server ;  	if(*ptr1 == ':') 
 		{ ptr1 ++ ;  		  port = atoi(ptr1); 		}   , 	ipstatus.host_desc.dsc$a_pointer = server ;0 	ipstatus.host_desc.dsc$w_length  = server_len ;3 	ipstatus.host_desc.dsc$b_dtype   = DSC$K_DTYPE_T ; 3 	ipstatus.host_desc.dsc$b_class   = DSC$K_CLASS_S ;  	ipstatus.host_port = port ;    & /* add the <cr> to end of host_name */5 	memcpy( host, cli_host_name_str, cli_host_name_len);  	host_len = cli_host_name_len ; & 	host[host_len] = 0x0D ;	host_len ++ ;& 	host[host_len] = 0x0A ;	host_len ++ ; 	host[host_len] = 0x00 ;     status = ip_init(&ipstatus);   status = ip_connect(&ipstatus);    if(!status) {  	      my_exit(12);  	    }	     3 status =  ip_sendline(&ipstatus, host, host_len ) ;    num_errors = 0 ;5 /* now read the stuff until remote end closes link */   N while( (status = ip_readline(&ipstatus, response.ptr, response.remain )) > -1) 		{ 9 		  if(status == 0) num_errors ++ ; else num_errors = 0 ;  		  if(num_errors >3) break ;  		  response.ptr += status ; 		  response.used += status ;  		  response.remain -= status ;  		  if(response.remain < 512)  			{ response.alloc += 2000 ; < 			  response.data = realloc(response.data, response.alloc);7 			  response.remain = response.alloc - response.used ;  			}A                    response.ptr = response.data + response.used ;  		}   /* end of while */     response.ptr = 0x00;    " status = ip_disconnect(&ipstatus);  
 return(1); }  /*** end of get_whois ****/     B /****************************************************************/   get_params()B /****************************************************************/ {  long status; char command_line[264];  char temp_str[24];  ' $DESCRIPTOR(command_desc,command_line);   $DESCRIPTOR(TEMP_DESC,temp_str); unsigned short temp_len ;    unsigned short command_length ;     memcpy(command_line,"WHOIS ",6);C command_desc.dsc$a_pointer = &command_line[6] ; /* skip "whois " */   command_desc.dsc$w_length -= 6 ;  A status = lib$get_foreign( &command_desc, 0, &command_length , 0);   0 command_desc.dsc$w_length = command_length + 6 ;+ command_desc.dsc$a_pointer = command_line ; B *(command_desc.dsc$a_pointer + command_desc.dsc$w_length ) = 0x00;    & status = cli$dcl_parse( &command_desc, 			&CLI_WHOIS, 			&lib$get_input, 			&lib$get_input, 			0);  E if(! (status & 1)) { exit(status | 0x10000000L); /* parse failed */ }     / 	cli_list_present	    = cli$present(&CLI_LIST); 3 	cli_output_present	    = cli$present(&CLI_OUTPUT);   & 	status = cli$get_value(	&CLI_OUTPUT,	 				&CLI_OUTPUT_DESC,  				&cli_output_len);      if(!(cli_list_present & 1) ) {   9 	cli_host_name_present	    = cli$present(&CLI_HOST_NAME); 3 	cli_server_present	    = cli$present(&CLI_SERVER); / 	cli_full_present	    = cli$present(&CLI_FULL); 1 	cli_brief_present	    = cli$present(&CLI_BRIEF); / 	cli_port_present	    = cli$present(&CLI_PORT);   ) 	status = cli$get_value(	&CLI_HOST_NAME,	  				&CLI_HOST_NAME_DESC, 				&cli_host_name_len);   	if(cli_server_present & 1)  		{ ' 		status = cli$get_value(	&CLI_SERVER,	  					&CLI_SERVER_DESC, 					&cli_server_len); 		}      	if(cli_port_present & 1)  		{ $ 		status = cli$get_value (&CLI_PORT, 					&TEMP_DESC, 					&temp_len);   		temp_str[temp_len] = 0x00 ;   		cli_port_int = atoi(temp_str);                 }  		else cli_port_int = 43 ;	  	p   }  else   {SC    	/* set unused variables to null length for a /LIST operation */  	cli_host_name_len = 0 ; 	cli_server_len = 0 ;  	e& } /* end of if list_present or else */    0 	CLI_OUTPUT_DESC.dsc$w_length = cli_output_len ;( 	cli_output_str[cli_output_len] = 0x00 ;    6 	CLI_HOST_NAME_DESC.dsc$w_length = cli_host_name_len ;0 	CLI_SERVER_DESC.dsc$w_length = cli_server_len ;  - 	cli_host_name_str[cli_host_name_len] = 0x00;.' 	cli_server_str[cli_server_len] = 0x00;>    
 return(1);   } /* end of get_params */iB /****************************************************************/      E /*******************************************************************/oE  ip_sendline(struct ipstatus_struct *ipstatus, char *data, int size) uE /*******************************************************************/C {T int temp_length, status ;E temp_length = size;T if(!temp_length) return ;t  8         status = sys$qiow(0,            /* Event flag */I                         ipstatus->ip_channel,        /* Channel number */C:                         IO$_WRITEVBLK,  /* I/O function */I                         &ipstatus->iosb,           /* I/O status block */t                         0, 0,t8                         data,            /* P1 buffer */C                         temp_length,         /* P2 buffer length */ $                         0, 0, 0, 0);  D if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL))Q 	 { fprintf(out_file, "IP_SENDLINE: WRITE to host =>%s<= failed\n QIO status=%d",;% 			ipstatus->host_desc.dsc$a_pointer,t 			 ipstatus->iosb.status);t 	} } /* end of sendline */E    E /*******************************************************************/tJ  ip_readline(struct ipstatus_struct *ipstatus, char *data, long max_size) E /*******************************************************************/  {o int status ;     ipstatus->iosb.count = 0 ;8         status = sys$qiow(0,            /* Event flag */I                         ipstatus->ip_channel,        /* Channel number */d9                         IO$_READVBLK,  /* I/O function */ I                         &ipstatus->iosb,           /* I/O status block */{                         0, 0,n8                         data,            /* P1 buffer */@                         max_size,         /* P2 buffer length */$                         0, 0, 0, 0);  ( *(data + ipstatus->iosb.count) = 0x00 ;   8 if( ipstatus->iosb.status == SS$_LINKDISCON) return(-1);  J else if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL ))6 	 { fprintf(out_file, "IP_readline: \n QIO status=%d", 			status );6 	   fprintf(out_file, " IOSB status = %d count=%d\n", / 		ipstatus->iosb.status, ipstatus->iosb.count);  	   return(-1);t 	}   return(ipstatus->iosb.count);p   } /* end of readline */p    / /*********************************************/o-  ip_connect(struct ipstatus_struct *ipstatus)h/ /*********************************************/  { 2 #define htons(x) ((unsigned short)((x<<8)|(x>>8))) int status ;N struct SocketParamStruct   socketParam;     /* params used to create socket */ short retlen ;T unsigned long  bind_command = INETACP$C_TRANS * 256 + INETACP_FUNC$C_GETHOSTBYNAME ;   $DESCRIPTOR(acp_command,""); $DESCRIPTOR(response_desc,""); char addr_buff[4]; char buffer[80];     struct  itemlst_2 {i*                 unsigned short il2_length; 		unsigned short il2_type ;,"                 void *il2_address;         } host_address ;    . /* initialize the socket structure to nulls */: memset( &(ipstatus->host), 0, sizeof(struct sockaddr_in));  - /* now, do a bind resolve of the host name */   3 acp_command.dsc$a_pointer = (void *) &bind_command;_0 acp_command.dsc$w_length = sizeof(bind_command);  C response_desc.dsc$a_pointer = (void *) &(ipstatus->host.sin_addr) ;*? response_desc.dsc$w_length = 4 ; /* unsigned long IP address */*   retlen = 0 ;  2 strcpy(buffer, ipstatus->host_desc.dsc$a_pointer);, ipstatus->host_desc.dsc$a_pointer = buffer ;    N status = sys$qiow(0,ipstatus->ip_channel, IO$_ACPCONTROL, &ipstatus->iosb,0,0, 		 &acp_command, 		 &ipstatus->host_desc, 		 &retlen,, 		 &response_desc, 		 0,0);  D if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL))S 	 { fprintf(out_file, "%%WHOIS-E-BADSRV, Cannot resolve IP for whois server: %s\n",a& 			ipstatus->host_desc.dsc$a_pointer); 	   return(0); 	}       /*3 fprintf(out_file, "%s translates to %d.%d.%d.%d\n",i$ 		ipstatus->host_desc.dsc$a_pointer,+ 		ipstatus->host.sin_addr.S_un.S_un_b.s_b1,i+ 		ipstatus->host.sin_addr.S_un.S_un_b.s_b2,i+ 		ipstatus->host.sin_addr.S_un.S_un_b.s_b3,f, 		ipstatus->host.sin_addr.S_un.S_un_b.s_b4);   */  K /* ipstatus->host.sin_addr is set by above QIO and sin_zero inited to 0s */           ( /**** connection can now be made ******/, ipstatus->host.sin_family = TCPIP$C_AF_INET;5 ipstatus->host.sin_port=	 htons(ipstatus->host_port);e    # socketParam.protocol = TCPIP$C_TCP; , socketParam.type     = INET_PROTYP$C_STREAM; socketParam.family   = AF_INET;(  8        status = sys$qiow(0,            	/* Event flag */A                         ipstatus->ip_channel,/* Channel number */r:                         IO$_SETMODE,    /* I/O function */@                         &ipstatus->iosb,  /* I/O status block */                         0, 0, M                         &socketParam, 0,   /* P1 Socket creation parameter */1                         0, 0,-                         0, 0);  D if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL))P 	 { fprintf(out_file, "IP_CONNECT: SETMODE to host =>%s<= failed\n QIO status=",& 			ipstatus->host_desc.dsc$a_pointer); 	   lib$signal(status); ( 	   fprintf(out_file, " IOSB status =");& 	   lib$signal(ipstatus->iosb.status); 	   return(0); 	}  6        memset(&host_address, 0, sizeof(host_address));?        host_address.il2_length  = sizeof( struct sockaddr_in) ;t6        host_address.il2_address =   &(ipstatus->host);  aJ status = sys$qiow(0,ipstatus->ip_channel, IO$_ACCESS, &ipstatus->iosb,0,0, 		 0,0,&host_address, 
 		 0,0,0);  D if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL))N 	 { fprintf(out_file, "%%WHOIS-E-NOCONNECT, Connection to server %s failed\n",& 			ipstatus->host_desc.dsc$a_pointer);* 	   	   lib$signal(ipstatus->iosb.status); 	   return(0); 	}  
 return(1);   } /* end of ip_connect */i    - /*******************************************/ 0  ip_disconnect(struct ipstatus_struct *ipstatus)- /*******************************************/! {p int status ;  *         /* Close the socket (optional). */         status = sys$qiow(3,-                         ipstatus->ip_channel, &                         IO$_DEACCESS ,(                         &ipstatus->iosb,                         0, 0,,!                         0, 0, 0, e
 			0 , 0, 0);t  D if ((status != SS$_NORMAL) || (ipstatus->iosb.status != SS$_NORMAL))Q 	 { fprintf(out_file, "IP_DISCONNECT: DEACCESS host =>%s<= failed\n QIO status=",s& 			ipstatus->host_desc.dsc$a_pointer);( 	   fprintf(out_file, " IOSB status ="); 	}  + status = sys$dassgn(ipstatus->ip_channel) ;   
 return(1); } /* end of ip_disconnect */    / /*********************************************/a.  int ip_init(struct ipstatus_struct *ipstatus)/ /*********************************************/  {u? /* Convert short port number from host to network byte order */e int status ;) $DESCRIPTOR(TCPIP$DEVICE,"TCPIP$DEVICE");   ( /* now we assign channel to IP device */: /* this gets re-used if whois searches multiple servers */  ? status = sys$assign(&TCPIP$DEVICE,&(ipstatus->ip_channel),0,0);; if(status != SS$_NORMAL) {h 			   fprintf(out_file, "%%WHOIS-E-NODEV, Assign to TCPIP$DEVICE failed, TCPIP services unavailable\n"); 			   return(0);                          }     
 return(1); } /* end of ip_init */    6 /****************************************************/  my_exit( long status )%6 /****************************************************/  A /** sets up the exit status so that DCL doesn't display a messagesC  ** also, if an odd "status", then first bit of exit status is also D  ** set to 1 to indicate status. (value of "status" starts at bit 4)  **/   {c long final_status ;s if(out_file) fclose(out_file) ;o  G final_status = 0x10000000L + ( status & 0x00000001L ) + (status * 8L) ;  exit(final_status) ; } /* end of my_exit  */=    ; /*********************************************************/h0  int  show_content(struct buffer_struct *buffer); /*********************************************************/    {"C /** this routine outputs the acquired data in packets not exceeding*C  ** a certain size to make it compatible with "PIPE" and not exceed /  ** bufquota. PIPE's mailbox is 256 bytes wide.f  **/  " char temp , *ptr1, *ptr2 , *ptr3 ; int remain, mysize  ;o #define SHOWSIZE 256   ptr1 = buffer->data ;c remain = buffer->used ;    while (remain > 0 )r {oB 	if(remain > SHOWSIZE)  mysize = SHOWSIZE ; else mysize = remain ; 	ptr2 = ptr1 + mysize ;n 	temp = *ptr2 ;f 	*ptr2 = 0x00 ;p  	fprintf(out_file, "%s", ptr1 ); 	*ptr2 = temp ;e 	ptr1 = ptr2 ; 	remain -= SHOWSIZE ;/ } /* end of while */  
 return(1); } /* end of show_content */p