/* This code was ripped and slightly modified from module SLmisc.c of 
   the Slang library (www.s-lang.org). I certainly do not claim any 
   merits for this MPJZ
*/   

/* Copyright (c) 1992, 1999 John E. Davis
 * This file is part of the S-Lang library.
 *
 * You may distribute under the terms of either the GNU General Public
 * License or the Perl Artistic License.
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <stdarg.h>

int vsnprintf (char *buf, unsigned int buflen, char *fmt, va_list ap)
{
   unsigned int len;

   /* On some systems vsprintf returns useless information.  So, punt */
   vsprintf (buf, fmt, ap);
   len = strlen (buf);
   if (len >= buflen)
     {
       exit(EXIT_FAILURE);
       return EOF;    /* NOT reached */
     }
   return (int)len;
}       
int snprintf (char *buf, unsigned int buflen, char *fmt, ...)
{
   int status;

   va_list ap;

   va_start (ap, fmt);
   status = vsnprintf (buf, buflen, fmt, ap);
   va_end (ap);

   return status;
}
