/* Structure for manageing data volume.
 */
#include "access_db.h"
/*
 * Constants:
 *	MAX_VOLNAME	Max size allowed for volume name.
 *	MAX_VOLPATH	Max length for full volume path.
 *	DENSITY		Number of file versions per filename to store
 */
#define MAX_VOLNAME 31
#define MAX_VOLPATH 255
#define DENSITY 60
#define CATALOGUE_CONFIG_KEY "0:CATALOGUE"
/*
 * Define structure that opaque volptr data type points to.  Main control
 * structure for managing volume.
 */
struct cds_bmlock {
    struct cds_bmlock *next_hash;
    int ref_count;
};
struct cds_volume {
    pthread_mutex_t lock;
    int ref_count;		/* number of accessors */
    int dismount_pending;
    int object_limit;		/* maximum number of objects to allocate */
    int data_limit;		/* maximum number of data bytes */
    int data_used;		/* estimate of current data bytes stored */
    IFILE *catalogue;		/* handle to access .volnamecatalogue file */
    FILE *bitmap;		/* handle to access volname.bitmap file */
    /*
     * bmtable store bitmap in segments, each segment corresponding to 
     * a subdirectory for file storage.
     */
    struct {
	int count;		/* number of set bits */
	int last_offset;	/* last offset allocated or freed */
	int dirty;		/* true if page needs flushed */
	long map[(256/BITS_PER_LONG)*DENSITY];
    } *bmtable[256];
    struct {
	int count;		/* current number of locks held */
	int htable_size;	/* size of hash table */
	long mask;		/* mask for hashing function */
	struct cds_bmlock *hash;/* hash table */
    } bmlock;			/* locks for bits */
    char name[MAX_VOLNAME+1];	/* base volume name */
    char dir[MAX_VOLPATH+1];	/* Root directory for volume, VMS format */
};
/*
 * The cat_entry structure defines the format of records within the
 * catalogue file.
 */
struct cat_entry {		/* catalogue record */
    long number;		/* internal object number, primary key */
    long state;			/* state: 0-placeholder, 1-new, 2-old */
    long ref_count;		/* number of continuations */
    long access_window[2];
    long size;			/* Data size, not including MIME header */
    long mod_time;
    long reserved;
    char name[224];		/* secondary key */
};
/*
 * The catalogue file has a special record with keys 0 (primary) and
 * "0:CATALOG" (secondary).  The non-key fields are assigned special
 * meaning according to the following structure.
 */
struct cat_header_entry {		/* catalogue record */
    long number;		/* internal object number must be zero*/
    long state;			/* must be zero */
    long data_limit;
    long data_used;
    long object_limit;
    long size;			/* Data size, not including MIME header */
    long mod_time;
    long reserved;
    char name[224];		/* primary key */
};
