/*
 * Test functionality of check_vms_password routines.  Command line argument
 * is name of external authenticator to load.
 */
#include <stdio.h>
#include "authutil.h"
#include <prvdef.h>
#include <descrip.h>

static char username[2048];
static char password[2048];
int LIB$GET_INPUT();
static $DESCRIPTOR(username_dx, username);
static $DESCRIPTOR(password_dx, password);
static $DESCRIPTOR(username_prompt, "Username: ");
static $DESCRIPTOR(password_prompt, "Password: ");

int main ( int argc, char **argv )
{
    int status, SYS$SETPRV(), length;
    long prev_privs[2], privs[2];
    static unsigned char remote_addr[4] = { 127, 0, 0, 1 };

    privs[0] = PRV$M_SYSPRV;
    privs[1] = 0;
    status = SYS$SETPRV ( 0, privs, 0, prev_privs );

    status = auth_init_vms_pwd ( "AUTHUTIL_TST",
	prev_privs, (argc>1) ? argv[1] : (char *) 0,
	256, 1000, "0 00:05:00" );
    printf("Status of init: %d\n", status );
    if ( (status&1) == 0 ) return status;
    /*
     * Ask to username password pairs.
     */
    length = 0;
    for ( ; ; ) {
	status = LIB$GET_INPUT ( &username_dx, &username_prompt, &length );
	if ( (status&1) == 0 ) break;
	username[length] = '\0';
	status = LIB$GET_INPUT ( &password_dx, &password_prompt, &length );
	if ( (status&1) == 0 ) break;
	password[length] = '\0';

	status = auth_check_vms_password ( username, password, remote_addr, 0);
	printf("Status of pwd check: %d\n", status );
    }
    return status;
}
