/*
 * Prototypes for routines in script_manage.c
 */
/*
 * Configure_manage_port is called when during rule file parsing to
 * handle interpretation of MANAGE command.  Errors are output via tlog_putlog.
 */
int http_configure_manage_port (
	char *item,		/*  "PORT"  | "HOST"  | "SCRIPT" */
	char *arg1,		/*  port#     ip-addr   script-name */
	char *arg2,		/*    -          -      command-list */
	char *reserved );	/* Reserved for future use */


/*
 * Manage_request is called during scriptserver protocol processing as part
 * of <DNETMANAGE> dispatching.  Return value is 1 for success (200) and
 * 0 for failure.
 */
int http_script_manage_request ( 
	char *script, 		/* name of script making request */
       char *request, 		/* Command to execute: [host:]port command */
       char *response,		/* request status line (returned) */
	int rspsize,		/* Size of response array */
	int *rsplen );		/* Size of returned line */
/*
 * Reset the pending information.
 */
int http_clear_script_manage();
/*
 * verify_script_request checks if script management pending and that
 * remote port is temporary port and that request is TRIGGER.
 */
int http_verify_script_request (
	void *ctx,			/* TCP/IP context */
	char *request,			/* Buffer containing manage command */
	int reqsize,			/* size of request buffer (max length)*/
	int *length );

int http_decode_manage_host ( char *hoststr, unsigned int *ip_addr, int *port);
