$!
$! Link object file(s) specified by P1 into shareable image for
$! providing 'external authorization' password checking routine.
$! If P1 is empty, build the sample extension from source embedded in this
$! procedure.
$!
$! After building the image (e.g. my_extension.exe):
$!    1. Copy the shareable to www_system.
$!    2. Modify http_systartup.com to install the image and define logical
$!	 that has name (only name) of the image:
$!         $ define/sys/exec ext_extension_image my_extension_share
$!    3. Shutdown and restart the server.
$!
$! This procedure works on Alpha's only.
$!
$!
$ IF P1 .eqs. "" then gosub make_stub
$!
$! Link a shareable image, symbol vector defines 2 routines.
$!
$ write sys$output "Linking ", P1, "..."
$ link/share 'P1',sys$input/option
SYMBOL_VECTOR=(-
   INITIALIZE=PROCEDURE,-
   CHECK_PASSWORD=PROCEDURE)
$!
$ exit
$!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
$! Make object file for demonstration shareable image.
$!
$ make_stub:
$ P1 = "sample_ext_extension.obj"
$ write sys$Output "Building sample external auth shareable"
$ cc sys$input/object=sys$disk:[]'P1'/list=sys$disk:[]ext_auth.lis/show=include
$ deck
/*
 * This module defines the templates for functions needed to verify passwords 
 * when the SYSAUF record has the 'extauth' flag set.  The extauth processing
 * is only performed if the logical SYS$SINGLE_SIGNON is defined.
 *
 * The functions supplied are (see below for details):
 *    int INITIALIZE( *flags, *version, char ***taglist, int *tlist_size )
 *    int CHECK_PASSWORD ( char *username, char *password, char *domain,
 *		char **tag_table );
 *
 * Author:	David Jones
 * Date:	8-JUN-2000
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <descrip.h>			/* VMS string descriptors */
#include <utcblkdef.h>			/* VMS Time structures */
#include <prvdef.h>			/* VMS privilege mask bits */
#include <acmedef.h>			/* VMS authorization and cred. mgr. */
#include <iledef.h>			/* VMS item list structures */
#define EXT_AUTH_VERSION 1
/*
 * Define static table of 'tags' that the authenticator is to recognize
 * inside protection setup files.  When we want to allow a tag to occur
 * more than once we repeat it in succession in the table up to the number
 * of repeats we want to allow.  In subsequent calls to check_password,
 * the corresponding slot in the tag_table argument has either a NULL
 * pointer or points to the remainder of that tag line.  For multiple
 * instances the sucessive entries are filled in and terminated by
 * a null pointer.
 *
 * Tag names must be enclosed in angle brackets and are case insensitive.
 */
static struct {
    char *name;				/* Tag string to match */
    int max_count;			/* Max number of repeats. */
    int start, finish;			/* Indices in tag_table */
} tag_def[] = {
   { "<demotag1>", 1, 0, 0 },
   { "<demotag2>", 2, 0, 0 },
   { "<demotag3>", 1, 0, 0 },
   { (char *) 0, 0, 0, 0 }		/* end of list */
};
static char **ext_tag_list;		/* allocated by initialize func. */
int ext_tag_list_size;
int single_signon_flags;
int event_flag;
unsigned long acm_privs[2];		/* privs needed to perform $logon call*/
int LIB$GET_EF(), SYS$LOGONW(), SYS$SETPRV();

/***************************************************************************/
/*
 * The initialize function is called at image startup and may perform
 * any one-time initialization of the shareable image.  It is called only
 * once and takes 3 output arguments.
 *
 * Usually this function will translate logical names in order to
 * determine configuration information needed to access the appropriate
 * databases.
 *
 * Arguments:
 *    int *flags	Flags to indicate options supported by this image:
 *			   <0>  If set, indicates the image supports
 *				authentication of local usernames that have
 *				uai$m_extauth set in their UAF records.
 *
 *    int *version	Receives current interface version, which indicates
 *			which other functions the shareable image provides.
 *			Current version is 1.
 *
 *    char ***taglist	Recevies pointer to statically allocated array of
 *			null-terminated character strings, each string is or 
 *			form "<keyword>".  The same keyword may be repeated
 *			multiple times in succession in the list. Caller may 
 *			specify a null pointer, indicating no tag list
 *			processing will be done.
 *
 *    int *tlist_size	Receives size of returned tag list if non-null.
 *
 * Return value:
 *    1		Successful initialization.
 *   even	Error in initialization, CHECK_PASSWORD routine should not
 *		called.
 */
int INITIALIZE ( int *flags, int *version, char ***taglist, int *tlist_size )
{
    char *env;
    /*
     * Build tag list from tag_def array if caller requested it.
     */
    ext_tag_list_size = 0;
    if ( taglist ) {
	int i, j, k;
	/*
	 * Calculate size needed.
	 */
	for ( i = 0; tag_def[i].name; i++ ) ext_tag_list_size +=
		tag_def[i].max_count;
	/*
	 * Allocate table and build list, repeating the tags as
	 * many times as needed.  Fill in start/finish in tag_def while
	 * doing so.
	 */
	ext_tag_list = (char **) malloc ( (ext_tag_list_size+1) *
		sizeof(char *) );
	if ( ext_tag_list ) {
	    for ( j = i = 0; tag_def[i].name; i++ ) {
		tag_def[i].start = j;
	        for ( k = 0; k < tag_def[i].max_count; k++ ) {
		    tag_def[i].finish = j;
		    ext_tag_list[j++] = tag_def[i].name;
	        }
	    }
	    ext_tag_list[j] = (char *) 0;

	} else ext_tag_list_size = 0;
    }
    /*
     * Prepare for handling single-signon authentication.  Get flags bits
     * from sys$single_signon logical, allocate event flag, and initialize
     * mask of privileges required for sys$logon() call.
     */
    env = getenv ( "SYS$SINGLE_SIGNON" );
    single_signon_flags = (env) ? atoi(env) : 0;
    event_flag = 0;
    LIB$GET_EF ( &event_flag );
    acm_privs[0] = PRV$M_SYSPRV | PRV$M_NETMBX | PRV$M_TMPMBX | PRV$M_CMKRNL;
    acm_privs[1] = 0;
    if ( (PRV$M_AUDIT & (~acm_privs[1]) ) == 0 ) {
	acm_privs[1] = (PRV$M_AUDIT>>32);
    } else {
	acm_privs[1] = 0x020;
    }
    /*
     * Return configuration info to caller.
     */
    if ( taglist ) *taglist = ext_tag_list;
    if ( tlist_size ) *tlist_size = ext_tag_list_size;
    if ( flags ) *flags = (single_signon_flags&1) ? 1 : 0; /* support ext auth */
    *version = EXT_AUTH_VERSION;			/* API version */
    return 1;
}
/*****************************************************************************/
/* The check password function takes a username and password supplied by
 * the caller and validates them using the appropriate means (e.g.
 * contacting SMB server).
 *
 * Input arugments (readonly):
 *    username		Null-terminated string containing username, case
 *			may be mixed.  Maximum username is 255 characters.
 *
 *    password		Null-terminated string password to test, maximum
 *			password is 255 characters.  May be mixed case.
 *
 *    domain		If null, username argument was found in SYSUAF file
 *			and has the extauth flag set.  Otherwise, domain
 *			points to string parsed from setup file.
 *
 *    tag_table		If non-null, array of string pointers to setup file 
 *			arguments.  Array position corresponds to tag list 
 *			position returned in the initialize call.
 *
 * Return values:
 *    0			Password check failed.
 *    1			Password check succeeded.
 */
int CHECK_PASSWORD ( 
	const char *username, 
	const char *password,
	const char *domain,
	const char **tag_table,
	unsigned char *remote_addr,
	int addr_format )
{
    int i, j;
#ifdef DEBUG
    printf("External check for user: '%s', domain: '%s'\n", username,
	domain ? domain : "<NULL>" );
#endif
    /*
     * Scan the tag list if one present and process data specified in
     * setup file via the extension tags.
     */
    if ( tag_table ) {
	/*
	 * Loop over tag names.
	 */
#ifdef DEBUG
	printf("  scanning tag list supplied by caller, tag[0]: %s...\n",
	    tag_def[0].name ? tag_def[0].name : "<NULL>" );
#endif
        for ( i = 0; tag_def[i].name; i++ ) {
	    /*
	     * Scan tag table range for this tag.
	     */
	    for ( j = tag_def[i].start; j <= tag_def[i].finish; j++ ) {
		if ( tag_table[j] == (char *) 0 ) break;  /* no more */
		/*
		 * Process the tag value.
		 */
#ifdef DEBUG
	        printf ( "    passed tag %s: %s\n", ext_tag_list[i], 
			tag_table[j] );
#endif
	    }
        }
    }
    /*
     * Do password check with sys$logonw() call if single-signon enabled.
     * and we are a 'SYSUAF' call (null domain).
     */
    if ( !domain && (single_signon_flags&1) ) {
	int i, status;
	struct { long status, sts2; } iosb;
	struct _ile3 itemlist[4];
	unsigned long prev_mask[2];
	/*
	 * Build argument list.
	 */
	memset (itemlist, 0, sizeof(itemlist));

	i = 0;
 	itemlist[i].ile3$w_code = ACME$_USERID;
	itemlist[i].ile3$w_length = strlen(username);
	itemlist[i].ile3$ps_bufaddr = (char *) username;
 
	i++;
	itemlist[i].ile3$w_code = ACME$_PASSWORD;
	itemlist[i].ile3$w_length = strlen(password);
	itemlist[i].ile3$ps_bufaddr = (char *) password;

	i++;
	itemlist[i].ile3$w_code = ACME$_DOMAIN;
	itemlist[i].ile3$w_length = 6;
	itemlist[i].ile3$ps_bufaddr = "LANMAN";
        /*
         * Enable privileges needed for $logon call, saving the current privs.
         */
	status = SYS$SETPRV ( 1, acm_privs, 0, prev_mask );
	if ( (status&1) == 0 ) return 0;	/* setprv failed */
	/*
	 * Call undocumented system service, this was gleaned from test code
	 * supplied by Mark Berryman and the VMS source code listings.
	 */
	status = SYS$LOGONW ( event_flag,
			ACME$_VERIFY_PASSWORD_ONLY,
			&itemlist,
			0,
			0,
			&iosb,
			0,
			0);
	/*
	 * Disable the privileges we enabled that weren't there before.
	 */
	prev_mask[0] = (~prev_mask[0]) & acm_privs[0];
	prev_mask[1] = (~prev_mask[1]) & acm_privs[1];
  	if ( prev_mask[0] || prev_mask[1] ) {
	    (void) SYS$SETPRV  ( 0, prev_mask, 0, 0 );
	}
	/*
	 * Examine return status from $logon call.
	 */
#ifdef DEBUG
	printf("Status of $logonw: %d %x %x\n", status, iosb.status, iosb.sts2);
#endif
	if ( (status&1) == 1 ) status = iosb.status;
	return (status&1);		/* return 1 or zero */
	
    }
    /*
     * For explicit domains, do your own thing.  Examples:
     *    1. Authenticate via remote SMB server, tags can specified username.
     *    2. Authenticate via private hashed database, tag in setup file
     *       specifies filename of database.
     *    3. Authenticate via kerberos server.
     */
    if ( domain ) {
    }
    return 0;
}
$ eod
$ return
