/*
 * Define message structure for communication between HPSS (High Performance
 * Script Service) MST and the HPSS application.
 *
 * Message consists of 2 mbx unit numbers (comhdr) followed by function and
 * method lengths followed by a list of lengths of names and values for
 * the CGI variables followed by the data.
 */
#define HPSS_MAX_MSGSIZE 16384
#define HPSS_MAX_OUT_MSGSIZE 4096   /* dictated by iobufsize if web server! */
#define HPSS_MAX_PAIR (HPSS_MAX_MSGSIZE/sizeof(struct hpss_length_pair))
struct hpss_length_pair {
    short nlen;				/* length of name  */
    short vlen;				/* length of value */
};
union hpss_mbxmsg {
    struct {
	unsigned short out_mbx;		/* unit number of output mailbox */
	unsigned short in_mbx;		/* same as out_mbx if none */
	short func;			/* invocation mode: HTBIN, CONVERT */
	short method;
    } comhdr;
    struct hpss_length_pair def[HPSS_MAX_PAIR];
    char data[HPSS_MAX_MSGSIZE];
};
