/*
 * Thread-safe file access module.
 */
int tf_initialize();
void *tf_open(char *fname, char *mode, char errmsg[256] );
int tf_close( void *fptr );
int tf_read ( void *fptr, char *buffer, int bufsize );
int tf_last_error (void *fptr, int *last_errno, int *last_vms_cond );
int tf_getline ( void *fptr, char *buffer, int bufsize, int max_lines );
int tf_header_info ( void *fptr, int *size, unsigned *uic, 
		unsigned int *cdate, unsigned int *mdate );
char *tf_format_time ( unsigned long bintim, char *buffer );
unsigned long tf_decode_time ( char *string );
int tf_isdir ( void *fptr );
int tf_at_eof ( void *fptr );
int tf_set_crlf_newline ( void *fptr, int new_mode ); /* returns previous mode*/
/*
 * option bits, alternatively set by HTTP_FILE_ACCESS_FLAGS env. variable:
 *   <0>	Scan for non-ODS2 chars in filespec and fixup if found.
 *   <1>	Always fixup unix-style filespec to VMS format.
 *   <2>	Save date XAB pointer for retrieval of expiration date.
 *   <3>	Save protection XAB ptr. for retrieval of file ACL.
 *
 * tf_set_options must be called after tf_intitialize().
 */
#define TF_OPT_EFS_FIXUP_COND 1
#define TF_OPT_EFS_FIXUP_ALWAYS 2
#define TF_OPT_HDR_EDATE 4
#define TF_OPT_HDR_ACL 8
int tf_set_options ( int flags, int *enabled );
int tf_test_expiration ( void *fptr, int *cur_time );
int tf_ext_header_info ( void *fptr, 
	unsigned int *edate,
	void *aclbuf, int aclbuf_size, int *acl_len );
