$!
$! This procedure is run by privileged processes to prepare for creation
$! of the MBXNET daemon process.  You must be running version 6.2 or higher.
$!
$! When complete, this procedure affects the system/process environment
$! in the following ways:
$!
$!    1. System logical name MBXNET_SYSTEM is defined to translate to the
$!       directory containing this file.  Images mbxnet_daemon_create.exe
$!       and mbxnet_daemon.exe are assumed to exist in the directory as well.
$!
$!    2. The mbxnet_daemon.exe image is install with privileges necessary
$!       for it to operate (DETACH).
$!
$!    3. The foreign command (DCL symbol) mbxnet_create_daemon is defined.
$!       The mbxnet_create_daemon command has the follow syntax:
$!
$!		mbxnet_create_daemon username [logfile]
$!		
$!	  where:
$!		username	Username under daemon's server processes run.
$!		logfile		Output file for daemon's error message
$!				(default: nl:).
$!
$!	   The create daemon command will create the DCL symbol login_dir
$!	   whose value is the login device/directory for the specified
$!	   username.  It will also perform a DCL open on the mailbox from
$!	   which the daemon process reads it's control parameters.  Closing
$!	   this mailbox will complete parameter setup for the daemon.  Prior
$!	   to closing the mailbox, you write additional parameters for
$!	   the daemon.
$!
$ if .not. f$privilege("SYSNAM,SYSPRV,NETMBX,CMKRNL")
$ then
$    write sys$output "This procedure requires SYSNAM, SYSPRV, and CMKRNL."
$    exit
$ endif
$!
$! Define mbxnet_system
$!
$ proc = f$environment("PROCEDURE")
$ proc_dir = f$parse("1.;",proc,,,"NO_CONCEAL,SYNTAX_ONLY") - "][" - "]1.;"
$ proc_dir = proc_dir + "]"
$ define/system/exec mbxnet_system 'proc_dir'
$ mbxnet_create_daemon == "$mbxnet_system:mbxnet_daemon_create"
$!
$! Install image.
$!
$ if f$search("mbxnet_system:mbxnet_daemon_create.exe") .eqs. ""
$ then
$    write sys$output "Missing required image: mbxnet_daemon_create.exe"
$    exit
$ endif
$ if f$search("mbxnet_system:mbxnet_daemon.exe") .eqs. ""
$ then
$    write sys$output "Missing required image: mbxnet_daemon_create.exe"
$    exit
$ endif
$ daemon_privs = "DETACH,SYSNAM,PRMMBX"
$ daemon_image = "''proc_dir'mbxnet_daemon.exe"
$ action = "ADD"
$ if f$file_attributes(daemon_image,"KNOWN") then action = "REPLACE"
$ install 'action' 'daemon_image' /privilege=('daemon_privs')
$ exit $status;
