/*
 * Return user authorization information about a user:
 *	uid			User uic
 *	Login dir.		User's login directory (device + dir),
 *				converted to unix filename format.
 *
 * Date:4-APR-1996		Initial OSF/1 version.
 * Revised: 5-MAR-2000		Support linux.
 */
#include <stdio.h>
#include <stdlib.h>
#include <pwd.h>
#ifdef linux
#ifndef SIABUFSIZ
#define SIABUFSIZ 8192
#endif
#else
/* OSF */
#include <sia.h>		/* defines SIABUFSIZE */
#endif
#include "tutil.h"

int http_log_level;		/* Logging control flag */
#define USERNAME_MAX 40

int http_user_information ( char *username, int user_len,
	int *uic,
	char *login_dir, int maxlen )
{
    int i, status, length, tlog_putlog();
    struct passwd user_info;
#ifdef linux
    struct passwd *work;
#endif
    char userkey[USERNAME_MAX], pw_buf[SIABUFSIZ];
    /*
     * lookup name.
     */
   if ( user_len >= sizeof(userkey) ) return 20;	/* name too long */
   tu_strnzcpy ( userkey, username, user_len );
#ifdef linux
   status = getpwnam_r ( userkey, &user_info, pw_buf, sizeof(pw_buf), &work );
#else
   status = getpwnam_r ( userkey, &user_info, pw_buf, sizeof(pw_buf) );
#endif
    /*
     * Check if logging enabled to this level and place info in log file.
     */
    if ( http_log_level > 10 ) {
	tlog_putlog ( 10,
	   "userdir username: '!AZ', getpwnam_r status: !SL dir: '!AZ'!/", 
		userkey, status, 
		(!status && user_info.pw_dir) ? user_info.pw_dir : "{err}" );
    }
    if ( status == 0 ) {
	/*
	 * Lookup successful, copy result.
	 */
	*uic = (int) user_info.pw_uid;
	if ( !user_info.pw_dir ) user_info.pw_dir = "/";
	tu_strnzcpy ( login_dir, user_info.pw_dir, maxlen-2 );
	/*
	 * Fixup, append final slash
	 */
	i = tu_strlen ( login_dir );
	login_dir[i++] = '/';
	login_dir[i] = '\0';
    } else {
	/*
	 * Error in lookup.
	 */
	return 20;	/* VMS style error */
    }
    return 1;		/* Success */
}
