/*
 * Test operation of exceptions.
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <signal.h>
#include "pthread_1c_np.h"

static void *worker_main ( void *x )
{
    char *arg;
    arg = (char *) x;
    printf ( "Worker entered, arg='%s'\n", arg );

    TRY {
	if ( strcmp ( arg, "div" ) == 0 ) {
	    int quo;
	    printf ( "Forcing divide by zero...\n");
	    quo = 200 / arg[3];
	    printf ( "quotient is: %d\n", quo );
	} if ( strcmp ( arg, "exit" ) == 0 ) {
	    pthread_exit ( x );
        } if ( strcmp ( arg, "pipe" ) == 0 ) {
	   raise ( SIGPIPE );
	} else {
	    printf ( "Normal stuff inside TRY block...\n");
	}
    } CATCH ( pthread_exit_e ) {
	printf("Worker caught Thread exit caught\n");
	RERAISE;
    } CATCH ( pthread_exc_SIG
FPE_e ) {
        printf ( "Worker caught floating point exception\n");
    } CATCH_ALL {
	printf("unknown exception caught by worker\n");
        RERAISE;
    } ENDTRY
    printf ( "worker exiting\n");

    return (void *) 0;
}

int main ( int argc, char **argv )
{
    pthread_t worker;
    int status;
    char *worker_status;

    status = pthread_create ( &worker, (void *) 0, worker_main,
	argc > 1 ? argv[1] : "" );
    printf("Status of worker start: %d\n", status );
    status = pthread_join ( worker, (void *) &worker_status );
    printf("Status of join: %d\n", status );
}
