/*
 * Define prototypes for client certificate 'registration' functions used
 * by tserver_ssl module to support client certificates.  The allocate
 * function returns true on success and false on failure.  The register
 * function returns a null handle value on failure.
 */
typedef void *client_cert_dataset;	/* handle for all data associated
					 * with a unique set of index numbers*/
typedef void *client_cert_instance;	/* Handle for data associated with
					 * a particular index with a
					 * a client_cert_dataset */

typedef struct {
    int d_limit;			/* actual allocated size of data[] */
    int d_used;				/* Amount of data[] used */
    int error;				/* If true, error occurred */
    short int length[4];
    unsigned char data[8];		/* Certificate name formatted as
					 * text followed by issuer and
					 * CA chain, variable size */
} client_cert_info;

/*
 * Utility functions for building client_cert_info structure...
 */
client_cert_info *client_cert_info_init ( void *buffer, int buf_size );
client_cert_info *client_cert_info_validate ( void *buffer, int buf_len );
int client_cert_info_add_item ( unsigned char *buffer, int buflen, 
	client_cert_info *info );
