C [INHERIT ('SYS$LIBRARY:STARLET', 'SYS$LIBRARY:PASCAL$LIB_ROUTINES', C                                  'SYS$LIBRARY:PASCAL$SMG_ROUTINES', D                                  'SYS$LIBRARY:PASCAL$STR_ROUTINES')]   PROGRAM MAILUAF( OUTPUT);  {  PROGRAM DESCRIPTION:     ?   This program is used to maintain the VMSMAIL_PROFILE.DAT file +   which handles the forwarding for VMSMAIL.    	 AUTHORS:        W. Eric Wentz    V. Edward James     CREATION DATE:   7-Jan-1986                 C H A N G E   L O G   %      Date     |   Name  | Description P --------------+---------+------------------------------------------------------- %[change_entry]%O  3-AUG-1991       James   Changed to use callable mail routines instead of file H 18-Nov-1991       James   Changed to SMG$ routines to add command recall@ 19-Oct-1993       James   Removed use of WRITEV with Output_Line }    CONST .      VERSION                 = '019310191243';"      MAX_RECALL_LINES        = 20;!      FULL_USER               = 1; !      FULL_ADDRESS            = 2; !      FULL_DIRECTORY          = 3; !      FULL_PERSONAL           = 4; !      FULL_EDITOR             = 5; !      FULL_FORM               = 6; !      FULL_QUEUE              = 7; !      FULL_MESSAGES           = 8; !      FULL_CC_PROMPT          = 9; "      FULL_AUTO_PURGE         = 10;"      FULL_SELF_SEND          = 11;"      FULL_SELF_REPLY         = 12;"      FULL_SELF_FORWARD       = 13;"      FULL_CREATE_IF          = 14;"      FULL_TERMINATOR         = 15;  !      SHORT_USER              = 1; !      SHORT_ADDRESS           = 2; !      SHORT_TERMINATOR        = 3;   >    TYPE  { [HIDDEN] Pre-declared data types from STARLET.PAS }       $BYTE = [BYTE] -128..127;        $UBYTE = [BYTE] 0..255; #       $WORD = [WORD] -32768..32767;        $UWORD = [WORD] 0..65535;   J    {  If your version of Pascal's STARLET.PAS does not include $MAILMSGDEF/       then uncomment the following statement: } '      %INCLUDE 'MAILMSGDEF.PAS /NOLIST'    I    {  If your version of Pascal's STARLET.PAS does not include $CLIMSGDEF /       then uncomment the following statement: } &      %INCLUDE 'CLIMSGDEF.PAS /NOLIST'   3    { *** MODULE ITEMLIST ***           901119   VEJ +          System Service Itemlist Layout   }     TYPE <       Item_List_Cell                = RECORD CASE INTEGER OF
       1: (6          Buffer_length              : [WORD] 0..65535;6          Item_code                  : [WORD] 0..65535;/          Buffer_address             : UNSIGNED; .          Return_length_addr         : UNSIGNED          ); 
       2: (.          Terminator                 : UNSIGNED          ); 
       END;M       Item_List_Template(Count:INTEGER) = ARRAY [1..Count] OF Item_List_Cell;      TYPE3      Keyboard_Id_Type        = [VOLATILE] UNSIGNED; 3      Key_Table_Id_Type       = [VOLATILE] UNSIGNED; %      Descriptor              = RECORD &         DSC$W_Length         : $UWORD;&         DSC$B_Type           : $UBYTE;&         DSC$B_Class          : $UBYTE;'         DSC$A_Pointer        : INTEGER;          END;     VAR 0      Keyboard_Id             : Keyboard_Id_Type;1      Key_Table_Id            : Key_Table_Id_Type;   +      User                    : STRING(255); +      Address                 : STRING(255); +      Directory               : STRING(255); +      Personal                : STRING(255); +      Editor                  : STRING(255); +      Form                    : STRING(255); +      Queue                   : STRING(255); '      Queue_Len               : INTEGER; -      Messages                : $WORD VALUE 0; '      CC_Prompt               : BOOLEAN; '      Auto_Purge              : BOOLEAN; '      Self_Send               : BOOLEAN; '      Self_Reply              : BOOLEAN; '      Self_Forward            : BOOLEAN;   '      User_Len                : INTEGER; '      Address_Len             : INTEGER; '      Directory_Len           : INTEGER; '      Personal_Len            : INTEGER; '      Editor_Len              : INTEGER; '      Form_Len                : INTEGER;   '      CC_Prompt_Val           : INTEGER; '      Auto_Purge_Val          : INTEGER; '      Self_Send_Val           : INTEGER; '      Self_Reply_Val          : INTEGER; '      Self_Forward_Val        : INTEGER;   '      User_Modified           : BOOLEAN; '      Address_Modified        : BOOLEAN; '      Directory_Modified      : BOOLEAN; '      Personal_Modified       : BOOLEAN; '      Editor_Modified         : BOOLEAN; '      Form_Modified           : BOOLEAN; '      Queue_Modified          : BOOLEAN; '      Messages_Modified       : BOOLEAN; '      CC_Prompt_Modified      : BOOLEAN; '      Auto_Purge_Modified     : BOOLEAN; '      Self_Send_Modified      : BOOLEAN; '      Self_Reply_Modified     : BOOLEAN; '      Self_Forward_Modified   : BOOLEAN;   3      Context                 : UNSIGNED VALUE ZERO;   +      Command                 : STRING(255); 4      Initial_String          : STRING(255) VALUE '';*      Initial_String_Desc     : Descriptor;'      Show_Full_Qualifier     : BOOLEAN; '      Show_Inuse_Qualifier    : BOOLEAN; '      Show_Brief_Qualifier    : BOOLEAN; -      Foreign_Command_Len     : $WORD VALUE 0; '      Status                  : INTEGER; 8      MAILUAF_TABLE           : [EXTERNAL,VALUE] INTEGER;@      Null_Item_List          : Item_List_Template(1) VALUE ZERO;@      User_Name_Item_List     : Item_List_Template(3) VALUE ZERO;@      First_User_Item_List    : Item_List_Template(3) VALUE ZERO;@      Next_User_Item_List     : Item_List_Template(3) VALUE ZERO;N      Full_Item_List          : Item_List_Template(FULL_TERMINATOR) VALUE ZERO;O      Short_Item_List         : Item_List_Template(SHORT_TERMINATOR) VALUE ZERO;   P (******************************************************************************)+   FUNCTION Get_Cli_Info : BOOLEAN; FORWARD;   P (******************************************************************************)A   FUNCTION Get_User_Info( VAR In_Item_List  : Item_List_Template; M                           VAR Out_Item_List : Item_List_Template) : UNSIGNED; "                           FORWARD;  P (******************************************************************************)   FUNCTION MUAF_Get_Input(N      VAR Resultant_String : [CLASS_S] PACKED ARRAY [$l1..$u1:INTEGER] OF CHAR;G      Prompt_String : [CLASS_S] PACKED ARRAY [$l2..$u2:INTEGER] OF CHAR; 8      VAR Resultant_Length : $UWORD) : UNSIGNED; FORWARD;  P (******************************************************************************)3   PROCEDURE Set_Full_Item_List_For_Modify; FORWARD;   P (******************************************************************************)1   PROCEDURE Set_Full_Item_List_For_Show; FORWARD;   P (******************************************************************************))   PROCEDURE Set_Short_Item_List; FORWARD;   P (******************************************************************************)(   [asynchronous,external(Cli$DCL_Parse)]   Function Cli$DCL_Parse( :      var command_string  : [CLASS_S,READONLY] PACKED ARRAY#         [$L1..$U1:INTEGER] OF CHAR; '      %immed table : [READONLY] INTEGER; :      %immed [UNBOUND] procedure param_routine := %immed 0;;      %immed [UNBOUND] procedure prompt_routine := %immed 0; 8      var prompt_string : [CLASS_S,READONLY] PACKED ARRAY@         [$L2..$U2:INTEGER] OF CHAR:=%IMMED 0):INTEGER; EXTERNAL;  P (******************************************************************************)'   [asynchronous,external(Cli$Dispatch)]    Function Cli$Dispatch(H      var userarg : [READONLY] INTEGER := %IMMED 0) : UNSIGNED; EXTERNAL;  P (******************************************************************************)(   [asynchronous,external(Cli$Get_Value)]   Function Cli$Get_Value( 6      var entity_desc : [CLASS_S,READONLY] PACKED ARRAY#         [$L1..$U1:INTEGER] OF CHAR; E      var retdesc : [CLASS_S] PACKED ARRAY [$L2..$U2:INTEGER] OF CHAR; =      var retlength : $UWORD :=%IMMED 0) : UNSIGNED; EXTERNAL;   P (******************************************************************************)&   [asynchronous,external(Cli$Present)]   Function Cli$Present( 6      var entity_desc : [CLASS_S,READONLY] PACKED ARRAY9         [$L1..$U1:INTEGER] OF CHAR) : UNSIGNED; EXTERNAL;   P (******************************************************************************)*   [asynchronous,external(Lbr$Output_Help)]   Function Lbr$Output_Help( /      %immed [unbound] procedure output_routine; 7      var output_width : [READONLY] INTEGER := %IMMED 0; 4      var line_desc : [READONLY,CLASS_S] PACKED ARRAY+         [A..B:INTEGER] OF CHAR := %IMMED 0; 7      var library_name : [READONLY,CLASS_S] PACKED ARRAY +         [C..D:INTEGER] OF CHAR := %IMMED 0; 0      var flags : [READONLY] UNSIGNED :=%IMMED 0;D      %immed [unbound] procedure input_routine) : UNSIGNED; EXTERNAL;  P (******************************************************************************)%   [EXTERNAL]FUNCTION Mail$User_Begin( '      VAR context : [VOLATILE] UNSIGNED; E      %REF in_item_list : [UNSAFE] ARRAY [$l2..$u2:INTEGER] OF $UBYTE; F      %REF out_item_list : [UNSAFE] ARRAY [$l3..$u3:INTEGER] OF $UBYTE)         : UNSIGNED; EXTERNAL;   P (******************************************************************************)+   [EXTERNAL]FUNCTION Mail$User_Delete_Info( '      VAR context : [VOLATILE] UNSIGNED; E      %REF in_item_list : [UNSAFE] ARRAY [$l2..$u2:INTEGER] OF $UBYTE; F      %REF out_item_list : [UNSAFE] ARRAY [$l3..$u3:INTEGER] OF $UBYTE)         : UNSIGNED; EXTERNAL;   P (******************************************************************************)#   [EXTERNAL]FUNCTION Mail$User_End( '      VAR context : [VOLATILE] UNSIGNED; E      %REF in_item_list : [UNSAFE] ARRAY [$l2..$u2:INTEGER] OF $UBYTE; F      %REF out_item_list : [UNSAFE] ARRAY [$l3..$u3:INTEGER] OF $UBYTE)         : UNSIGNED; EXTERNAL;   P (******************************************************************************)(   [EXTERNAL]FUNCTION Mail$User_Get_Info('      VAR context : [VOLATILE] UNSIGNED; E      %REF in_item_list : [UNSAFE] ARRAY [$l2..$u2:INTEGER] OF $UBYTE; F      %REF out_item_list : [UNSAFE] ARRAY [$l3..$u3:INTEGER] OF $UBYTE)         : UNSIGNED; EXTERNAL;   P (******************************************************************************)(   [EXTERNAL]FUNCTION Mail$User_Set_Info('      VAR context : [VOLATILE] UNSIGNED; E      %REF in_item_list : [UNSAFE] ARRAY [$l2..$u2:INTEGER] OF $UBYTE; F      %REF out_item_list : [UNSAFE] ARRAY [$l3..$u3:INTEGER] OF $UBYTE)         : UNSIGNED; EXTERNAL;   P (******************************************************************************)   [GLOBAL]PROCEDURE Add_User;       VAR'         Modified             : BOOLEAN; (         Istat                : UNSIGNED;   BEGIN 4      Cli$Get_Value( 'USER', User.BODY, User.LENGTH);9      User_Name_Item_List[1].Buffer_Length := User.LENGTH; !      Set_Full_Item_List_For_Show; B      Istat := Get_User_Info( User_Name_Item_List, Full_Item_List);      IF NOT ODD( Istat) THEN2         { MAIL$_NOSUCHUSR = 8290346 (%X007E802A) }(         IF Istat <> MAIL$_NOSUCHUSR THEN            Lib$Stop( Istat)          ELSE            BEGIN"               IF Get_Cli_Info THEN                  BEGIN2                     Set_Full_Item_List_For_Modify;?                     Full_Item_List[FULL_CREATE_IF].Item_Code := ,                        MAIL$_USER_CREATE_IF;9                     Istat := Mail$User_Set_Info( Context, @                                                  Full_Item_List,A                                                  Null_Item_List); =                     IF NOT ODD( Istat) THEN Lib$Stop( Istat); 3                     WRITELN( 'User ',User,' added')                   END            END	      ELSE 7         WRITELN( 'User ',User,' record already exists')    END;  { Add_User }  P (******************************************************************************)    PROCEDURE Check_Full_Or_Brief;      VAR(         Istat                : UNSIGNED;   BEGIN "      Show_Full_Qualifier := FALSE;#      Show_Brief_Qualifier := FALSE; #      Show_Inuse_Qualifier := FALSE; #      Istat := Cli$Present( 'FULL'); !      IF Istat = CLI$_PRESENT THEN $         Show_Full_Qualifier := TRUE;$      Istat := Cli$Present( 'BRIEF');!      IF Istat = CLI$_PRESENT THEN %         Show_Brief_Qualifier := TRUE; $      Istat := Cli$Present( 'INUSE');!      IF Istat = CLI$_PRESENT THEN %         Show_Inuse_Qualifier := TRUE;    END;  { Check_Full_Or_Brief }   P (******************************************************************************)"   PROCEDURE Create_SMG_Structures;      VAR'         Status               : INTEGER;    BEGIN F      Status := SMG$Create_Virtual_Keyboard( keyboard_id:= Keyboard_Id,2                  recall_size := MAX_RECALL_LINES);0      IF NOT ODD( Status) THEN LIB$Stop( Status);C      Status := SMG$Create_Key_Table( key_table_id := Key_Table_Id); 0      IF NOT ODD( Status) THEN LIB$Stop( Status);=      Status := SMG$Add_Key_Def( key_table_id := Key_Table_Id, >         key_name := 'FIND', attributes := SMG$M_KEY_TERMINATE,,         equivalence_string := 'RECALL/ALL');0      IF NOT ODD( Status) THEN LIB$Stop( Status);=      Status := SMG$Add_Key_Def( key_table_id := Key_Table_Id, ?         key_name := 'SELECT', equivalence_string := 'RECALL '); 0      IF NOT ODD( Status) THEN LIB$Stop( Status);=      Status := SMG$Add_Key_Def( key_table_id := Key_Table_Id, ;         key_name := 'HELP', equivalence_string := 'HELP '); 0      IF NOT ODD( Status) THEN LIB$Stop( Status);=      Status := SMG$Add_Key_Def( key_table_id := Key_Table_Id, =         key_name := 'DO', attributes := SMG$M_KEY_TERMINATE); 0      IF NOT ODD( Status) THEN LIB$Stop( Status);!   END;  { Create_SMG_Structures }   P (******************************************************************************)"   PROCEDURE Delete_SMG_Structures;      VAR'         Status               : INTEGER; G         Flags                : UNSIGNED VALUE 0; { don't erase screen }    BEGIN 9      Status := SMG$Delete_Virtual_Keyboard( Keyboard_Id); 0      IF NOT ODD( Status) THEN LIB$Stop( Status);!   END;  { Delete_SMG_Structures }   P (******************************************************************************)   PROCEDURE Display_User; 
      CONST#         MAX_FAO_STR          = 132;       VAR=         Fao_Str              : VARYING [MAX_FAO_STR] OF CHAR; G         Control_Str          : PACKED ARRAY [1..3] OF CHAR VALUE '!SL'; (         Istat                : UNSIGNED;   BEGIN !      IF Directory.LENGTH > 0 THEN <         WRITELN( 'User ',User,' subdirectory is ',Directory)	      ELSE #         IF Show_Full_Qualifier THEN @            WRITELN( 'User ',User,' has not set a subdirectory');2      IF (Messages > 0) OR Show_Full_Qualifier THEN
         BEGIN 0            Istat := $FAO( Ctrstr := Control_Str,K                           Outlen := Fao_Str.LENGTH, Outbuf := Fao_Str.BODY, *                           P1 := Messages);4            IF NOT ODD( Istat) THEN Lib$Stop( Istat);)            WRITELN( 'User ',User,' has ', H               SUBSTR( Fao_Str.BODY, 1, Fao_Str.LENGTH), ' new messages')         END;      IF Address.LENGTH > 0 THEN @         WRITELN( 'User ',User,' forwarding address is ',Address)	      ELSE #         IF Show_Full_Qualifier THEN !            WRITELN( 'User ',User, 3               ' has not set a forwarding address');        IF Personal.LENGTH > 0 THEN         WRITELN( 'User ',User,0            ' personal name is "', Personal, '"')	      ELSE #         IF Show_Full_Qualifier THEN A            WRITELN( 'User ',User,' has not set a personal name');       IF Editor.LENGTH > 0 THEN4         WRITELN( 'User ',User,' editor is ', Editor)	      ELSE #         IF Show_Full_Qualifier THEN ;            WRITELN( 'User ',User,' has not set an editor'); -      IF CC_Prompt OR Show_Full_Qualifier THEN          IF CC_Prompt THEN ?            WRITELN( 'User ', User, ' has CC prompting enabled')          ELSEA            WRITELN( 'User ', User, ' has CC prompting disabled'); H      IF (Self_Send OR Self_Reply OR Self_Forward) OR Show_Full_Qualifier	      THEN 
         BEGIN :            IF Self_Send OR Self_Reply OR Self_Forward THEN               BEGIN N                  IF Self_Send AND (NOT Self_Reply) AND (NOT Self_Forward) THEN+                     WRITELN( 'User ', User,T@                        ' has automatic copies to self on SEND');N                  IF (NOT Self_Send) AND Self_Reply AND (NOT Self_Forward) THEN+                     WRITELN( 'User ', User,AA                        ' has automatic copies to self on REPLY'); N                  IF (NOT Self_Send) AND (NOT Self_Reply) AND Self_Forward THEN+                     WRITELN( 'User ', User,eC                        ' has automatic copies to self on FORWARD'); H                  IF Self_Send AND Self_Reply AND (NOT Self_Forward) THEN+                     WRITELN( 'User ', User,-F                        ' has automatic copies to self on SEND,REPLY');H                  IF Self_Send AND (NOT Self_Reply) AND Self_Forward THEN+                     WRITELN( 'User ', User, H                        ' has automatic copies to self on SEND,FORWARD');H                  IF (NOT Self_Send) AND Self_Reply AND Self_Forward THEN+                     WRITELN( 'User ', User,RI                        ' has automatic copies to self on REPLY,FORWARD');RB                  IF Self_Send AND Self_Reply AND Self_Forward THEN+                     WRITELN( 'User ', User, N                        ' has automatic copies to self on SEND,REPLY,FORWARD');               ENDO            ELSE %               WRITELN( 'User ', User, :                  ' has automatic copies to self disabled')         END;.      IF Auto_Purge OR Show_Full_Qualifier THEN
         BEGIN1            IF Auto_Purge THEN %               WRITELN( 'User ', User,=@                  ' has automatic deleted message purge enabled')            ELSET%               WRITELN( 'User ', User, A                  ' has automatic deleted message purge disabled')=         END;      IF Queue.LENGTH > 0 THEN.@         WRITELN( 'User ',User,' default print queue is ', Queue)	      ELSE'#         IF Show_Full_Qualifier THENS!            WRITELN( 'User ',User,o4               ' has not set a default print queue');      IF Form.LENGTH > 0 THEN>         WRITELN( 'User ',User,' default print form is ', Form)	      ELSEt#         IF Show_Full_Qualifier THENN!            WRITELN( 'User ',User, 2               ' has not set a default print form')   END;  { Display_User }  P (******************************************************************************)   [GLOBAL]PROCEDURE Done;       VAR(         Istat                : UNSIGNED;   BEGIN_F      Istat := Mail$User_End( Context, Null_Item_List, Null_Item_List);.      IF NOT ODD( Istat) THEN Lib$Stop( Istat);      $EXIT;I   END;  { Done }  P (******************************************************************************)   FUNCTION Get_Cli_Info;      VAR'         Modified             : BOOLEAN;e(         Istat                : UNSIGNED;(         Jstat                : UNSIGNED;   BEGIN       User_Modified := FALSE;      Address_Modified := FALSE;C!      Directory_Modified := FALSE;:       Personal_Modified := FALSE;      Editor_Modified := FALSE;      Form_Modified := FALSE;      Queue_Modified := FALSE;R       Messages_Modified := FALSE;!      CC_Prompt_Modified := FALSE;d"      Auto_Purge_Modified := FALSE;!      Self_Send_Modified := FALSE; "      Self_Reply_Modified := FALSE;$      Self_Forward_Modified := FALSE;      Modified := FALSE; &      Istat := Cli$Present( 'FORWARD');!      IF Istat = CLI$_PRESENT THEN          BEGIN     C            Cli$Get_Value( 'FORWARD', Address.BODY, Address.LENGTH); $            Address_Modified := TRUE;            Modified := TRUE          END;!      IF Istat = CLI$_NEGATED THEN:
         BEGIN             Address := ''; $            Address_Modified := TRUE;            Modified := TRUE_         END;  (      Istat := Cli$Present( 'DIRECTORY');!      IF Istat = CLI$_PRESENT THEN 
         BEGINEI            Cli$Get_Value( 'DIRECTORY', Directory.BODY, Directory.LENGTH); &            Directory_Modified := TRUE;            Modified := TRUEa         END;!      IF Istat = CLI$_NEGATED THEN 
         BEGING            Directory := ''; &            Directory_Modified := TRUE;            Modified := TRUEt         END;  '      Istat := Cli$Present( 'PERSONAL'); !      IF Istat = CLI$_PRESENT THENa
         BEGINTF            Cli$Get_Value( 'PERSONAL', Personal.BODY, Personal.LENGTH);%            Personal_Modified := TRUE;f            Modified := TRUED         END;!      IF Istat = CLI$_NEGATED THEN_
         BEGIN:            Personal := '';%            Personal_Modified := TRUE;i            Modified := TRUE          END;  %      Istat := Cli$Present( 'EDITOR');o!      IF Istat = CLI$_PRESENT THENr
         BEGIN @            Cli$Get_Value( 'EDITOR', Editor.BODY, Editor.LENGTH);#            Editor_Modified := TRUE;             Modified := TRUEO         END;!      IF Istat = CLI$_NEGATED THEN 
         BEGIN             EDITOR := '';#            Editor_Modified := TRUE;             Modified := TRUEI         END;  #      Istat := Cli$Present( 'FORM');I!      IF Istat = CLI$_PRESENT THEN;
         BEGINl:            Cli$Get_Value( 'FORM', Form.BODY, Form.LENGTH);!            Form_Modified := TRUE;             Modified := TRUEC         END;!      IF Istat = CLI$_NEGATED THEN 
         BEGINI            FORM := '';!            Form_Modified := TRUE;N            Modified := TRUE          END;  $      Istat := Cli$Present( 'QUEUE');!      IF Istat = CLI$_PRESENT THENl
         BEGINR=            Cli$Get_Value( 'QUEUE', Queue.BODY, Queue.LENGTH);Z"            Queue_Modified := TRUE;            Modified := TRUEZ         END;!      IF Istat = CLI$_NEGATED THENm
         BEGINI            QUEUE := '';S"            Queue_Modified := TRUE;            Modified := TRUEU         END;  '      Istat := Cli$Present( 'MESSAGES');*!      IF Istat = CLI$_PRESENT THEN 
         BEGINCD            Cli$Get_Value( 'MESSAGES', Command.BODY, Command.LENGTH);E            READV( SUBSTR( Command.BODY, 1, Command.LENGTH), Messages,A!               ERROR := CONTINUE);e%            Messages_Modified := TRUE;t            Modified := TRUE          END;!      IF Istat = CLI$_NEGATED THEN 
         BEGIN*            Messages := 0;*%            Messages_Modified := TRUE;             Modified := TRUE          END;  #      Istat := Cli$Present( 'COPY');.!      IF Istat = CLI$_PRESENT THEN_
         BEGIN_            REPEAT2L               Jstat := Cli$Get_Value( 'COPY', Command.BODY, Command.LENGTH);H               { CLI$PARSE check that options are valid from list in cld,J                 so now can just check for first letter, which is unique. }9               IF SUBSTR( Command.BODY, 1, 1) = 'S'   THEN*                  BEGIN&                     Self_Send := TRUE;.                     Self_Send_Modified := TRUE                  END;*9               IF SUBSTR( Command.BODY, 1, 3) = 'NOS' THEN                   BEGIN'                     Self_Send := FALSE;*.                     Self_Send_Modified := TRUE                  END;n9               IF SUBSTR( Command.BODY, 1, 1) = 'R'   THENN                  BEGIN'                     Self_Reply := TRUE;e0                     Self_Reply_Modified := TRUE;                  END;t9               IF SUBSTR( Command.BODY, 1, 3) = 'NOR' THENu                  BEGIN(                     Self_Reply := FALSE;0                     Self_Reply_Modified := TRUE;                  END;A9               IF SUBSTR( Command.BODY, 1, 1) = 'F'   THEN*                  BEGIN)                     Self_Forward := TRUE; 2                     Self_Forward_Modified := TRUE;                  END; 9               IF SUBSTR( Command.BODY, 1, 3) = 'NOF' THEN*                  BEGIN*                     Self_Forward := FALSE;2                     Self_Forward_Modified := TRUE;                  END;[%            UNTIL Jstat = CLI$_ABSENT; H            IF (NOT Self_Send_Modified) AND (NOT Self_Reply_Modified) AND.               (NOT Self_Forward_Modified) THEN               BEGIN G                  { CLI$_ABSENT returned on first call to Cli$Get_Value.*O                    /COPY specified without list ( no SEND, REPLY, or FORWARD) }n#                  Self_Send := TRUE;:,                  Self_Send_Modified := TRUE;$                  Self_Reply := TRUE;-                  Self_Reply_Modified := TRUE;*&                  Self_Forward := TRUE;/                  Self_Forward_Modified := TRUE;                END;            Modified := TRUEd         END;!      IF Istat = CLI$_NEGATED THENt
         BEGINI            Self_Send := FALSE;&            Self_Send_Modified := TRUE;            Self_Reply := FALSE;R'            Self_Reply_Modified := TRUE;R!            Self_Forward := FALSE; )            Self_Forward_Modified := TRUE;             Modified := TRUEI         END;  (      Istat := Cli$Present( 'CC_PROMPT');!      IF Istat = CLI$_PRESENT THEN*
         BEGIN*            CC_Prompt := TRUE;*&            CC_Prompt_Modified := TRUE;            Modified := TRUE          END;!      IF Istat = CLI$_NEGATED THENE
         BEGIN:            CC_Prompt := FALSE;&            CC_Prompt_Modified := TRUE;            Modified := TRUET         END;  (      Istat := Cli$Present( 'AUTOPURGE');!      IF Istat = CLI$_PRESENT THEN*
         BEGIN*            Auto_Purge := TRUE;'            Auto_Purge_Modified := TRUE;             Modified := TRUEI         END;!      IF Istat = CLI$_NEGATED THEN$
         BEGIN]            Auto_Purge := FALSE;l'            Auto_Purge_Modified := TRUE;F            Modified := TRUE          END;        Get_Cli_Info := Modified*   END;  { Get_Cli_Info }  P (******************************************************************************)   FUNCTION Get_User_Info;       VAR(         Istat                : UNSIGNED;   BEGIN H      Istat := Mail$User_Get_Info( Context, In_Item_List, Out_Item_List);      IF ODD( Istat) THEN
         BEGIN*#            User.LENGTH := User_Len;*)            Address.LENGTH := Address_Len;A-            Directory.LENGTH := Directory_Len;t+            Personal.LENGTH := Personal_Len;i'            Editor.LENGTH := Editor_Len; %            Queue.LENGTH := Queue_Len;S#            Form.LENGTH := Form_Len;T&            IF ODD( CC_Prompt_Val) THEN               CC_Prompt := TRUE*            ELSE*!               CC_Prompt := FALSE;R'            IF ODD( Auto_Purge_Val) THENR                Auto_Purge := TRUE            ELSE_"               Auto_Purge := FALSE;&            IF ODD( Self_Send_Val) THEN               Self_Send := TRUEG            ELSE !               Self_Send := FALSE;*'            IF ODD( Self_Reply_Val) THEN*                Self_Reply := TRUE            ELSED"               Self_Reply := FALSE;)            IF ODD( Self_Forward_Val) THENa"               Self_Forward := TRUE            ELSEV$               Self_Forward := FALSE;         END;      Get_User_Info := Istat    END;  { Get_User_Info }F  P (******************************************************************************)   [GLOBAL]PROCEDURE Help_User;      VAR(         Istat                : UNSIGNED;   BEGIN &      Istat := Cli$Present( 'VERSION');!      IF Istat = CLI$_PRESENT THEN .         WRITELN( 'Mailuaf Version ', Version);;      Cli$Get_Value( 'TOPIC', Command.BODY, Command.LENGTH);_9      Istat := Lbr$Output_Help( line_desc := Command.BODY,iG                                output_routine := %IMMED Lib$Put_Output,E;                                library_name   := 'MAILUAF',tH                                input_routine  := %IMMED MUAF_Get_Input);-      IF NOT ODD( Istat) THEN Lib$Stop( Istat)l   END;  { Help_User }   P (******************************************************************************)   [GLOBAL]PROCEDURE List_Users;       VAR(         Istat                : UNSIGNED;   BEGINs      Check_Full_Or_Brief;eD      IF (NOT Show_Full_Qualifier) AND (NOT Show_Brief_Qualifier) AND'         (NOT Show_Inuse_Qualifier) THEN*%         Show_Brief_Qualifier := TRUE; !      IF Show_Brief_Qualifier THEN 
         BEGIN I            WRITELN( 'Username                       Forwarding address');LI            WRITELN( '--------                       ------------------');L            Set_Short_Item_List;TI            Istat := Get_User_Info( First_User_Item_List, Short_Item_List)R         ENDI	      ELSEL
         BEGIN '            Set_Full_Item_List_For_Show; H            Istat := Get_User_Info( First_User_Item_List, Full_Item_List)         END;.      IF NOT ODD( Istat) THEN Lib$Stop( Istat);      REPEAT $         IF Show_Brief_Qualifier THEN            BEGIN(               IF Address.LENGTH > 0 THENL                  WRITELN( PAD( SUBSTR( User.BODY, 1, User.LENGTH), ' ', 31),                     Address);iK               Istat := Get_User_Info( Next_User_Item_List, Short_Item_List)A            END         ELSE            BEGIN               Display_User;uJ               Istat := Get_User_Info( Next_User_Item_List, Full_Item_List)            END;$         IF NOT ODD( Istat) THENG5            { MAIL$_NOMOREREC = 8314792 (%X007EDFA8) }e=            IF Istat <> MAIL$_NOMOREREC THEN Lib$Stop( Istat);q      UNTIL NOT ODD( Istat)   END;  { List_Users }  P (******************************************************************************)    [GLOBAL]PROCEDURE Modify_User;      VAR'         Modified             : BOOLEAN;I(         Istat                : UNSIGNED;   BEGINa4      Cli$Get_Value( 'USER', User.BODY, User.LENGTH);9      User_Name_Item_List[1].Buffer_Length := User.LENGTH;)!      Set_Full_Item_List_For_Show;IB      Istat := Get_User_Info( User_Name_Item_List, Full_Item_List);      IF NOT ODD( Istat) THEN2         { MAIL$_NOSUCHUSR = 8290346 (%X007E802A) }:         IF Istat <> MAIL$_NOSUCHUSR THEN Lib$Stop( Istat);      IF ODD( Istat) THEN
         BEGIN*            IF Get_Cli_Info THEN*               BEGIN*/                  Set_Full_Item_List_For_Modify;V6                  Istat := Mail$User_Set_Info( Context,=                                               Full_Item_List, >                                               Null_Item_List);:                  IF NOT ODD( Istat) THEN Lib$Stop( Istat);4                  WRITELN( 'User ',User,' modified');               END*         END*	      ELSE*7         WRITELN( 'User ',User,' record does not exist')    END;  { Modify_User }   P (******************************************************************************)   FUNCTION MUAF_Get_Input;      VAR(         Istat                : UNSIGNED;&         Term_Code            : $UWORD;   BEGIN ?      Initial_String_Desc.DSC$W_Length := Initial_String.LENGTH;uA      Istat := SMG$Read_Composed_Line( keyboard_id := Keyboard_Id,i%         key_table_id := Key_Table_Id,s-         resultant_string := Resultant_String,s'         prompt_string := Prompt_String, -         resultant_length := Resultant_Length,:3         initial_string := %REF Initial_String_Desc,a+         word_terminator_code := Term_Code); $         (* flags := TRM$M_NOKEEP, *)      IF NOT ODD( Istat) THEN
         BEGINI$            IF Istat <> SMG$_EOF THEN               Lib$Stop( Istat);R            Istat := RMS$_EOF         ENDe	      ELSE 
         BEGIN             Istat := SS$_NORMAL;             Initial_String := ''r         END;      MUAF_Get_Input := Istat   END;  { MUAF_Get_Input }  P (******************************************************************************)    [GLOBAL]PROCEDURE Recall_Line;      VAR(         Istat                : UNSIGNED;&         ii                   : $UBYTE;   BEGINS"      Istat := Cli$Present( 'ALL');!      IF Istat = CLI$_PRESENT THENs
         BEGINtH            Istat := SMG$Replace_Input_Line( keyboard_id := Keyboard_Id);4            IF NOT ODD( Istat) THEN Lib$Stop( Istat);-            FOR ii := 1 TO MAX_RECALL_LINES DON               BEGINn4                  Initial_String_Desc.DSC$W_Length :=,                     Initial_String.CAPACITY;L                  Istat := SMG$Return_Input_Line( keyboard_id := Keyboard_Id,A                     resultant_string := %REF Initial_String_Desc, 3                     byte_integer_line_number := ii,S?                     resultant_length := Initial_String.LENGTH);f:                  IF NOT ODD( Istat) THEN Lib$Stop( Istat);2                  IF Initial_String.LENGTH > 0 THEN/                     WRITELN( ii:3, ' ', SUBSTR( F                        Initial_String.BODY, 1, Initial_String.LENGTH))               END;            Initial_String := ''e         ENDR	      ELSEO
         BEGIN ,            Istat := Cli$Present( 'LINE_NO');'            IF Istat = CLI$_PRESENT THENt               BEGINRI                  Cli$Get_Value( 'LINE_NO', Command.BODY, Command.LENGTH);_:                  IF NOT ODD( Istat) THEN Lib$Stop( Istat);N                  Istat := SMG$Replace_Input_Line( keyboard_id := Keyboard_Id);:                  IF NOT ODD( Istat) THEN Lib$Stop( Istat);                  ii := 0;TE                  READV( SUBSTR( Command.BODY, 1, Command.LENGTH), ii,s'                     ERROR := CONTINUE); >                  IF (0 < ii) AND (ii <= MAX_RECALL_LINES) THEN                     BEGIN :                        Initial_String_Desc.DSC$W_Length :=2                           Initial_String.CAPACITY;6                        Istat := SMG$Return_Input_Line(5                           keyboard_id := Keyboard_Id, G                           resultant_string := %REF Initial_String_Desc, 9                           byte_integer_line_number := ii, E                           resultant_length := Initial_String.LENGTH);c?                        IF NOT ODD( Istat) THEN Lib$Stop( Istat)                      END                END          END    END;  { Recall_Line }c  P (******************************************************************************)    [GLOBAL]PROCEDURE Remove_User;      VAR'         Modified             : BOOLEAN; '         Save_Full            : BOOLEAN;d'         Save_Inuse           : BOOLEAN; (         Istat                : UNSIGNED;   BEGIN 4      Cli$Get_Value( 'USER', User.BODY, User.LENGTH);9      User_Name_Item_List[1].Buffer_Length := User.LENGTH; !      Set_Full_Item_List_For_Show; B      Istat := Get_User_Info( User_Name_Item_List, Full_Item_List);      IF NOT ODD( Istat) THEN2         { MAIL$_NOSUCHUSR = 8290346 (%X007E802A) }:         IF Istat <> MAIL$_NOSUCHUSR THEN Lib$Stop( Istat);      IF ODD( Istat) THEN
         BEGIN,3            Istat := Mail$User_Delete_Info( Context,E?                                            User_Name_Item_List,e;                                            Null_Item_List);*4            IF NOT ODD( Istat) THEN Lib$Stop( Istat);/            WRITELN( 'User ', User, ' removed'); K            WRITELN( '***************************************************');lF            WRITELN( 'User ', User, ' had the following information:');,            Save_Full := Show_Full_Qualifier;.            Save_Inuse := Show_Inuse_Qualifier;'            Show_Full_Qualifier := TRUE;*)            Show_Inuse_Qualifier := FALSE;R            Display_User;,            Show_Full_Qualifier := Save_Full;.            Show_Inuse_Qualifier := Save_Inuse;J            WRITELN( '***************************************************')         ENDr	      ELSEf7         WRITELN( 'User ',User,' record does not exist')i   END;  { Remove_User }   P (******************************************************************************)*   PROCEDURE Set_Full_Item_List_For_Modify;   BEGINt<      Full_Item_List[FULL_USER].Buffer_Length := User.LENGTH;@      Full_Item_List[FULL_USER].Item_Code := MAIL$_USER_USERNAME;      IF Address_Modified THENE
         BEGIN:%            IF Address.LENGTH > 0 THENa               BEGIN N                  Full_Item_List[FULL_ADDRESS].Buffer_Length := Address.LENGTH;:                  Full_Item_List[FULL_ADDRESS].Item_Code :=-                     MAIL$_USER_SET_FORWARDING                END:            ELSE 7               Full_Item_List[FULL_ADDRESS].Item_Code :==-                  MAIL$_USER_SET_NO_FORWARDINGN         ENDt	      ELSEr=         Full_Item_List[FULL_ADDRESS].Item_Code := MAIL$_NOOP;       IF Directory_Modified THENe
         BEGIND'            IF Directory.LENGTH > 0 THEN                BEGINe@                  Full_Item_List[FULL_DIRECTORY].Buffer_Length :=%                     Directory.LENGTH;G<                  Full_Item_List[FULL_DIRECTORY].Item_Code :=0                     MAIL$_USER_SET_SUB_DIRECTORY               END             ELSES9               Full_Item_List[FULL_DIRECTORY].Item_Code :=T0                  MAIL$_USER_SET_NO_SUB_DIRECTORY         END.	      ELSE ?         Full_Item_List[FULL_DIRECTORY].Item_Code := MAIL$_NOOP;D      IF Personal_Modified THEN
         BEGINE&            IF Personal.LENGTH > 0 THEN               BEGINrP                  Full_Item_List[FULL_PERSONAL].Buffer_Length := Personal.LENGTH;;                  Full_Item_List[FULL_PERSONAL].Item_Code :=E0                     MAIL$_USER_SET_PERSONAL_NAME               ENDE            ELSE 8               Full_Item_List[FULL_PERSONAL].Item_Code :=0                  MAIL$_USER_SET_NO_PERSONAL_NAME         END 	      ELSE >         Full_Item_List[FULL_PERSONAL].Item_Code := MAIL$_NOOP;      IF Editor_Modified THEN
         BEGIN $            IF Editor.LENGTH > 0 THEN               BEGINEL                  Full_Item_List[FULL_EDITOR].Buffer_Length := Editor.LENGTH;O                  Full_Item_List[FULL_EDITOR].Item_Code := MAIL$_USER_SET_EDITOR                ENDa            ELSETO               Full_Item_List[FULL_EDITOR].Item_Code := MAIL$_USER_SET_NO_EDITOR          ENDd	      ELSEU<         Full_Item_List[FULL_EDITOR].Item_Code := MAIL$_NOOP;      IF Form_Modified THEN
         BEGINI"            IF Form.LENGTH > 0 THEN               BEGINLH                  Full_Item_List[FULL_FORM].Buffer_Length := Form.LENGTH;K                  Full_Item_List[FULL_FORM].Item_Code := MAIL$_USER_SET_FORM                END             ELSEfK               Full_Item_List[FULL_FORM].Item_Code := MAIL$_USER_SET_NO_FORM$         ENDS	      ELSE :         Full_Item_List[FULL_FORM].Item_Code := MAIL$_NOOP;      IF Queue_Modified THENo
         BEGINm#            IF Queue.LENGTH > 0 THENR               BEGINmJ                  Full_Item_List[FULL_QUEUE].Buffer_Length := Queue.LENGTH;M                  Full_Item_List[FULL_QUEUE].Item_Code := MAIL$_USER_SET_QUEUEs               ENDT            ELSEIM               Full_Item_List[FULL_QUEUE].Item_Code := MAIL$_USER_SET_NO_QUEUE          END=	      ELSE ;         Full_Item_List[FULL_QUEUE].Item_Code := MAIL$_NOOP;a      IF Messages_Modified THENN         Full_Item_List[FULL_MESSAGES].Item_Code := MAIL$_USER_SET_NEW_MESSAGES	      ELSEm>         Full_Item_List[FULL_MESSAGES].Item_Code := MAIL$_NOOP;      IF CC_Prompt_Modified THEN 
         BEGINn            IF CC_Prompt THEN9               Full_Item_List[FULL_CC_PROMPT].Item_Code :=1)                  MAIL$_USER_SET_CC_PROMPT             ELSE 9               Full_Item_List[FULL_CC_PROMPT].Item_Code :=d,                  MAIL$_USER_SET_NO_CC_PROMPT         ENDC	      ELSE,?         Full_Item_List[FULL_CC_PROMPT].Item_Code := MAIL$_NOOP;        IF Auto_Purge_Modified THEN
         BEGINn            IF Auto_Purge THEN :               Full_Item_List[FULL_AUTO_PURGE].Item_Code :=*                  MAIL$_USER_SET_AUTO_PURGE            ELSER:               Full_Item_List[FULL_AUTO_PURGE].Item_Code :=-                  MAIL$_USER_SET_NO_AUTO_PURGES         ENDd	      ELSE)@         Full_Item_List[FULL_AUTO_PURGE].Item_Code := MAIL$_NOOP;      IF Self_Send_Modified THEN 
         BEGINd            IF Self_Send THEN9               Full_Item_List[FULL_SELF_SEND].Item_Code :=')                  MAIL$_USER_SET_COPY_SEND             ELSEr9               Full_Item_List[FULL_SELF_SEND].Item_Code :==,                  MAIL$_USER_SET_NO_COPY_SEND         ENDm	      ELSE1?         Full_Item_List[FULL_SELF_SEND].Item_Code := MAIL$_NOOP;e       IF Self_Reply_Modified THEN
         BEGINr            IF Self_Reply THEN :               Full_Item_List[FULL_SELF_REPLY].Item_Code :=*                  MAIL$_USER_SET_COPY_REPLY            ELSEe:               Full_Item_List[FULL_SELF_REPLY].Item_Code :=-                  MAIL$_USER_SET_NO_COPY_REPLYT         ENDf	      ELSEo@         Full_Item_List[FULL_SELF_REPLY].Item_Code := MAIL$_NOOP;"      IF Self_Forward_Modified THEN
         BEGINS            IF Self_Forward THEN <               Full_Item_List[FULL_SELF_FORWARD].Item_Code :=,                  MAIL$_USER_SET_COPY_FORWARD            ELSE <               Full_Item_List[FULL_SELF_FORWARD].Item_Code :=/                  MAIL$_USER_SET_NO_COPY_FORWARD          ENDT	      ELSE B         Full_Item_List[FULL_SELF_FORWARD].Item_Code := MAIL$_NOOP;<      Full_Item_List[FULL_CREATE_IF].Item_Code := MAIL$_NOOP;)   END;  { Set_Full_Item_List_For_Modify }   P (******************************************************************************)(   PROCEDURE Set_Full_Item_List_For_Show;   BEGIN=P      Full_Item_List[FULL_USER].Item_Code          := MAIL$_USER_RETURN_USERNAME;K      Full_Item_List[FULL_ADDRESS].Item_Code       := MAIL$_USER_FORWARDING; N      Full_Item_List[FULL_DIRECTORY].Item_Code     := MAIL$_USER_SUB_DIRECTORY;N      Full_Item_List[FULL_PERSONAL].Item_Code      := MAIL$_USER_PERSONAL_NAME;G      Full_Item_List[FULL_EDITOR].Item_Code        := MAIL$_USER_EDITOR; E      Full_Item_List[FULL_FORM].Item_Code          := MAIL$_USER_FORM;$F      Full_Item_List[FULL_QUEUE].Item_Code         := MAIL$_USER_QUEUE;M      Full_Item_List[FULL_MESSAGES].Item_Code      := MAIL$_USER_NEW_MESSAGES; J      Full_Item_List[FULL_CC_PROMPT].Item_Code     := MAIL$_USER_CC_PROMPT;K      Full_Item_List[FULL_AUTO_PURGE].Item_Code    := MAIL$_USER_AUTO_PURGE; J      Full_Item_List[FULL_SELF_SEND].Item_Code     := MAIL$_USER_COPY_SEND;K      Full_Item_List[FULL_SELF_REPLY].Item_Code    := MAIL$_USER_COPY_REPLY;*M      Full_Item_List[FULL_SELF_FORWARD].Item_Code  := MAIL$_USER_COPY_FORWARD;G@      Full_Item_List[FULL_CREATE_IF].Item_Code     := MAIL$_NOOP;C      Full_Item_List[FULL_USER].Buffer_Length      := User.CAPACITY; F      Full_Item_List[FULL_ADDRESS].Buffer_Length   := Address.CAPACITY;H      Full_Item_List[FULL_DIRECTORY].Buffer_Length := Directory.CAPACITY;G      Full_Item_List[FULL_PERSONAL].Buffer_Length  := Personal.CAPACITY; E      Full_Item_List[FULL_EDITOR].Buffer_Length    := Editor.CAPACITY; C      Full_Item_List[FULL_FORM].Buffer_Length      := Form.CAPACITY;UD      Full_Item_List[FULL_QUEUE].Buffer_Length     := Queue.CAPACITY;'   END;  { Set_Full_Item_List_For_Show }   P (******************************************************************************)    PROCEDURE Set_Short_Item_List;   BEGIN P      Short_Item_List[SHORT_USER].Item_Code        := MAIL$_USER_RETURN_USERNAME;K      Short_Item_List[SHORT_ADDRESS].Item_Code     := MAIL$_USER_FORWARDING; C      Short_Item_List[SHORT_USER].Buffer_Length    := User.CAPACITY;_F      Short_Item_List[SHORT_ADDRESS].Buffer_Length := Address.CAPACITY;   END;  { Set_Short_Item_List }A  P (******************************************************************************)#   PROCEDURE Set_Up_Mail_Item_Lists;*   BEGIN*  =      User_Name_Item_List[1].Item_Code := MAIL$_USER_USERNAME; C      User_Name_Item_List[1].Buffer_Address := IADDRESS( User.BODY);:4      User_Name_Item_List[1].Return_length_addr := 0;8      User_Name_Item_List[2].Item_Code := MAIL$_NOSIGNAL;,      User_Name_Item_List[3].Terminator := 0;;      First_User_Item_List[1].Item_Code := MAIL$_USER_FIRST;o9      First_User_Item_List[2].Item_Code := MAIL$_NOSIGNAL; -      First_User_Item_List[3].Terminator := 0; 9      Next_User_Item_List[1].Item_Code := MAIL$_USER_NEXT; 8      Next_User_Item_List[2].Item_Code := MAIL$_NOSIGNAL;,      Next_User_Item_List[3].Terminator := 0;  L      Short_Item_List[SHORT_USER].Buffer_Address     := IADDRESS( User.BODY);K      Short_Item_List[SHORT_USER].Return_length_addr := IADDRESS( User_Len); 9      Short_Item_List[SHORT_ADDRESS].Buffer_Address     :=lP                                                         IADDRESS( Address.BODY);9      Short_Item_List[SHORT_ADDRESS].Return_length_addr :=iO                                                         IADDRESS( Address_Len); 7      Short_Item_List[SHORT_TERMINATOR].Terminator := 0;a  J      Full_Item_List[FULL_USER].Buffer_Address     := IADDRESS( User.BODY);I      Full_Item_List[FULL_USER].Return_length_addr := IADDRESS( User_Len);f  P      Full_Item_List[FULL_ADDRESS].Buffer_Address     := IADDRESS( Address.BODY);O      Full_Item_List[FULL_ADDRESS].Return_length_addr := IADDRESS( Address_Len);r  9      Full_Item_List[FULL_DIRECTORY].Buffer_Address     := O                                                      IADDRESS( Directory.BODY); 9      Full_Item_List[FULL_DIRECTORY].Return_length_addr := N                                                      IADDRESS( Directory_Len);  8      Full_Item_List[FULL_PERSONAL].Buffer_Address     :=N                                                      IADDRESS( Personal.BODY);8      Full_Item_List[FULL_PERSONAL].Return_length_addr :=M                                                      IADDRESS( Personal_Len);   N      Full_Item_List[FULL_EDITOR].Buffer_Address     := IADDRESS( Editor.BODY);M      Full_Item_List[FULL_EDITOR].Return_length_addr := IADDRESS( Editor_Len);   J      Full_Item_List[FULL_FORM].Buffer_Address     := IADDRESS( Form.BODY);I      Full_Item_List[FULL_FORM].Return_length_addr := IADDRESS( Form_Len);R  L      Full_Item_List[FULL_QUEUE].Buffer_Address     := IADDRESS( Queue.BODY);K      Full_Item_List[FULL_QUEUE].Return_length_addr := IADDRESS( Queue_Len);,  ;      Full_Item_List[FULL_MESSAGES].Buffer_Length      := 2;eM      Full_Item_List[FULL_MESSAGES].Buffer_Address     := IADDRESS( Messages);e;      Full_Item_List[FULL_MESSAGES].Return_length_addr := 0;H  <      Full_Item_List[FULL_CC_PROMPT].Buffer_Length      := 4;9      Full_Item_List[FULL_CC_PROMPT].Buffer_Address     := N                                                      IADDRESS( CC_Prompt_Val);<      Full_Item_List[FULL_CC_PROMPT].Return_length_addr := 0;  =      Full_Item_List[FULL_AUTO_PURGE].Buffer_Length      := 4; :      Full_Item_List[FULL_AUTO_PURGE].Buffer_Address     :=O                                                      IADDRESS( Auto_Purge_Val);D=      Full_Item_List[FULL_AUTO_PURGE].Return_length_addr := 0;e  <      Full_Item_List[FULL_SELF_SEND].Buffer_Length      := 4;9      Full_Item_List[FULL_SELF_SEND].Buffer_Address     :='N                                                      IADDRESS( Self_Send_Val);<      Full_Item_List[FULL_SELF_SEND].Return_length_addr := 0;  =      Full_Item_List[FULL_SELF_REPLY].Buffer_Length      := 4;C:      Full_Item_List[FULL_SELF_REPLY].Buffer_Address     :=O                                                      IADDRESS( Self_Reply_Val);e=      Full_Item_List[FULL_SELF_REPLY].Return_length_addr := 0;d  ?      Full_Item_List[FULL_SELF_FORWARD].Buffer_Length      := 4;s<      Full_Item_List[FULL_SELF_FORWARD].Buffer_Address     :=O                                                    IADDRESS( Self_Forward_Val);r?      Full_Item_List[FULL_SELF_FORWARD].Return_length_addr := 0;)  <      Full_Item_List[FULL_CREATE_IF].Buffer_Length      := 0;<      Full_Item_List[FULL_CREATE_IF].Buffer_Address     := 0;<      Full_Item_List[FULL_CREATE_IF].Return_length_addr := 0;  5      Full_Item_List[FULL_TERMINATOR].Terminator := 0;S"   END;  { Set_Up_Mail_Item_Lists }  P (******************************************************************************)   [GLOBAL]PROCEDURE Show_User;      VAR(         Istat                : UNSIGNED;   BEGIN       Check_Full_Or_Brief; D      IF (NOT Show_Full_Qualifier) AND (NOT Show_Brief_Qualifier) AND'         (NOT Show_Inuse_Qualifier) THENa%         Show_Inuse_Qualifier := TRUE; 4      Cli$Get_Value( 'USER', User.BODY, User.LENGTH);9      User_Name_Item_List[1].Buffer_Length := User.LENGTH;S!      IF Show_Brief_Qualifier THEN1
         BEGINLI            WRITELN( 'Username                       Forwarding address');LI            WRITELN( '--------                       ------------------');t            Set_Short_Item_List;oH            Istat := Get_User_Info( User_Name_Item_List, Short_Item_List)         ENDc	      ELSE 
         BEGINe'            Set_Full_Item_List_For_Show; G            Istat := Get_User_Info( User_Name_Item_List, Full_Item_List)          END;      IF NOT ODD( Istat) THEN2         { MAIL$_NOSUCHUSR = 8290346 (%X007E802A) }:         IF Istat <> MAIL$_NOSUCHUSR THEN Lib$Stop( Istat);      IF ODD( Istat) THEN;         IF Show_Full_Qualifier OR Show_Inuse_Qualifier THEN             Display_User          ELSEO            WRITELN( PAD( SUBSTR( User.BODY, 1, User.LENGTH), ' ', 31), Address) 	      ELSE 7         WRITELN( 'User ',User,' record does not exist')    END;  { Show_User }O  P (******************************************************************************)P (**************              Mainline code           **************************)P (******************************************************************************)     VAR=(      Istat                   : UNSIGNED; BEGINY2   Initial_String_Desc.DSC$B_Type := DSC$K_DTYPE_T;3   Initial_String_Desc.DSC$B_Class := DSC$K_CLASS_S;iF   Initial_String_Desc.DSC$A_Pointer := IADDRESS( Initial_String.BODY);   Create_SMG_Structures;=   Istat := Lib$Get_Foreign( resultant_string := Command.BODY,C@                             resultant_length := Command.LENGTH);+   IF NOT ODD( Istat) THEN Lib$Stop( Istat);_(   Foreign_Command_Len := Command.LENGTH;   Set_Up_Mail_Item_Lists;nE   Istat := Mail$User_Begin( Context, Null_Item_List, Null_Item_List); +   IF NOT ODD( Istat) THEN Lib$Stop( Istat);n   Status := SS$_NORMAL;    WHILE Status <> RMS$_EOF DO(
      BEGIN'         IF Foreign_Command_Len > 0 THENN            BEGIN&               Status := Cli$DCL_Parse(P                  %DESCR SUBSTR( Command.BODY, 1, Command.LENGTH), MAILUAF_TABLE,J                  %IMMED Lib$Get_Input, %IMMED Lib$Get_Input, 'MAILUAF> ');0               IF ODD( Status) THEN Cli$Dispatch;                Status := RMS$_EOF            END         ELSE            BEGIN&               Status := Cli$DCL_Parse()                  %IMMED 0, MAILUAF_TABLE,eL                  %IMMED MUAF_Get_Input, %IMMED MUAF_Get_Input, 'MAILUAF> ');/               IF ODD( Status) THEN Cli$DispatchI            END	      END; C   Istat := Mail$User_End( Context, Null_Item_List, Null_Item_List);0+   IF NOT ODD( Istat) THEN Lib$Stop( Istat);S   Delete_SMG_Structures  END.