  J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |              PERSONA              %%   \ @  *                %% |          verify.c  c2003          %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *?  *  Copyright (C) 1999, 2003 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */    #include "version.h" #pragma module verify VERSION   B #include <stdio.h>                   /* Standard IO definitions */G #include <descrip.h>                 /* Descriptor Definition Macros */ M #include <jpidef.h>                  /* Job/Process Information item codes */ < #include <lnmdef.h>                  /* logical name defs */9 #include <prvdef.h>                  /* Priv mask defs */  #include <psldef.h> F #include <ssdef.h>                   /* System Service return codes */A #include <string.h>                  /* currently for strlen() */ T #include <uaidef.h>                  /* User Authorization Information item codes */ #include "defs.h"    extern int  status;   > extern uint AuthPriv[2];             /* Image process privs */@ extern uint CurPriv[2];              /* current process privs */   extern short TimLen;   extern char CurTime[28];O extern char LnmEquiv[80];            /* result of successful lnm translation */ J extern char NewPrcDev[32];           /* device of target users location */L extern char NewPrcDir[80];           /* filepath of target users location */; extern char NewUser[13];             /* Target user name */ M extern char NewUserTrim[13];         /* string for new username w/o blanks */ O extern char OldPrcDev[32];           /* device of origination users location */ Q extern char OldPrcDir[80];           /* filepath of origination users location */ = extern char OldUser[16];             /* Invoking user name */   D extern struct ITEM LnmItem[3];       /* Itemlist for $TRNLNM info */D extern struct ITEM UaiItem[15];      /* Itemlist for $GETUIA info */    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm E  * Description: Check to see if the specified logical name is defined G  *              in the required table. If defined, copy the equivalence A  *              string to the global buffer 'LnmEquiv' and return H  *              SS$_NORMAL to caller. Else return status from SYS$TRNLNM  *              call to caller.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckLnm(int NameValue)  { H     char    LogName[16];              /* persona logging logical name */     char    LnmTable[32];        short   LnmEquivLen;     short   LnmTableLen;       int     LnmStat;  M     $DESCRIPTOR(Dsc_Lnm, LogName);     /* logical name for persona logging */ ?     $DESCRIPTOR(Dsc_TabNam, LnmTable); /* lnm table to check */   +     LnmItem[0].buf_size = sizeof(LnmTable); &     LnmItem[0].item_code = LNM$_TABLE;$     LnmItem[0].buf_addr = &LnmTable;&     LnmItem[0].buf_len = &LnmTableLen;+     LnmItem[1].buf_size = sizeof(LnmEquiv); '     LnmItem[1].item_code = LNM$_STRING; $     LnmItem[1].buf_addr = &LnmEquiv;&     LnmItem[1].buf_len = &LnmEquivLen;     LnmItem[2].buf_size = 0;     LnmItem[2].item_code = 0;        switch(NameValue) {          case PERSONA_MODE:'             strcpy(LnmTable,"LNM$JOB"); -             sprintf(LogName, "PERSONA_MODE");              break;         case PERSONA_LOG: 0             strcpy(LnmTable,"LNM$SYSTEM_TABLE");,             sprintf(LogName, "PERSONA_LOG");             break;     } /     Dsc_TabNam.dsc$w_length = strlen(LnmTable); +     Dsc_Lnm.dsc$w_length = strlen(LogName); @     LnmStat = sys$trnlnm(0, &Dsc_TabNam, &Dsc_Lnm, 0, &LnmItem);;     if(LnmStat == SS$_NORMAL) LnmEquiv[LnmEquivLen] = '\0';      return(LnmStat); }     N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: ChkPrivJ  * Description: Call LIB$GETJPI to see if we are running with the requiredL  *              privs. If so return SS$_NORMAL, else see if user can set theK  *              required privs from their current privs. If not, we have to F  *              return SS$_NOPRIV to indicate this image cannot be run)  *              due to insufficent privs.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ 
 int ChkPriv()  { 
 #ifdef ARF@     int EnabFlg = 1;               /* Enable flag for $SETPRV */     int CurrPriv[2] = 0;     int PrevPriv[2] = 0;     int PrivMask[2] = 0;     int PrivStat = 0;      short SetPrv = FALSE;   ?     PrivMask[0] = PRV$M_SYSPRV + PRV$M_DETACH + PRV$M_CMKRNL +  -                   PRV$M_SYSNAM + PRV$M_WORLD;   E     if((CurPriv[0] & PrivMask[0]) == PrivMask[0]) return(SS$_NORMAL); 
     else {4         if(CurPriv[0] & PRV$M_SETPRV) SetPrv = TRUE;     }        if(!SetPrv) { 8         if((AuthPriv[0] & PrivMask[0]) == PrivMask[0]) {'             CurPriv[0] |= PRV$M_SETPRV;              SetPrv = TRUE;	         }          else {,             if(AuthPriv[0] & PRV$M_SETPRV) {+                 CurPriv[0] |= PRV$M_SETPRV;                  SetPrv = TRUE;
             } 	         }      }   #     if(!SetPrv) return(SS$_NOPRIV); #     else CurPriv[0] |= PrivMask[0];   H         /* Set the required priv bits for this image. If returned statusB            is SS$_NOPRIV then we exit due to insufficient privs */  ;     PrivStat = sys$setprv(EnabFlg, &CurPriv, 0, &PrevPriv); 6     if(PrivStat != SS$_NORMAL) return(SS$_NOTALLPRIV);     return(SS$_NORMAL);  #else      int enabflg = 1;     int prmflg = 0;      int PrvStat;     int PrivMask1 = 0;     int PrivMask2 = 0;     int ProcPriv[2] = 0;   @     struct  {short len, code; int *bufadr, *retlen;} JpiItem[2];   &     JpiItem[0].len = sizeof(ProcPriv);$     JpiItem[0].code = JPI$_PROCPRIV;"     JpiItem[0].bufadr = &ProcPriv;     JpiItem[0].retlen = 0;     JpiItem[1].len = 0;      JpiItem[1].code = 0;   I     PrivMask2 = PRV$M_CMKRNL + PRV$M_DETACH + PRV$M_SYSPRV + PRV$M_WORLD;      PrivMask1 |= PRV$M_SETPRV;   6     PrvStat = sys$getjpiw(0, 0, 0, &JpiItem, 0, 0, 0);,     if(PrvStat != SS$_NORMAL) exit(PrvStat);B     if((ProcPriv[0] & PrivMask2) == PrivMask2) return(SS$_NORMAL);!     if(PrivMask1 & ProcPriv[0]) { !         ProcPriv[0] |= PrivMask2; <         PrvStat = sys$setprv(enabflg, &ProcPriv, prmflg, 0);         return(PrvStat);     }      return(SS$_NOPRIV);  #endif }     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetCurTime C  * Description: Get current date and time as ascii string and place F  *              resultant string in global buffer 'CurTime'. Strip offE  *              hundreds of seconds. This used for logging if enabled   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void GetCurTime()  {      int cvtflg = 0;        char *ptr2 = 0;   #     $DESCRIPTOR(Dsc_Time, CurTime);   8     status = sys$asctim(&TimLen, &Dsc_Time, 0, &cvtflg);     if(status == SS$_NORMAL) {$         ptr2 = strchr(CurTime, '.');         if(ptr2) *ptr2 = '\0';     }  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: GetOlduserEnv()C  * Description: Get the current SYS$DISK dirpath definition for the E  *              originating user. This is not necessarily same as the H  *              SYS$LOGIN location. Needed when persona process is done.G  *              (You may note this looks much like SetTargetDir() code.   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int GetOlduserEnv()  {      int     attrib = 0;      short   StringLen;     short   User = 0; %     char    LogName[] = {"SYS$DISK"}; )     char    LnmTable[] = {"LNM$PROCESS"};   O     $DESCRIPTOR(Dsc_Lnm, LogName);       /* logical name for persona logging */ A     $DESCRIPTOR(Dsc_Table, LnmTable);    /* lnm table to check */ E     $DESCRIPTOR(Dsc_DevO, OldPrcDev);    /* original sys$disk name */ A     $DESCRIPTOR(Dsc_DirO, OldPrcDir);    /* original directory */   ,     LnmItem[0].buf_size = strlen(OldPrcDev);%     LnmItem[0].buf_addr = &OldPrcDev; '     LnmItem[0].item_code = LNM$_STRING;      LnmItem[0].buf_len = 0;      LnmItem[1].buf_size = 0;     LnmItem[1].item_code = 0;   E         /* get the logical name for the current value of SYS$DISK and C            save devicename in OldPrcDev/NewPrcDev as appropriate */   I     status = lib$get_logical(&Dsc_Lnm, &Dsc_DevO, &StringLen, &Dsc_Table, )                              0, 0, 0, 0); !     if(!status & 1) exit(status);      OldPrcDev[StringLen] = 0;   3     status = sys$setddir(0, &StringLen, &Dsc_DirO); "     if(!status & 1) exit(status);      OldPrcDir[StringLen] = 0;        return(status);  }       L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckIdent E  * Description: Reads the rights database to verify invoking user has G  *              appropriate identifier granted to assume the persona of A  *              the target user. If not, return SS$_NOSUCHID else <  *              if proper identifier then return SS$_NORMAL.  *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckIdent() {      char Name[31];     char TargIdentStr[31];       int HolderBin[2];      int TargIdentBin;      int HeldBin, context = 0;        short count = 0;        $DESCRIPTOR(Dsc_Name, Name);(     $DESCRIPTOR(Dsc_Pers, TargIdentStr);  <         /* get invoking username, convert to binary value */       strcpy(Name, OldUser);)     Dsc_Name.dsc$w_length = strlen(Name); 5     status = sys$asctoid ( &Dsc_Name, &HolderBin, 0); '     if(!(status & 1)) lib$stop(status);   7         /* get target username, prefix with PERS_, then @            convert identifier str to binary identeifier value */  2     sprintf(TargIdentStr, "PERS_%s", NewUserTrim);1     Dsc_Pers.dsc$w_length = strlen(TargIdentStr); 6     status = sys$asctoid(&Dsc_Pers, &TargIdentBin, 0);C     if(!(status & 1)) return(status);   /* probably SS$_NOSUCHID */   :         /* Make repeated calls to SYS$FIND_HELD to return 6            all identifiers held by holder (OldUser) */  ?     HolderBin[1] = 0;        /* complete the quadword holder */ !     while(status == SS$_NORMAL) { B         status = sys$find_held(&HolderBin, &HeldBin, 0, &context);"         if(status == SS$_NORMAL) {)             if(HeldBin == TargIdentBin) { P                 status = sys$finish_rdb(&context); /* rights database context */#                 return(SS$_NORMAL); 
             }              else count++; 	         } >         if((status == SS$_NOSUCHID) && !count) return(status);     } B     return(status);     /* probably SS$_NOSUCHID with count > 0 */ }     J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: SetTargetDir B  * Description: Overcome more perceived shortcomings of SYS$CREPRCG  *              using a subprocess. Modify PROCESS table so the logical J  *              SYS$DISK and the default dir reflect the login path which H  *              is defined in the SYSAUF.DAT record for the target user.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int SetTargetDir(int UserType) {       int     acmode = PSL$C_EXEC;     int     attrib = 0;      short   StringLen;     short   User = 0; %     char    LogName[] = {"SYS$DISK"}; )     char    LnmTable[] = {"LNM$PROCESS"};   O     $DESCRIPTOR(Dsc_Lnm, LogName);       /* logical name for persona logging */ A     $DESCRIPTOR(Dsc_Table, LnmTable);    /* lnm table to check */ @     $DESCRIPTOR(Dsc_DevO, OldPrcDev);    /* old sys$disk name */@     $DESCRIPTOR(Dsc_DevN, NewPrcDev);    /* new sys$disk name */A     $DESCRIPTOR(Dsc_DirO, OldPrcDir);    /* original directory */ C     $DESCRIPTOR(Dsc_DirN, NewPrcDir);    /* new target directory */        if(UserType == OLDUSER) { 0         LnmItem[0].buf_size = strlen(OldPrcDev);)         LnmItem[0].buf_addr = &OldPrcDev;      }      else {      /* NEWUSER */ 0         LnmItem[0].buf_size = strlen(NewPrcDev);)         LnmItem[0].buf_addr = &NewPrcDev;      } '     LnmItem[0].item_code = LNM$_STRING;      LnmItem[0].buf_len = 0;      LnmItem[1].buf_size = 0;     LnmItem[1].item_code = 0;        E         /* get the logical name for the current value of SYS$DISK and C            save devicename in OldPrcDev/NewPrcDev as appropriate */        if(UserType == OLDUSER) { M         status = lib$get_logical(&Dsc_Lnm, &Dsc_DevO, &StringLen, &Dsc_Table, -                                  0, 0, 0, 0); %         if(!status & 1) exit(status); !         OldPrcDev[StringLen] = 0;      }      else {      /* NEWUSER */ M         status = lib$get_logical(&Dsc_Lnm, &Dsc_DevN, &StringLen, &Dsc_Table, -                                  0, 0, 0, 0); %         if(!status & 1) exit(status); !         NewPrcDev[StringLen] = 0;      }   +     if(strcmp(OldPrcDev, NewPrcDev) != 0) { !         if(UserType == OLDUSER) { 4             LnmItem[0].buf_size = strlen(OldPrcDev);-             LnmItem[0].buf_addr = &OldPrcDev; 	         } !         else {      /* NEWUSER */ 4             LnmItem[0].buf_size = strlen(NewPrcDev);-             LnmItem[0].buf_addr = &NewPrcDev; 	         } N         status = sys$crelnm(&attrib, &Dsc_Table, &Dsc_Lnm, &acmode, &LnmItem);%         if(!status & 1) exit(status);      }      if(UserType == OLDUSER) { 2         Dsc_DirO.dsc$w_length = strlen(OldPrcDir);.         status = sys$setddir(&Dsc_DirO, 0, 0);&         if(!status & 1) exit(status);      }      else {      /* NEWUSER */ 2         Dsc_DirN.dsc$w_length = strlen(NewPrcDir);?         status = sys$setddir(&Dsc_DirN, &StringLen, &Dsc_DirO); &         if(!status & 1) exit(status); !         OldPrcDir[StringLen] = 0;      }      return(status);  }       J /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: SetJobEnvB  * Description: Overcome some perceived shortcomings of SYS$CREPRCD  *              using a subprocess. Modify JOB table so the logicalsG  *              SYS$LOGIN and SYS$SCRATCH reflect the login path which  K  *              is defined in the SYSAUF.DAT record for the argument 'User'   *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int SetJobEnv(char *User)  {       int     acmode = PSL$C_EXEC;     int     attrib = 0;      short   DevLen;      short   DirLen;      short   DirOLen;     char    LogName[32];     char    LnmTable[32];      char    DeviceName[32];      char    DirName[64];     char    LoginPath[80];(     char    Process[] = {"LNM$PROCESS"};%     char    SysDisk[] = {"SYS$DISK"};      char    *ptr1 = 0;     char    *ptr2 = 0;  O     $DESCRIPTOR(Dsc_Lnm, LogName);       /* logical name for persona logging */ A     $DESCRIPTOR(Dsc_Table, LnmTable);    /* lnm table to check */ A     $DESCRIPTOR(Dsc_User, User);         /* username to modify */        ptr1 = strchr(User, ' ');      if(ptr1) *ptr1 = 0; )     Dsc_User.dsc$w_length = strlen(User);      -     UaiItem[0].buf_size = sizeof(DeviceName); '     UaiItem[0].item_code = UAI$_DEFDEV; &     UaiItem[0].buf_addr = &DeviceName;     UaiItem[0].buf_len  = 0;*     UaiItem[1].buf_size = sizeof(DirName);'     UaiItem[1].item_code = UAI$_DEFDIR;*#     UaiItem[1].buf_addr = &DirName;*     UaiItem[1].buf_len  = 0;     UaiItem[2].buf_size = 0;     UaiItem[2].item_code = 0;   <     status = sys$getuai(0, 0, &Dsc_User, &UaiItem, 0, 0, 0);*     if(status != SS$_NORMAL) exit(status);       DevLen = DeviceName[0];      DeviceName[DevLen + 1] = 0;      DirLen = DirName[0];     DirName[DirLen + 1] = 0;<     sprintf(LoginPath, "%s%s", DeviceName + 1, DirName + 1);  ,     LnmItem[0].buf_size = strlen(LoginPath);'     LnmItem[0].item_code = LNM$_STRING; %     LnmItem[0].buf_addr = &LoginPath;%     LnmItem[0].buf_len = 0;      LnmItem[1].buf_size = 0;     LnmItem[1].item_code = 0;   !     strcpy(LogName, "SYS$LOGIN"); +     Dsc_Lnm.dsc$w_length = strlen(LogName);       strcpy(LnmTable, "LNM$JOB");.     Dsc_Table.dsc$w_length = strlen(LnmTable);  J     status = sys$crelnm(&attrib, &Dsc_Table, &Dsc_Lnm, &acmode, &LnmItem);J     if(!status & 1) exit(status); /* if not SS$_NORMAL or SS$_SUPERCEDE */  #     strcpy(LogName, "SYS$SCRATCH"); +     Dsc_Lnm.dsc$w_length = strlen(LogName);n  J     status = sys$crelnm(&attrib, &Dsc_Table, &Dsc_Lnm, &acmode, &LnmItem);J     if(!status & 1) exit(status); /* if not SS$_NORMAL or SS$_SUPERCEDE */       ptr1 = &DeviceName[1];     ptr2 = &DirName[1];*     strcpy(NewPrcDev, ptr1);     strcpy(NewPrcDir, ptr2);       return(status);m }o  