9 /* Copyright (C) 1988-1991 Free Software Foundation, Inc.  This file is part of GNU Make.  @ GNU Make is free software; you can redistribute it and/or modifyD it under the terms of the GNU General Public License as published byC the Free Software Foundation; either version 1, or (at your option)  any later version.  ; GNU Make is distributed in the hope that it will be useful, > but WITHOUT ANY WARRANTY; without even the implied warranty of= MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the , GNU General Public License for more details.  A You should have received a copy of the GNU General Public License < along with GNU Make; see the file COPYING.  If not, write toI the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */    #include "make.h"  #include "commands.h"  #include "job.h" #include "dep.h" #include "file.h"    #ifndef USG  #ifndef	sgi  #include <sys/file.h>  #endif #else  #include <fcntl.h> #endif    8 #if	!defined(__GNU_LIBRARY__) && !defined(_POSIX_SOURCE) extern int fstat (); extern time_t time (); #endif    extern int try_implicit_rule ();    / /* Incremented when a file has been remade.  */ % static unsigned int files_remade = 0;   : static int update_file (), update_file_1 (), check_dep (); static void remake_file (); 3 static time_t name_mtime (), library_file_mtime ();  extern time_t f_mtime ();       N /* Remake all the goals in the `struct dep' chain GOALS.  Return -1 if nothingM    was done, 0 if all goals were updated successfully, or 1 if a goal failed. O    If MAKEFILES is nonzero, these goals are makefiles, so -t, -q, and -n should J    be disabled for them unless they were also command-line targets, and weK    should only make one goal at a time and return as soon as one goal whose 8    `changed' member is nonzero is successfully made.  */   int $ update_goal_chain (goals, makefiles)       register struct dep *goals;      int makefiles;  { =   int t = touch_flag, q = question_flag, n = just_print_flag;    unsigned int j = job_slots;    int status = -1;  > #define	MTIME(file) (makefiles ? file_mtime_no_search (file) \ 		     : file_mtime (file))   =   /* Duplicate the chain so we can remove things from it.  */   !   goals = copy_dep_chain (goals);      if (makefiles)&     /* Only run one job at a time.  */     job_slots = 1;  :   /* Update all the goals until they are all finished.  */     while (goals != 0)     { (       register struct dep *g, *lastgoal;  %       /* Wait for a child to die.  */          wait_for_children (1, 0);          lastgoal = 0;        g = goals;       while (g != 0) 	{	 	  int x; " 	  time_t mtime = MTIME (g->file); 	  check_renamed (g->file);    	  if (makefiles)  	    { 	      if (g->file->cmd_target)  		{  		  touch_flag = t;  		  question_flag = q; 		  just_print_flag = n; 		}  	      else 3 		touch_flag = question_flag = just_print_flag = 0;  	    }  0 	  x = update_file (g->file, makefiles ? 1 : 0); 	  check_renamed (g->file); " 	  if (x != 0 || g->file->updated) 	    { 	      int stop = 0;5 	      /* If STATUS was not already 1, set it to 1 if 2 		 updating failed, or to 0 if updating succeeded.5 		 Leave STATUS as it is if no updating was done.  */  	      if (status < 1) 		{ $ 		  if (g->file->update_status != 0) 		    {  		      /* Updating failed.  */  		      status = 1; . 		      stop = !keep_going_flag && !makefiles; 		    } & 		  else if (MTIME (g->file) != mtime) 		    {  		      /* Updating was done. 0 			 If this is a makefile and just_print_flag or4 			 question_flag is set (meaning -n or -q was given: 			 and this file was specified as a command-line target),7 			 don't change STATUS.  If STATUS is changed, we will 6 			 get re-exec'd, and fall into an infinite loop.  */? 		      if (!makefiles || (!just_print_flag && !question_flag))  			status = 0;+ 		      if (makefiles && g->file->dontcare) 5 			/* This is a default makefile.  Stop remaking.  */  			stop = 1; 		    }  		}   ? 	      /* This goal is finished.  Remove it from the chain.  */  	      if (lastgoal == 0)  		goals = g->next; 	      else  		lastgoal->next = g->next;    	      /* Free the storage.  */  	      free ((char *) g);   2 	      g = lastgoal == 0 ? goals : lastgoal->next;   	      if (stop) 		break; 	    } 	  else  	    { 	      lastgoal = g; 	      g = g->next;  	    } 	}     }      if (makefiles)     {        touch_flag = t;        question_flag = q;       just_print_flag = n;       job_slots = j;     }      return status; }                                                           : /* If FILE is not up to date, execute the commands for it.-    Return 0 if successful, 1 if unsuccessful; A    but with some flag settings, just call `exit' if unsuccessful.   5    DEPTH is the depth in recursions of this function. @    We increment it during the consideration of our dependencies,>    then decrement it again after finding out whether this file    is out of date.  7    If there are multiple double-colon entries for FILE, "    each is considered in turn.  */  
 static int update_file (file, depth)       struct file *file;       unsigned int depth; {    register int status = 0;   register struct file *f;,   unsigned int ofiles_remade = files_remade;   int commands_finished = 0;  %   for (f = file; f != 0; f = f->prev)      { <       char not_started = f->command_state == cs_not_started;)       status |= update_file_1 (f, depth);        check_renamed (f);*       if (status != 0 && !keep_going_flag) 	return status; J       commands_finished |= not_started && f->command_state == cs_finished;     }   L   /* For a top level target, if we have found nothing whatever to do for it,4      print a message saying nothing needs doing.  */  2   if (status == 0 && files_remade == ofiles_remadeK       && commands_finished && depth == 0 && !silent_flag && !question_flag)      { )       if (file->phony || file->cmds == 0) 6 	message ("Nothing to be done for `%s'.", file->name);
       else- 	message ("`%s' is up to date.", file->name);        fflush (stdout);     }      return status; }                           D /* Consider a single `struct file' and update it as appropriate.  */  
 static int update_file_1 (file, depth)       struct file *file;       unsigned int depth; {    register time_t this_mtime; '   int noexist, must_make, deps_changed;    int dep_status = 0; !   register struct dep *d, *lastd;    char running = 0;   .   DEBUGPR ("Considering target file `%s'.\n");     if (file->updated)     { "       if (file->update_status > 0) 	{@ 	  DEBUGPR ("Recently tried and failed to update file `%s'.\n"); 	  return file->update_status; 	}  6       DEBUGPR ("File `%s' was considered already.\n");       return 0;      }      switch (file->command_state)     {      case cs_not_started:     case cs_deps_running:        break;     case cs_running:.       DEBUGPR ("Still updating file `%s'.\n");       return 0;      case cs_finished: 1       DEBUGPR ("Finished updating file `%s'.\n"); !       return file->update_status;      default:       abort ();      }   
   ++depth;  2   /* Notice recursive update of the same file.  */   file->updating = 1;   D   /* Looking at the file's modtime beforehand allows the possibilityD      that its name may be changed by a VPATH search, and thus it may@      not need an implicit rule.  If this were not done, the fileE      might get implicit commands that apply to its initial name, only G      to have that name replaced with another found by VPATH search.  */   !   this_mtime = file_mtime (file);    check_renamed (file); &   noexist = this_mtime == (time_t) -1;   if (noexist),     DEBUGPR ("File `%s' does not exist.\n");     must_make = noexist;  8   /* If file was specified as a target with no commands,,      come up with some default commands.  */  ?   if (!file->phony && file->cmds == 0 && !file->tried_implicit)      { *       if (try_implicit_rule (file, depth))0 	DEBUGPR ("Found an implicit rule for `%s'.\n");
       else 	{2 	  DEBUGPR ("No implicit rule found for `%s'.\n");4 	  if (default_file != 0 && default_file->cmds != 0) 	    {6 	      DEBUGPR ("Using default commands for `%s'.\n");' 	      file->cmds = default_file->cmds;s 	    } 	  file->also_make = 0;a 	}       file->tried_implicit = 1;h     }e  B   /* Update all non-intermediate files we depend on, if necessary,C      and see whether any of them is more recent than this file.  */i     lastd = 0;   d = file->deps;i   while (d != 0)     {U       time_t mtime;u  #       mtime = file_mtime (d->file);T       check_renamed (d->file);         if (d->file->updating) 	{2 	  error ("Circular %s <- %s dependency dropped.", 		 file->name, d->file->name); 	  if (lastd == 0) 	    { 	      file->deps = d->next; 	      free ((char *) d);  	      d = file->deps; 	    } 	  elsea 	    { 	      lastd->next = d->next;e 	      free ((char *) d);n 	      d = lastd->next;  	    } 	  continue; 	}         d->file->parent = file;eG       dep_status |= check_dep (d->file, depth, this_mtime, &must_make);f       check_renamed (d->file);  6       running |= (d->file->command_state == cs_running2 		  || d->file->command_state == cs_deps_running);  .       if (dep_status != 0 && !keep_going_flag) 	break;          if (!running)n, 	d->changed = file_mtime (d->file) != mtime;         lastd = d;       d = d->next;     }i  4   /* Now we know whether this target needs updating.D      If it does, update all the intermediate files we depend on.  */     if (must_make)     {h/       for (d = file->deps; d != 0; d = d->next)i 	if (d->file->intermediate)e 	  {) 	    time_t mtime = file_mtime (d->file);  	    check_renamed (d->file);e 	    d->file->parent = file;0 	    dep_status |= update_file (d->file, depth); 	    check_renamed (d->file);   5 	    running |= (d->file->command_state == cs_runnings1 			|| d->file->command_state == cs_deps_running);   - 	    if (dep_status != 0 && !keep_going_flag) 
 	      break;e   	    if (!running)5 	      d->changed = ((file->phony && file->cmds != 0)c) 			    || file_mtime (d->file) != mtime);l 	  }     }n     file->updating = 0;   ;   DEBUGPR ("Finished dependencies of target file `%s'.\n");_  /   /* If any dependency failed, give up now.  */      if (dep_status != 0)     {n(       file->command_state = cs_finished;'       file->update_status = dep_status;e       file->updated = 1;         depth--;  3       DEBUGPR ("Giving up on target file `%s'.\n");h  '       if (depth == 0 && keep_going_flag!) 	  && !just_print_flag && !question_flag) A 	error ("Target `%s' not remade because of errors.", file->name);f         return dep_status;     }o     if (running)     {;,       file->command_state = cs_deps_running;       --depth;=       DEBUGPR ("The dependencies of `%s' are being made.\n");        return 0;i     }i  '   file->command_state = cs_not_started;   +   /* Now record which dependencies are more 4      recent than this file, so we can define $?.  */     deps_changed = 0; +   for (d = file->deps; d != 0; d = d->next)l     {:,       time_t d_mtime = file_mtime (d->file);       check_renamed (d->file);  9 #if 1	/* %%% In version 4, remove this code completely to,7 	   implement not remaking deps if their deps are newer  	   than their parents.  */s;       if (d_mtime == (time_t) -1 && !d->file->intermediate) ' 	/* We must remake if this dep does not)& 	   exist and is not intermediate.  */ 	must_make = 1;t #endif  ;       /* Set DEPS_CHANGED if this dep actually changed.  */ !       deps_changed |= d->changed;   <       /* Set D->changed if either this dep actually changed,9 	 or its dependent, FILE, is older or does not exist.  */n4       d->changed |= noexist || d_mtime > this_mtime;  !       if (debug_flag && !noexist)  	{ 	  print_spaces (depth); 	  if (d_mtime == (time_t) -1)@ 	    printf ("Dependency `%s' does not exist.\n", dep_name (d)); 	  elsep< 	    printf ("Dependency `%s' is %s than dependent `%s'.\n",@ 		    dep_name (d), d->changed ? "newer" : "older", file->name); 	  fflush (stdout);  	}     };  D   /* Here depth returns to the value it had when we were called.  */
   depth--;  ,   if (file->double_colon && file->deps == 0)     {        must_make = 1;I       DEBUGPR ("Target `%s' is double-colon and has no dependencies.\n");)     } ?   else if (file->is_target && !deps_changed && file->cmds == 0)o     {r       must_make = 0;O       DEBUGPR ("No commands for `%s' and no dependencies actually changed.\n");(     }e     if (!must_make)c     {=3       DEBUGPR ("No need to remake target `%s'.\n"); (       file->command_state = cs_finished;       file->update_status = 0;       file->updated = 1;       return 0;      }I  )   DEBUGPR ("Must remake target `%s'.\n");r  :   /* Now, take appropriate actions to remake the file.  */   remake_file (file);   )   if (file->command_state != cs_finished)H     { 4       DEBUGPR ("Commands of `%s' are being run.\n");       return 0;o     }t     switch (file->update_status)     {n     case 1:t7       DEBUGPR ("Failed to remake target file `%s'.\n");        break;     case 0:l:       DEBUGPR ("Successfully remade target file `%s'.\n");       break;     case -1:H       error ("internal error: `%s' update_status is -1 at cs_finished!", 	     file->name);       abort ();r     default:H       error ("internal error: `%s' update_status invalid!", file->name);       abort ();=     }f     file->updated = 1;   return file->update_status;f }o                                          C /* Set FILE's `updated' flag and re-check its mtime and the mtime's(5    of all files listed in its `also_make' member.  */    void notice_finished_file (file)        register struct file *file; {    file->updated = 1;     ++files_remade;v     if (!file->phony)r     {f*       if (just_print_flag || question_flag+ 	  || (file->is_target && file->cmds == 0))s( 	file->last_mtime = time ((time_t *) 0);
       else 	file->last_mtime = 0;     }      if (file->also_make != 0)      {e       register unsigned int i;/       for (i = 0; file->also_make[i] != 0; ++i)e 	{= 	  register struct file *f = enter_file (file->also_make[i]);  	  f->updated = 1;* 	  f->update_status = file->update_status;( 	  if (just_print_flag || question_flag)& 	    f->last_mtime = file->last_mtime; 	  elsec 	    f->last_mtime = 0;, 	}     }  }s                                                  9 /* Check whether another file (whose mtime is THIS_MTIME)e@    needs updating on account of a dependency which is file FILE.)    If it does, store 1 in *MUST_MAKE_PTR."4    In the process, update any non-intermediate files0    that FILE depends on (including FILE itself).-    Return nonzero if any updating failed.  */p  
 static int2 check_dep (file, depth, this_mtime, must_make_ptr)      struct file *file;o      unsigned int depth;      time_t this_mtime;       int *must_make_ptr; {)   register struct dep *d;t   int dep_status = 0;s  
   ++depth;   file->updating = 1;_     if (!file->intermediate)?     /* If this is a non-intermediate file, update it and recordd/        whether it is newer than THIS_MTIME.  */n     {        time_t mtime;t-       dep_status = update_file (file, depth);        check_renamed (file);c        mtime = file_mtime (file);       check_renamed (file); 5       if (mtime == (time_t) -1 || mtime > this_mtime)s 	*must_make_ptr = 1;     }t   else     {h&       /* FILE is an intermediate file.? 	 Update all non-intermediate files we depend on, if necessary,e: 	 and see whether any of them is more recent than the file& 	 on whose behalf we are checking.  */!       register struct dep *lastd;e       lastd = 0;       d = file->deps;f       while (d != 0) 	{ 	  if (d->file->updating)i 	    {6 	      error ("Circular %s <- %s dependency dropped."," 		     file->name, d->file->name); 	      if (lastd == 0) 		{e 		  file->deps = d->next;c 		  free ((char *) d); 		  d = file->deps;a 		}  	      elsef 		{p 		  lastd->next = d->next; 		  free ((char *) d); 		  d = lastd->next; 		}c 	      continue; 	    }   	  d->file->parent = file;G 	  dep_status |= check_dep (d->file, depth, this_mtime, must_make_ptr);  	  check_renamed (d->file);l+ 	  if (dep_status != 0 && !keep_going_flag)  	    break;(  
 	  lastd = d;m 	  d = d->next;" 	}     }f     file->updating = 0;>   return dep_status; }a                            > /* Touch FILE.  Return zero if successful, nonzero if not.  */  I #define TOUCH_ERROR(call) return (perror_with_name (call, file->name), 1)o  
 static int touch_file (file)        register struct file *file; {h   if (!silent_flag)      {i(       printf ("touch %s\n", file->name);       fflush (stdout);     }    #ifndef	NO_ARCHIVES(   if (ar_name (file->name))r!     return ar_touch (file->name);r   else #endif     {,9       int fd = open (file->name, O_RDWR | O_CREAT, 0666);d         if (fd < 0)  	TOUCH_ERROR ("touch: open: ");f
       else 	{ 	  struct stat statbuf;  	  char buf;    	  if (fstat (fd, &statbuf) < 0)$ 	    TOUCH_ERROR ("touch: fstat: ");4 	  /* Rewrite character 0 same as it already is.  */ 	  if (read (fd, &buf, 1) < 0)# 	    TOUCH_ERROR ("touch: read: ");) 	  if (lseek (fd, 0L, 0) < 0L)$ 	    TOUCH_ERROR ("touch: lseek: "); 	  if (write (fd, &buf, 1) < 0)>$ 	    TOUCH_ERROR ("touch: write: ");# 	  /* If file length was 0, we juste( 	     changed it, so change it back.  */ 	  if (statbuf.st_size == 0) 	    { 	      (void) close (fd);t6 	      fd = open (file->name, O_RDWR | O_TRUNC, 0666); 	      if (fd < 0)  		TOUCH_ERROR ("touch: open: "); 	    } 	  (void) close (fd);s 	}     }o     return 0;( }t              7 /* Having checked and updated the dependencies of FILE,d4    do whatever is appropriate to remake FILE itself.8    Return the status from executing FILE's commands.  */   static void= remake_file (file)      struct file *file;l {d   if (file->cmds == 0)     {f       if (file->phony), 	/* Phony target.  Pretend it succeeded.  */ 	file->update_status = 0;        else if (file->is_target)p5 	/* This is a nonexistent target file we cannot make. + 	   Pretend it was successfully remade.  */> 	file->update_status = 0; 
       else 	{< 	  /* This is a dependency file we cannot remake.  Fail.  */5 	  static char noway[] = "*** No way to make target";e) 	  if (keep_going_flag || file->dontcare)e 	    { 	      if (!file->dontcare)t( 		error ("%s `%s'.", noway, file->name);   	      file->update_status = 1; 	    } 	  elset* 	    fatal ("%s `%s'", noway, file->name); 	}     }    else     {i!       chop_commands (file->cmds);   1       if (touch_flag && !file->cmds->any_recurse)s 	{ 	  if (file->phony)_ 	    file->update_status = 0;t 	  elseeD 	    /* Should set file's modification date and do nothing else.  */- 	    file->update_status = touch_file (file);t 	}
       else 	{  	  execute_file_commands (file);
 	  return; 	}     }%  $   file->command_state = cs_finished;   notice_finished_file (file); }               5 /* Return the mtime of a file, given a `struct file'. N    Caches the time in the struct file to avoid excess stat calls.  If the fileJ    is not found, and SEARCH is nonzero, VPATH searching and replacement isI    done.  If that fails, a library (-lLIBNAME) is tried but the library'soJ    actual name (/lib/libLIBNAME.a, etc.) is not substituted into FILE.  */   time_t f_mtime (file, search)       register struct file *file;      int search; {>   register time_t mtime;  @   /* File's mtime is not known; must get it from the system.  */   #ifndef	NO_ARCHIVES1   if (ar_name (file->name))P     {E6       /* This file is an archive-member reference.  */         char *arname, *memname;D       struct file *arfile;       int arname_used = 0;  %       /* Find the archive's name.  */i4       ar_parse_name (file->name, &arname, &memname);  :       /* Find the modification time of the archive itself.= 	 Also allow for its name to be changed via VPATH search.  */e$       arfile = lookup_file (arname);       if (arfile == 0) 	{  	  arfile = enter_file (arname); 	  arname_used = 1;  	}'       mtime = f_mtime (arfile, search);l       check_renamed (arfile);s2       if (search && strcmp (arfile->name, arname)) 	{% 	  /* The archive's name has changed. : 	     Change the archive-member reference accordingly.  */   	  unsigned int arlen, memlen;   	  if (!arname_used) 	    { 	      free (arname);e 	      arname_used = 1;l 	    }   	  arname = arfile->name;e 	  arlen = strlen (arname);r 	  memlen = strlen (memname);E   	  free (file->name);%  : 	  file->name = (char *) xmalloc (arlen + 1 + memlen + 2);% 	  bcopy (arname, file->name, arlen);" 	  file->name[arlen] = '(';.3 	  bcopy (memname, file->name + arlen + 1, memlen); ( 	  file->name[arlen + 1 + memlen] = ')';- 	  file->name[arlen + 1 + memlen + 1] = '\0';P 	}         if (!arname_used)) 	free (arname);a       free (memname);t         if (mtime == (time_t) -1)lF 	/* The archive doesn't exist, so it's members don't exist either.  */ 	return (time_t) -1;  *       mtime = ar_member_date (file->name);     }    else #endif     {s&       mtime = name_mtime (file->name);  )       if (mtime == (time_t) -1 && search)  	{- 	  /* If name_mtime failed, search VPATH.  */s 	  char *name = file->name;' 	  if (vpath_search (&name)) 	    {  	      rename_file (file, name); 	      check_renamed (file);! 	      mtime = name_mtime (name);b 	    } #ifndef VMS: 	  elser1 	    /* Last resort, is it a library (-lxxx)?  */ * 	    if (name[0] == '-' && name[1] == 'l')- 	      mtime = library_file_mtime (&name[2]);s #endif 	}     }   <   /* Store the mtime into all the entries for this file.  */     while (file != 0)h     {'       file->last_mtime = mtime;        file = file->prev;     }      return mtime;e }i    E /* Return the mtime of the file or archive-member reference NAME.  */e  
 static time_tf name_mtime (name)       register char *name;f {    struct stat st;      if (stat (name, &st) < 0)m     return (time_t) -1;t     return (time_t) st.st_mtime; }e    = /* Return the mtime of a library file specified as -lLIBNAME, J    searching for a suitable library file in the system library directories!    and the VPATH directories.  */f  
 static time_tl library_file_mtime (lib)      char *lib;; {    time_t mtime; 
   char *name;s  ,   name = concat ("/usr/lib/lib", lib, ".a");   mtime = name_mtime (name);   if (mtime == (time_t) -1)>"     mtime = name_mtime (name + 4);   if (mtime == (time_t) -1)      { >       char *local = concat ("/usr/local/lib/lib", lib,  ".a");!       mtime = name_mtime (local);o       free (local);i     }F   if (mtime == (time_t) -1)i"     mtime = name_mtime (name + 9);   if (mtime == (time_t) -1)e     {        char *newname = name + 9;g"       if (vpath_search (&newname)) 	{  	  mtime = name_mtime (newname); 	  free (newname); 	}     }s     free (name);     return mtime;i }*