 [  IDENT ( 'LCK V1.1' ) ,  
 INHERIT ( '     'sys$library:pascal$cli_routines' , '     'sys$library:pascal$lib_routines' ,      'sys$library:starlet' ,      'int:lck_declarations' ,     'int:lck_messages' ) ]  MODULE lck_routines ;     {  Marc Van Dyck, 15-MAR-2000 }     [ HIDDEN ] CONST       {+} $     { Basic stuff, internal use only     {-}   a     max_lck_id_width	    = 10 ;				{ number of digits of the largest possible unsigned longword } C     log_name_length	    = 255 ;				{ max length of a logical name } W     equ_name_length	    = 1024 ;				{ max length of the equivalence of a logical name } \     suffix		    = '_LOCKID' ;			{ added to resource name to form logical storing lock ID # }     [ HIDDEN ] TYPE        {+} $     { Basic stuff, internal use only     {-}   -     word_unsigned   = [ BYTE (2) ] 0..65535 ; 9     log_name_type   = VARYING [log_name_length] OF CHAR ; 9     equ_name_type   = VARYING [equ_name_length] OF CHAR ;       lck_id_type	    = UNSIGNED ;      lck_flags_type  = UNSIGNED ;       item_list_type  = RECORD 			length	: word_unsigned ;  			item	: word_unsigned ;  			buffer	: UNSIGNED ; 			retlen	: UNSIGNED ;U 			endmark	: UNSIGNED VALUE 0 ;		{ Indicates end of list. Must be zero at all times }  		      END;       lksb_type	    = RECORD 			status	    : word_unsigned ;   			reserved    : word_unsigned ; 			lck_id	    : lck_id_type ; 
 		      END ;        iosb_type	    = RECORD 			status	    : UNSIGNED ; 			reserved    : UNSIGNED ; 
 		      END ;        priv_mask_type  = RECORD 			low_bits    : UNSIGNED ;  			high_bits   : UNSIGNED ;  		      END ;	     [ HIDDEN ] VAR       {+} b     { We need some static storage to store the data that we will pass to the [ UNBOUND ] routines.G     { All system services are declared [ UNBOUND ] in starlet.pas/pen .      {-}   ;     lck_res_name    : [ VOLATILE ] lck_resource_name_type ; /     lck_id_val	    : [ VOLATILE ] lck_id_type ; 1     item_list	    : [ VOLATILE ] item_list_type ; +     lckstblk	    : [ VOLATILE ] lksb_type ; *     iostblk	    : [ VOLATILE ] iosb_type ;1     lck_flags	    : [ VOLATILE ] lck_flags_type ; 1     lck_id_log	    : [ VOLATILE ] log_name_type ; 2     lck_id_text	    : [ VOLATILE ] equ_name_type ;2     privileges	    : [ VOLATILE ] priv_mask_type ;    W [ HIDDEN ] FUNCTION translate_logical (	logical_name	    : [ VOLATILE ] log_name_type ; D 					VAR equival_name    : [ VOLATILE ] VARYING [eqbuflen] OF CHAR ;4 					lntable_name	    : [ VOLATILE ] log_name_type ;< 					access_mode	    : [ VOLATILE ] UNSIGNED := PSL$C_USER ;3 					attributes	    : [ VOLATILE ] UNSIGNED := 0 )   				: UNSIGNED ;       {+} 4     { A generic function to translate a logical name     {-}   +     BEGIN { of function translate_logical }            WITH item_list DO 
         BEGIN !             length  := eqbuflen ; $             item    := LNM$_STRING ;7             buffer  := IADDRESS ( equival_name.BODY ) ; 7             retlen  := IADDRESS ( equival_name.LENGTH ) 
         END ;   9 	translate_logical := $TRNLNM (  tabnam := lntable_name ,  					attr   := attributes ,  					lognam := logical_name ,  					acmode := access_mode , 					itmlst := item_list )  +     END { of function translate_logical } ;     [ [ HIDDEN ] FUNCTION define_kernel_logical (	logical_name	    : [ VOLATILE ] log_name_type ; E 						VAR equival_name    : [ VOLATILE ] VARYING [eqbuflen] OF CHAR ; 5 						lntable_name	    : [ VOLATILE ] log_name_type )  					: UNSIGNED ;        {+} @     { A generic function to define a logical name in kernel mode     {-}        VAR   ; 	local_logical_name : [ STATIC , VOLATILE ] log_name_type ; ; 	local_lntable_name : [ STATIC , VOLATILE ] log_name_type ;        {+} ?     { This is the function that will be executed in kernel mode      {-}   C     [ ASYNCHRONOUS , UNBOUND ] FUNCTION define_logical : UNSIGNED ;   $ 	BEGIN {of function define_logical }  F             define_logical := $CRELNM ( tabnam := local_lntable_name ,/ 					attr   := LNM$M_CONFINE + LNM$M_NO_ALIAS , * 				        lognam := local_logical_name ,$ 				        acmode := PSL$C_KERNEL ,! 				        itmlst := item_list )   ,         END { of function define_logical } ;  0     BEGIN { of function define_kernel_logical }   % 	local_logical_name := logical_name ; % 	local_lntable_name := lntable_name ;            WITH item_list DO 
         BEGIN $ 	    length	:= equival_name.LENGTH ; 	    item	:= LNM$_STRING ;/ 	    buffer	:= IADDRESS ( equival_name.BODY ) ;  	    retlen	:= 0 	END ;         Z         define_kernel_logical := $CMKRNL ( routin := %IMMED define_logical , arglst := 0 )  /     END { of function define_kernel_logical } ;     W [ HIDDEN ] FUNCTION delete_kernel_logical (	logical_name	: [ VOLATILE ] log_name_type ; 1 						lntable_name	: [ VOLATILE ] log_name_type )  				    : UNSIGNED ;       {+} @     { A generic function to delete a logical name in kernel mode     {-}        VAR   ; 	local_logical_name : [ STATIC , VOLATILE ] log_name_type ; ; 	local_lntable_name : [ STATIC , VOLATILE ] log_name_type ;        {+} ?     { This is the function that will be executed in kernel mode      {-}   C     [ ASYNCHRONOUS , UNBOUND ] FUNCTION delete_logical : UNSIGNED ;   % 	BEGIN { of function delete_logical }   ? 	    delete_logical := $DELLNM ( tabnam := local_lntable_name , * 				        lognam := local_logical_name ,( 				        acmode := PSL$C_KERNEL )      ,         END { of function delete_logical } ;  /     BEGIN { of function delete_kernel_logical }   % 	local_logical_name := logical_name ; % 	local_lntable_name := lntable_name ;   S 	delete_kernel_logical := $CMKRNL ( routin := %IMMED delete_logical , arglst := 0 )   /     END { of function delete_kernel_logical } ;     V [ GLOBAL , ASYNCHRONOUS ] FUNCTION lck_request (   name	    : lck_resource_name_type ;I 						   width    : lck_resource_width_type := lck_resource_width_group ; D 						   mode	    : lck_request_mode_type := lck_request_mode_wait ) 				: UNSIGNED ;       {+}      { Code for LOCK/REQUEST      {-}        VAR	status : UNSIGNED ;   A     [ ASYNCHRONOUS , UNBOUND ] FUNCTION enqueue_lock : UNSIGNED ;        {+}      { Enqueue the lock in privileged mode, so that it remains active after image exit (user mode locks are released at image exit). s     { We will do this in EXEC mode, altough SUPER would have been sufficient - but there is no $CMSUPER service ...      {-}   )         BEGIN {of function enqueue_lock }   ;             enqueue_lock := $ENQW ( lkmode := LCK$K_EXMODE,  				    lksb   := lckstblk , 				    flags  := lck_flags ,  				    resnam := lck_res_name,  				    acmode := PSL$C_SUPER )   # 	END { of function enqueue_lock } ;   %     BEGIN { of function lck_request }        {+} a     { Take local copies in static storage for all arguments to be passed to [ UNBOUND ] routines. J     { Those five arguments should not be touched anymore after this point.     {-}            lck_res_name := name ;         lck_flags := 0 ;Y         IF width = lck_resource_width_system THEN lck_flags := lck_flags + LCK$M_SYSTEM ; N 	IF mode = lck_request_mode_test THEN lck_flags := lck_flags + LCK$M_NOQUEUE ;       {+} {     { System-wide locks are very dangerous because they are used everywhere by VMS itself. Messing up with a VMS lock might x     { easily compromise the stability of the whole system. If coding conventions have been correctly followed, every VMS     { identifier - and therefore every resource name that VMS takes locks against - should contain a '$' sign. We are therefore e     { going to prohibit any usage of the '$' sign in the resource name if a system lock is requested.      {-}   J 	IF ( width = lck_resource_width_system ) AND ( INDEX ( name , '$' ) > 0 )       {+} L     { Lock is requested in system mode and with a '$' in the name => refused     {-}   " 	THEN lck_request := LCK_NAMRESVMS       {+} [     { Lock is requested in group mode or name does not contain any '$' => we may continue }      {-}   ! 	ELSE BEGIN { of IF-ELSE branch }        {+} y     { We have a problem with privileges. We do not want normal users to be able to queue system-wide locks. This normally |     { requires to have the SYSLCK privilege. However, the image containing this code will normally be installed with CMKRNL,z     { and once this privilege is on, VMS does not require SYSLCK anymore. We will therefor check for SYSLCK ourselves, and-     { return with SS$_NOPRIV if it is not on.      {-}    	    WITH item_list DO
 	    BEGIN 		length  := 8 ; 		item    := JPI$_CURPRIV ; & 		buffer  := IADDRESS ( privileges ) ; 		retlen  := 0
 	    END ;  / 	    status := $GETJPIW (	itmlst := item_list ,  				    iosb   := iostblk ) ;   ; 	    IF status = SS$_NORMAL THEN status := iostblk.status ;    	    IF status <> SS$_NORMAL       {+} #     { Call to system service failed      {-}    	    THEN lck_request := status        {+}      { Evaluate system service answer - is SYSLCK on ? Of course, if the lock requested is not system wide, we just don't care ...      {-}   % 	    ELSE BEGIN { of if-else branch }   b 		IF ( UAND ( privileges.low_bits , PRV$M_SYSLCK ) = 0 ) AND ( width = lck_resource_width_system )       {+} *     { Privilege is off - return SS$_NOPRIV     {-}     		THEN lck_request := SS$_NOPRIV       {+} G     { Privilege is on, or lock requested does not require it - continue      {-}   " 		ELSE BEGIN { of if-else branch }       {+} *     { Check if logical name already exists     {-}   + 		    lck_id_log := lck_res_name + suffix ; E 		    status := translate_logical (   logical_name    := lck_id_log , * 						    equival_name    := lck_id_text ,, 						    lntable_name    := 'LNM$PROCESS' ,* 						    attributes	:= LNM$M_CASE_BLIND ,) 						    access_mode	:= PSL$C_KERNEL ) ;    		    CASE status OF       {+} $     { Yes - don't proceed any furher     {-}   . 			SS$_NORMAL :	lck_request := LCK_LCKALRXTS ;       {+}      { No - proceed     {-}    			SS$_NOLOGNAM :	BEGIN        {+} (     { Enqueue the lock in executive mode     {-}   J 			    status := $CMEXEC ( routin := %IMMED enqueue_lock , arglst := 0 ) ;   			    CASE status OF        {+} %     { The service call was successful      {-}   , 				SS$_NORMAL :    BEGIN { of case branch }       {+} x     { Define a logical name to contain the channel number (group logical for group lock, system logical for system lock)3     { so that we can use it later with LOCK/RELEASE \     { We use a kernel mode logical so that we are -nearly- sure that nobody will mess it up.     {-}   ' 				    lck_id_val := lckstblk.lck_id ; - 				    lck_id_log := lck_res_name + suffix ; R 				    lck_id_text := UDEC ( lck_id_val , max_lck_id_width , max_lck_id_width ) ;  I 				    status := define_kernel_logical (   logical_name := lck_id_log ,  & 									equival_name := lck_id_text ,* 									lntable_name := 'LNM$PROCESS' ) ;  @ 				    IF ( status = SS$_NORMAL ) OR ( status = SS$_SUPERSEDE )' 					    THEN lck_request := LCK_LCKGTD # 					    ELSE lck_request := status     				    END { of case branch } ;       {+} B     { The lock is already in use and we have requested not to wait     {-}   1 				SS$_NOTQUEUED : lck_request := LCK_LCKINUSE ;        {+} &     { The service call to $ENQ failed.^     { We don't continue any further and return to our caller with the status that we received.     {-}   % 				OTHERWISE lck_request := status ;     			    END { of case statement }   			END { of case branch } ;        {+} )     { The service call to $TRNLLM failed. ^     { We don't continue any further and return to our caller with the status that we received.     {-}   " 			OTHERWISE	lck_request := status   		    END { of case statement }    		END { of if-else branch }    	    END { of if-else branch }   	END { of if-else branch }  %     END { of function lck_request } ;     ] [ GLOBAL , ASYNCHRONOUS ] FUNCTION lck_release ( name : lck_resource_name_type ) : UNSIGNED ;        {+}      { Code for LOCK/RELEASE      {-}        VAR status : UNSIGNED ;   A     [ ASYNCHRONOUS , UNBOUND ] FUNCTION dequeue_lock : UNSIGNED ;        {+} X     { Dequeue the lock. We will do that in executive mode, like we did for the creation.`     { Actually, supervisor mode would have been enough, but there is no $CMSUPER system service.     {-}   *         BEGIN { of function dequeue_lock }  2 	    dequeue_lock := $DEQ (  lkid   := lck_id_val, 				    acmode := PSL$C_SUPER )   *         END { of function dequeue_lock } ;  %     BEGIN { of function lck_release }        {+} a     { Take local copies in static storage for all arguments to be passed to [ UNBOUND ] routines. C     { This argument should not be touched anymore after this point.      {-}            lck_res_name := name ;       {+}      { Get the lock ID number     {-}   & 	lck_id_log := lck_res_name + suffix ;> 	status := translate_logical (	logical_name    := lck_id_log ,% 					equival_name    := lck_id_text , ' 					lntable_name    := 'LNM$PROCESS' , % 					attributes	:= LNM$M_CASE_BLIND , $ 					access_mode	:= PSL$C_KERNEL ) ;   	IF status <> SS$_NORMAL   	THEN lck_release := status        {+}      { We got a translation     {-}   ! 	ELSE BEGIN { of if-then branch }        {+} "     { Transform ASCII into numeric     {-}   ) 	    READV ( lck_id_text , lck_id_val ) ;  	    IF STATUSV <> 0         {+} 5     { Can't translate - logical name contains garbage      {-}   & 	    THEN lck_release := LCK_LCKINTERR       {+} 3     { Translation OK - all done, report good status      {-}   % 	    ELSE BEGIN { of if-else branch }        {+} E     { Delete the process logical name where the lock ID was retained. G     { We will release that lock, so we don't need that info anymore ...      {-}   b 		status := delete_kernel_logical ( logical_name := lck_id_log , lntable_name := 'LNM$PROCESS' ) ; 		IF status <> SS$_NORMAL        {+} #     { Call to system service failed      {-}    		THEN lck_release := status       {+} ,     { Execution of system service successful     {-}   ! 		ELSE BEGIN {of if-else branch }        {+}      { Delete the mailbox now.      {-}   I 		    status := $CMEXEC ( routin := %IMMED dequeue_lock , arglst := 0 ) ;  		    IF status <> SS$_NORMAL        {+} #     { Call to system service failed      {-}     		    THEN lck_release := status       {+} '     { Call to system service successful      {-}   $ 		    ELSE lck_release := LCK_LCKREL   		END { of if-else branch }    	    END { of if-else branch }   	END { of if-else branch }  %     END { of function lck_release } ;     END { of module lck_routines } .                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            