 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkscan.cE This file contains the code to perform lexical analysis of makefiles.    Modifications: SAM	Stephen A. Meadows  I SAM 89-May-11	Modified program to switch the INVOKE_MACRO code from a '$' < 		in the make and rules files to a 0xFE.  The '$' is now an A 		EXTERNAL_INVOKE_MACRO and INVOKE_MACRO is a '~'.  This removes  < 		a serious bug when using '\$' in the Rules file.  The old > 		method parsed the '\$' to a '$' which was then interpeted as< 		INVOKE_MACRO when the rule was used.  When the tokens are > 		read the INVOKE_MACRO character is subsituted for the '$" in& 		make_getc().  The '\$' is unchanged. */   #include "make.h"    #define MAX_CMD_DEF_LEN	256   : #define	_GETC(fp)	((fp) == NULL ? cmdln_getc() : getc(fp))I #define _UNGETC(c, fp)	((fp) == NULL ? cmdln_ungetc(c) : ungetc(c, (fp)))   ; static int Line_number;		/* position in current makefile */ 3 static int Prev_nl;		/* true if at start of line */ : static int Cmdlndef;		/* command line definition status */$ static char Cmdbuf[MAX_CMD_DEF_LEN]; static int Cmdidx;  C /* Read a makefile and parse it into tokens significant to make. */    MAKE_TOKEN * make_token_list(mkfptr) 
 FILE *mkfptr;  {  	int toklen, tokline, simple;  	register MAKE_TOKEN **mtptr;  	MAKE_TOKEN *tok_list_ptr; 	char token[MAX_TOKEN_LEN];   ! 	/* Scan through the makefile. */    	Line_number = 1;  	Prev_nl = TRUE; 	mtptr = &tok_list_ptr;  	*mtptr = NULL; I 	while ((toklen = make_token(mkfptr, token, &tokline, &simple)) != EOF) {  		*mtptr = E_ALLOC(MAKE_TOKEN); , 		(*mtptr)->mt_text = newstr(token, toklen); 		(*mtptr)->mt_line = tokline; 		(*mtptr)->mt_next = NULL;  		(*mtptr)->mt_simple = simple;  		mtptr = &(*mtptr)->mt_next;  	} 	return (tok_list_ptr);  }   6 /* Read next token from makefile pointed to by mkfptr.1 Return length of token, or EOF on end of file. */   + make_token(mkfptr, tokbuf, tklnptr, simptr) 
 FILE *mkfptr;  register char *tokbuf; int *tklnptr, *simptr; { ! 	static int start_of_line = TRUE; ! 	static int command_line = FALSE;  	static int tok_ch_saved = EOF; ( 	static int past_first_comm_tok = FALSE; 	register int c; 	int tok_got_literal;  	char *tok0;  ? 	/* Get line number before reading first character of token. */    	*simptr = TRUE; 	*tklnptr = Line_number;  % 	/* Read first character of token. */    	if (tok_ch_saved != EOF) {  		c = tok_ch_saved;  		tok_ch_saved = EOF; - 	} else if ((c = make_getc(mkfptr)) == EOF) {  		command_line = FALSE;  		return (EOF);  	}   	/* Check for end of line. */    	if (c == '\n') {  		start_of_line = TRUE;  		command_line = FALSE;  		tokbuf[0] = c; 		tokbuf[1] = '\0'; 
 		return (1);  	}  @ 	/* If token wasn't newline, get line number now, since originalD 	line number may be off due to line continuation, multiple newlines,' 	or other unpredictable acts of god. */    	*tklnptr = Line_number;  ) 	/* Check for single character tokens. */    	if (IS_TOK_SEP(c)) {   ? 		/* Of the token separator characters, space is significant at ? 		the start of a line.  The others are significant anywhere. */   " 		if (c != ' ' || start_of_line) { 			start_of_line = FALSE;  			command_line = (c == ' ');  			past_first_comm_tok = FALSE;  			tokbuf[0] = c;  			tokbuf[1] = '\0'; 			return (1); 		}   3 		/* If the space is not at the start of a line, it 3 		is a token separator, with no other significance, " 		and can therefore be skipped. */   		c = make_getc(mkfptr); 	}  5 	/* Check for special characters on command lines. */   > 	if (command_line && (c == MC_IGN_ERROR || c == MC_NO_ECHO) && 	    !past_first_comm_tok) { 		*tokbuf++ = c; 		*tokbuf = '\0'; 
 		return (1);  	}  $ 	/* Get next word, of any length. */   	tok0 = tokbuf;  	start_of_line = FALSE;  	tok_got_literal = FALSE;  	while (1) {. 		if (c == INVOKE_MACRO && !tok_got_literal) { 			*simptr = FALSE;  		}  		*tokbuf++ = c;' 		if ((c = make_getc(mkfptr)) == EOF) { 	 			break;  		}  		if (IS_TOK_SEP(c)) { 			if (command_line) {/ 				if (c != DEPENDENCY && c != DEFINE_MACRO) {  					break;  				}  			} else { ( 				if (!tok_got_literal || c == '\n') { 					break;  				}  			} 		} < 		tok_got_literal = (!tok_got_literal && c == NEXT_LITERAL); 	} 	tok_ch_saved = c; 	*tokbuf = '\0'; 	past_first_comm_tok = TRUE; 	return (tokbuf - tok0); }   6 /* Return the next syntactically significant character* from the makefile pointed to by mkfptr. */   make_getc(mkfptr) 
 FILE *mkfptr;  {  	static int make_saved = EOF; " 	static int mkget_literal = FALSE; 	int c;    	while (1) {  % 		/* Get next character from file. */    		if (make_saved != EOF) { 			c = make_saved; 			make_saved = EOF;
 		} else { 			c = map_getc(mkfptr); 		}   - 		/* Compress consecutive blanks into one. */    		if (c == ' ') {  			while (1) {  1 				/* Compress any number of blanks into one. */   ) 				while ((c = map_getc(mkfptr)) == ' ')  					;  , 				/* If newline follows blanks, return it,- 				thereby deleting past trailing blanks. */    				if (c == '\n') { 					break;  				}   & 				/* Check for line continuation. */   				if (c == CONTINUE_LINE) { * 					if ((c = map_getc(mkfptr)) == '\n') { 						continue;  					}  					make_saved = CONTINUE_LINE; 				}   ( 				/* Save char after CONTINUE_LINE. */   				_UNGETC(c, mkfptr);  				c = ' ';
 				break; 			} 		}   $ 		/* Check for line continuation. */  - 		if (!mkget_literal && c == CONTINUE_LINE) { ( 			if ((c = map_getc(mkfptr)) == '\n') {
 				continue;  			} 			_UNGETC(c, mkfptr); 			c = CONTINUE_LINE;  		}   / 		/* if the last character wasn't a literal and 0 		   the external invoke macro is found it must 2 		   be switched to the internal format instead */  5 		if (!mkget_literal && c == EXTERNAL_INVOKE_MACRO) { 4 			c = INVOKE_MACRO;	/* SAM 890511 substitue chrs */ 		}   . 		/* Remember each literal that's returned. */  8 		mkget_literal = (!mkget_literal && c == NEXT_LITERAL);  ! 		/* Eat consecutive newlines. */    		if (c != '\n' || !Prev_nl) { 			Prev_nl = (c == '\n');  			return (c); 		}  	} }   > /* Read characters from mkfptr.  Convert any tabs into spaces. Eliminate comments. */   map_getc(mkfptr)
 FILE *mkfptr;  {  	register int c;  . 	/* Read next character, check for comment. */  + 	if ((c = _GETC(mkfptr)) == OPEN_COMMENT) { < 		while ((c = _GETC(mkfptr)) != EOF && c != CLOSE_COMMENT) { 			if (c == '\n') {  				Line_number++; 			} 		}  		c = REPLACE_COMMENT; 	}  < 	/* If character is NEXT_LITERAL, and following character is> 	OPEN_COMMENT, delete NEXT_LITERAL and return OPEN_COMMENT. */   	if (c == NEXT_LITERAL) { , 		if ((c = _GETC(mkfptr)) != OPEN_COMMENT) { 			_UNGETC(c, mkfptr); 			c = NEXT_LITERAL; 		}  	}  @ 	/* Blanks require special checks on the following character. */   	if (c == ' ' || c == '\t') {   ; 		/* Compress any number of consecutive blanks into one. */   1 		while ((c = _GETC(mkfptr)) == ' ' || c == '\t')  			;  2 		/* Blanks preceding a comment are irrelevant. */   		if (c == OPEN_COMMENT) {= 			while ((c = _GETC(mkfptr)) != EOF && c != CLOSE_COMMENT) {  				if (c == '\n') { 					Line_number++;  				}  			} 			c = REPLACE_COMMENT;  		}   , 		/* Eliminate trailing spaces on a line. */   		if (c != '\n' && c != EOF) { 			if (c != ' ') { 				_UNGETC(c, mkfptr);  			} 			c = ' ';  		}  	}  ! 	/* Keep track of line number. */    	if (c == '\n') {  		Line_number++; 	} 	return (c); }   D /* Return the next character from command line macro definitions. */   cmdln_getc() { 	 	int len;   8 	/* See if command line macro definitions were given. */   	if (Cmdlndef == 0) { " 		if (cli_present("DEFINE") > 0) { 			Cmdlndef = 1; 			Cmdbuf[Cmdidx = 0] = '\0'; 
 		} else { 			Cmdlndef = -1;  			return (EOF); 		}  	} else if (Cmdlndef < 0) {  		return (EOF);  	}  ! 	/* Return the next character. */    	if (Cmdbuf[Cmdidx] == '\0') {< 		len = cli_get_value("DEFINE", Cmdbuf, sizeof(Cmdbuf) - 1); 		if (len < 0) { 			Cmdlndef = -1; 
 		} else { 			Cmdidx = 0; 		}  		if (Cmdlndef == 0) { 			Cmdlndef = 1;
 		} else { 			return ('\n');  		}  	}" 	return (Cmdbuf[Cmdidx++] & 0xFF); }   5 /* Make character c the next character to be returned / when reading command line macro definitions. */    cmdln_ungetc(c)  int c; {  	if (Cmdidx > 0) {, 		Cmdbuf[--Cmdidx] = (c == '\n' ? '\0' : c); 	} } 