#include <stdio.h>
#include <ctype.h>

#include "externs.h"  
#include "keym.h"
#include "sysdep.h"
#include "display.h"
#include "buffer.h"
#include "window.h"
#include "search.h"
#include "file.h"

int *DIGIT_ARG;
char LAST_CHAR;
int EDT_DIRECTION = 1;

void prev_line_cmd()
{
    find_next_cmd();
}


void (*root_map[128])() =
  {
      beep,                 /* ^@ */
      beep,                 /* ^A */
      beep,                 /* ^B */
      beep,                 /* ^C */
      page_down_cmd,            /* ^D */
      beep, /* ^E */
      search_cmd,               /* ^F */
      beep, /* ^G */
      help_cmd,                 /* ^H */
      page_right_cmd,           /* ^I */
      next_line_cmd,            /* ^J */
      ctrl_k_map_cmd,           /* ^K */
      beep, /* ^L */
      next_line_cmd,            /* ^M */
      next_line_cmd,            /* ^N */
      beep, /* ^O */
      previous_line_cmd,        /* ^P */
      beep, /* ^Q */
      redraw_cmd,               /* ^R */
      beep, /* ^S */
      time_cmd,                 /* ^T */
      page_up_cmd,              /* ^U */
      page_down_cmd,            /* ^V */
      ctrl_w_map_cmd,           /* ^W */
      ctrl_x_map_cmd,           /* ^X */
      beep, /* ^Y */
      sys_spawn_cmd,            /* ^Z */
      esc_map_cmd,              /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      page_down_cmd,            /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      sys_spawn_cmd,            /* $ */
      goto_percent_cmd,         /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      goto_mark_cmd,            /* , */
      digit_arg_cmd,            /* - */
      beep, /* . */
      search_cmd,               /* / */
      digit_arg_cmd,            /* 0 */
      digit_arg_cmd,            /* 1 */
      digit_arg_cmd,            /* 2 */
      digit_arg_cmd,            /* 3 */
      digit_arg_cmd,            /* 4 */
      digit_arg_cmd,            /* 5 */
      digit_arg_cmd,            /* 6 */
      digit_arg_cmd,            /* 7 */
      digit_arg_cmd,            /* 8 */
      digit_arg_cmd,            /* 9 */
      extended_key_cmd,         /* : */
      beep, /* ; */
      page_left_cmd,            /* < */
      beep, /* = */
      page_right_cmd,           /* > */
      search_back_cmd,          /* ? */
      beep, /* @ */
      beep, /* A */
      end_of_buffer_cmd,        /* B */
      beep, /* C */
      page_down_cmd,            /* D */
      edit_cmd, /* E */
      search_cmd,               /* F */
      goto_line_cmd,            /* G */
      help_cmd,                 /* H */
      beep, /* I */
      goto_line_cmd,            /* J */
      beep, /* K */
      toggle_lock,              /* L */
      set_mark_cmd,             /* M */
      find_next_cmd,            /* N */
      other_window_cmd,         /* O */
      beep, /* P */
      exit_cmd,                 /* Q */
      redraw_cmd,               /* R */
      search_cmd,		       /* S */
      top_of_buffer_cmd,        /* T */
      page_up_cmd,              /* U */
      next_line_cmd,            /* V */
      toggle_width_cmd,         /* W */
      exit_cmd, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      prev_line_cmd, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      end_of_buffer_cmd,        /* b */
      beep, /* c */
      page_down_cmd,            /* d */
      edit_cmd, /* e */
      search_cmd,               /* f */
      goto_line_cmd,            /* g */
      help_cmd,                 /* h */
      beep, /* i */
      goto_line_cmd,            /* j */
      beep, /* k */
      toggle_lock,              /* l */
      set_mark_cmd,             /* m */
      find_next_cmd,            /* n */
      other_window_cmd,         /* o */
      beep, /* p */
      exit_cmd,                 /* q */
      redraw_cmd,               /* r */
      search_cmd,		       /* s */
      top_of_buffer_cmd,        /* t */
      page_up_cmd,              /* u */
      next_line_cmd,            /* v */
      toggle_width_cmd,         /* w */
      exit_cmd, /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      page_up_cmd               /* ^? */
    };

/*  escape map  */
void (*escape_map[128])() =
  {
      beep, /* ^@ */
      beep, /* ^A */
      beep, /* ^B */
      beep, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      beep, /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      beep, /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      beep, /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      beep, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      sys_spawn_cmd,            /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      digit_arg_cmd,            /* - */
      beep, /* . */
      beep, /* / */
      beep, /* 0 */
      digit_arg_cmd,            /* 1 */
      digit_arg_cmd,            /* 2 */
      digit_arg_cmd,            /* 3 */
      digit_arg_cmd,            /* 4 */
      digit_arg_cmd,            /* 5 */
      digit_arg_cmd,            /* 6 */
      digit_arg_cmd,            /* 7 */
      digit_arg_cmd,            /* 8 */
      digit_arg_cmd,            /* 9 */
      beep, /* : */
      beep, /* ; */
      top_of_buffer_cmd,        /* < */
      beep, /* = */
      end_of_buffer_cmd,        /* > */
      beep, /* ? */
      beep, /* @ */
      beep, /* A */
      beep, /* B */
      beep, /* C */
      beep, /* D */
      beep, /* E */
      beep, /* F */
      beep, /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      beep, /* M */
      beep, /* N */
      O_map_cmd,                /* O */
      beep, /* P */
      beep, /* Q */
      beep, /* R */
      beep, /* S */
      beep, /* T */
      beep, /* U */
      beep, /* V */
      beep, /* W */
      extended_cmd_cmd,         /* X */
      beep, /* Y */
      beep, /* Z */
      O_map_cmd,                /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      beep, /* d */
      beep, /* e */
      beep, /* f */
      beep, /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      beep, /* m */
      beep, /* n */
      beep, /* o */
      beep, /* p */
      beep, /* q */
      beep, /* r */
      beep, /* s */
      beep, /* t */
      beep, /* u */
      beep, /* v */
      beep, /* w */
      extended_cmd_cmd,         /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void (*ctrl_x_map[128])() =
  {
      beep, /* ^@ */
      beep, /* ^A */
      beep, /* ^B */
      exit_cmd, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      find_file_cmd,            /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      beep, /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      beep, /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      beep, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      beep, /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      beep, /* - */
      beep, /* . */
      beep, /* / */
      del_window_cmd,           /* 0 */
      one_window_cmd,           /* 1 */
      two_window_cmd,           /* 2 */
      beep, /* 3 */
      beep, /* 4 */
      beep, /* 5 */
      beep, /* 6 */
      beep, /* 7 */
      beep, /* 8 */
      beep, /* 9 */
      beep, /* : */
      beep, /* ; */
      beep, /* < */
      beep, /* = */
      beep, /* > */
      beep, /* ? */
      beep, /* @ */
      beep, /* A */
      beep, /* B */
      beep, /* C */
      beep, /* D */
      beep, /* E */
      beep, /* F */
      beep, /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      beep, /* M */
      beep, /* N */
      other_window_cmd,         /* O */
      beep, /* P */
      beep, /* Q */
      beep, /* R */
      beep, /* S */
      beep, /* T */
      beep, /* U */
      beep, /* V */
      beep, /* W */
      beep, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      beep, /* d */
      beep, /* e */
      beep, /* f */
      beep, /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      beep, /* m */
      beep, /* n */
      other_window_cmd,         /* o */
      beep, /* p */
      beep, /* q */
      beep, /* r */
      beep, /* s */
      beep, /* t */
      beep, /* u */
      beep, /* v */
      beep, /* w */
      beep, /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void (*ctrl_w_map[128])() =
  {
      beep, /* ^@ */
      beep, /* ^A */
      beep, /* ^B */
      beep, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      beep, /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      beep, /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      beep, /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      beep, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      beep, /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      beep, /* - */
      beep, /* . */
      beep, /* / */
      del_window_cmd,           /* 0 */
      one_window_cmd,           /* 1 */
      two_window_cmd,           /* 2 */
      beep, /* 3 */
      beep, /* 4 */
      beep, /* 5 */
      beep, /* 6 */
      beep, /* 7 */
      beep, /* 8 */
      beep, /* 9 */
      beep, /* : */
      beep, /* ; */
      beep, /* < */
      beep, /* = */
      beep, /* > */
      beep, /* ? */
      beep, /* @ */
      beep, /* A */
      beep, /* B */
      beep, /* C */
      beep, /* D */
      beep, /* E */
      beep, /* F */
      beep, /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      beep, /* M */
      beep, /* N */
      other_window_cmd,         /* O */
      beep, /* P */
      beep, /* Q */
      beep, /* R */
      beep, /* S */
      beep, /* T */
      beep, /* U */
      beep, /* V */
      beep, /* W */
      beep, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      beep, /* d */
      beep, /* e */
      beep, /* f */
      beep, /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      beep, /* m */
      beep, /* n */
      other_window_cmd, /* o */
      beep, /* p */
      beep, /* q */
      beep, /* r */
      beep, /* s */
      beep, /* t */
      beep, /* u */
      beep, /* v */
      beep, /* w */
      beep, /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void (*ctrl_k_map[128])() =
  {
      beep, /* ^@ */
      beep, /* ^A */
      set_mark_cmd,             /* ^B */
      beep, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      beep, /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      goto_mark_cmd,            /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      goto_mark_cmd,            /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      beep, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      beep, /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      beep, /* - */
      beep, /* . */
      beep, /* / */
      beep, /* 0 */
      beep, /* 1 */
      beep, /* 2 */
      beep, /* 3 */
      beep, /* 4 */
      beep, /* 5 */
      beep, /* 6 */
      beep, /* 7 */
      beep, /* 8 */
      beep, /* 9 */
      beep, /* : */
      beep, /* ; */
      beep, /* < */
      beep, /* = */
      beep, /* > */
      beep, /* ? */
      beep, /* @ */
      beep, /* A */
      beep, /* B */
      beep, /* C */
      extended_cmd_cmd,         /* D */
      exit_cmd,                 /* E */
      beep, /* F */
      find_file_cmd,            /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      set_mark_cmd,             /* M */
      beep, /* N */
      beep, /* O */
      beep, /* P */
      beep, /* Q */
      beep, /* R */
      beep, /* S */
      beep, /* T */
      beep, /* U */
      beep, /* V */
      beep, /* W */
      beep, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      extended_cmd_cmd,         /* d */
      exit_cmd,                 /* e */
      beep, /* f */
      find_file_cmd,            /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      set_mark_cmd,             /* m */
      beep, /* n */
      beep, /* o */
      beep, /* p */
      beep, /* q */
      beep, /* r */
      beep, /* s */
      beep, /* t */
      beep, /* u */
      beep, /* v */
      beep, /* w */
      beep, /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void (*esc_O_map[128])() =
  {
      beep, /* ^@ */
      beep, /* ^A */
      beep, /* ^B */
      beep, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      beep, /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      beep, /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      beep, /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      beep, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      beep, /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      beep, /* - */
      beep, /* . */
      beep, /* / */
      dec_extended_map_cmd,     /* 0 */
      dec_extended_map_cmd,     /* 1 */
      dec_extended_map_cmd,     /* 2 */
      dec_extended_map_cmd,     /* 3 */
      dec_extended_map_cmd,     /* 4 */
      dec_extended_map_cmd,     /* 5 */
      dec_extended_map_cmd,     /* 6 */
      dec_extended_map_cmd,     /* 7 */
      dec_extended_map_cmd,     /* 8 */
      dec_extended_map_cmd,     /* 9 */
      beep, /* : */
      beep, /* ; */
      beep, /* < */
      beep, /* = */
      beep, /* > */
      beep, /* ? */
      beep, /* @ */
      previous_line_cmd,        /* A */
      next_line_cmd,            /* B */
      page_right_cmd,           /* C */
      page_left_cmd,            /* D */
      beep, /* E */
      beep, /* F */
      beep, /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      next_line_cmd, /* M */
      beep, /* N */
      beep, /* O */
      pf1_map_cmd, /* P */	/* PF1 */
      help_cmd, /* Q */ /* PF2 */
      edt_find_next_cmd, /* R */ /* PF3 */
      beep, /* S */ /* PF4 */
      beep, /* T */
      beep, /* U */
      beep, /* V */
      beep, /* W */
      beep, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      beep, /* d */
      beep, /* e */
      beep, /* f */
      beep, /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      beep, /* m */
      set_mark_cmd, /* n */
      beep, /* o */
      edt_line_cmd, /* p */ /* KP0 */
      beep, /* q */ /* KP1 */
      beep, /* r */ /* KP2 */
      beep, /* s */ /* KP3 */
      edt_forward_cmd, /* t */ /* KP4 */
      edt_back_cmd, /* u */ /* KP5 */
      beep, /* v */ /* KP6 */
      beep, /* w */ /* KP7 */
      edt_page_cmd, /* x */ /* KP8 */
      beep, /* y */ /* KP9 */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void (*pf1_map[128])() =	/* Gold */
  {
      beep, /* ^@ */
      beep, /* ^A */
      beep, /* ^B */
      beep, /* ^C */
      beep, /* ^D */
      beep, /* ^E */
      beep, /* ^F */
      beep, /* ^G */
      beep, /* ^H */
      beep, /* ^I */
      beep, /* ^J */
      beep, /* ^K */
      beep, /* ^L */
      beep, /* ^M */
      beep, /* ^N */
      beep, /* ^O */
      beep, /* ^P */
      beep, /* ^Q */
      beep, /* ^R */
      beep, /* ^S */
      beep, /* ^T */
      beep, /* ^U */
      beep, /* ^V */
      beep, /* ^W */
      beep, /* ^X */
      beep, /* ^Y */
      beep, /* ^Z */
      pf1_esc_map_cmd, /* ^[ */
      beep, /* ^\ */
      beep, /* ^] */
      beep, /* ^^ */
      beep, /* ^_ */
      beep, /*   */
      beep, /* ! */
      beep, /* " */
      beep, /* # */
      beep, /* $ */
      beep, /* % */
      beep, /* & */
      beep, /* ' */
      beep, /* ( */
      beep, /* ) */
      beep, /* * */
      beep, /* + */
      beep, /* , */
      beep, /* - */
      beep, /* . */
      beep, /* / */
      digit_arg_cmd, /* 0 */
      digit_arg_cmd, /* 1 */
      digit_arg_cmd, /* 2 */
      digit_arg_cmd, /* 3 */
      digit_arg_cmd, /* 4 */
      digit_arg_cmd, /* 5 */
      digit_arg_cmd, /* 6 */
      digit_arg_cmd, /* 7 */
      digit_arg_cmd, /* 8 */
      digit_arg_cmd, /* 9 */
      beep, /* : */
      beep, /* ; */
      beep, /* < */
      beep, /* = */
      beep, /* > */
      beep, /* ? */
      beep, /* @ */
      beep, /* A */
      beep, /* B */
      beep, /* C */
      beep, /* D */
      beep, /* E */
      beep, /* F */
      beep, /* G */
      beep, /* H */
      beep, /* I */
      beep, /* J */
      beep, /* K */
      beep, /* L */
      beep, /* M */
      beep, /* N */
      one_window_cmd, /* O */
      beep, /* P */
      exit_cmd, /* Q */
      beep, /* R */
      sys_spawn_cmd, /* S */
      beep, /* T */
      beep, /* U */
      del_window_cmd, /* V */
      beep, /* W */
      two_window_cmd, /* X */
      beep, /* Y */
      beep, /* Z */
      beep, /* [ */
      beep, /* \ */
      beep, /* ] */
      beep, /* ^ */
      beep, /* _ */
      beep, /* ` */
      beep, /* a */
      beep, /* b */
      beep, /* c */
      beep, /* d */
      beep, /* e */
      beep, /* f */
      beep, /* g */
      beep, /* h */
      beep, /* i */
      beep, /* j */
      beep, /* k */
      beep, /* l */
      beep, /* m */
      beep, /* n */
      one_window_cmd, /* o */
      beep, /* p */
      exit_cmd, /* q */
      beep, /* r */
      sys_spawn_cmd, /* s */
      beep, /* t */
      beep, /* u */
      del_window_cmd, /* v */
      beep, /* w */
      two_window_cmd, /* x */
      beep, /* y */
      beep, /* z */
      beep, /* { */
      beep, /* | */
      beep, /* } */
      beep, /* ~ */
      beep  /* ^? */
  };

void execute_key()
{
    char ch;
    int r,c;
    c = CURS_COL - COLUMN + 1;
    r = CURS_ROW;
    if (MINI_BUF[0] != '\0') put_message();
    if (r < 1) r = 1;
    else if (r > (WIN->bot - WIN->top + 1))
      r = WIN->bot - WIN->top + 1;
    if (c > SCREEN_WIDTH) c = SCREEN_WIDTH;
    else if (c < 1) c = 1;
    goto_rc(r + WIN->top - 1,c);
    fflush(stdout);
    DIGIT_ARG = (int *) NULL;
    ch = getkey();
    if (MINI_BUF[0] != '\0') clear_minibuffer();
    LAST_CHAR = ch;
    (*root_map[ (int) ch ])();
}

void ctrl_x_map_cmd()
{
    char ch;

    ch = getkey();
    (*ctrl_x_map[ (int) ch ])();
}

void ctrl_k_map_cmd()
{
    char ch;

    ch = getkey();
    (*ctrl_k_map[ (int) ch ])();
}

void ctrl_w_map_cmd()
{
    char ch;

    ch = getkey();
    (*ctrl_w_map[ (int) ch ])();
}

void O_map_cmd()
{
    char ch;

    ch = getkey();
    LAST_CHAR = ch;
    (*esc_O_map[ (int) ch ])();
}

void esc_map_cmd()
{
    char ch;

    ch = getkey();
    LAST_CHAR = ch;
    (*escape_map[ (int) ch ])();
}

/* weird sequences of form ^[[n~ where n is an integer */
void dec_extended_map_cmd()
{
    char ch, numstr[5];
    int i, num;
    
    ch = LAST_CHAR;  /* should be integer */
    i = 0;
    numstr[i++] = ch;
 
    while (ch = getkey(), isdigit(ch)) numstr[i++] = ch;
    if (ch == '~')
      {
          numstr[i++] =  '\0';
          sscanf(numstr,"%d",&num);
          switch (num)
            {
              case 5:
                page_up_cmd(); break; /* prev screen */
              case 6:
                page_down_cmd(); break; /* next screen */
              case 1:
                search_cmd(); break; /* find */
              case 4:
                set_mark_cmd(); break; /* select */
              case 2:   
                goto_mark_cmd(); break; /* insert here */
              case 28:
                help_cmd(); break; /* Help */
              case 29:  /* do */
                extended_cmd_cmd(); break;
              default:
                beep(); break;
            }
      }
    else beep();
}

/* weird sequences of form ^[[n~ where n is an integer */
void pf1_esc_map_cmd()
{
    char ch;
    
    LAST_CHAR = ch = getkey();
    switch (ch)
	{
	case 'O':
	    LAST_CHAR = ch = getkey();
	    switch (ch)
		{
		case 't': /* KP4 */
		    end_of_buffer_cmd(); break;
		case 'u': /* KP5 */
		    top_of_buffer_cmd(); break;
		case 'w': /* KP7 */
		    extended_cmd_cmd(); break;
		case 'n': /* KP7 */
		    goto_mark_cmd(); break;
		case 'R': /* PF3 */
		    edt_find_cmd(); break;
		default :
		    beep(); break;
		}
	    break;
	case '[':
	    LAST_CHAR = ch = getkey();
	    switch (ch)
		{
		case 'A':
		    other_window_cmd(); break;
		case 'B':
		    other_window_cmd(); break;
		case 'C':
		    page_left_cmd(); break;
		case 'D':
		    page_right_cmd(); break;
		default :
		    beep(); break;
		};
	    break;
	default :
            beep(); break;
	}
}

void pf1_map_cmd()
{
    char ch;

    ch = getkey();
    LAST_CHAR = ch;
    (*pf1_map[ (int) ch ])();
}

void page_down_cmd()
{
   int n = 1;
   
   if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
   if (n < 0) n = 1;
   n = C_LINE + n * (WIN->bot - WIN->top + 1);
   while ((BUF->fd != -1) && (NUM_LINES < n + 50)) read_file_dsc(1);
   update_windows(n);
}

void page_up_cmd()
{
    int n = 1;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    update_windows(C_LINE - n * (WIN->bot - WIN->top + 1));
}

void page_right_cmd()
{
    int n = 1;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    COLUMN = COLUMN + n * 59;
    update_windows(C_LINE);
}

void page_left_cmd()
{
    int n = 1;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    COLUMN = COLUMN - n * 59;
    update_windows(C_LINE);
}

void next_line_cmd()
{
    int n = 1;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
   
   while ((BUF->fd != -1) && (NUM_LINES < C_LINE + n + 50)) read_file_dsc(1);
   update_windows(C_LINE + n);
}

void previous_line_cmd()
{
   int n = 1;
   if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
   
    update_windows(C_LINE - n);
}


void top_of_buffer_cmd()
{
    update_windows(1);
}

void end_of_buffer_cmd()
{
   while (BUF->fd != -1) read_file_dsc(-1);
   update_windows(NUM_LINES);
}
#ifdef unix
#include <signal.h>
#endif
extern void sys_spawn_cmd()
{
    int update = 0;
    reset_tty();
    reset_display();
    fflush(stdout);
#ifdef VMS
    if (LAST_CHAR == '\032') exit(0);
    if (do_shell_command()) update = 1; /* scroll region reset by message facility */
#else                          
   kill(0, SIGTSTP);
   update = 1;
#endif
   init_tty();
   if (update) redraw_display();
}

void redraw_cmd()
{
    redraw_display();
}

void goto_line_cmd()
{
    int n = C_LINE;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    else
      {
          MINI_BUF[0] = 0;
          if (!read_from_minibuffer("Line", (char *) MINI_BUF)) return;
          sscanf((char *) MINI_BUF,"%d",&n);
          MINI_BUF[0] = 0;
      }
    update_windows(n);
}

void goto_percent_cmd()
{
    unsigned char *pos;
    int n;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    else
      {
          MINI_BUF[0] = 0;
          if (!read_from_minibuffer("%", (char *) MINI_BUF)) return;
          sscanf((char *) MINI_BUF,"%d",&n);
          MINI_BUF[0] = 0;
      }
    if (n < 0) n = 0; else if (n > 100) n = 100;
   if (BUF->fd != -1) read_file_dsc(-1);
   pos = BEG + (n * (EOB - BEG))/100;
   n = what_line(pos);
   update_windows(n);
}

void extended_key_cmd()
{
    if (-1 == do_extended_key()) exit_cmd();
}

void extended_cmd_cmd()
{
    if (-1 == do_extended_cmd()) exit_cmd();
}

void set_mark_cmd()
{
    BUF->mark = C_LINE;
    message("Mark Set.",0);
}

void goto_mark_cmd()
{
    int mark = BUF->mark;
    BUF->mark = C_LINE;
    update_window(mark);
    message("Mark Set.",0);
}

void one_window_cmd()
{
    one_window();
}

void two_window_cmd()
{
    two_windows();
}

void del_window_cmd()
{
    delete_window();
}

void other_window_cmd()
{
    int n = 1;
    if (DIGIT_ARG != (int *) NULL) n = *DIGIT_ARG;
    other_window(n);
}


void find_next_cmd()
{
   int col, line, n = 1;
   int ofs;
    
    if (DIGIT_ARG != NULL) n = *DIGIT_ARG;
    line = search(CURS_POS + SEARCH_DIR, n, &col);
    if (line < 1) return;
   
   /* note that only offsets are meaningful!! (version 4) */
    ofs = CURS_POS - BEG;
    if ((line < WIN->beg_line) || (line > WIN->beg_line + WIN->bot - WIN->top))
      update_window(line);
    CURS_POS = BEG + ofs;
   
    CURS_ROW = line - C_LINE + 1;
    CURS_COL = col;
}

void search_cmd()
{
    SEARCH_DIR = 1;
    if (read_from_minibuffer("Search",SEARCH_STR) == -1)
      return;
    CURS_POS = C_POS;
    find_next_cmd();
}

void search_back_cmd()
{
    SEARCH_DIR = -1;
    if (read_from_minibuffer("Search",SEARCH_STR) == -1)
      return;
    find_next_cmd();
}

void help_cmd()
{
    do_help_command();
}

void find_file_cmd()
{
    user_get_file();
}

void time_cmd()
{
    message(get_time(),0);
}

void exit_cmd()
{
    reset_tty();
    reset_display();
#ifndef  VMS
    tt_putchar('\n');
#endif    
    exit(0);
}

void digit_arg_cmd()
{
    char num[15], ch;
    int j = 0;
    static int digits;
    
    num[j++] = LAST_CHAR;
    ch = getkey();
    while ((ch >= '0') && (ch <= '9'))
      {
          num[j++] = ch;
          ch = getkey();
      }
    
    if (((j == 1) && (LAST_CHAR != '-')) || (j > 1))
      {
          num[j] = '\0';
          sscanf(num,"%d",&digits);
          DIGIT_ARG = &digits;
      }
    LAST_CHAR = ch;
    (*root_map[ (int) ch ])();
}

    
void toggle_width_cmd()
{
    if (SCREEN_WIDTH == 80)
      {
          if (!RESTORE_WIDTH_TO) RESTORE_WIDTH_TO = 80;
          set_width(132, 1);
      }          
    else if (SCREEN_WIDTH == 132)
      {
          if (!RESTORE_WIDTH_TO) RESTORE_WIDTH_TO = 132;
          set_width(80, 1);
      }          
}

void edt_forward_cmd()
{
    EDT_DIRECTION = 1;
}

void edt_back_cmd()
{
    EDT_DIRECTION = 0;
}

void edt_page_cmd()
{
    if (EDT_DIRECTION == 0)
	{
	    page_up_cmd();
	}
    else
	{
	    page_down_cmd();
	}
}

void edt_line_cmd()
{
    if (EDT_DIRECTION == 0)
	{
	    previous_line_cmd();
	}
    else
	{
	    next_line_cmd();
	}
}

void edt_find_cmd()
{
    if (EDT_DIRECTION == 0)
	{
	    search_back_cmd();
	}
    else
	{
	    search_cmd();
	}
}

void edt_find_next_cmd()
{
    if (EDT_DIRECTION == 0)
	{
	    SEARCH_DIR = -1;
	}
    else
	{
	    SEARCH_DIR = 1;
	}
    find_next_cmd();
}

