         PROGRAM LAST
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          9 JANUARY 1990
C        MODIFIED
C          17 MAY 1990 JON BAKER
C               ADDED COLUMN HEADERS AND DISPLAYED ON
C               EACH PAGE.  ALSO ADDED PAGE MARKERS.
C           8 MAY 1992 JON BAKER
C               SET HELP DEFAULT IN .CLD FILE AND NOT SOURCE
C          31 AUG 1992 JON BAKER        (OUT_INFO, GET_INFO)
C               ADD HOOK FOR LIST CAPABILITY.
C          15 JAN 1993 JON BAKER
C               ADD LOGICAL NAME TRANSLATION AND DISTRIBUTION LISTS
C          14 MAY 1993 JON BAKER
C               ADD DISUSER STATUS
C          21 DEC 1993 JON BAKER & RICARDO DEL CUETO   (HEADER)
C               ADD CHECKING OF SYS$NODE LOGICAL IF SCSNODE SYSGEN PARAM
C               NOT USED (BUT YOU SHOULD BE USING!!).  THANKS FOR SOME OF 
C               THE CODING ON THAT ROUTINE RICARDO.  =)
C          22 DEC 1993 JON BAKER
C               PROVIDE SWITCH TO DISPLAY EITHER OWNER OR ACCOUNT FIELD
C               FROM SYSUAF.DAT
C          22 DEC 1993 JON BAKER
C               ENABLE A FULL TYPE QUALIFIER
C          22 DEC 1993 JON BAKER
C               DISPLAY LAST LOGIN TIME WITH /FULL QUALFIER
C          23 DEC 1993 JON BAKER
C               DISPLAY DAY OF WEEK WITH /FULL QUALIFIER, ADD DAY_O_WEEK
C               SUBROUTINE
C          23 DEC 1993 JON BAKER
C               CLEAN UP DISPLAY FOR EASIER READABILITY
C          31 JAN 1994 JON BAKER
C               FIX PROBLEM OF NOT USING A QUALIFIER FOR TYPE OF REPORT OR
C               SUPPLYING A USER/INPUT FILE.
C          04 FEB 1994 JON BAKER
C               LOGICAL NAME TRANSLATION CLEANUP.  FIX TRANSLATION OF
C               SYSUAF (STATUS IS 0, THOUGH INFORMATION IS RETURNED).
C          22 JUL 1994 JON BAKER
C               PROPER FIX FOR LOGICAL NAME TRANSLATION RETURN VALUES.
C               FORGOT $SSDEF INCLUDE FILE.
C  2.5     28 OCT 1994 JON BAKER
C               FIX ERROR MESSAGING
C          31 OCT 1994 JON BAKER
C               SET UP FOR 'GROUP' PRIVILEGE TO READ USERS IN SAME GROUP
C          10 MAY 1995 JON BAKER
C               ADD IN THE USAGE OF NONINTERACTIVE LOGIN
C               FIX SECURITY HOLE WHERE UNPRIV'ED USERS COULD SEE ANYONE
C           9 APR 1996 JON BAKER
C               FIX LOGIC WHEN USING LOGICALS FOR USER PROMPTING
C          16 APR 1996 JON BAKER
C               FIX OUTPUT DISPLAY FOR /BY_GROUP.  WAS NOT PUSHING <FF>
C               WHEN NEW GROUP AND PREVIOUS USER DID NOT HAVE LOGIN
C               AND HAD NEVER LOGGED IN
C  3.0     29 DEC 1997 JON BAKER
C               ALLOW COMMENTS VIA (!) WITHIN DISTRIBUTION FILES
C          08 JAN 1998 JON BAKER
C               ALLOW USE OF LOGICAL USERNAMES IN DISTRIBUTION FILES
C          29 JAN 1998 JON BAKER     (MAIN,GET_SYSUAF,BANNER,EXIT_HANDLER)
C               ADD /SYSUAF QUALIFIER TO CHANGE SYSUAF.DAT FILES.  MOVE
C               CODE TO SUBROUTINE SYSUAF.  ADD EXIT_HANDLER ROUTINE TO
C               CLEANUP
C          30 JAN 1998 JON BAKER
C               USE CASE INSENSITIVE GROUP FIELD.  WILL FIX SORTING PROBLEM
C               ON MIXED-CASE SYSUAF ENTRIES.
C          04 FEB 1998 JON BAKER
C               FIX PAGE SPACING ANNOMOLY.
C          04 AUG 1998 JON BAKER
C               MODULARIZE CODE FOR MAINTAINABILITY AND ENHANCEMENTS.
C               GET_LIST, GET_USERS, BY_USER, BY_GROUP, ONE_GROUP
C          06 AUG 1998 JON BAKER
C               MOVE MAX_LINES FROM 62 TO 60 SINCE SOME OUTPUTS COULD CAUSE
C               FORM FEED TO BE PUT ONTO NEXT PAGE THEREBY PUTTING BLANK
C               PAGE IN HARDCOPY OUTPUT.
C          11 AUG 1998 JON BAKER
C               MAKE ACCOUNT COMPARISONS CASE INSENSITIVE TO GROUP PRIVILEGE
C               ACCESS
C          12 AUG 1998 JON BAKER
C               IF USING /ACCOUNT, COMPARE WITH PROPER FIELDS
C
C        LANGUAGE
C          FORTRAN 77
C        PURPOSE
C          TO FIGURE THE LAST TIME A USER LOGGED IN AND HOW MANY DAYS IT HAS
C          BEEN.
C        DESCRIPTION
C          USE OF SYSTEM ROUTINES TO GET INFORMATION FROM THE UAF FILES.
C          IF A USER HAS NOT LOGGED IN, RMS SERVICES ARE USED TO EXTRACT
C          THE CREATION DATE FROM THE USER'S DEFAULT DIRECTORY.  (ONLY
C          WAY I COULD THINK OF TO FIND WHEN A USER WAS ADDED SINCE THE
C          DIRECTORY WAS ADDED AT THE SAME TIME.  THERE IS A PROBLEM WITH
C          THIS IF MULTIPLE USERS LOG INTO A SPECIAL DEFAULT DIRECTORY.)
C
C        SUBROUTINES AND FUNCTIONS
C    S     BY_GROUP    : INFORMATION ABOUT ALL GROUPS, BY GROUP
C    S     BY_USER     : INFORMATION ABOUT ALL USERS, BY USERS
C    S     COMPRESS    : COMPRESSES STRING
C    F     CREOPEN     : USEROPEN ROUTINE FOR RMS SERVICES TO EXTRACT CREATION
C                        DATE OF A DIRECTORY
C    S     DAY_O_WEEK  : RETURN SUNDAY-SATURDAY TYPE DATE
C    S     EXIT_HANDLER: CLEANUP UPON IMAGE EXIT
C    S     GET_INFO    : GETS INFORMATION FROM UAF FILE
C    F     GET_LIST    : OPEN LIST FILE IF QUALIFIER USED
C    S     GET_PRV     : CHECKS NECESSARY PRIVS AND SETS LOGICALS
C    S     GET_SYSUAF  : DETERMINE APPROPRIATE SYSUAF FILE TO USE
C    S     GET_UAF     : GETS LIST OF USERS AND THEIR ACCOUNTS FROM UAF FILE
C    S     GET_USERS   : INFORMATION ABOUT 1 USER OR DISTRIBUTION FILE
C    S     HEADER      : DISPLAY PAGE HEADER
C    F     LENGTH      : RETURNS LENGTH OF A STRING
C    F     NOUSE       : GETS CREATION DATE OF DIRECTORY OF ACCOUNTS NEVER USED
C    S     ONE_GROUP   : GET INFO ON ONE GROUP
C    F     OUT_INFO    : DISPLAYS OUTPUT OF INFORMATION
C    S     SORT_UAF    : SORTS LIST OF USERS BY ACCOUNT
C
C        GLOSSARY
C          AGROUP      : IS THERE A GROUP TO SEARCH FOR???
C          AUSER       : IS THERE A USER TO SEARCH FOR??
C          BYGROUP     : SORT INFORMATION BY GROUP (ALL) ??
C          BYUSER      : SORT INFORMATION BY USER (ALL) ??
C          DATE        : TODAY'S CHARACTER DATE
C          DAYS        : DAY OFFSET PROVIDED??
C          FF          : FORM FEED
C          FOUND       : GROUP FOUND??
C          GROUP       : GROUP TO REPORT ON
C          GROUP_LEN   : LENGTH OF GROUP
C          HELP_FILE   : HELP FILE
C          I           : CONTROL VARIABLE
C          INSTALLED   : INSTALLATION CHECK FOR SYSPRV
C          J           : CONTROL VARIABLE
C          K           : CONTROL VARIABLE
C          CLILEN      : LENGTH OF CLI$GET_VALUE VARIABLES
C          LINES       : NUMBER OF LINES ON CURRENT PAGE
C          LIST        : LOGICAL FOR LISTING
C          MAX_LINES   : MAXIMUM LINES PRINTED ON A PAGE
C          MULTI       : MULTI USER LISTING
C          OFFSET      : DAY OFFSET
C          OUT         : NAME OF OUTPUT FILE
C          OUTPUT      : INFORMATION DISPLAYED ON THIS USER??
C          PAGE        : PAGE NUMBERING
C          PHONEFILE   : LIST DATABASE FILE
C          PRIV_GROUP  : GROUP PRIV LOGICAL
C          PRIV_SYSPRV : SYSPRV PRIV LOGICAL
C          STATUS      : RETURN VARIABLE
C          SYSUAF      : SYSTEM USER AUTHORIZATION FILE TO USE
C          TEMP        : TEMPORARY STORAGE VARIABLE
C          TODAY       : TODAY'S INTEGER DATE
C          UAF         : RECORD OF UAF LISTING
C          UNT         : OUTPUT UNIT
C          USER        : USER NAME 
C          USER_GROUP  : EXECUTOR'S GROUP
C
C        INCLUDES
C
         INCLUDE 'UAFDEF.INC /NOLIST'
         INCLUDE '($LNMDEF)'
         INCLUDE '($SSDEF)'
         INCLUDE '($SYSSRVNAM)'
C
C        FORMATS
C
  100    FORMAT(I4)
  120    FORMAT(X,'%LAST-E-NOSUCHGROUP, No such group -  ',A)
  170    FORMAT(X,'%LAST-F-INSPRIV, Insufficient privilege for ',
     1          'attempted operation')
  171    FORMAT(X,'%LAST-I-NOTINST, LAST not installed with SYSPRV')
  300    FORMAT('$Enter username:  ')
  305    FORMAT(A)
  500    FORMAT(' LAST was written and conceived by Jonathan C. Baker')
  501    FORMAT(' using the FORTRAN programming language.  Questions,')
  502    FORMAT(' problems or suggestions can be addressed to Jon')
  503    FORMAT(' at the following address, phone or internet address:')
  504    FORMAT('       Naval Surface Warfare Center')
  505    FORMAT('       Code N83, Bldg 1510')
  509    FORMAT('       17320 Dahlgren Rd')
  506    FORMAT('       Dahlgren, VA 22448')
  507    FORMAT('       540-653-8705')
  508    FORMAT('       INTERNET: jbaker@nswc.navy.mil')
C
C        STRUCTURES 
C
         STRUCTURE  /ITM_LIST/
           UNION
             MAP
               INTEGER*2    BUFFER_LENGTH, CODE
               INTEGER*4    BUFFER_ADDRESS, RETLEN_ADDRESS
             END MAP
             MAP
               INTEGER*4    END_OF_LIST
             END MAP
           END UNION
         END STRUCTURE
C
C        DECLARE VARIABLES
C
         INTEGER*4     TODAY, CLI$GET_VALUE, CLILEN, UNT, 
     1                 OFFSET, STATUS, GROUP_LEN, PAGE, 
     2                 LENGTH, I, J, MAX_LINES, LINES
         CHARACTER*1   FF
         CHARACTER*4   TEMP
         CHARACTER*12  USER, USER_NAME
         CHARACTER*23  DATE
         CHARACTER*32  GROUP, USER_GROUP
         CHARACTER*50  OUT
         CHARACTER*255 HELP_FILE, PHONEFILE, USERS, SYSUAF
         LOGICAL       DAYS, BYUSER, BYGROUP, AGROUP, AUSER,
     1                 CLI$PRESENT, FOUND, OUT_INFO, OUTPUT, LIST,
     2                 PRIV_SYSPRV, PRIV_GROUP, INSTALLED, GET_LIST
C
C        COMMONS
C
         COMMON /BOOLEAN/ BYUSER, BYGROUP, AGROUP
         COMMON /LISTING/ LIST, PHONEFILE
         COMMON /PRIVS/ PRIV_SYSPRV, PRIV_GROUP, USER_GROUP, 
     1                  USER_NAME, INSTALLED
         COMMON /SYSFILE/ SYSUAF
         COMMON /OUTDEV/ UNT
         COMMON /LINEINFO/ MAX_LINES, FF
C
C        INITIALIZE VARIABLES
C
         FF = CHAR(12)
         MAX_LINES = 60
         LINES = 0

         CALL GET_PRV ()
C
C        DETERMINE OUTPUT DEVICE
C
         IF(CLI$PRESENT('OUTPUT'))THEN
           UNT = 10
           STATUS = CLI$GET_VALUE('OUTPUT', OUT, CLILEN)
           OPEN(UNIT=UNT,
     1          FILE=OUT(1:CLILEN),
     2          STATUS='NEW',
     3          CARRIAGECONTROL='LIST')
         ELSE
           UNT = 6
         ENDIF 
C
C        DISPLAY ABOUT INFO
C
         IF (CLI$PRESENT('ABOUT')) THEN
           WRITE (UNT,*) ' '
           WRITE (UNT,*) '                LAST 3.0'
           WRITE (UNT,*) ' '
           WRITE (UNT,500) 
           WRITE (UNT,501) 
           WRITE (UNT,502) 
           WRITE (UNT,503) 
           WRITE (UNT,504) 
           WRITE (UNT,505) 
           WRITE (UNT,509) 
           WRITE (UNT,506) 
           WRITE (UNT,507) 
           WRITE (UNT,508) 
           WRITE (UNT,*) ' '
           CALL EXIT
         ENDIF
C
C        RUN HELP IF QUALIFIER IS PRESENT
C
         IF (CLI$PRESENT('HELP')) THEN
           STATUS = CLI$GET_VALUE ('HELP', HELP_FILE, CLILEN)
           CALL LIB$DO_COMMAND(('HELP/NOUSER/NOLIBLIST/LIBRARY=' //
     1                          HELP_FILE(1:CLILEN) // ' LAST'))
         ENDIF
C
C        DETERMINE SYSUAF
C
         CALL GET_SYSUAF ()
C
C        CHECK PRESENCE OF QUALIFIERS AND/OR PARAMETERS
C
         AUSER   = .FALSE.
         STATUS  = CLI$GET_VALUE('P1', USERS, CLILEN)
         J = LENGTH (USERS)
         IF (LENGTH (USERS) .NE. 0) THEN
           DOWHILE (INDEX (USERS, '"') .NE. 0)
             J = INDEX(USERS, '"')
             USERS(J:J) = ' '
           ENDDO
         ENDIF
         CALL COMPRESS (USERS)

         BYGROUP = CLI$PRESENT('BY_GROUP')
         BYUSER  = CLI$PRESENT('ALL_USERS')
         AGROUP  = CLI$PRESENT('GROUP')
         DAYS    = CLI$PRESENT('DAYS')

         IF(LENGTH (USERS) .NE. 0)THEN
           J = LENGTH (USERS)
           AUSER = .TRUE.
         ELSEIF((LENGTH (USERS) .EQ. 0) .AND.
     1          (.NOT. (BYGROUP))    .AND.
     2          (.NOT. (BYUSER))     .AND.
     3          (.NOT. (AGROUP))) THEN
C
C        NO PARAMETERS OR QUALIFIERS PRESENT.  GET A USERNAME
C
           DOWHILE(.NOT. (AUSER))
             IF(LENGTH (USERS) .NE. 0)THEN
               AUSER = .TRUE.
               CALL STR$UPCASE(USERS,USERS)
               CALL COMPRESS (USERS)
               DOWHILE (INDEX (USERS, '"') .NE. 0)
                 J = INDEX(USERS, '"')
                 USERS(J:J) = ' '
               ENDDO
             ELSE
 9000          WRITE(6,300) 
               READ(6,305) USERS
             ENDIF
           ENDDO
         ENDIF
C
C        CONFIRM LIST FILE
C
         LIST = GET_LIST (PHONEFILE)
C
C        GET DATE INFORMATION AND SET UP DAY OFFSET
C
         CALL LIB$DAY(TODAY)
         CALL LIB$DATE_TIME(DATE)
         OFFSET = 0
         IF((.NOT.(AUSER)) .AND. (DAYS))THEN
           STATUS = CLI$GET_VALUE('DAYS', TEMP, CLILEN)
           READ(TEMP(1:CLILEN),100) OFFSET
         ENDIF
C
C        DETERMINE REQUESTED INFORMATION
C
         IF(AUSER)THEN
           CALL GET_USERS (USERS, DATE, TODAY)
         ELSE
C
C        GENERATE LIST BY USER
C
C
C        CHECK FOR SUFFICIENT PRIVILEGES TO RUN PROGRAM
C
           IF(BYUSER)THEN
             IF (.NOT. PRIV_SYSPRV) THEN
               WRITE (*,170)
               CALL EXIT
             ENDIF

             CALL BY_USER (DATE, TODAY, OFFSET)
C
C        GENERATE LIST BY ACCOUNT
C
           ELSEIF(BYGROUP)THEN

             IF (.NOT. PRIV_SYSPRV) THEN
               WRITE (*,170)
               CALL EXIT
             ENDIF

             CALL BY_GROUP (DATE, TODAY, OFFSET)
C
C        GET INFORMATION OF A SINGLE GROUP
C
           ELSEIF(AGROUP)THEN

             FOUND = .FALSE.
             STATUS = CLI$GET_VALUE('GROUP', GROUP, CLILEN)
             IF(GROUP(1:1) .EQ. '"')THEN
               GROUP = GROUP(2:CLILEN - 1)
             ENDIF
             CALL STR$UPCASE (GROUP, GROUP)
             CALL COMPRESS (USER)

             IF (.NOT. PRIV_SYSPRV) THEN
               IF ((.NOT. INSTALLED) .AND. PRIV_GROUP) THEN
                 WRITE (*,171)
                 WRITE (*,170)
                 CALL EXIT 
               ENDIF

               IF (.NOT. (PRIV_GROUP .AND. 
     1                   (GROUP .EQ. USER_GROUP))) THEN
                 WRITE (*,170)
                 CALL EXIT 
               ENDIF
             ENDIF

             CALL ONE_GROUP (DATE, TODAY, OFFSET, GROUP)

           ENDIF
C
         ENDIF
C
C        CLOSE OPEN FILES
C
         IF (LIST) THEN
           CLOSE (12)
         ENDIF
         IF (UNT .EQ. 10) THEN
           CLOSE (10)
         ENDIF
C
C        STOP
         END
C
C        END OF MAIN
C
C***************************************************************************
C
         SUBROUTINE BY_GROUP (DATE, TODAY, OFFSET)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          27 JULY 1998
C        PURPOSE
C          BETTER MODULARIZE LAST
C        DESCRIPTION
C          GET AND DISPLAY INFORMATION BY USER GROUP
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            GET_UAF
C            HEADER
C            SORT_UAF
C            OUT_INFO
C 
C        PARAMETERS
C          DATE        : CURRENT DATE
C          OFFSET      : DATE OFFSET
C          TODAY       : TODAY'S INTEGER DATE
C        LOCAL GLOSSARY
C          FF          : FORM FEED
C          GROUP       : CURRENT GROUP
C          I           : CONTROL VARIABLE
C          LINES       : LINES OF OUTPUT
C          MAX_LINES   : MAXIMUM OUTPUT LINES PER PAGE
C          OUTPUT      : STATUS VARIABLE
C          PAGE        : PAGE NUMBER
C          UNT         : OUTPUT UNIT
C          USER        : USER TO GRAB INFO
C
C        INCLUDES
C
         INCLUDE 'UAFDEF.INC /NOLIST'
C
C        DECLARE VARIABLES
C
         INTEGER*4       UNT, MAX_LINES, PAGE, LINES, OFFSET, TODAY, I
         CHARACTER*(*)   DATE
         CHARACTER*1     FF
         CHARACTER*12    USER
         CHARACTER*32    GROUP
         LOGICAL         OUTPUT, OUT_INFO
C
C        COMMONS
C
         COMMON /OUTDEV/ UNT
         COMMON /LINEINFO/ MAX_LINES, FF
C
C        GET UAF INFORMATION AND SORT
C
         CALL GET_UAF (UAF)
         CALL SORT_UAF (UAF)
C
C        PRINT HEADER
C
         PAGE = 1
         CALL HEADER(DATE,OFFSET,PAGE,LINES)
         OUTPUT = .FALSE.
C
C        LOOP THROUGH LIST, PULLING MATCHING ACCOUNT NAMES TO GET THE USER'S
C        DATA
C
         GROUP = UAF.ACCOUNT(1)
         DO 1050 I = 1,UAF.NUM_USERS
           IF (.NOT.(GROUP .EQ. UAF.ACCOUNT(I))) THEN
C
C        NEW ACCOUNT, THEREFORE NEW PAGE AND PRINT HEADER
C
             WRITE(UNT,*) FF
             PAGE = 1
             CALL HEADER(DATE,OFFSET,PAGE,LINES)
C
             GROUP = UAF.ACCOUNT(I)
           ENDIF
C
C        TEST FOR NEW PAGE
C
           IF(LINES .GE. MAX_LINES)THEN
             PAGE = PAGE + 1
             WRITE(UNT,*) FF
             CALL HEADER(DATE,OFFSET,PAGE,LINES)
           ENDIF
C
C        GET THE INFORMATION
C
           USER = UAF.USER(I)
           OUTPUT = OUT_INFO(USER,OFFSET,TODAY,LINES)
 1050    CONTINUE
C
         RETURN
         END
C
C        END OF BY_GROUP
C
C***************************************************************************
C
         SUBROUTINE BY_USER (DATE, TODAY, OFFSET)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          27 JULY 1998
C        PURPOSE
C          BETTER MODULARIZING LAST PROGRAM
C        DESCRIPTION
C          PROVIDE LAST LOGIN INFORMATION ON LIST OF USERS
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            GET_UAF
C            HEADER
C            OUT_INFO
C
C        PARAMETERS
C          DATE        : CURRENT DATE
C          OFFSET      : DATE OFFSET
C          TODAY       : TODAY'S INTEGER DATE
C        LOCAL GLOSSARY
C          FF          : FORM FEED
C          I           : CONTROL VARIABLE
C          LINES       : LINES ON CURRENT PAGE
C          MAX_LINES   : MAXIMUM LINES OF OUTPUT PER PAGE
C          OUTPUT      : STATUS VARIABLE
C          PAGE        : PAGE NUMBER
C          USER        : USER TO GRAB INFO FOR
C
C        INCLUDES
C
         INCLUDE 'UAFDEF.INC /NOLIST'
C
C        DECLARE VARIABLES
C
         INTEGER*4      PAGE, I, MAX_LINES, TODAY, LINES, OFFSET, UNT
         CHARACTER*(*)  DATE
         CHARACTER*1    FF
         CHARACTER*12   USER
         LOGICAL        OUT_INFO, OUTPUT
C
C        COMMONS
C
         COMMON /OUTDEV/ UNT
         COMMON /LINEINFO/ MAX_LINES, FF
C
C        GENERATE LIST OF USERS
C
         CALL GET_UAF (UAF)
C
C        PRINT HEADER
C
         LINES = 0
         PAGE = 1
         CALL HEADER (DATE, OFFSET, PAGE, LINES)
C
C        GET THE USER'S DATA
C
         DO 1000 I = 1,UAF.NUM_USERS

           USER = UAF.USER(I)
C
C        TEST FOR NEW PAGE
C
           IF(LINES .GE. MAX_LINES)THEN
             PAGE = PAGE + 1
             WRITE(UNT,*) FF
             CALL HEADER (DATE, OFFSET, PAGE, LINES)
           ENDIF

           OUTPUT = OUT_INFO (USER, OFFSET, TODAY, LINES)

 1000    CONTINUE
         RETURN
         END
C
C        END BY_USER
C
C*****************************************************************************
C
         SUBROUTINE COMPRESS (STR)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          11 JAN 1991
C        PURPOSE
C          COLLAPSE A STRING
C        DESCRIPTION
C          TAKE OUT DOUBLE OCCURANCES OF SPACES, TAKE OUT TABS, TAKE OUT
C          LEADING BLANKS AND SPACES AND ASSURE THAT THERE IS A SPACE AFTER
C          A COMMA
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            LENGTH
C
C        PARAMETERS
C          STR     : STRING TO COLLAPSE
C        LOCAL GLOSSARY
C          BLANK   : A BLANK CHARACTER
C          I       : CONTROL VARIABLE
C          J       : CONTROL VARIABLE
C          SKIP    : SHOULD NEXT BLANK/TAB BE SKIPPED??
C          STR_LEN : LENGTH OF STR
C          TAB     : A TAB CHARACTER
C          TEMP    : TEMPORARY STORAGE VARIABLE
C           
C        DECLARE VARIABLES
C
         INTEGER        STR_LEN, I ,LENGTH, J
         CHARACTER*(*)  STR
         CHARACTER*1    BLANK, TAB
         CHARACTER*255  TEMP
         LOGICAL        SKIP
C
C        INITIALIZE VARIABLES
C
         BLANK = CHAR(32)
         TAB = CHAR(9)
         STR_LEN = LENGTH (STR)

         DO 1000 I = 1,255
           TEMP(I:I) = BLANK
 1000    CONTINUE

         SKIP = .FALSE.
         J = 1
C
C        SKIP OVER LEADING BLANKS AND TABS
C
         I = 1
         DOWHILE ((I .LE. STR_LEN) .AND.
     1            ((STR(I:I) .EQ. BLANK) .OR.
     2             (STR(I:I) .EQ. TAB)))
           I = I + 1
         ENDDO
C
C        COMPRESS
C
         DOWHILE (I .LE. STR_LEN)
C
C        SKIP OVER NECESSARY BLANKS AND TABS
C
           IF ((STR(I:I) .EQ. BLANK) .OR.
     1         (STR(I:I) .EQ. TAB)) THEN
             IF (.NOT. (SKIP)) THEN
               SKIP = .TRUE.
               TEMP(J:J) = BLANK
               J = J + 1
             ENDIF
           ELSE
C
C        PUT CHARACTER INTO TEMP STRING
C
             SKIP = .FALSE.
             TEMP(J:J) = STR(I:I)
             J = J + 1
             IF (STR(I:I) .EQ. ',') THEN
               TEMP(J:J) = BLANK
               J = J + 1
               SKIP = .TRUE.
             ENDIF
           ENDIF
           I = I + 1
         ENDDO
C
C        REPLACE COMPRESSED STRING INTO STR
C
         DO 1050 I = 1,LEN(STR)
           STR(I:I) = TEMP(I:I)
 1050    CONTINUE
C
         RETURN
         END
C
C        END OF COMPRESS
C
C***************************************************************************
C
         INTEGER*4 FUNCTION CREOPEN(FAB,RAB)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          8 JANUARY 1990
C        PURPOSE
C          EXTRACT CREATION DATE FROM DIRECTORY FILE
C        DESCRIPTION
C          USE RMS SERVICES THROUGH USEROPEN.
C        COMMUNICATIONS
C          CALLS FROM
C            NOUSE
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          FAB      : FAB FOR DIRECTORY FILE
C          RAB      : RAB FOR DIRECTORY FILE
C        LOCAL GLOSSARY
C          CDATE    : CREATION DATE
C     
C        INCLUDED
C
         INCLUDE '($FABDEF)'
         INCLUDE '($RABDEF)'
         INCLUDE '($XABDEF)'
         INCLUDE '($XABDATDEF)'
C
C        STRUCTURE
C
         STRUCTURE  /MYXAB/
           UNION
             MAP
               RECORD  /XABDEF/  XAB
             END MAP
             MAP
               RECORD  /XABDATDEF/  DAT
             END MAP
           END UNION
         END STRUCTURE
C
C        DECLARE RECORDS
C
         RECORD /FABDEF/ FAB, /RABDEF/ RAB, /MYXAB/ XABDAT
C
C        DECLARE VARIABLES
C
         INTEGER*4  SYS$OPEN, SYS$CONNECT, CDATE(2)
C
C        COMMON
C 
         COMMON /DATETIME/ CDATE
C
C        SET FILE ACCESS TO 'GET' WHICH IS 'READONLY'.
C
         FAB.FAB$B_FAC = FAB$M_GET
C
C        INITIALIZE XABDAT STRUCTURE
C
         XABDAT.XAB.XAB$B_COD = XAB$C_DAT
         XABDAT.XAB.XAB$B_BLN = XAB$C_DATLEN
         XABDAT.XAB.XAB$L_NXT = FAB.FAB$L_XAB
         FAB.FAB$L_XAB = %LOC(XABDAT)
C
C        OPEN THE FILE AND CONNECT TO IT
C
         CREOPEN = SYS$OPEN(FAB)
         IF (.NOT. CREOPEN) THEN
           RETURN
         ENDIF

         CREOPEN = SYS$CONNECT(RAB)
         IF (.NOT. CREOPEN) THEN
           RETURN
         ENDIF
C
C        PEEL OFF CREATION DATE
C
         CDATE(1) = XABDAT.DAT.XAB$Q_CDT(1)
         CDATE(2) = XABDAT.DAT.XAB$Q_CDT(2)
C
         RETURN
         END
C
C        END OF CREOPEN
C
C**************************************************************************
C
         SUBROUTINE DAY_O_WEEK (DAYNUM, WEEK_DAY)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          22 DEC 1993
C        PURPOSE
C          RETURN STRING OF DAY OF WEEK
C        DESCRIPTION
C          TRANSLATE DAYNUM TO APPROPRIATE STRING VALUE
C        COMMUNICATIONS
C          CALLS FROM
C            NOUSE
C            OUT_INFO
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          DAYNUM     : NUMBER OF THE WEEK DAY
C          WEEK_DAY   : STRING OF THE WEEK DAY
C        LOCAL GLOSSARY
C          (NONE)
C
C        DECLARE VARIABLES
C
         INTEGER        DAYNUM
         CHARACTER*10   WEEK_DAY
C
         IF (DAYNUM .EQ. 1) THEN
           WEEK_DAY = 'Monday'
         ELSE IF (DAYNUM .EQ. 2) THEN
           WEEK_DAY = 'Tuesday'
         ELSE IF (DAYNUM .EQ. 3) THEN
           WEEK_DAY = 'Wednesday'
         ELSE IF (DAYNUM .EQ. 4) THEN
           WEEK_DAY = 'Thursday'
         ELSE IF (DAYNUM .EQ. 5) THEN
           WEEK_DAY = 'Friday'
         ELSE IF (DAYNUM .EQ. 6) THEN
           WEEK_DAY = 'Saturday'
         ELSE 
           WEEK_DAY = 'Sunday'
         ENDIF
C
         RETURN
         END
C
C        END OF DAY_O_WEEK
C
C**************************************************************************
C
         SUBROUTINE EXIT_HANDLER (CONDITION)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          30 JANUARY 1998
C        PURPOSE
C          CLEANUP UPON EXIT OF PROGRAM
C        DESCRIPTION
C          EXIT HANDLER ROUTINE SETUP VIA DCLEXH TO REMOVE LOGICALS
C          NECESSARY TO PROGRAM EXECUTION.
C
C        COMMUNICATIONS
C          CALLS FROM
C            (EXTERNAL ROUTINE SET IN GET_SYSUAF - CALLED AT EXIT OF IMAGE)
C          CALLS TO
C            LENGTH
C
C        PARAMETERS
C          CONDITION     : EXIT CONDITION (NOT USED AT THIS TIME)
C        LOCAL GLOSSARY
C          STATUS        : STATUS RETURN VARIABLE
C
C        INCLUDES
C
         INCLUDE '($LNMDEF)'
         INCLUDE '($PSLDEF)'
         INCLUDE '($SSDEF)'
         INCLUDE '($SYSSRVNAM)'
C
C        DECLARE VARIABLES
C
         INTEGER*4          CONDITION, STATUS
C
C        REMOVE SYSUAF LOGICAL, THEN LNM$FILE_DEV
C
         STATUS = SYS$DELLNM ('LNM$PROCESS', 
     1                        'SYSUAF', PSL$C_EXEC)

         STATUS = SYS$DELLNM ('LNM$PROCESS_DIRECTORY', 
     1                        'LNM$FILE_DEV', PSL$C_EXEC)
C
         RETURN
         END
C
C        END OF EXIT_HANDLER
C
C***************************************************************************
C
         SUBROUTINE GET_INFO (USER, USERDEV, USERDIR, USERGROUP,
     1                        USERLOG, NETLOG, USERNAME, USERPHONE, 
     2                        FLAGS)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          9 JANUARY 1990
C         31 AUGUST 1992   - JON BAKER
C             ADD HOOK TO LIST.
C        PURPOSE
C          GET INFORMATION REGARDING A SPECIFIC USER
C        DESCRIPTION
C          USE SYSTEM ROUTINES TO GET THE INFORMATION FROM UAF FILES
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          FLAGS      : ACCOUNT FLAGS
C          NETLOG     : NONINTERACTIVE LOGIN
C          USER       : TO TO GET INFO ABOUT
C          USERDEV    : USER DEVICE
C          USERDIR    : USER DIRECTORY
C          USERGROUP  : USER GROUP
C          USERLOG    : LAST LOGGIN TIME
C          USERNAME   : USER'S FULL NAME
C          UERPHONE   : USER'S PHONE NUMBER
C        LOCAL GLOSSARY
C          DEV_LEN    : LENGTH OF DEV_LEN
C          DIR_LEN    : LENGTH OF DIRECTORY
C          GROUP      : TEST VARIABLE  (USED FOR LIST PROGRAM)
C          GROUP_LEN  : LENGTH OF USERGROUP
C          I          : CONTROL VARIABLE
C          LIST       : LISTING REQUIRED LOGICAL
C          LOG_LEN    : LENGTH OF LOG  
C          NAME       : TEST VARIABLE
C          PHONEFILE  : LISTING FILE
C          STATUS     : RETURN VARIABLE FOR SYSTEM CALL
C
C        INCLUDES
C
         INCLUDE        '($UAIDEF)'
C
C        FORMATS
C
  120    FORMAT(X'%LAST-F-PROCERR, Error processing LIST file.')
  200    FORMAT(X,A12,3X,A30,3X,A15,3X,A14)
C
C        DECLARE STRUCTURES AND RECORDS
C
         STRUCTURE      /ITMLST/
           UNION
             MAP
               INTEGER*2  BUFLEN
               INTEGER*2  ITMCOD
               INTEGER*4  BUFADR
               INTEGER*4  RETADR
             END MAP
             MAP
               INTEGER*4  END_LIST
             END MAP
           END UNION
         END STRUCTURE
C
         RECORD  / ITMLST /  GETUAI_LIST(6)
C
C        DECLARE VARIABLES
C
         INTEGER*4      STATUS, I, LOG_LEN, DEV_LEN, DIR_LEN, GROUP_LEN,
     1                  USERLOG(2), NETLOG(2), SYS$GETUAI, FLAG_LEN, 
     2                  FLAGS
         CHARACTER*(*)  USER
         CHARACTER*(*)  USERDEV
         CHARACTER*(*)  USERDIR
         CHARACTER*(*)  USERGROUP
         CHARACTER*(*)  USERNAME
         CHARACTER*(*)  USERPHONE
         CHARACTER*12   NAME
         CHARACTER*15   GROUP
         CHARACTER*250  PHONEFILE
         LOGICAL        LIST, CLI$PRESENT
C
C        COMMON BLOCK
C
         COMMON /LISTING/ LIST, PHONEFILE
C
C        INTIALIZE ITMLST
C         
         GETUAI_LIST(1).BUFLEN = 8
         GETUAI_LIST(1).ITMCOD = UAI$_LASTLOGIN_I
         GETUAI_LIST(1).BUFADR = %LOC(USERLOG)
         GETUAI_LIST(1).RETADR = %LOC(LOG_LEN)
         IF (CLI$PRESENT('ACCOUNT_FIELD')) THEN
           GETUAI_LIST(2).BUFLEN = 32
           GETUAI_LIST(2).ITMCOD = UAI$_ACCOUNT
           GETUAI_LIST(2).BUFADR = %LOC(USERGROUP)
           GETUAI_LIST(2).RETADR = %LOC(GROUP_LEN)
         ELSE
           GETUAI_LIST(2).BUFLEN = 32
           GETUAI_LIST(2).ITMCOD = UAI$_OWNER
           GETUAI_LIST(2).BUFADR = %LOC(USERGROUP)
           GETUAI_LIST(2).RETADR = %LOC(GROUP_LEN)
         ENDIF

         GETUAI_LIST(3).BUFLEN = 32
         GETUAI_LIST(3).ITMCOD = UAI$_DEFDEV
         GETUAI_LIST(3).BUFADR = %LOC(USERDEV)
         GETUAI_LIST(3).RETADR = %LOC(DEV_LEN)
         GETUAI_LIST(4).BUFLEN = 64
         GETUAI_LIST(4).ITMCOD = UAI$_DEFDIR
         GETUAI_LIST(4).BUFADR = %LOC(USERDIR)
         GETUAI_LIST(4).RETADR = %LOC(DIR_LEN)
         GETUAI_LIST(5).BUFLEN = 4
         GETUAI_LIST(5).ITMCOD = UAI$_FLAGS
         GETUAI_LIST(5).BUFADR = %LOC(FLAGS)
         GETUAI_LIST(5).RETADR = %LOC(FLAG_LEN)
         GETUAI_LIST(6).BUFLEN = 8
         GETUAI_LIST(6).ITMCOD = UAI$_LASTLOGIN_N
         GETUAI_LIST(6).BUFADR = %LOC(NETLOG)
         GETUAI_LIST(6).RETADR = %LOC(LOG_LEN)
         GETUAI_LIST(7).END_LIST = 0
C
C        CLEAR CHARACTER ARRAYS
C
         USERLOG(1) = 0
         USERLOG(2) = 0
         DO 1000 I = 1, 64
           USERDIR(I:I) = ' '
 1000    CONTINUE
         DO 1010 I = 1, 32
           USERDEV(I:I) = ' '
           USERGROUP(I:I) = ' '
 1010    CONTINUE
C
C        GET THE USER INFORMATION FROM THE UAF FILES
C
         STATUS = SYS$GETUAI(,,USER,GETUAI_LIST,,,)
         IF (.NOT. CLI$PRESENT('ACCOUNT_FIELD')) THEN
           USERGROUP = USERGROUP(2:) // ' '
           CALL STR$UPCASE (USERGROUP, USERGROUP)
         ENDIF
C
C        GET THE USER INFORMATION FROM LIST FILES
C
         IF (LIST) THEN
           LEN = LENGTH (USER)
           READ(12,200,KEYID=0,KEY=USER(1:LEN),ERR=9876) 
     1            NAME, USERNAME, GROUP, USERPHONE
           IF (USER .NE. NAME) THEN
 9876        USERPHONE = '(???)???-????  '
             USERNAME = '[**** unknown user name ****] '
           ENDIF
         ENDIF
C
         RETURN
         END
C
C        END OF GET_INFO
C
C*****************************************************************************
C
         LOGICAL FUNCTION GET_LIST (PHONEFILE)
C
C        AUTHOR
C          JONATHAN BAKER
C        DATE
C          09 FEB 1998
C        PURPOSE
C          OPEN LIST DATABASE FILE
C        DESCRIPTION
C          CHECK FOR PARAMETER, READ INPUT AND OPEN FILE
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          (NONE)
C        LOCAL GLOSSARY
C          IOST        : IO RETURN STATUS
C          P_LEN       : LENGTH OF PHONEFILE
C          PHONEFILE   : LISTING FILE
C          STATUS      : RETURN VARIABLE
C
C        FORMATS
C
  200    FORMAT(X,'%LAST-E-UNKLIST, Unknown LIST file')
  210    FORMAT(X,'%LAST-E-LISTERR, Unable to access LIST file')
C
C        DECLARE VARIABLES
C
         INTEGER*4       P_LEN, IOST, STATUS, CLI$GET_VALUE
         CHARACTER*(*)   PHONEFILE
C
         STATUS  = CLI$GET_VALUE('LIST', PHONEFILE, P_LEN)
         IF (P_LEN .GT. 0) THEN
           GET_LIST = .TRUE.
           OPEN(UNIT=12,
     1          FILE=PHONEFILE,
     2          STATUS='OLD',
     3          ORGANIZATION='INDEXED',
     4          FORM='FORMATTED',
     5          RECL=90,
     6          READONLY,
     7          ACCESS='KEYED',
     8          KEY=(2:13:CHARACTER,17:46:CHARACTER,
     9               50:64:CHARACTER),
     A          IOSTAT=IOST,
     B          ERR=1234)
           IF (.FALSE.) THEN
 1234        IF (IOST .EQ. 29) THEN
               WRITE (6,200)
             ELSE
               WRITE (6,210)
             ENDIF
             GET_LIST = .FALSE.
           ENDIF
         ELSE
           GET_LIST = .FALSE.
         ENDIF
C
         RETURN
         END
C
C        END OF GET_LIST
C
C***************************************************************************
C
         SUBROUTINE GET_PRV ()
C
C        AUTHOR
C         JONATHAN C. BAKER
C        DATE
C          21 OCT 1994
C          10 MAY 1995  JON BAKER
C             CHANGED CURPRV TO PROCPRIV.  CURPRIV PICKS UP IMAGPRV WHICH
C             IS NOT DESIREABLE.
C          05 FEB 1998  JON BAKER
C             ADD CHECKS FOR SYSNAM
C        PURPOSE
C          CHECK FOR PROPER PRIVILEGES
C        DESCRIPTION
C          SYSTEM CALLS
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          (NONE)
C        LOCAL GLOSSARY
C          GROUP       : GROUP PRIV
C          INST_SYSNAM : CHECK FOR INSTALLED SYSNAM
C          INST_SYSPRV : CHECK FOR INSTALLED SYSPRV
C          MASK        : PRIV MASK
C          STATUS      : RETURN VARIABLE
C          SYSNAM      : SYSNAM PRIV
C          SYSPRV      : SYSPRV PRIV
C          USER        : EXECUTOR
C          USER_GROUP  : GROUP OF EXECUTING USER
C
C        INCLUDES
C
         INCLUDE '($UAIDEF)'
         INCLUDE '($JPIDEF)'
C
C        DECLARE STRUCTURES AND RECORDS
C
         STRUCTURE      /ITMLST/
           UNION
             MAP
               INTEGER*2  BUFLEN
               INTEGER*2  ITMCOD
               INTEGER*4  BUFADR
               INTEGER*4  RETADR
             END MAP
             MAP
               INTEGER*4  END_LIST
             END MAP
           END UNION
         END STRUCTURE
C
         RECORD  / ITMLST /  GETUAI_LIST(2)
C
C        DECLARE VARIABLES
C
         INTEGER*4       STATUS, LIB$GETJPI, SYS$GETUAI, GROUP_LEN
         CHARACTER*12    USER
         CHARACTER*32    USER_GROUP
         CHARACTER*255   MASK
         LOGICAL         GROUP, SYSPRV, SYSNAM, CLI$PRESENT, 
     1                   INST_SYSNAM, INST_SYSPRV
C
C        COMMON BLOCKS
C
         COMMON /PRIVS/ SYSPRV, GROUP, USER_GROUP, USER, INST_SYSPRV,
     1                  SYSNAM, INST_SYSNAM
C
C        INITIALIZE VARIABLES
C
         SYSPRV      = .FALSE.
         SYSNAM      = .FALSE.
         GROUP       = .FALSE.
         INST_SYSPRV = .FALSE.
         INST_SYSNAM = .FALSE.
         USER_GROUP  = ' '
C
C        CHECK FOR INSTALLED PRIVS
C
         STATUS = LIB$GETJPI (JPI$_IMAGPRIV,,,,MASK,)
         IF (INDEX(MASK,'SYSPRV') .NE. 0) THEN
           INST_SYSPRV = .TRUE.
         ENDIF
         IF (INDEX(MASK,'SYSNAM') .NE. 0) THEN
           INST_SYSNAM = .TRUE.
         ENDIF
C
C        CHECK USER PRIVILEGE STATUS
C
         STATUS = LIB$GETJPI (JPI$_PROCPRIV,,,,MASK,)
         IF (INDEX(MASK,'SYSPRV') .NE. 0) THEN
           SYSPRV = .TRUE.
         ENDIF
         IF (INDEX(MASK,'SYSNAM') .NE. 0) THEN
           SYSNAM = .TRUE.
         ENDIF
         IF (INDEX(MASK,'GROUP') .NE. 0) THEN
           GROUP = .TRUE.
         ENDIF
C
C        GET EXECUTOR'S GROUP
C
         STATUS = LIB$GETJPI (JPI$_USERNAME,,,,USER,)

         IF (CLI$PRESENT('ACCOUNT_FIELD')) THEN
           GETUAI_LIST(1).BUFLEN = 32
           GETUAI_LIST(1).ITMCOD = UAI$_ACCOUNT
           GETUAI_LIST(1).BUFADR = %LOC(USER_GROUP)
           GETUAI_LIST(1).RETADR = %LOC(GROUP_LEN)
         ELSE
           GETUAI_LIST(1).BUFLEN = 32
           GETUAI_LIST(1).ITMCOD = UAI$_OWNER
           GETUAI_LIST(1).BUFADR = %LOC(USER_GROUP)
           GETUAI_LIST(1).RETADR = %LOC(GROUP_LEN)
         ENDIF
         GETUAI_LIST(2).END_LIST = 0

         STATUS = SYS$GETUAI(,,USER,GETUAI_LIST,,,)
         IF (.NOT. CLI$PRESENT('ACCOUNT_FIELD')) THEN
           USER_GROUP = USER_GROUP(2:) // ' '
           CALL STR$UPCASE (USER_GROUP, USER_GROUP)
         ENDIF
C
         RETURN
         END
C
C        END OF GET_PRV
C
C***************************************************************************
C
         SUBROUTINE GET_SYSUAF
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          30 JAN 1998
C          06 FEB 1988  JON BAKER
C               CHECK SYSNAM FOR PROPER USAGE OF /SYSUAF QUALIFIER
C        PURPOSE
C          DETERMINE SYSUAF TO USE
C        DESCRIPTION
C          USE LIST OF CRITERIA AND SETUP COMMON VARIABLE.
C          1.  CHECK /SYSUAF
C          2.  CHECK SYSUAF LOGICAL
C          3.  CHECK SYS$SYSTEM:SYSUAF.DAT
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            LENGTH
C
C        PARAMETERS
C          (NONE)
C        LOCAL GLOSSARY
C          CLILEN      : LENGTH RETURN VARIABLE
C          GROUP       : USER HAS GROUP PRIV
C          I           : CONTROL VARIABLE
C          INST_SYSNAM : PROGRAM INSTALLED WITH SYSNAM PRIV
C          INST_SYSPRV : COMMON BLOCK HOLDER
C          RET_LEN     : RETURN STRING LENGTH
C          RET_STR     : RETURN STRING
C          STATUS      : STATUS RETURN VARIABLE
C          SYSPRV      : COMMON BLOCK HOLDER
C          SYSNAM      : USER HAS SYSNAM PRIV
C          SYSUAF      : SYSUAF FILE TO USE (COMMON)
C          TABLES      : LIST OF LOGICAL TABLES FOR LNM$FILE_DEV
C          TRANSLOG    : ITEM LIST TO PASS TO SYSTEM CALL
C          USER        : COMMON BLOCK HOLDER
C          USER_GROUP  : COMMON BLOCK HOLDER
C
C        FORMATS
C
  100    FORMAT (X,'%LAST-F-NOSYSNAM, SYSNAM privilege needed for ',
     1           'qualifier usage')
  110    FORMAT (X,'%LAST-F-INSTSYSNAM, LAST not installed with',
     1           ' SYSNAM privilege')
C
C        INCLUDES
C
         INCLUDE '($LNMDEF)'
         INCLUDE '($PSLDEF)'
         INCLUDE '($SSDEF)'
         INCLUDE '($SYSSRVNAM)'
C
C        STRUCTURES 
C
         STRUCTURE  /ITM_LIST/
           UNION
             MAP
               INTEGER*2    BUFFER_LENGTH, CODE
               INTEGER*4    BUFFER_ADDRESS, RETLEN_ADDRESS
             END MAP
             MAP
               INTEGER*4    END_OF_LIST
             END MAP
           END UNION
         END STRUCTURE

         STRUCTURE / EXIT_BLOCK /
           INTEGER*4       FORWARD_LINK
           INTEGER*4       HANDLER_ADDR
           INTEGER*4       ARG_COUNT
           INTEGER*4       CONDITION
         END STRUCTURE
C
C        DECLARE VARIALBES
C
         RECORD /EXIT_BLOCK/  EXIT_BLK
         RECORD /ITM_LIST/    TRANSLOG(5)
         INTEGER*4            CLI$GET_VALUE, STATUS, CLILEN, RET_LEN,
     1                        LENGTH, I, EXIT_STATUS
         CHARACTER*12         USER
         CHARACTER*32         USER_GROUP
         CHARACTER*255        SYSUAF, RET_STR, TABLES(4)
         LOGICAL              CLI$PRESENT, SYSPRV, GROUP, 
     1                        INST_SYSPRV, SYSNAM, INST_SYSNAM
         EXTERNAL             EXIT_HANDLER
C
C        COMMON BLOCK
C
         COMMON /SYSFILE/ SYSUAF
         COMMON /PRIVS/ SYSPRV, GROUP, USER_GROUP, USER, INST_SYSPRV,
     1                  SYSNAM, INST_SYSNAM
C
C        SETUP FOR EXIT HANDLER
C
         EXIT_BLK.HANDLER_ADDR = %LOC(EXIT_HANDLER)
         EXIT_BLK.CONDITION    = %LOC(EXIT_STATUS)
         EXIT_BLK.ARG_COUNT    = 1

         STATUS = SYS$DCLEXH( EXIT_BLK )
C
C        SET FILENAME TO APPROPRIATE SYSUAF
C
         IF (CLI$PRESENT('SYSUAF')) THEN
C
C        CHECK FOR AUTHORIZATION TO USE /SYSUAF QUALIFIER
C
           IF (.NOT. SYSNAM) THEN
             IF ((.NOT. INST_SYSNAM) .AND. GROUP) THEN
               WRITE (*,110)
             ELSE
               WRITE (*,100)
             ENDIF

             CALL EXIT
           ENDIF
C
C        USE ALTERNATE SYSUAF
C
           STATUS = CLI$GET_VALUE('SYSUAF',SYSUAF,CLILEN)
C
C        CHECK FOR SYSUAF LOGICAL
C
           TRANSLOG(1).CODE = LNM$_STRING
           TRANSLOG(1).BUFFER_LENGTH = 255
           TRANSLOG(1).BUFFER_ADDRESS = %LOC(RET_STR)
           TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
           TRANSLOG(2).END_OF_LIST = 0

           STATUS = SYS$TRNLNM (,'LNM$SYSTEM_TABLE',SYSUAF(1:CLILEN),,
     1                          TRANSLOG)
           IF (STATUS) THEN
             SYSUAF = RET_STR(1:RET_LEN)
           ENDIF
         ELSE
C
C        USE PRIMARY SYSUAF
C
C        CHECK FOR SYSUAF LOGICAL
C
           TRANSLOG(1).CODE = LNM$_STRING
           TRANSLOG(1).BUFFER_LENGTH = 255
           TRANSLOG(1).BUFFER_ADDRESS = %LOC(RET_STR)
           TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
           TRANSLOG(2).END_OF_LIST = 0

           STATUS = SYS$TRNLNM (,'LNM$SYSTEM_TABLE','SYSUAF',,
     1                          TRANSLOG)
           IF (STATUS) THEN
             SYSUAF = RET_STR(1:RET_LEN)
           ELSE
             SYSUAF = 'SYS$SYSTEM:SYSUAF.DAT'
           ENDIF
         ENDIF
C
C        CHECK TO SEE IF 'SYSUAF.DAT' NEEDS TO BE APPENDED
C
         I = LENGTH (SYSUAF)
         IF ((SYSUAF(I:I) .EQ. ':') .OR. (SYSUAF(I:I) .EQ. ']')) THEN
           SYSUAF = SYSUAF(1:I) // 'SYSUAF.DAT'
         ENDIF
C
C        SETUP SYSAUF LOGICALS TO USE WITH SYS$GETUAI.  USE SYS$CRELNM
C        SO LOGICALS ARE AUTOMATICALLY KILLED WHEN EXECUTION STOPS OF
C        LAST
C
         TABLES(1) = 'LNM$PROCESS'
         TRANSLOG(1).CODE = LNM$_STRING
         TRANSLOG(1).BUFFER_LENGTH = LENGTH(TABLES(1))
         TRANSLOG(1).BUFFER_ADDRESS = %LOC(TABLES(1))
         TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
         TABLES(2) = 'LNM$JOB'
         TRANSLOG(2).CODE = LNM$_STRING
         TRANSLOG(2).BUFFER_LENGTH = LENGTH(TABLES(2))
         TRANSLOG(2).BUFFER_ADDRESS = %LOC(TABLES(2))
         TRANSLOG(2).RETLEN_ADDRESS = %LOC(RET_LEN)
         TABLES(3) = 'LNM$GROUP'
         TRANSLOG(3).CODE = LNM$_STRING
         TRANSLOG(3).BUFFER_LENGTH = LENGTH(TABLES(3))
         TRANSLOG(3).BUFFER_ADDRESS = %LOC(TABLES(3))
         TRANSLOG(3).RETLEN_ADDRESS = %LOC(RET_LEN)
         TABLES(4) = 'LNM$SYSTEM'
         TRANSLOG(4).CODE = LNM$_STRING
         TRANSLOG(4).BUFFER_LENGTH = LENGTH(TABLES(4))
         TRANSLOG(4).BUFFER_ADDRESS = %LOC(TABLES(4))
         TRANSLOG(4).RETLEN_ADDRESS = %LOC(RET_LEN)
         TRANSLOG(5).END_OF_LIST = 0

         STATUS = SYS$CRELNM (,'LNM$PROCESS_DIRECTORY','LNM$FILE_DEV',
     1                        PSL$C_EXEC, TRANSLOG)

         IF (.NOT. STATUS) THEN
           CALL SYS$EXIT( %VAL( STATUS ))
         ENDIF

         TRANSLOG(1).CODE = LNM$_STRING
         TRANSLOG(1).BUFFER_LENGTH = LENGTH(SYSUAF)
         TRANSLOG(1).BUFFER_ADDRESS = %LOC(SYSUAF)
         TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
         TRANSLOG(2).END_OF_LIST = 0
         STATUS = SYS$CRELNM (,'LNM$PROCESS', 'SYSUAF',
     1                        PSL$C_EXEC, TRANSLOG)

         IF (.NOT. STATUS) THEN
           CALL SYS$EXIT( %VAL( STATUS ))
         ENDIF
C
         RETURN
         END
C
C        END OF GET_SYSUAF
C
C***************************************************************************
C
         SUBROUTINE GET_UAF (UAF)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          10 JAN 1990
C           3 APR 1996   JON BAKER
C                        EXTEND ERROR PROCESSING OF SYSUAF FILE
C          30 JAN 1998   JON BAKER
C                        SET ACCOUNT VARIABLE TO UPPERCASE.  WILL FIX
C                        SORTING PROBLEMS WITH MIXED CASE ENTRIES IN SYSUAF
C        PURPOSE
C          GET ALL THE USERNAMES AND ACCOUNTS
C        DESCRIPTION
C          OPEN UP SYSUAF.DAT AND READ THE INFORMATION THAT IS NEEDED
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C 
C        PARAMETERS
C          UAF       : RECORD OF UAF INFORMATION
C        LOCAL GLOSSARY
C          RET_LEN   : RETURN LENGTH OF RET_STR
C          SYSUAF    : SYSTEM USER AUTHORIZATION FILE
C
C
C        INCLUDES
C
         INCLUDE 'UAFDEF.INC /NOLIST'
         INCLUDE '($LNMDEF)'
         INCLUDE '($SSDEF)'
C
C        FORMATS
C
  100    FORMAT()
  200    FORMAT(4X,A12,69X,A20) 
  201    FORMAT(4X,A12,36X,A20)
C
C        STRUCTURES 
C
         STRUCTURE  /ITM_LIST/
           UNION
             MAP
               INTEGER*2    BUFFER_LENGTH, CODE
               INTEGER*4    BUFFER_ADDRESS, RETLEN_ADDRESS
             END MAP
             MAP
               INTEGER*4    END_OF_LIST
             END MAP
           END UNION
         END STRUCTURE
C
C        DECLARE VARIABLES
C
         INTEGER            IOS
         CHARACTER*255      SYSUAF
         LOGICAL            CLI$PRESENT
C
C        COMMON BLOCK
C
         COMMON /SYSFILE/ SYSUAF
C
C        OPEN SYSUAF.DAT FILE AND READ THE RECORDS OF USERS
C
         OPEN(UNIT=1,
     1        ACCESS = 'SEQUENTIAL',
     2        FILE = SYSUAF,
     3        IOSTAT = IOS,
     4        READONLY,
     5        SHARED,
     6        STATUS = 'OLD',
     7        ORGANIZATION = 'INDEXED',
     8        ERR=9000)
C
C        SKIP THE FIRST (UNUSED) RECORD AND INITIALIZE THE COUNTER
C
C         READ (1,100)             ! USED NOW
         UAF.NUM_USERS = 1
C
C        LOOP UNTIL END OF FILE
C
         IF (CLI$PRESENT('ACCOUNT_FIELD')) THEN          ! READ ACCOUNT FIELD
           DOWHILE (.TRUE.)
             READ(1,FMT=201,END=9090) UAF.USER(UAF.NUM_USERS),
     1                                UAF.ACCOUNT(UAF.NUM_USERS)
             CALL STR$UPCASE (UAF.ACCOUNT(UAF.NUM_USERS),
     1                        UAF.ACCOUNT(UAF.NUM_USERS))
             UAF.NUM_USERS = UAF.NUM_USERS + 1
           ENDDO
         ELSE                                            ! READ OWNER FIELD
           DOWHILE (.TRUE.)
             READ(1,FMT=200,END=9090) UAF.USER(UAF.NUM_USERS),
     1                                UAF.ACCOUNT(UAF.NUM_USERS)
             CALL STR$UPCASE (UAF.ACCOUNT(UAF.NUM_USERS),
     1                        UAF.ACCOUNT(UAF.NUM_USERS))
             UAF.NUM_USERS = UAF.NUM_USERS + 1
           ENDDO
         ENDIF
C
 9090    CLOSE(1)
         UAF.NUM_USERS = UAF.NUM_USERS - 1
C
         IF (.FALSE.) THEN
 9000      WRITE(*,*) '%LAST-F-ERROPEN, Error opening SYSUAF'

           IF ((IOS .EQ. 29) .OR. (IOS .EQ. 42)) THEN
             WRITE(*,*) '-RMS-E-FNF, File not found'
           ELSE
             WRITE(*,*) '-FOR-I-OPENERR, Error number ', IOS
           ENDIF
           CALL EXIT 
         ENDIF
C
         RETURN
	 END
C
C        END OF GET_UAF
C
C*****************************************************************************
C
         SUBROUTINE GET_USERS (USERS, DATE, TODAY)
C
C        AUTHOR
C          JONATHAN BAKER
C        DATE
C          09 FEB 1998
C        PURPOSE
C          GET INFO FOR SINGLE OR DISTRIBUTION LIST
C        DESCRIPTION
C          TEST FOR LOGICALS AND FOLLOW LOOPED LOGIC
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            HEADER
C            OUT_INFO
C
C        PARAMETERS
C          DATE        : CURRENT DATE
C          USERS       : INDIVIDUAL OR DISTRIBUTION LIST
C          TODAY       : TODAY'S INTEGER DATE
C        LOCAL GLOSSARY
C          CLILEN      : RETURN VARIABLE
C          LINES       : LINES OF OUTPUT
C          MULTI       : MULTIPLE USERS SWITCH (DISTRIBUTION FILE)
C          OFFSET      : DATE OFFSET
C          PAGE        : PAGES OF OUTPUT
C          RET_LEN     : RETURN VARIABLE
C          RET_STR     : RETURN STRING
C          STATUS      : STATUS VARIABLE
C          TRANSLOG    : TRANSLATE LOGICAL STRUCTURE
C          UNT         : OUTPUT UNIT
C          USER        : TRANSLATED SINGLE OR DISTRIBUTION OF USER(S)
C
C        INCLUDES
C
C         INCLUDE 'UAFDEF.INC /NOLIST'
         INCLUDE '($LNMDEF)'
         INCLUDE '($SSDEF)'
         INCLUDE '($SYSSRVNAM)'
C
C        FORMATS
C
  305    FORMAT(A)
C
C        STRUCTURES 
C
         STRUCTURE  /ITM_LIST/
           UNION
             MAP
               INTEGER*2    BUFFER_LENGTH, CODE
               INTEGER*4    BUFFER_ADDRESS, RETLEN_ADDRESS
             END MAP
             MAP
               INTEGER*4    END_OF_LIST
             END MAP
           END UNION
         END STRUCTURE
C
C        DECLARE VARIABLES
C
         RECORD /ITM_LIST/    TRANSLOG(2)
         INTEGER*4      STATUS, CLILEN, RET_LEN, UNT, PAGE, LINES,
     1                  OFFSET, TODAY, MAX_LINES
         CHARACTER*(*)  DATE
         CHARACTER*1    FF
         CHARACTER*255  USERS, USER, RET_STR
         LOGICAL        MULTI
C
C        COMMON BLOCK
C
         COMMON /OUTDEV/ UNT
         COMMON /LINEINFO/ MAX_LINES, FF
C
C        CHECK FOR LOGICAL NAMES
C
         MULTI = .FALSE.
         STATUS = 1
         IF (USERS(1:1) .NE. '@') THEN
           TRANSLOG(1).CODE = LNM$_STRING
           TRANSLOG(1).BUFFER_LENGTH = 255
           TRANSLOG(1).BUFFER_ADDRESS = %LOC(RET_STR)
           TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
           TRANSLOG(2).END_OF_LIST = 0
           CLILEN = LENGTH(USERS)

           STATUS = SYS$TRNLNM (,'LNM$DCL_LOGICAL',USERS(1:CLILEN),,
     1                          TRANSLOG)
           IF (.NOT. STATUS) THEN
             USER = USERS(1:CLILEN)
           ELSE
             IF (RET_STR(1:1) .NE. '@') THEN
               USER = RET_STR(1:RET_LEN)
             ELSE
C
C        PRINT HEADER AND PROCESS DISTRIBUTION LIST
C
               MULTI = .TRUE.
               PAGE = 1
               CALL HEADER(DATE,OFFSET,PAGE,LINES)
               OPEN(UNIT=69,FILE=RET_STR(2:RET_LEN),READONLY,
     1              ACCESS='SEQUENTIAL',ERR=9090,IOSTAT=IOS,
     2              STATUS='OLD')
C
C        READ THROUGH FILE OF USERS
C
               DOWHILE (.TRUE.)
                 READ(69,305,END=8000) USER
                 IF (LENGTH(USER) .NE. 0) THEN
                   CALL STR$UPCASE(USER,USER)
                   CALL COMPRESS (USER)
C
                   I = INDEX(USER, '!')
                   IF (I .NE. 0) THEN
                     K = LEN(USER)
                     DO 1220 J = I, K
                       USER(J:J) = ' '
 1220                CONTINUE
                   ENDIF
C
C        CHECK FOR SECONDARY LOGICAL NAMES
C
                   TRANSLOG(1).CODE = LNM$_STRING
                   TRANSLOG(1).BUFFER_LENGTH = 255
                   TRANSLOG(1).BUFFER_ADDRESS = %LOC(RET_STR)
                   TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
                   TRANSLOG(2).END_OF_LIST = 0
                   CLILEN = LENGTH(USER)
                   STATUS = SYS$TRNLNM (,'LNM$DCL_LOGICAL',
     1                              USER(1:CLILEN),,TRANSLOG)
                   IF (STATUS) THEN
                     USER = RET_STR(1:RET_LEN)
                   ENDIF
C
C        TEST FOR NEW PAGE
C
                   IF(LINES .GE. MAX_LINES)THEN
                     PAGE = PAGE + 1
                     WRITE(UNT,*) FF
                     CALL HEADER(DATE,OFFSET,PAGE,LINES)
                   ENDIF

                   OUTPUT = OUT_INFO(USER,OFFSET,TODAY,LINES)
                 ENDIF
               ENDDO
C
C        LET SYSTEM HANDLE FILE ERRORS
C
 8000          IF (.FALSE.) THEN
 9090            IF (IOS .EQ. 29) THEN
                   WRITE (*,*) '%LAST-F-FILENOTFND, File not found'
                 ENDIF
                 CALL EXIT (IOS)
               ENDIF
               IF (LENGTH(USER) .NE. 0) THEN
C
C        TEST FOR NEW PAGE
C
                 IF(LINES .GE. MAX_LINES)THEN
                   PAGE = PAGE + 1
                   WRITE(UNT,*) FF
                   CALL HEADER(DATE,OFFSET,PAGE,LINES)
                 ENDIF
               ENDIF
             ENDIF
           ENDIF
C
C        SINGLE USER
C
           IF (.NOT. MULTI) THEN
             PAGE = -1
             CALL HEADER (DATE,OFFSET,PAGE,LINES)
             OUTPUT = OUT_INFO(USER,OFFSET,TODAY,LINES)
           ENDIF
         ELSE
C
C        PRINT HEADER AND PROCESS DISTRIBUTION LIST
C
           MULTI = .TRUE.
           PAGE = 1
           CALL HEADER(DATE,OFFSET,PAGE,LINES)
           RET_LEN = LENGTH (USERS)
           OPEN(UNIT=69,FILE=USERS(2:RET_LEN),READONLY,
     1              ACCESS='SEQUENTIAL',ERR=9091,IOSTAT=IOS,
     2              STATUS='OLD')
C
C        READ THROUGH FILE OF USERS
C
           DOWHILE (.TRUE.)
             READ(69,305,END=8001) USER
             IF (LENGTH(USER) .NE. 0) THEN
               CALL STR$UPCASE(USER,USER)
               CALL COMPRESS (USER)
C
C        CHECK FOR SECONDARY LOGICAL NAMES
C
               TRANSLOG(1).CODE = LNM$_STRING
               TRANSLOG(1).BUFFER_LENGTH = 255
               TRANSLOG(1).BUFFER_ADDRESS = %LOC(RET_STR)
               TRANSLOG(1).RETLEN_ADDRESS = %LOC(RET_LEN)
               TRANSLOG(2).END_OF_LIST = 0
               CLILEN = LENGTH(USER)
               STATUS = SYS$TRNLNM (,'LNM$DCL_LOGICAL',
     1                            USER(1:CLILEN),,TRANSLOG)
               IF (STATUS) THEN
                 USER = RET_STR(1:RET_LEN)
               ENDIF
C
C        TEST FOR NEW PAGE
C
               IF(LINES .GE. MAX_LINES)THEN
                 PAGE = PAGE + 1
                 WRITE(UNT,*) FF
                 CALL HEADER(DATE,OFFSET,PAGE,LINES)
               ENDIF

               OUTPUT = OUT_INFO(USER,OFFSET,TODAY,LINES)
             ENDIF
           ENDDO
C
C        LET SYSTEM HANDLE FILE ERRORS
C
 8001      IF (.FALSE.) THEN
 9091        IF (IOS .EQ. 29) THEN
               WRITE (*,*) '%LAST-F-FILENOTFND, File not found'
             ENDIF
             CALL EXIT (IOS)
           ENDIF
           IF (LENGTH(USER) .NE. 0) THEN
C
C        TEST FOR NEW PAGE
C
             IF(LINES .GE. MAX_LINES)THEN
               PAGE = PAGE + 1
               WRITE(UNT,*) FF
               CALL HEADER(DATE,OFFSET,PAGE,LINES)
             ENDIF
           ENDIF
         ENDIF
C
         RETURN
         END
C
C        END OF GET_USERS
C
C***************************************************************************
C
         SUBROUTINE HEADER (DATE,OFFSET,PAGE,LINES)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          12 JANUARY 1990
C          21 DECEMBER 1993   - IMPLEMENTED CHECKING SYS$NODE IF SCSNODE
C                               IS NOT USED.  CODE EXTRACTED FROM EXAMPLE
C                               OF THIS PROBLEM CITED BY RICARDO DEL CUETO
C        PURPOSE
C          TO PRINT HEADER INFO
C        DESCRIPTION
C          PRINT HEADER INFO
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C            GET_USERS
C          CALLS TO
C            LENGTH
C
C        PARAMETERS
C          DATE      : TODAY'S DATE
C          LINES     : NUMBER OF LINES PRINTED ON FOR THE PAGE
C          OFFSET    : DAY OFFSET
C          PAGE      : PAGE NUMBER
C        LOCAL GLOSSARY
C          I         : CONTROL VARIABLE
C          NODE_LEN  : LENGTH OF NODE OR SYSTEM
C          NODENAME  : NAME OF CURRENT NODE
C          STATUS    : RETURN VARIABLE
C          SYSTEM    : NAME OF CLUSTER
C          UNT       : OUTPUT UNIT
C
C        FORMATS
C
  100    FORMAT(2X,'LAST LOGIN RESULTS DONE ON  ',A,'  THE DAY OF  ',
     1          A11,'.')
  101    FORMAT(2X,'THE FOLLOWING USERS HAVE NOT USED THEIR ACCOUNTS ',
     1          'FOR AT LEAST ',I4,' DAYS:')
  105    FORMAT(2X,'SYSUAF:  ',A)
  106    FORMAT(11X,A)
  110    FORMAT(70X,'Page ',I4)
  120    FORMAT(42X,'Last Login/',7x,'Days')
  121    FORMAT(1X,'User',10X,'Group',11X,'Disusr',4X,'Creation Date',
     1          3X,'Since Used')
  122    FORMAT(1X,4('-'),10X,5('-'),11X,6('-'),
     1          4X,13('-'),3X,10('-'))
C
C        INCLUDED
C
         INCLUDE   '($SYIDEF)'
         INCLUDE   '($LNMDEF)'
         INCLUDE   '($SSDEF)'
C
C        STRUCTURES
C
         STRUCTURE /ITMLST/
           UNION
             MAP
               INTEGER*2  BUFLEN, ITMCOD
               INTEGER*4  BUFADR, RETADR
             END MAP
             MAP
               INTEGER*4  END_LIST
             END MAP
           END UNION
         END STRUCTURE
C
C        RECORDS
C
         RECORD /ITMLST/ GETSYI_LIST(2)
C
C        DECLARE VARIABLES
C
         INTEGER*4      OFFSET, NODE_LEN, UNT, STATUS, SYS$GETSYIW,
     1                  PAGE, LINES, SYS$TRNLNM, I
         CHARACTER*(*)  DATE
         CHARACTER*15   NODENAME
         CHARACTER*255  SYSUAF
C
C        COMMONS
C
         COMMON /OUTDEV/ UNT
         COMMON /SYSFILE/ SYSUAF
C
C        PRINT OUT THE PAGE NUMBER
C
         LINES = 0
         IF (PAGE .GT. 0) THEN
           IF (PAGE .EQ. 1) THEN
             WRITE(UNT,*) ' '
             LINES = LINES + 1
           ENDIF
           WRITE(UNT,110) PAGE
           WRITE(UNT,*) ' '
           WRITE(UNT,*) ' '
           LINES = LINES + 3
         ENDIF

         IF (PAGE .EQ. 1)THEN
C
C        SET UP ARRAY AND GET SYSTEM INFORMATION
C
           GETSYI_LIST(1).BUFLEN = 15
           GETSYI_LIST(1).ITMCOD = SYI$_NODENAME
           GETSYI_LIST(1).BUFADR = %LOC(NODENAME)
           GETSYI_LIST(1).RETADR = %LOC(NODE_LEN)
           GETSYI_LIST(2).END_LIST = 0
C
           STATUS = SYS$GETSYIW(,,,GETSYI_LIST,,,)
C
           IF (NODE_LEN .LE. 0) THEN
             GETSYI_LIST(1).BUFLEN = 15
             GETSYI_LIST(1).ITMCOD = LNM$_STRING
             GETSYI_LIST(1).BUFADR = %LOC(NODENAME)
             GETSYI_LIST(1).RETADR = %LOC(NODE_LEN)
             GETSYI_LIST(2).END_LIST = 0

             STATUS = SYS$TRNLNM(,'LNM$SYSTEM_TABLE','SYS$NODE:',,
     1                GETSYI_LIST)

             IF (NODE_LEN .LE. 0) THEN
               NODENAME = '$$$$$$'
               NODE_LEN = 6
             ELSE
               I = INDEX (NODENAME, '::')
               IF (I .NE. 0) THEN
                 NODE_LEN = I
               ENDIF
             ENDIF
           ENDIF
C
C        DISPLAY SYSTEM HEADER
C
           WRITE(UNT,100) NODENAME(1:NODE_LEN), DATE(1:11)

           I = LENGTH (SYSUAF)
           WRITE(UNT,105) SYSUAF(1:65)
           LINES = LINES + 2
           IF (I .GT. 65) THEN
             LINES = LINES + 1
             WRITE(UNT,106) SYSUAF(66:130)
           ENDIF
           IF (I .GT. 130) THEN
             LINES = LINES + 1
             WRITE(UNT,106) SYSUAF(131:195)
           ENDIF
           IF (I .GT. 195) THEN
             LINES = LINES + 1
             WRITE(UNT,106) SYSUAF(196:255)
           ENDIF

           WRITE(UNT,*) ' '
           WRITE(UNT,101) OFFSET
           WRITE(UNT,*) ' '
           WRITE(UNT,*) ' '
           LINES = LINES + 4              
         ENDIF
C
C        PRINT OUT COLUMN HEADINGS
C
         WRITE(UNT,120) 
         WRITE(UNT,121)
         WRITE(UNT,122) 
         LINES = LINES + 3
C
         RETURN
         END
C
C        END OF HEADER
C
C*****************************************************************************
C
         INTEGER FUNCTION  LENGTH (STR)
C      
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          5 MARCH 1986
C        PURPOSE
C          TO FIND LENGTH OF A STRING
C        DESCRIPTION
C          FINDS THE LITERAL LENGTH OF THE STRING.  NOT THE CHARACTER
C          STORAGE LENGTH THAT THE SYSTEM ROUTINE "LEN"  PERFORMS
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          STR     : STRING TO GET LENGTH OF 
C        LOCAL GLOSSARY
C          BLANK   : BLANK CHARACTER
C          I       : CONTROL VARIABLE
C          J       : CONTROL VARIABLE
C          NULL    : NULL CHARACTER
C          TAB     : TAB CHARACTER
C
C        DECLARE VARIABLES
C
         CHARACTER*(*) STR
         CHARACTER*1   BLANK, TAB, NULL
         INTEGER       I
C
C        INITIALIZE VARIABLES
C
         BLANK = CHAR(32)
         TAB = CHAR(11)
         NULL = CHAR(0)
C
         I = LEN(STR)
         DOWHILE((I .GE. 1) .AND.
     1           ((STR(I:I) .EQ. BLANK) .OR. 
     2            (STR(I:I) .EQ. NULL)  .OR. 
     3            (STR(I:I) .EQ. TAB)))
           I = I - 1
         ENDDO

         LENGTH = I
C
         RETURN
         END                        
C
C        END OF LENGTH
C
C***************************************************************************
C
         LOGICAL FUNCTION NOUSE(USER, USERDEV, USERDIR, USERGROUP,
     1                          TODAY, OFFSET, LINES, USERNAME, 
     2                          USERPHONE, DISUSER)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          9 JAN 1990
C         31 AUG 1992  JON BAKER
C             ADD HOOK TO LIST.
C         10 MAY 1995  JON BAKER
C             SUPPRESS FULL OUTPUT IF THE USER DIRECTORY DOES NOT MATCH.
C             OTHERWISE IT WILL TELL YOU THE LAST DAY WHICH IS MISLEADING
C             IF NO LOGINS HAVE OCCURRED.
C        PURPOSE
C          TO GET THE CREATION DATE FROM THE DEFAULT DIRECTORY 
C        DESCRIPTION
C          USE RMS SERVICES ON A USEROPEN
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            DAY_O_WEEK
C            LENGTH
C
C        PARAMETERS
C          DISUSER    : FLAG FOR DISUSER'D ACCOUNT
C          LINES      : NUMBER OF LINES OUTPUT
C          OFFSET     : DAY OFFSET
C          TODAY      : DELTA TIME FOR TODAY
C          USER       : USERNAME
C          USERDEV    : USER DEVICE
C          USERDIR    : USER DIRECTORY
C          USERGROUP  : USER GROUP
C          USERNAME   : USER'S ACTUAL NAME
C          USERPHONE  : USER'S WORK PHONE
C        LOCAL GLOSSARY
C          ABORT_FULL : SKIP A FULL DISPLAY (IN CASES OF NOLOGIN & NO DIR)
C          CDATE      : CREATION DATE
C          DAY        : USERLOG IN DELTA TIME
C          DAYNUM     : INTEGER DAY OF WEEK
C          DEV_LEN    : DEVICE LENGTH
C          DIFF       : DIFFERENCE IN NUMBER OF DAYS BETWEEN TODAY'S DATE
C                       AND LAST LOGGIN DATE
C          DIR_LEN    : DIRECTORY LENGTH
C          FILENAME   : HOLDS PROPER DIRECTORY STRUCTURE
C          FILE_LEN   : FILENAME LENGTH
C          I          : CONTROL VARIALBE
C          PERIOD     : IS PRESENT CHARACTER A PERIOD???
C          TEMP_TIME  : ABSOLUTE TIME STRING
C          UNT        : OUTPUT UNIT
C          USERLOG    : NEW USERLOG INFO
C          WHEN       : DATE DIRECTORY WAS CREATED
C          WHEN_DAY   : STRING DAY OF WEEK
C          WHEN_TIME  : TIME OF LAST LOGIN
C
C         EXTERNALS
C
          EXTERNAL CREOPEN
C
C        FORMATS
C
  129    FORMAT(1X,A12,2X,A15,2X,A3,7X,A12,2X,I4,
     1          ' DAYS  **NVR USED**')
  130    FORMAT(15X,A30,16X,A14)
  155    FORMAT(1X,A12,2X,A15,2X,A3,3X,
     1          'directory does not match UAF **NVR USED**',I4)
  160    FORMAT(15X,'Date was on a  ',A10,2X,A11)
C
C        DECLARE VARIABLES
C
         INTEGER*4      TODAY, I, FILE_LEN, DIR_LEN, DEV_LEN, CDATE(2),
     1                  UNT, DIFF, DAY, USERLOG, OFFSET, LINES, DAYNUM
         CHARACTER*(*)  USER
         CHARACTER*(*)  USERDEV
         CHARACTER*(*)  USERDIR
         CHARACTER*(*)  USERGROUP
         CHARACTER*(*)  USERNAME
         CHARACTER*(*)  USERPHONE
         CHARACTER*(*)  DISUSER
         CHARACTER*11   WHEN_TIME, WHEN_DAY
         CHARACTER*12   WHEN
         CHARACTER*23   TEMP_TIME
         CHARACTER*80   FILENAME
         LOGICAL        PERIOD, CLI$PRESENT, ABORT_FULL
C
C        COMMON
C
         COMMON /DATETIME/ CDATE
         COMMON /OUTDEV/ UNT
         COMMON /LISTING/ LIST
C
C        INITIALIZE VARIABLES
C
         NOUSE = .FALSE.
         ABORT_FULL = .FALSE.
C
C        GET VARIABLE LENGTHS
C
         DEV_LEN = LENGTH(USERDEV)
         DIR_LEN = LENGTH(USERDIR) - 1
C
C        PARSE THE DIRECTORY STRUCTURE TO FIGURE THE PROPER DEFAULT DIRECTORY
C
         IF(INDEX(USERDIR,'.') .NE. 0)THEN
           PERIOD = .FALSE.
           I = DIR_LEN
           DOWHILE( (.NOT. PERIOD) .AND. (I .NE. 1))
             IF(USERDIR(I:I) .EQ. '.')THEN
               PERIOD = .TRUE.
             ELSE
               I = I - 1
             ENDIF
           ENDDO
           FILENAME = USERDEV(2:DEV_LEN) // '[000000.' //
     1                USERDIR(3:I - 1) // ']' //
     2                USERDIR(I + 1:DIR_LEN) // '.DIR'
         ELSE
           FILENAME = USERDEV(2:DEV_LEN) // '[000000]' // 
     1                USERDIR(3:DIR_LEN) // '.DIR'
         ENDIF
C
C        OPEN UP THE DIRECTORY WITH RMS THROUGH USEROPEN
C
         FILE_LEN = LENGTH(FILENAME)
         OPEN(UNIT=20,
     1        FILE=FILENAME(1:FILE_LEN),
     2        STATUS='OLD',
     3        ERR=9050,
     4        USEROPEN=CREOPEN)
         CLOSE(20)
C
C        CONVERT TO GET THE FULL DATE WITHOUT TIME, THEN GET BINARY TIME
C        OF THE DATE, WITHOUT THE TIME, AND PICK UP THE DELTA TIME OF THE 
C        DATE
C
         CALL SYS$ASCTIM(,TEMP_TIME,CDATE,0)
         WHEN = TEMP_TIME(1:12)
         CALL SYS$BINTIM(WHEN,USERLOG)
         CALL LIB$DAY(DAY,USERLOG)
C
C        PRINT OUT DISPLAY
C
         DIFF = TODAY - DAY
         IF(DIFF .GE. OFFSET)THEN
           NOUSE = .TRUE.
           IF (.TRUE.) THEN
             WRITE(UNT,129) USER, USERGROUP, DISUSER, WHEN, DIFF
           ELSE
 9050        WRITE(UNT,155) USER, USERGROUP, DISUSER
             ABORT_FULL = .TRUE.
           ENDIF
           LINES = LINES + 1
C
C        DISPLAY FULL MODE
C
           IF (CLI$PRESENT('FULL')) THEN
             IF (.NOT. ABORT_FULL) THEN
               CALL LIB$DAY_OF_WEEK (USERLOG, DAYNUM)
               CALL DAY_O_WEEK (DAYNUM, WHEN_DAY)
               WHEN_TIME = TEMP_TIME(13:23)

               WRITE (UNT, 160) WHEN_DAY, WHEN_TIME
               LINES = LINES + 1
             ENDIF
           ENDIF
C
C        DISPLAY LIST OUTPUT
C
           IF (LIST) THEN
             WRITE (UNT, 130) USERNAME, USERPHONE
             LINES = LINES + 1
           ENDIF

           IF (CLI$PRESENT('LIST') .OR. CLI$PRESENT('FULL')) THEN
             WRITE (UNT,*) ' '
             LINES = LINES + 1
           ENDIF

         ENDIF
C
         RETURN
         END
C
C        END OF NOUSE
C
C***************************************************************************
C
         SUBROUTINE ONE_GROUP (DATE, TODAY, OFFSET, GROUP)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          27 JULY 1998
C        PURPOSE
C          BETTER MODULARIZE LAST, GET INFO ON ONE GROUP
C        DESCRIPTION
C          CHECK UAF AND PULL INFO ON USERS IN THAT GROUP
C
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            GET_UAF
C            HEADER
C            LENGTH
C            OUT_INFO
C
C        PARAMETERS
C          DATE        : CURRENT DATE
C          GROUP       : GROUP TO DEAL WITH
C          OFFSET      : DATE OFFSET
C          TODAY       : TODAY'S INTEGER DATE
C        LOCAL GLOSSARY
C          CLILEN      : CONTROL VARIABLE
C          FOUND       : CONTROL VARIABLE
C          FF          : FORM FEED
C          GROUP_LEN   : LENGTH OF GROUP NAME
C          I           : CONTROL VARIABLE
C          LINES       : LINE ON PAGE
C          MAX_LINES   : MAX LINES PER PAGE
C          OUTPUT      : RETURN STATUS VARIABLE
C          PAGE        : PAGE NUMBER
C          UNT         : OUTPUT UNIT NUMBER
C          USER        : USER TO GET INFO
C
C            
C        FORMATS
C
  120    FORMAT(X,'%LAST-E-NOSUCHGROUP, No such group -  ',A)
C
C        INCLUDES
C
         INCLUDE 'UAFDEF.INC /NOLIST'
C
C        DECLARE VARIABLES
C
         INTEGER*4       TODAY, OFFSET, PAGE, LINES, MAX_LINES, I,
     1                   GROUP_LEN, CLILEN, UNT
         CHARACTER*(*)   DATE
         CHARACTER*(*)   GROUP
         CHARACTER*1     FF
         CHARACTER*12    USER
         LOGICAL         OUTPUT, OUT_INFO, FOUND
C
C        COMMON
C
         COMMON /OUTDEV/ UNT
         COMMON /LINEINFO/ MAX_LINES, FF
C
         CLILEN = LENGTH(GROUP)
         CALL GET_UAF (UAF)
C
C        PRINT HEADER
C
         PAGE = 1
         CALL HEADER(DATE,OFFSET,PAGE,LINES)
C
C        LOOP THROUGH LIST, PULLING MATCHING ACCOUNT NAMES TO GET THE USER'S
C        DATA
C
         DO 1010 I = 1, UAF.NUM_USERS
           GROUP_LEN = LENGTH(UAF.ACCOUNT(I))
           IF(GROUP(1:CLILEN) .EQ. UAF.ACCOUNT(I)(1:GROUP_LEN))THEN
C
C        TEST FOR NEW PAGE
C
             IF(LINES .GE. MAX_LINES)THEN
               PAGE = PAGE + 1
               WRITE(UNT,*) FF
               CALL HEADER(DATE,OFFSET,PAGE,LINES)
             ENDIF

             USER = UAF.USER(I)
             OUTPUT = OUT_INFO(USER,OFFSET,TODAY,LINES)
             FOUND = .TRUE.
           ENDIF
 1010    CONTINUE
C
C        PRINT MESSAGE IF NO GROUP BY THAT NAME
C
         IF(.NOT. (FOUND))THEN
           WRITE(UNT,*) ' '
           WRITE(UNT,120) GROUP(1:CLILEN)
           WRITE(UNT,*) ' '
         ENDIF
C
         RETURN
         END
C
C        END OF ONE_GROUP
C
C***************************************************************************
C
         LOGICAL FUNCTION OUT_INFO (USER,OFFSET,TODAY,LINES)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          12 JAN 1990
C          26 OCT 1994   JON BAKER
C             ADD MODIFICATIONS FOR GROUP VIEWING
C          10 MAY 1995   JON BAKER
C             SETUP FOR NONINTERACTIVE LOGINS OPTION
C        PURPOSE
C          TO RETRIEVE AND DISPLAY DATA
C        DESCRIPTION
C          MAKE CALLS TO INFORMATIVE ROUTINES AND DISPLAY DESIRED INFORMATION
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C            GET_USERS
C          CALLS TO
C            DAY_O_WEEK
C            GET_INFO
C            NOUSE
C
C        PARAMETERS
C          OFFSET     : DAY OFFSET
C          TODAY      : TODAY'S DELTA TIME
C          USER       : USERNAME
C        LOCAL GLOSSARY
C          DAY        : USERLOG IN DELTA TIME
C          DAY1       : NETLOG IN DELTA TIME
C          DAYNUM     : INTEGER DAY OF WEEK
C          DIFF       : NUMBER OF DAYS SINCE LAST LOGIN
C          DISUSER    : ACCOUNT DISUSERED FLAG
C          FLAGS      : ACCOUNT FLAGS
C          GROUP      : GROUP PRIV
C          NETLOG     : NONINTERACTIVE LOGIN
C          SYSPRV     : SYSPRV PRIV
C          TEMP_TIME  : ABSOLUTE TIME STRING
C          USER_GROUP : EXECUTOR'S GROUP
C          USER_NAME  : EXECUTOR'S USERNAME
C          USERDEV    : USER'S DEVICE
C          USERDIR    : USER'S DIRECTORY
C          USERGROUP  : USER'S GROUP
C          USERLOG    : USER'S LAST LOGIN TIME
C          USERNAME   : USER'S FULL NAME
C          USERPHONE  : USER'S PHONE NUMBER
C          WHEN       : ASCII TIME FOR LAST LOGIN
C
C        INCLUDE
C
         INCLUDE '($UAIDEF)'
C
C        FORMATS
C
  127    FORMAT(X,A12,2X,A15,2X,A3,7X,A11,3X,I4,' DAYS',X,A)
  128    FORMAT(X,A12,4X,'does not exist as a user.')
  130    FORMAT(15X,A30,16X,A13)
  160    FORMAT(15X,'Date was on a  ',A10,2X,A11)
  170    FORMAT(X,'%LAST-F-NOPRIV, No privilege to ',
     1          'perform operation on  ',A12)
  171    FORMAT(X,'%LAST-I-NOTINST, LAST not installed with SYSPRV')
C
C        DECLARE VARIABLES
C
         INTEGER*4     USERLOG(2), OFFSET, DAY, TODAY, DIFF, UNT,
     1                 LINES, FLAGS, DAYNUM, NETLOG(2), DAY1
         CHARACTER*3   DISUSER
         CHARACTER*11  WHEN_TIME, WHEN_DAY
         CHARACTER*12  USER, WHEN, USER_NAME
         CHARACTER*13  NET
         CHARACTER*14  USERPHONE
         CHARACTER*23  TEMP_TIME
         CHARACTER*30  USERNAME
         CHARACTER*32  USERDEV, USERGROUP, USER_GROUP
         CHARACTER*64  USERDIR
         LOGICAL       BYGROUP, BYUSER, AGROUP, NOUSE, LIST,
     1                 CLI$PRESENT, SYSPRV, GROUP, INSTALLED
C
C        COMMONS
C
         COMMON /BOOLEAN/ BYUSER, BYGROUP, AGROUP
         COMMON /OUTDEV/ UNT
         COMMON /LISTING/ LIST
         COMMON /PRIVS/ SYSPRV, GROUP, USER_GROUP, USER_NAME,
     1                  INSTALLED
C
C        INITIALIZE VARIABLES
C
         OUT_INFO = .FALSE.
         CALL STR$UPCASE (USER, USER)
         CALL COMPRESS (USER)
         NET = ' '
C
C        GET THE USER'S DATA
C
         CALL GET_INFO (USER, USERDEV, USERDIR, USERGROUP, 
     1                  USERLOG, NETLOG, USERNAME, USERPHONE, FLAGS)
C
C        CHECK FOR PRIVILEGE TO SEE USER
C
         IF ((SYSPRV) .OR. 
     1       (GROUP .AND. (USERGROUP .EQ. USER_GROUP)) .OR.
     2       (USER .EQ. USER_NAME)) THEN
C
C        CHECK TO SEE IF VALID USER
C
           IF (USERDIR(2:2) .EQ. ' ') THEN
C
C        NOT A VALID USERNAME
C
             IF((.NOT.(BYUSER))  .AND. 
     1          (.NOT.(BYGROUP)) .AND. 
     2          (.NOT.(AGROUP))) THEN

               WRITE(UNT,128) USER
               LINES = LINES + 1

               IF (CLI$PRESENT('LIST') .OR. CLI$PRESENT('FULL')) THEN
                 WRITE (UNT,*) ' '
                 LINES = LINES + 1
               ENDIF

             ENDIF

           ELSE
             IF (BTEST(FLAGS, UAI$V_DISACNT)) THEN
               DISUSER = 'Yes'
             ELSE
               DISUSER = 'No'
             ENDIF

             CALL LIB$DAY(DAY,USERLOG)
             IF (CLI$PRESENT('NONINTERACTIVE')) THEN
               CALL LIB$DAY(DAY1,NETLOG)
               IF (DAY1 .GT. DAY) THEN
                 DAY = DAY1
                 USERLOG(1) = NETLOG(1)
                 USERLOG(2) = NETLOG(2)
                 NET = '(Noninteract)'
               ENDIF
             ENDIF

             IF(DAY .EQ. 0)THEN
C
C        ACCOUNT HAS NEVER BEEN USED.  FIND CREATION DATE OF ACCOUNT
C
               OUT_INFO = NOUSE(USER,USERDEV,USERDIR,USERGROUP,
     1                          TODAY,OFFSET,LINES,
     1                          USERNAME, USERPHONE, DISUSER)
             ELSE
C
C       GET THE DIFFERENCES IN THE DELTA TIME FOR REPORTING
C
               DIFF = TODAY - DAY
               IF(DIFF .GE. OFFSET)THEN
                 OUT_INFO = .TRUE.
                 CALL SYS$ASCTIM(,TEMP_TIME,USERLOG,0)
                 WHEN = TEMP_TIME(1:12)

                 WRITE(UNT,127) USER, USERGROUP, DISUSER, WHEN, 
     1                          DIFF, NET
                 LINES = LINES + 1

                 IF (CLI$PRESENT('FULL')) THEN
                   WHEN_TIME = TEMP_TIME(13:23)
                   CALL LIB$DAY_OF_WEEK (USERLOG, DAYNUM)
                   CALL DAY_O_WEEK (DAYNUM, WHEN_DAY)

                   WRITE (UNT, 160) WHEN_DAY, WHEN_TIME
                   LINES = LINES + 1
                 ENDIF
                 IF (LIST) THEN
                   WRITE (UNT, 130) USERNAME, USERPHONE
                   LINES = LINES + 1
                 ENDIF

                 IF (CLI$PRESENT('LIST') .OR. CLI$PRESENT('FULL')) THEN
                   WRITE (UNT,*) ' '
                   LINES = LINES + 1
                 ENDIF

               ENDIF
             ENDIF
           ENDIF
         ELSE
           IF (GROUP .AND. (.NOT. INSTALLED)) THEN
             WRITE (*,171)
           ENDIF
           WRITE (*,170) USER
         ENDIF
C
         RETURN
         END
C
C        END OF OUT_INFO
C
C*****************************************************************************
C
         SUBROUTINE SORT_UAF(UAF)
C
C        AUTHOR
C          JONATHAN C. BAKER
C        DATE
C          12 JANUARY 1990
C        PURPOSE
C          TO SORT UAF BY ACCOUNT WITHOUT DISRUPTING USERS AS A SUB SORT
C        DESCRIPTION
C          USE SELECTION SORT
C        COMMUNICATIONS
C          CALLS FROM
C            MAIN
C          CALLS TO
C            (NONE)
C
C        PARAMETERS
C          UAF       : RECORD OF ARRAYS
C        LOCAL GLOSSARY
C          I         : CONTROL VARIABLE
C          J         : CONTROL VARIABLE
C          K         : CONTROL VARIABLE
C          L         : CONTROL VARIABLE
C          TACCOUNT  : TEST ACCOUNT
C
C        INCLUDE
C
         INCLUDE 'UAFDEF.INC /NOLIST'
C
C        RECORDS
C
         RECORD /UAF/ TEMPREC
C
C        DECLARE VARIABLES
C
         INTEGER*4     I, J, K, L
         CHARACTER*32  TACCOUNT, TEMP
C
C        START SELECTION SORT
C
         
         DO 1010 L = 1,32
           TEMP(L:L) = CHAR(126)
 1010    CONTINUE

         DO 1000 J = 1, UAF.NUM_USERS
           K = 0
           TACCOUNT = TEMP

           DO 1020 I = 1, UAF.NUM_USERS
             IF((TACCOUNT .GT. UAF.ACCOUNT(I)) .AND.
     1          (UAF.ACCOUNT(I)(1:1) .NE. CHAR(126)))THEN
               TACCOUNT = UAF.ACCOUNT(I)
               K = I
             ENDIF
 1020      CONTINUE
           TEMPREC.USER(J) = UAF.USER(K)
           TEMPREC.ACCOUNT(J) = UAF.ACCOUNT(K)
           UAF.ACCOUNT(K) = TEMP
 1000    CONTINUE
C
C        SET UAF EQUAL TO TEMPREC
C
         DO 1050 I = 1,UAF.NUM_USERS
           UAF.USER(I) = TEMPREC.USER(I)
           UAF.ACCOUNT(I) = TEMPREC.ACCOUNT(I)
 1050    CONTINUE
C
         RETURN
         END
C
C        END OF SORT_UAF
C
C***************************************************************************
