#include <stdio.h>
#include "externs.h"
#include "window.h"
#include "buffer.h"
#include "file.h"
#include "sysdep.h"
#include "keym.h"
#include "most.h"
#include "search.h"  

int SQUEEZE_LINES = 0;          /* switch parameters */
int MOST_A_OPT = 0;             /* automatically choose -b if necessary */
int MOST_C_OPT = 0;             /* begin pages at top of screen */
int MOST_V_OPT = 0;             /* display control chars */
int MOST_B_OPT = 0;             /* display Binary File */
int MOST_T_OPT = 0;             /* display tab as ^I-- valid only with V option */
int MOST_D_OPT = 0;             /* delete file mode  (see ':D')  */
int MOST_L_OPT = 0;             /* use ^L (formfeed) to clear screen */

void most(char *file, int start)
{
    int piped, row, col;
    
    init_display();
    get_cdir(C_DIR);

    row = col = 0;
    if (file[0] == '\0') piped = 1; else piped = 0;
    
    find_file(file);
    goto_line(start);
    CURS_POS = C_POS;
    if (*SEARCH_STR != '\0' && (row = search(C_POS,1,&col), row > 0))
      {
          goto_line(row);
      }
    else
      {
          row = C_LINE;
          col = 1;
      }
    
    window_buffer();
    CURS_ROW = WIN->curs_line = row - C_LINE + 1;
    WIN->curs_pos = CURS_POS;
    CURS_COL = WIN->curs_col = col;
    redraw_window();
    update_status(1);

    while (1)
      {
          execute_key();
      } 
}

