 /* **++ **  FACILITY:	NEWSRDR  **3 **  ABSTRACT:	Commands related to posting articles.  ** **  MODULE DESCRIPTION:  **? **  	This module contains the routines that implement the POST,  **  MAIL, and REPLY commands.  ** **  AUTHOR: 	    M. Madison 7 **  	    	    COPYRIGHT  1993, 1994 MADGOAT SOFTWARE.  " **  	    	    ALL RIGHTS RESERVED. ** **  CREATION DATE:  04-SEP-1992  ** **  MODIFICATION HISTORY:  **1 **  	04-SEP-1992 V1.0    Madison 	Initial coding. ? **  	17-SEP-1992 V1.0-1  Madison 	Fix follwup-to: poster check. 3 **  	22-SEP-1992 V1.0-2  Madison 	Fix STORE mix-up. H **  	30-SEP-1992 V1.0-3  Madison 	Missing header separator in FWD/STORE.G **  	01-OCT-1992 V1.0-4  Madison 	Must lower-case group names on REPLY. ? **  	07-OCT-1992 V1.0-5  Madison 	cli_get_value("OK"...)?  Duh. E **  	23-DEC-1992 V1.0-6  Madison 	Fix Post_Article return-code check. : **  	23-MAR-1993 V1.0-7  Madison 	Fix file_read reference.9 **  	08-APR-1993 V1.0-8  Madison 	Fix REPLY/DISTRIBUTION. 8 **  	12-APR-1993 V1.1    Madison 	Get_Article_* changes.E **  	08-JUL-1993 V1.2    Madison 	Let user specify name of keep file. 7 **  	02-AUG-1993 V1.2-1  Madison 	Fix minor CANCEL bug. E **  	21-SEP-1993 V1.3    Madison 	Add /APPROVED, /EXPIRES qualifiers. : **  	29-SEP-1993 V1.3-1  Madison 	Fix /KEYWORDS qualifier.J **  	05-OCT-1993 V1.3-2  Madison 	Fix handling of null To: in cmd_forward.? **  	15-JAN-1994 V1.3-3  Madison 	get_article_body has changed. 9 **  	28-MAR-1994 V1.3-4  Madison 	Check Copy_File status. < **  	16-MAY-1994 V1.4    Madison 	Customizable reply prefix.8 **  	19-MAY-1994 V1.4-1  Madison 	Fix broken mail check.E **  	08-DEC-1994 V1.4-2  Madison 	References are separated by blanks!  **-- */ #include "newsrdr.h" #include "globals.h"        EXTERN struct GRP *curgroup;!     EXTERN int        cur_artnum;    #ifdef __GNUC__ * #define RMS$_EOF ((unsigned int) rms$_eof)#     extern unsigned int rms$_eof();  #else  #pragma nostandard&     globalvalue unsigned int RMS$_EOF; #pragma standard #endif  *     extern struct GRP *Find_Group(char *);7     extern int Post_Article(struct QUE *, char *, int); 8     extern unsigned int csl_parse(char *, struct QUE *);I     extern int Mail_Message(struct QUE *, char *, char *, int, int, int); P     extern unsigned int Get_Article_Hdrs(struct GRP *, int, void *, int, int *);J     extern unsigned int Get_Article_Body(int, char *, char *, int *, int);@     extern unsigned int Parse_ToList(char *, struct QUE *, int);1     extern void Make_Return_Address(char *, int); ?     extern unsigned int Copy_File(char *, char *, char *, int);         /* **++ **  ROUTINE:	cmd_post  ** **  FUNCTIONAL DESCRIPTION:  ** **  	POST command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_post()  ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_post() {   B     char tmp[STRING_SIZE], ngstr[STRING_SIZE], inspec[FSPEC_SIZE];D     char outspec[FSPEC_SIZE], dist[STRING_SIZE], fupto[STRING_SIZE];     char *ngp, *dcp, *fcp;     struct HDR *h;     struct QUE hdrq;2     int is_temp, edit_flag, go_ahead, use_sigfile;     unsigned int status;  "     hdrq.head = hdrq.tail = &hdrq;     ngstr[0] = '\0';     ngp = ngstr;   /*E ** The server told us whether we could post or not when we connected.  */     if (!news_cfg.postingok) {$     	lib$signal(NEWS__NOPOSTING, 0);     	return SS$_NORMAL;      }    /*C ** Get the group(s) we're posting to.  Assume current group if none 	 ** given.  */;     while (OK(cli_get_value("GRPNAM", tmp, sizeof(tmp)))) {      	struct GRP *g;      	locase(tmp);      	g = Find_Group(tmp);      	if (g == NULL) { :     	    lib$signal(NEWS__NOSUCHGRP, 2, strlen(tmp), tmp);     	    return SS$_NORMAL;      	}  $     	if (ngp != ngstr) *ngp++ = ',';     	strcpy(ngp, g->grpnam);     	ngp+= strlen(g->grpnam);        }      *ngp = '\0';       if (ngp == ngstr) {      	if (curgroup == NULL) {)     	    lib$signal(NEWS__NOCURGROUP, 0);      	    return SS$_NORMAL; 
     	} else { )     	    strcpy(ngstr, curgroup->grpnam); E     	    lib$signal(NEWS__USINGCURGROUP, 2, strlen(curgroup->grpnam), !     	    	    	curgroup->grpnam);      	}     }   ;     insert_header(ngstr, hdrq.tail, NEWS_K_HDR_NEWSGROUPS);    /* ** Get the article subject */     tmp[0] = '\0';$     status = cli_present("SUBJECT");!     if (status == CLI$_PRESENT) { 9     	status = cli_get_value("SUBJECT", tmp, sizeof(tmp)); (     } else if (status != CLI$_NEGATED) {5     	status = get_cmd(tmp, sizeof(tmp), "Subject: ");      }   B     if (tmp[0]) insert_header(tmp, hdrq.tail, NEWS_K_HDR_SUBJECT);   /*  ** Do we use the signature file? */&     status = cli_present("SIGNATURE");F     use_sigfile = (news_prof.autosigpost && status != CLI$_NEGATED) ||8     	(!news_prof.autosigpost && status == CLI$_PRESENT);   /* ** Set the distribution header */)     status = cli_present("DISTRIBUTION"); !     if (status == CLI$_PRESENT) { )     	char dist[STRING_SIZE], *dcp = dist; B     	while (OK(cli_get_value("DISTRIBUTION", tmp, sizeof(tmp)))) {'     	    if (dcp != dist) *dcp++ = ',';      	    locase(tmp);      	    strcpy(dcp, tmp);     	    dcp += strlen(tmp);     	}     	*dcp = '\0'; =     	insert_header(dist, hdrq.tail, NEWS_K_HDR_DISTRIBUTION);      }    /* ** Set the Followup-to header. */(     status = cli_present("FOLLOWUP_TO");!     if (status == CLI$_PRESENT) {      	int fuptoerr = 0;     	float afew = 3.0;+     	char fupto[STRING_SIZE], *fcp = fupto; A     	while (OK(cli_get_value("FOLLOWUP_TO", tmp, sizeof(tmp)))) { (     	    if (fcp != fupto) *fcp++ = ',';     	    locase(tmp); *     	    if (strcmp(tmp, "poster") != 0) {%     	    	if (Find_Group(tmp) == 0) { ?     	    	    lib$signal(NEWS__NOSUCHGRP, 2, strlen(tmp), tmp);      	    	    fuptoerr = 1;      	    	    continue;      	    	} 
     	    }     	    strcpy(fcp, tmp);     	    fcp += strlen(tmp);     	}     	*fcp = '\0';      	if (*fupto != '\0') {A     	    insert_header(fupto, hdrq.tail, NEWS_K_HDR_FOLLOWUP_TO);      	}#     	if (fuptoerr) lib$wait(&afew);      }    /* ** Set the Approved: header. */%     status = cli_present("APPROVED"); !     if (status == CLI$_PRESENT) { +     	Make_Return_Address(tmp, sizeof(tmp)); 8     	insert_header(tmp, hdrq.tail, NEWS_K_HDR_APPROVED);     }    /* ** Set the Expires: header.  */$     status = cli_present("EXPIRES");!     if (status == CLI$_PRESENT) {       	struct dsc$descriptor tdsc;     	TIME expiry; 0     	cli_get_value("EXPIRES", tmp, sizeof(tmp));(     	INIT_SDESC(tdsc, strlen(tmp), tmp);6     	status = lib$convert_date_string(&tdsc, &expiry);     	if (OK(status)) {.     	    Make_Date(&expiry, tmp, sizeof(tmp));;     	    insert_header(tmp, hdrq.tail, NEWS_K_HDR_EXPIRES);      	}     }    /* ** Set the Summary: header.  */$     status = cli_present("SUMMARY");!     if (status == CLI$_PRESENT) { 0     	cli_get_value("SUMMARY", tmp, sizeof(tmp));7     	insert_header(tmp, hdrq.tail, NEWS_K_HDR_SUMMARY);      }    /* ** Set the Keywords: header. */%     status = cli_present("KEYWORDS"); !     if (status == CLI$_PRESENT) { %     	char kw[STRING_SIZE], *fcp = kw; >     	while (OK(cli_get_value("KEYWORDS", tmp, sizeof(tmp)))) {%     	    if (fcp != kw) *fcp++ = ',';      	    locase(tmp);      	    strcpy(fcp, tmp);     	    fcp += strlen(tmp);     	}     	*fcp = '\0';      	if (*kw != '\0') { ;     	    insert_header(kw, hdrq.tail, NEWS_K_HDR_KEYWORDS);      	}     }    /*- ** Get the input file name, if one was given.  */"     inspec[0] = outspec[0] = '\0';0     if (cli_present("INPFIL") == CLI$_PRESENT) {5     	cli_get_value("INPFIL", inspec, sizeof(inspec)); 5     } else if (cli_present("FILE") == CLI$_PRESENT) { 3     	cli_get_value("FILE", inspec, sizeof(inspec));      }    /*> ** Compose_Message prompts the user for message text, or fires ** up the text editor. */!     status = cli_present("EDIT"); =     edit_flag = (news_prof.edit && status != CLI$_NEGATED) || #     	    	(status == CLI$_PRESENT); C     status = Compose_Message(inspec, outspec, edit_flag, &is_temp);    /*C ** If all went ok, give the user a chance to back out.  If she says  ** it's OK, then post away.  */     if (!OK(status)) {,     	lib$signal(NEWS__COMPOSERR, 0, status);     } else if (!outspec[0]) { $     	lib$signal(NEWS__CANCELLED, 0);     } else {'     	strcpy(tmp, "Ready to post to: ");      	strcat(tmp, ngstr);     	put_output(tmp); 2     	go_ahead = Yes_Answer("Okay to proceed?", 1);L     	if (go_ahead) go_ahead = OK(Post_Article(&hdrq, outspec, use_sigfile));      	if (!go_ahead && is_temp) {D     	    go_ahead = !Yes_Answer("Keep file containing message?", 0);     	}3     	if (go_ahead && is_temp) file_delete(outspec);      	else if (is_temp) {"     	    strcpy(tmp, "Save as [");     	    strcat(tmp, outspec);     	    strcat(tmp, "]: ");9     	    status = get_cmd(inspec, sizeof(inspec)-1, tmp); /     	    if (OK(status) && inspec[0] != '\0') { 7     	    	status = Copy_File(outspec, inspec, dist, 0); /     	    	if (OK(status)) file_delete(outspec);      	    	else {K     	    	    lib$signal(NEWS__WRITERR, 2, strlen(inspec), inspec, status); $     	    	    strcpy(dist, outspec);     	    	}      	    } else {       	    	strcpy(dist, outspec);
     	    }2     	    strcpy(tmp, "Message retained in file ");     	    strcat(tmp, dist);      	    put_output(tmp);      	}     }    /* ** Clean up  */7     while (queue_remove(hdrq.head, &h)) mem_freehdr(h);        return SS$_NORMAL;   } /* cmd_post */   /* **++ **  ROUTINE:	cmd_mail  ** **  FUNCTIONAL DESCRIPTION:  ** **  	MAIL command. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_mail()  ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_mail() {   D     char tmp[STRING_SIZE], subjstr[STRING_SIZE], tostr[STRING_SIZE];2     char infspec[FSPEC_SIZE], outspec[FSPEC_SIZE];
     char *cp;      struct HDR *h;     struct QUE hdrq, destq; 7     int edit_flag, is_temp, go_ahead, use_sigfile, len;      unsigned int status;  "     hdrq.head = hdrq.tail = &hdrq;%     destq.head = destq.tail = &destq;    /*A ** Build the to list, if it was given on the command.  Otherwise, ! ** prompt the user for addresses.  */7     while (OK(cli_get_value("TO", tmp, sizeof(tmp)))) { '     	insert_header(tmp, destq.tail, 0);      }      if (destq.head == &destq) { 0     	status = get_cmd(tmp, sizeof(tmp), "To: ");     	len = strlen(tmp); 2     	while (len > 0 && isspace(tmp[len-1])) len--;     	if (len == 0) {     	    status = RMS$_EOF; 
     	} else {      	    tmp[len] = '\0'; 9     	    for (cp = tmp; *cp && isspace(*cp); cp++) len--; *     	    if (len == 0) status == RMS$_EOF;-     	    else status = csl_parse(cp, &destq);      	}     	if (!OK(status)) { <     	    while(queue_remove(destq.head, &h)) mem_freehdr(h);"     	    if (status != RMS$_EOF) {;     	    	lib$signal(NEWS__MAILERR, 0, NEWS__ADDRSYNTX, 0); 
     	    }     	    return SS$_NORMAL;      	}     }    /*( ** Build the To: header for the message. */         cp = tostr; D     for (h = destq.head; h != (struct HDR *) &destq; h = h->flink) {"     	if (cp != tostr) *cp++ = ',';     	strcpy(cp, h->str);     	cp += strlen(h->str);     }      *cp = '\0';    /* ** Set up the Subject: header  */$     status = cli_present("SUBJECT");!     if (status == CLI$_PRESENT) { A     	status = cli_get_value("SUBJECT", subjstr, sizeof(subjstr)); (     } else if (status != CLI$_NEGATED) {=     	status = get_cmd(subjstr, sizeof(subjstr), "Subject: "); (     	if (!OK(status)) return SS$_NORMAL;     }    /*" ** Should we use a signature file? */&     status = cli_present("SIGNATURE");F     use_sigfile = (news_prof.autosigmail && status != CLI$_NEGATED) ||?     	    	  (!news_prof.autosigmail && status == CLI$_PRESENT);    /*: ** If the user specified a file to be mailed, then use it. */     infspec[0] = '\0';5     cli_get_value("FSPEC", infspec, sizeof(infspec)); !     status = cli_present("EDIT"); =     edit_flag = (news_prof.edit && status != CLI$_NEGATED) || #     	    	(status == CLI$_PRESENT);    /*D ** Use Compose_Message to enter the message or edit it, or whatever. */     outspec[0] = '\0';D     status = Compose_Message(infspec, outspec, edit_flag, &is_temp);   /*E ** If the compose went ok, give the user one more chance to back out.  ** If ok by her, then mail it. */     if (!OK(status)) {,     	lib$signal(NEWS__COMPOSERR, 0, status);     } else if (!outspec[0]) { $     	lib$signal(NEWS__CANCELLED, 0);     } else {'     	strcpy(tmp, "Ready to mail to: ");      	strcat(tmp, tostr);     	put_output(tmp); 2     	go_ahead = Yes_Answer("Okay to proceed?", 1);     	if (go_ahead) {     	    int copy_self; &     	    status = cli_present("SELF");0     	    copy_self = (status == CLI$_PRESENT) ||7     	    	(news_prof.csmail && status != CLI$_NEGATED); J     	    go_ahead = OK(Mail_Message(&destq, subjstr, outspec, use_sigfile,"     	    	    	    copy_self, 0));     	}   /*D ** If the user decided not to mail the message, ask her if she wantsD ** to keep the message contents.  Otherwise, blow it away (if it was ** a file we created.  */      	if (!go_ahead && is_temp) {D     	    go_ahead = !Yes_Answer("Keep file containing message?", 0);     	}3     	if (go_ahead && is_temp) file_delete(outspec);      	else if (is_temp) {"     	    strcpy(tmp, "Save as [");     	    strcat(tmp, outspec);     	    strcat(tmp, "]: ");;     	    status = get_cmd(infspec, sizeof(infspec)-1, tmp); 0     	    if (OK(status) && infspec[0] != '\0') {9     	    	status = Copy_File(outspec, infspec, tostr, 0); /     	    	if (OK(status)) file_delete(outspec);      	    	else {M     	    	    lib$signal(NEWS__WRITERR, 2, strlen(infspec), infspec, status); %     	    	    strcpy(tostr, outspec);      	    	}      	    } else { !     	    	strcpy(tostr, outspec); 
     	    }2     	    strcpy(tmp, "Message retained in file ");     	    strcat(tmp, tostr);     	    put_output(tmp);      	}       }    /* ** Clean up  */8     while (queue_remove(destq.head, &h)) mem_freehdr(h);       return SS$_NORMAL;   } /* cmd_mail */   /* **++ **  ROUTINE:	cmd_reply ** **  FUNCTIONAL DESCRIPTION:  ** **  	REPLY command.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_reply() ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.  ** **  COMPLETION CODES: / **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_reply() {  #     struct QUE *hdrq, newhq, destq; 5     char diststr[STRING_SIZE], groupstr[STRING_SIZE]; L     char subjstr[STRING_SIZE], msgidstr[STRING_SIZE], fuptostr[STRING_SIZE];F     char newfupto[STRING_SIZE], refstr[STRING_SIZE], tmp[STRING_SIZE];2     char infspec[FSPEC_SIZE], outspec[FSPEC_SIZE];     struct HDR *hdr;     char *cp, *fromstr; F     int edit_flag, extract, post_reply, mail_reply, go_ahead, is_temp;     int use_sigp, use_sigm;      unsigned int status;       if (curgroup == NULL) { %     	lib$signal(NEWS__NOCURGROUP, 0);      	return SS$_NORMAL;      }      if (cur_artnum == 0) {#     	lib$signal(NEWS__NOCURART, 0);      	return SS$_NORMAL;      }    /*F ** Replies are a little bit complicated, since they can be both posted? ** and mailed.  Let's find out what we're supposed to be doing.  */  5     post_reply = cli_present("POST") == CLI$_PRESENT; 5     mail_reply = cli_present("MAIL") == CLI$_PRESENT; &     if (!(post_reply || mail_reply)) {&     	post_reply = news_prof.replypost;&     	mail_reply = news_prof.replymail;     }    /*F ** Check to make sure postings are OK (from the banner message when we ** first conneted. */,     if (post_reply && !news_cfg.postingok) {$     	lib$signal(NEWS__NOPOSTING, 0);     	return SS$_NORMAL;      }      /*C ** We need information from the current article's headers.  Some ofo# ** it is also settable by the user.  */C     *groupstr = *subjstr = *fuptostr = *infspec = *outspec = *tmp =t/     	    *diststr = *refstr = *newfupto = '\0';m  %     destq.head = destq.tail = &destq;        if (post_reply) {      	cp = groupstr;F<     	while (OK(cli_get_value("GRPNAM", tmp, sizeof(tmp)))) {     	    struct GRP *g;      	    locase(tmp);Y     	    g = Find_Group(tmp);      	    if (g == NULL) { ;     	    	lib$signal(NEWS__NOSUCHGRP, 2, strlen(tmp), tmp);k     	    	return SS$_NORMAL;
     	    })     	    if (cp != groupstr) *cp++ = ',';d     	    strcpy(cp, tmp);t     	    cp += strlen(tmp);-     	}     	*cp = '\0';     }c  .     if (*groupstr) strcpy(fuptostr, groupstr);       if (mail_reply) {(-     	if (cli_present("TO") == CLI$_PRESENT) {s<     	    while (OK(cli_get_value("TO", tmp, sizeof(tmp)))) {,     	    	insert_header(tmp, destq.tail, 0);
     	    }     	}     }	  A     status = Get_Article_Hdrs(curgroup, cur_artnum, &hdrq, 0, 0);l     if (!OK(status)) {+     	lib$signal(NEWS__REPLYERR, 0, status);      	return SS$_NORMAL;U     }V  J     for (hdr = hdrq->head; hdr != (struct HDR *) hdrq; hdr = hdr->flink) {     	switch (hdr->code) {e       	case NEWS_K_HDR_FROM:     	    	fromstr = hdr->str;e     	    	break;     	case NEWS_K_HDR_REPLY_TO:3     	    	if (mail_reply && destq.head == &destq) { 0     	    	    Parse_ToList(hdr->str, &destq, 0);     	    	}-     	    	break;      	case NEWS_K_HDR_NEWSGROUPS:5     	    	if (!*groupstr) strcpy(groupstr, hdr->str);-     	    	break;     	case NEWS_K_HDR_SUBJECT: $     	    	strcpy(subjstr, hdr->str);     	    	break;!     	case NEWS_K_HDR_FOLLOWUP_TO:"5     	    	if (!*fuptostr) strcpy(fuptostr, hdr->str);R     	    	break;"     	case NEWS_K_HDR_DISTRIBUTION:$     	    	strcpy(diststr, hdr->str);     	    	break;      	case NEWS_K_HDR_REFERENCES:#     	    	strcpy(refstr, hdr->str);      	    	break;      	case NEWS_K_HDR_MESSAGE_ID:%     	    	strcpy(msgidstr, hdr->str);n     	    	break;     	}     }P   /*G ** If the article has a Followup-To: poster header, then we're supposedr ** to mail the reply only. */     if (post_reply) {Q1     	if (streql_case_blind(fuptostr, "poster")) {u     	    post_reply = 0;     	    mail_reply = 1;'     	    lib$signal(NEWS__MUSTMAIL, 0);      	}     }y   /*+ ** Build the list of recipients if mailing.g */-     if (mail_reply && destq.head == &destq) { &     	Parse_ToList(fromstr, &destq, 0);      	if (destq.head == &destq) {=     	    lib$signal(NEWS__REPLYERR, 0, NEWS__NOREPLYADDR, 0);*     	    return SS$_NORMAL;      	}     }R   /*! ** Subject header for new article  */$     status = cli_present("SUBJECT");!     if (status == CLI$_NEGATED) {T     	*subjstr = '\0';((     } else if (status == CLI$_PRESENT) {8     	cli_get_value("SUBJECT", subjstr, sizeof(subjstr));     } else {0     	if (streql_case_blind(subjstr, "(none)")) {     	    *subjstr = '\0';/9     	} else if (!strneql_case_blind(subjstr, "Re:", 3)) {n8     	    memmove(subjstr+4, subjstr, strlen(subjstr)+1);$     	    memcpy(subjstr, "Re: ", 4);     	}     }    /* ** Signature file? */&     status = cli_present("SIGNATURE");C     use_sigp = (news_prof.autosigpost && status != CLI$_NEGATED) ||a%     	       (status == CLI$_PRESENT);rC     use_sigm = (news_prof.autosigmail && status != CLI$_NEGATED) ||u%     	       (status == CLI$_PRESENT);c   /*" ** Distribution header for article */)     status = cli_present("DISTRIBUTION"); !     if (status == CLI$_PRESENT) {      	cp = diststr;B     	while (OK(cli_get_value("DISTRIBUTION", tmp, sizeof(tmp)))) {(     	    if (cp != diststr) *cp++ = ',';     	    locase(tmp);s     	    strcpy(cp, tmp);(     	    cp += strlen(tmp);m     	}     	*cp = '\0';     }    /*& ** Followup-to header for new article. */(     status = cli_present("FOLLOWUP_TO");!     if (status == CLI$_PRESENT) {      	int fuptoerr = 0;     	float afew = 3.0;     	cp = newfupto; A     	while (OK(cli_get_value("FOLLOWUP_TO", tmp, sizeof(tmp)))) {r)     	    if (cp != newfupto) *cp++ = ',';O     	    locase(tmp); *     	    if (strcmp(tmp, "poster") != 0) {%     	    	if (Find_Group(tmp) == 0) { ?     	    	    lib$signal(NEWS__NOSUCHGRP, 2, strlen(tmp), tmp);)     	    	    fuptoerr = 1;g     	    	    continue;      	    	}h
     	    }     	    strcpy(cp, tmp);G     	    cp += strlen(tmp);t     	}     	*cp = '\0';#     	if (fuptoerr) lib$wait(&afew);"     }"   /*C ** Let's see if this is a REPLY/EXTRACT.  If so, we get the currentTL ** article's contents, stick the reply-prefix on the front of each line, and2 ** use that as the input file for Compose_Message. */!     status = cli_present("EDIT");r+     edit_flag = (status == CLI$_PRESENT) ||u9     	    	    (news_prof.edit && status != CLI$_NEGATED);T5     extract = cli_present("EXTRACT") != CLI$_NEGATED;t     edit_flag |= extract;        if (extract) {/     	char temp0[FSPEC_SIZE], temp1[FSPEC_SIZE];d     	unsigned int runit, wunit;s
     	int len;"  +     	make_temp_fspec(temp0, sizeof(temp0));T/     	make_temp_fspec(infspec, sizeof(infspec)); ?     	status = Get_Article_Body(cur_artnum, temp0, temp1, 0, 0);{     	if (!OK(status)) {t2     	    lib$signal(NEWS__REPLYERR, 0, status, 0);     	    return SS$_NORMAL;p     	}0     	status = file_open(temp1, &runit, 0, 0, 0);     	if (!OK(status)) {E     	    file_delete(temp1);/     	    lib$signal(NEWS__REPLYERR, 0, status);      	    return SS$_NORMAL;P     	}7     	status = file_create(infspec, &wunit, 0, infspec);;     	if (!OK(status)) {      	    file_close(runit);      	    file_delete(temp1);     	    return SS$_NORMAL;      	}      	strcpy(tmp, "In article ");     	strcat(tmp, msgidstr);      	strcat(tmp, ", "); %     	if (mail_reply && !post_reply) { #     	    strcat(tmp, "you write:"); 
     	} else {$     	    strcat(tmp, fromstr);!     	    strcat(tmp, " writes:");e     	})     	file_write(wunit, tmp, strlen(tmp)); E     	memcpy(tmp, news_prof.reply_prefix, news_prof.reply_prefix_len); ?     	while (OK(file_read(runit, tmp+news_prof.reply_prefix_len,rG     	    	    	    	sizeof(tmp)-news_prof.reply_prefix_len-1, &len))) {p@     	    file_write(wunit, tmp, len+news_prof.reply_prefix_len);     	}     	file_close(wunit);"     	file_close(runit);t     	file_delete(temp1);       }e   /*; ** Now use Compose_Message for entry/editing of reply text., */     *outspec = '\0';D     status = Compose_Message(infspec, outspec, edit_flag, &is_temp);#     if (!OK(status) || !*outspec) {P     	if (!OK(status)) {s0     	    lib$signal(NEWS__COMPOSERR, 0, status);
     	} else {E%     	    lib$signal(NEWS__CANCELLED);(     	}(     	if (*outspec) file_delete(outspec);'     	if (extract) file_delete(infspec);O     	return SS$_NORMAL;k     }&   /*H ** Now actually build the headers for the new article/mail message, then" ** get confirmation from the user. */%     newhq.head = newhq.tail = &newhq;c       if (post_reply) { 0     	if (!*fuptostr) strcpy(fuptostr, groupstr);@     	insert_header(fuptostr, newhq.tail, NEWS_K_HDR_NEWSGROUPS);J     	if (*subjstr) insert_header(subjstr, newhq.tail, NEWS_K_HDR_SUBJECT);O     	if (*diststr) insert_header(diststr, newhq.tail, NEWS_K_HDR_DISTRIBUTION);aP     	if (*newfupto) insert_header(newfupto, newhq.tail, NEWS_K_HDR_FOLLOWUP_TO);     	if (*refstr) { 5     	    if (strlen(refstr) < 255+strlen(msgidstr)) {      	    	strcat(refstr, " ");#     	    	strcat(refstr, msgidstr); 
     	    }B     	    insert_header(refstr, newhq.tail, NEWS_K_HDR_REFERENCES);
     	} else {OD     	    insert_header(msgidstr, newhq.tail, NEWS_K_HDR_REFERENCES);     	} /* ** Set the Approved: header. */&     	status = cli_present("APPROVED");"     	if (status == CLI$_PRESENT) {/     	    Make_Return_Address(tmp, sizeof(tmp));i=     	    insert_header(tmp, newhq.tail, NEWS_K_HDR_APPROVED);,     	}   /* ** Set the Expires: header.* */%     	status = cli_present("EXPIRES");g"     	if (status == CLI$_PRESENT) {$     	    struct dsc$descriptor tdsc;     	    TIME expiry; 4     	    cli_get_value("EXPIRES", tmp, sizeof(tmp));,     	    INIT_SDESC(tdsc, strlen(tmp), tmp);:     	    status = lib$convert_date_string(&tdsc, &expiry);     	    if (OK(status)) {/     	    	Make_Date(&expiry, tmp, sizeof(tmp));'=     	    	insert_header(tmp, newhq.tail, NEWS_K_HDR_EXPIRES);g
     	    }     	} /* ** Set the Summary: header.s */%     	status = cli_present("SUMMARY");,"     	if (status == CLI$_PRESENT) {4     	    cli_get_value("SUMMARY", tmp, sizeof(tmp));<     	    insert_header(tmp, newhq.tail, NEWS_K_HDR_SUMMARY);     	}   /* ** Set the Keywords: header. */&     	status = cli_present("KEYWORDS");"     	if (status == CLI$_PRESENT) {)     	    char kw[STRING_SIZE], *fcp = kw;cB     	    while (OK(cli_get_value("KEYWORDS", tmp, sizeof(tmp)))) {&     	    	if (fcp != kw) *fcp++ = ',';     	    	locase(tmp);     	    	strcpy(fcp, tmp);r     	    	fcp += strlen(tmp);r
     	    }     	    *fcp = '\0';      	    if (*kw != '\0') {)=     	    	insert_header(kw, newhq.tail, NEWS_K_HDR_KEYWORDS); 
     	    }     	}  '     	strcpy(tmp, "Ready to post to: ");      	strcat(tmp, fuptostr);(     	put_output(tmp);l       }        if (mail_reply) {_     	struct HDR *h;n'     	strcpy(tmp, "Ready to mail to: ");t     	cp = tmp+18;;E     	for (h = destq.head; h != (struct HDR *) &destq; h = h->flink) { 6     	    if (cp != tmp+18) {*cp++ = ','; *cp++ = ' ';}     	    strcpy(cp, h->str);     	    cp += strlen(h->str);     	}     	put_output(tmp);n     }/  /     go_ahead = Yes_Answer("Ok to proceed?", 1);d   /*( ** If the user says it's OK, then do it. */     if (go_ahead) {OL     	if (post_reply) go_ahead = OK(Post_Article(&newhq, outspec, use_sigp));"     	if (mail_reply && go_ahead) {     	    int copy_self;y&     	    status = cli_present("SELF");0     	    copy_self = (status == CLI$_PRESENT) ||8     	    	(news_prof.csreply && status != CLI$_NEGATED);G     	    go_ahead = OK(Mail_Message(&destq, subjstr, outspec, use_sigm,n     	    	    	copy_self, 0));     	}     }      /*9 ** Find out if we should keep or delete the message file.; */&     if (extract) file_delete(infspec);       if (!go_ahead && is_temp) {t@     	go_ahead = !Yes_Answer("Keep file containing message?", 0);     }e2     if (go_ahead && is_temp) file_delete(outspec);     else if (is_temp) {      	strcpy(tmp, "Save as [");     	strcat(tmp, outspec);     	strcat(tmp, "]: ");7     	status = get_cmd(infspec, sizeof(infspec)-1, tmp);f,     	if (OK(status) && infspec[0] != '\0') {9     	    status = Copy_File(outspec, infspec, refstr, 0);t.     	    if (OK(status)) file_delete(outspec);     	    else {uI     	    	lib$signal(NEWS__WRITERR, 2, strlen(infspec), infspec, status);e"     	    	strcpy(refstr, outspec);
     	    }
     	} else { !     	    strcpy(refstr, outspec);}     	}.     	strcpy(tmp, "Message retained in file ");     	strcat(tmp, refstr);c     	put_output(tmp);i     }=   /* ** Clean up_ */<     while (queue_remove(newhq.head, &hdr)) mem_freehdr(hdr);<     while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr);       return SS$_NORMAL;   } /* cmd_reply */S O /* **++ **  ROUTINE:	cmd_forward ** **  FUNCTIONAL DESCRIPTION:  **  **  	FORWARD and STORE commands. **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_forward() ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.r ** **  COMPLETION CODES:(/ **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_forward() {       struct QUE *hdrq, destq;H     char subjstr[STRING_SIZE], infspec[FSPEC_SIZE], outspec[FSPEC_SIZE];D     char tmp[STRING_SIZE], tostr[STRING_SIZE], bodyfile[FSPEC_SIZE];     struct HDR *h, *hdr;
     char *cp;SE     int edit_flag, is_temp, go_ahead, use_sigfile, artnum, store_cmd;*&     unsigned int runit, wunit, status;       if (curgroup == NULL) {R%     	lib$signal(NEWS__NOCURGROUP, 0);s     	return SS$_NORMAL;N     }    /*? ** Initialize and check to see if we are FORWARDing or STORing.  */:     *subjstr = *infspec = *outspec = *tmp = *tostr = '\0';-     cli_get_value("$VERB", tmp, sizeof(tmp));F-     store_cmd = strncmp(tmp, "STOR", 4) == 0;=  %     destq.head = destq.tail = &destq;n   /* ** Which article?= */0     if (cli_present("ARTNUM") == CLI$_PRESENT) {/     	cli_get_value("ARTNUM", tmp, sizeof(tmp));s,     	lib$cvt_dtb(strlen(tmp), tmp, &artnum);!     } else if (cur_artnum == 0) {s'     	    lib$signal(NEWS__NOCURART, 0);p     	    return SS$_NORMAL;e     } else {     	artnum = cur_artnum;a     }    /*E ** If this is a STORE, then we send to ourselves.  Otherwise, we send(# ** to whoever the user tells us to.l */     if (!store_cmd) { 8     	while (OK(cli_get_value("TO", tmp, sizeof(tmp)))) {+     	    insert_header(tmp, destq.tail, 0);m     	}      	if (destq.head == &destq) {4     	    status = get_cmd(tmp, sizeof(tmp), "To: ");     	    if (OK(status)) {      	    	int len = strlen(tmp);7     	    	while (len > 0 && isspace(tmp[len-1])) len--;E*     	    	if (len == 0) return SS$_NORMAL;     	    	tmp[len] = '\0';"     	    } else return SS$_NORMAL;)     	    status = csl_parse(tmp, &destq);      	    if (!OK(status)) { B     	    	while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr);R     	    	if (status != RMS$_EOF) lib$signal(NEWS__FWDERR, 0, NEWS__ADDRSYNTX, 0);     	    	return SS$_NORMAL;
     	    }     	}%     	status = cli_present("SUBJECT");s"     	if (status == CLI$_PRESENT) {E     	    status = cli_get_value("SUBJECT", subjstr, sizeof(subjstr)); )     	} else if (status != CLI$_NEGATED) {"A     	    status = get_cmd(subjstr, sizeof(subjstr), "Subject: ");",     	    if (!OK(status)) return SS$_NORMAL;     	}     }    /*B ** We need the headers early so we can get the Subject header out. */=     status = Get_Article_Hdrs(curgroup, artnum, &hdrq, 0, 0);)     if (!OK(status)) {)     	lib$signal(NEWS__FWDERR, 0, status);l     	return SS$_NORMAL;(     })     if (store_cmd) {K     	for (hdr = hdrq->head; hdr != (struct HDR *) hdrq; hdr = hdr->flink) { /     	    if (hdr->code == NEWS_K_HDR_SUBJECT) { $     	    	strcpy(subjstr, hdr->str);     	    	break;
     	    }     	}     }    /* ** Build the message to be sent  */.     make_temp_fspec(infspec, sizeof(infspec));6     status = file_create(infspec, &wunit, 0, infspec);     if (!OK(status)) {)     	lib$signal(NEWS__FWDERR, 0, status);C     	return SS$_NORMAL;      }P  J     for (hdr = hdrq->head; hdr != (struct HDR *) hdrq; hdr = hdr->flink) {
     	int len; 0     	Format_Header(hdr, tmp, sizeof(tmp), &len);!     	file_write(wunit, tmp, len);T     }o     file_write(wunit, "", 0);      file_close(wunit);  &     make_temp_fspec(tmp, sizeof(tmp));;     status = Get_Article_Body(artnum, tmp, bodyfile, 0, 0);      if (!OK(status)) {     	file_delete(infspec);=     	while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr);N,     	lib$signal(NEWS__FWDERR, 0, status, 0);     	return SS$_NORMAL;t     }G   /** ** Append the article body to the message. */  0     status = Copy_File(bodyfile, infspec, 0, 1);     file_delete(bodyfile);     if (!OK(status)) {     	file_delete(infspec);=     	while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr); )     	lib$signal(NEWS__FWDERR, 0, status);p     	return SS$_NORMAL;g     }S   /*
 ** Signature?  */     if (store_cmd) {     	use_sigfile = 0;m     } else {'     	status = cli_present("SIGNATURE");t.     	use_sigfile = (status == CLI$_PRESENT) ||B     	    	      (news_prof.autosigmail && status != CLI$_NEGATED);     }'         cp = tostr; D     for (h = destq.head; h != (struct HDR *) &destq; h = h->flink) {1     	if (cp != tostr) {*cp++ = ','; *cp++ = ' ';})     	strcpy(cp, h->str);     	cp += strlen(h->str);     }      *cp = '\0';e   /* ** FORWARDs can be editedl */     if (store_cmd) {     	edit_flag = 0;k     } else {"     	status = cli_present("EDIT");,     	edit_flag = (status == CLI$_PRESENT) ||9     	    	    (news_prof.edit && status != CLI$_NEGATED);_     }N  D     status = Compose_Message(infspec, outspec, edit_flag, &is_temp);   /*D ** If there was a problem or the forward was cancelled, clean up and ** get out of here.o */*     if (!OK(status) || *outspec == '\0') {     	if (!OK(status)) {i0     	    lib$signal(NEWS__COMPOSERR, 0, status);
     	} else {i(     	    lib$signal(NEWS__CANCELLED, 0);     	}3     	if (is_temp && *outspec) file_delete(outspec);p     	file_delete(infspec);=     	while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr);u     	return SS$_NORMAL;=     }    /*6 ** STOREs are automatic.  Otherwise, get confirmation. */     if (store_cmd) {     	go_ahead = 1;     } else {'     	strcpy(tmp, "Ready to mail to: ");r     	strcat(tmp, tostr);     	put_output(tmp); 2     	go_ahead = Yes_Answer("Okay to proceed?", 1);     }u   /*% ** If the user says OK, then mail it.  */     if (go_ahead) {)     	int copy_self;      	if (store_cmd) {g     	    copy_self = 0;f
     	} else { &     	    status = cli_present("SELF");0     	    copy_self = (status == CLI$_PRESENT) ||:     	    	    (news_prof.csfwd && status != CLI$_NEGATED);     	}C     	Mail_Message(&destq, subjstr, outspec, use_sigfile, copy_self,O     	    	    	    store_cmd);     }h   /* ** Clean up  */     file_delete(infspec);{&     if (is_temp) file_delete(outspec);  <     while (queue_remove(destq.head, &hdr)) mem_freehdr(hdr);       return SS$_NORMAL;   } /* cmd_forward */f a /* **++ **  ROUTINE:	cmd_cancel  ** **  FUNCTIONAL DESCRIPTION:> **A **  	CANCEL command.  Builds a "cancel" control message to cancelNJ **  an article.  It first checks to make sure that the current user posted) **  the article that should be cancelled.  **B **  RETURNS:	cond_value, longword (unsigned), write only, by value ** **  PROTOTYPE: ** **  	cmd_cancel()  ** **  IMPLICIT INPUTS:	Many. ** **  IMPLICIT OUTPUTS:	None.H ** **  COMPLETION CODES:	/ **  	SS$_NORMAL: 	Normal successful completion.  ** **  SIDE EFFECTS:   	None. ** **-- */ unsigned int cmd_cancel() {        char tmp[STRING_SIZE];     struct QUE *hdrqptr, hdrq;     struct HDR *hdr, *msgid;     int chkdfrom, artnum;      unsigned int status;       if (curgroup == NULL) {h%     	lib$signal(NEWS__NOCURGROUP, 0);y     	return SS$_NORMAL;r     }Q   /* ** Which article?i */0     if (cli_present("ARTNUM") == CLI$_PRESENT) {/     	cli_get_value("ARTNUM", tmp, sizeof(tmp));S,     	lib$cvt_dtb(strlen(tmp), tmp, &artnum);D     	if (artnum > curgroup->lastavl || artnum < curgroup->frstavl) {<     	    lib$signal(NEWS__OUTRNG, artnum, curgroup->frstavl,!     	    	    curgroup->lastavl);      	}     	return SS$_NORMAL; !     } else if (cur_artnum == 0) { #     	lib$signal(NEWS__NOCURART, 0);      	return SS$_NORMAL;o     } else {     	artnum = cur_artnum;e     }J   /*E ** Verify that this user posted the article.  Anyone can do a cancel,e ** you know. */     chkdfrom = 0;c     msgid = NULL;C@     status = Get_Article_Hdrs(curgroup, artnum, &hdrqptr, 0, 0);     if (OK(status)) {"Q     	for (hdr = hdrqptr->head; hdr != (struct HDR *) hdrqptr; hdr = hdr->flink) {",     	    if (hdr->code == NEWS_K_HDR_FROM) {     	    	struct QUE adrq;'     	    	struct HDR *myfrom, *itsfrom;      	    	int do_it;  (     	    	adrq.head = adrq.tail = &adrq;0     	    	Make_Return_Address(tmp, sizeof(tmp));&     	    	Parse_ToList(tmp, &adrq, 0);+     	    	queue_remove(adrq.head, &myfrom);(I     	    	while (queue_remove(adrq.head, &itsfrom)) mem_freehdr(itsfrom);=+     	    	Parse_ToList(hdr->str, &adrq, 0);r     	    	do_it = 0;5     	    	while (queue_remove(adrq.head, &itsfrom)) {=D     	    	    if (strcmp(myfrom->str, itsfrom->str) == 0) do_it = 1;#     	    	    mem_freehdr(itsfrom);      	    	}c     	    	if (!do_it) {;F     	    	    lib$signal(NEWS__NOCANCEL, 1, artnum, NEWS__NOTYOURS, 4,0     	    	    	strlen(myfrom->str), myfrom->str,+     	    	    	strlen(hdr->str), hdr->str); "     	    	    mem_freehdr(myfrom);      	    	    return SS$_NORMAL;     	    	}i     	    	mem_freehdr(myfrom);     	    	chkdfrom = 1;p#     	    	if (msgid != NULL) break;O
     	    }2     	    if (hdr->code == NEWS_K_HDR_MESSAGE_ID) {     	    	msgid = hdr;     	    	if (chkdfrom) break;
     	    }     	} /*9 ** Everything's ok: build the cancel message and post it.i */)     	if (hdr != (struct HDR *) hdrqptr) {)'     	    hdrq.head = hdrq.tail = &hdrq;	K     	    insert_header(curgroup->grpnam, hdrq.tail, NEWS_K_HDR_NEWSGROUPS);       	    strcpy(tmp, "cancel ");!     	    strcat(tmp, msgid->str);b;     	    insert_header(tmp, hdrq.tail, NEWS_K_HDR_CONTROL);/;     	    insert_header(tmp, hdrq.tail, NEWS_K_HDR_SUBJECT);s,     	    status = Post_Article(&hdrq, 0, 0);@     	    while (queue_remove(hdrq.head, &hdr)) mem_freehdr(hdr);
     	} else {p/     	    lib$signal(NEWS__NOCANCEL, 1, artnum);_     	}     } else {+     	lib$signal(NEWS__NOCANCEL, 1, artnum);E     }        return SS$_NORMAL;   } /* cmd_cancel */    