   L /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *  *<  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%\=  *                %% \___________________________________%% \ >  *                %% |                                   %%  \?  *                %% |               REVERT              %%   \ @  *                %% |          support.c  c2004         %%    \@  *                %% |            Lyle W. West           %%    |@  *                %% |                                   %%    |@  *                %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    |@  *                \                                        \   |@  *                 \                                        \  |@  *                  \                                        \ |@  *                   \________________________________________\|  *  *  *9  *  Copyright (C) 2004 Lyle W. West, All Rights Reserved. J  *  Permission is granted to copy and use this program so long as [1] thisH  *  copyright notice is preserved, and [2] no financial gain is involvedH  *  in copying the program.  This program may not be sold as "shareware"G  *  or "public domain" software without the express, written permission   *  of the author.  *@  *  This application must be relinked if the current VMS version+  *  is upgraded to version 7.3-2 or higher.   *M  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */     #define VERSION "V1.2-2" #pragma module SUPPORT VERSION    #include <stdio.h> #include <climsgdef.h> #include <ctype.h> #include <descrip.h> #include <jpidef.h>  #include <lnmdef.h>  #include <prvdef.h>  #include <psldef.h>  #include <ssdef.h> #include <string.h>  #include <stdlib.h> A #include <rms.h>                /* Include the RMS definitions */     #ifdef __ALPHA #define ARCH 1 #else  #define ARCH 0 #endif    typedef struct {      unsigned char FileName[132];     unsigned int Value;      unsigned int Status; } FILE_LST;        extern int CheckCount; extern int PurgeCount; extern int RevertCount;  extern int ErrCnt; extern int TotalAlloc; extern int TotalUsed;  extern int alloc_size; extern int used_size;    K extern short AllFlg;            /* user specified cmdline /ALL qualifier */ H extern short CheckFlg;          /* user want to see filespec contents */K extern short ElipsisFlg;        /* user specified [...] withing filespec */  extern short ExcludeCount;B extern short ExcludeFlg;        /* exclude specified file types */K extern short KeepFlg;           /* user supplied cmdline /KEEP qualifier */ F extern short KeepValue;         /* value provided by user for above */N extern short MinimumFlg;        /* user supplied cmdline /MINIMUM qualifier */F extern short MinimumValue;      /* value provided by user for above */O extern short NumFiles;          /* quantity of files of same name, diff vers */ H extern short PathFlg;           /* filepath to Dispatch() has changed */    extern char Buffer[80]; L extern char CmdVerb[32];        /* foreign cmd string invoking this image */ extern char CurPath[80];K extern char ExcludeStr[80];     /* file types to exclude from operations */  extern char NewPath[80]; extern char TargetPath[80];     globalvalue CTL$AG_CLIDATA;  globalvalue PRC_L_RECALLPTR; globalvalue PPD$L_PRC; globalvalue PRC_S_COMMANDS;     extern int lib$get_foreign();  extern int lib$get_input();  extern void ShowHelp();     globalvalue REVERT_CLD;       H /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *G  *  ShowHelp - Display a brief combination of REVERT.README and the cdu H  *             REVERT.CLD file. It provides a command line glance at the8  *             optional implementations of REVERT usage.  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void ShowHelp()  { 2     printf("\n\n  %s (%s)\n\n", CmdVerb, VERSION);N     printf("\tChanges the file version number of single/multiple versions\n");O     printf("\tof files in a directory. The lowest version of the filename \n"); L     printf("\tis renamed to version 1, and the highest version becomes \n");L     printf("\tversion n, where n is the total number of existing files \n");M     printf("\tof that name. If used with the /KEEP qualifier, lower file\n"); M     printf("\tversions are purged up to the KEEP value entered, then the\n"); O     printf("\tremaining file versions are renumbered, up from version 1.\n\n"); M     printf("\tNote that if the /MINIMUM value is between the highest and\n"); R     printf("\tthe lowest versions of a target filespec, %s adjusts the minimum\n",         CmdVerb); N     printf("\tvalue so all applicable versions are purged. Use the /CHECK\n");I     printf("\tqualifier first to determine file versions involved.\n\n"); N     printf("\tA significant attribute of %s is after the file versions are\n",         CmdVerb); R     printf("\treverted to lower version numbers, the date/time stamps of each\n");J     printf("\tfile remains identical to value prior to executing %s,\n\n",         CmdVerb); #     printf("     Parameters:\n\n"); L     printf("\t%s accepts one parameter, a VMS filespec which points to a\n",         CmdVerb); L     printf("\tdirectory and wildcarded filename specs. Filespec can use\n");F     printf("\twildcards per normal RMS wildcard usage. Example:\n\n");C     printf("\t  $ %s /CHECK SYS$SYSROOT:[SYSEXE]*.LOG\n", CmdVerb); 7     printf("\n\tThe default is *.*;* if omitted.\n\n"); "     printf("     Qualifiers\n\n");Q     printf("\t/ALL - if present, %s will revert/check the file version of all\n",          CmdVerb); N     printf("\t\tqualified files in the filepath, even if only one version\n");K     printf("\t\tis present. Files with version value of 1 are ignored.\n"); L     printf("\t\tRevert and Check are subject to command line parameters\n");8     printf("\t\tand qualifiers specified by user.\n\n");M     printf("\t/CHECK - Displays a list of files subject to reversion and\n"); N     printf("\t\tpurging based on the filespec and qualifiers specified on\n");L     printf("\t\ton the command line. No files are reverted or purged.\n\n");P     printf("\t/EXCLUDE=(list) - a list of one or more file TYPES which will\n");K     printf("\t\tbe excluded from both PURGE and REVERT operations. The\n"); K     printf("\t\tlist of exclusions must be enclosed in parentheses and\n"); :     printf("\t\titems separated by commas. Example:\n\n");K     printf("\t\t     $ %s /CHECK /EXCLUDE=(COM,DAT,LIS) *.*\n\n", CmdVerb); M     printf("\t/KEEP=n - if present, %s will retain the n highest versions\n",          CmdVerb); K     printf("\t\tand purge the remainder of lower versions. If /KEEP is\n"); H     printf("\t\tnot specified, the keep value defaults to 1 and all\n");:     printf("\t\tbut the highest version are purged.\n\n");O     printf("\t/MINIMUM=n - if present, %s will revert any filenames in the \n",          CmdVerb); M     printf("\t\tspecified path with a version at or higher than MINIMUM.\n"); N     printf("\t\tIf /MINIMUM is omitted, all matching files from the input\n");J     printf("\t\tfilespec with multiple versions are subject to being \n");H     printf("\t\treverted to lower versions, subject to the value of\n");9     printf("\t\tspecified for the /KEEP qualifier.\n\n"); /     printf("\t/HELP - Displays this text\n\n"); G     printf("\t/VERSION - %s displays version, build date,\n", CmdVerb); B     printf("\t\tand required privs for VMS Install utility.\n\n");     exit(1); }          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: RevertFiles E  * Description: Given a filespec as an argument, create a list of all F  *              versions of that filename and revert to lower versionsH  *              so lowest version will be ';1' and highest will be ';n',I  *              where n is the number if file versions present. The files H  *              are located and saved in an array, then renamed from theG  *              array, lowest version first. Lastly, a list of previous .  *              and new versions is displayed.  *F  *              If a filename has multiple versions where the highest H  *              version is greater than MinimumValue, we will revert theJ  *              versions of all files, as PurgeFiles() has already removedJ  *              all versions below KeepValue, even if  subsequent versions(  *              fall below MinimumValue.  *I  *              If the version of *filespec is less than MinimumValue, we -  *              simply return and do nothing.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */   void RevertFiles(char *filespec) {      int newvers = 1;L     int curvers = 0;        /* version of filename specified in *filespec */D     int filecount = 0;      /* will be number of versions located */     int rmsstat;        char fullspec[132];      char NewVerStr[16];      char NewFname[80];     char OldFname[80];     char RvtRsa[132];      char RvtEsa[132];      char *ptr;        struct FAB RvtFab;     struct NAM RvtNam;        FILE_LST  *RvtList; 7     FILE_LST  *FilePtr;         /* FilePtr->FileName */         RvtFab = cc$rms_fab;     RvtNam = cc$rms_nam;   J         /* get the version number of *filespec. If 'curvers' is lower than<            MinimumValue, we return without doing anything */        ptr = strchr(filespec, ';');
     if(ptr) {          ptr++;$         sscanf(ptr, "%d", &curvers);<         if(MinimumValue && (curvers < MinimumValue)) return;     }   D         /* reserve sufficient memory for a list of files base on theF            number of versions provided by main(). We probably will not!            use all array slots */   @     RvtList = (FILE_LST *) calloc(NumFiles+1, sizeof(FILE_LST));     FilePtr = RvtList;  A         /* init the fab and nam structures to get all versions */         strcpy(fullspec, filespec);       ptr = strchr(fullspec, ';');     if(ptr) *ptr = 0;      strcat(fullspec, ";*");   D     RvtFab.fab$l_dna = fullspec;           /* address of fullspec */C     RvtFab.fab$b_dns = strlen(fullspec);   /* assign the length. */ E     RvtFab.fab$l_nam = &RvtNam;            /* address of NAM block */    B     RvtNam.nam$l_esa = RvtEsa;             /* address of RvtEsa */A     RvtNam.nam$b_ess = sizeof(RvtEsa);     /* length of RvtEsa */ B     RvtNam.nam$l_rsa = RvtRsa;             /* address of RvtRsa */A     RvtNam.nam$b_rss = sizeof(RvtRsa);     /* length of RvtRsa */    @         /* create a list of files to rename to lower versions */   '     rmsstat = sys$parse(&RvtFab, 0, 0); $     RvtEsa[RvtNam.nam$b_esl] = '\0';#     while(rmsstat == RMS$_NORMAL) { ,         rmsstat = sys$search(&RvtFab, 0, 0);)         if(rmsstat != RMS$_NORMAL) break; (         RvtRsa[RvtNam.nam$b_rsl] = '\0';3         sscanf(RvtNam.nam$l_ver+1, "%d", &curvers); *         strcpy(FilePtr->FileName, RvtRsa);         FilePtr++;         filecount++;     }    >         /* rename files from bottom up using saved names. This8            method helps prevent duplicate name errors */   >     FilePtr--;          /* point to lowest filename version */!     while(newvers <= filecount) { :         rmsstat = RenameFile(&FilePtr->FileName, newvers);!         FilePtr->Value = newvers; "         FilePtr->Status = rmsstat;         FilePtr--;         newvers++;     }    1         /* see if we need to show where we are */         if(ElipsisFlg) {         if(!strlen(CurPath)) {$             strcpy(CurPath, RvtRsa);'             ptr = strchr(CurPath, ']');              if(ptr) {                  ptr++;                 *ptr = 0; 
             } '             printf("\n %s\n", CurPath); 	         }          else {$             strcpy(NewPath, RvtRsa);'             ptr = strchr(NewPath, ']');              if(ptr) {                  ptr++;                 *ptr = 0; 
             } /             if(strcmp(CurPath, NewPath) != 0) { +                 printf("\n %s\n", NewPath); )                 strcpy(CurPath, NewPath); 
             } 	         }      }    ?         /* finally, show user what we have just accomplished */         FilePtr++;&     while(strlen(FilePtr->FileName)) {-         ptr = strchr(FilePtr->FileName, ']');          if(ptr) ptr++;         strcpy(NewFname, ptr);         strcpy(OldFname, ptr);,         if(FilePtr->Status == RMS$_NORMAL) {(             ptr = strchr(NewFname, ';');             if(ptr) *ptr = 0; 6             sprintf(NewVerStr, ";%d", FilePtr->Value);(             strcat(NewFname, NewVerStr);=             printf("  %25s --> %-30s\n", OldFname, NewFname);              RevertCount++;	         } )         if(FilePtr->Status == RMS$_FLK) { L             printf("  %25s --> file locked by another process\n", OldFname);             ErrCnt++; 	         } 0         if(FilePtr->Status == SS$_DUPFILENAME) {A             printf("  %25s --> duplicate file name\n", OldFname);              ErrCnt++; 	         }          FilePtr++;     }      cfree(RvtList);  }          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: PurgeFilesE  * Description: User entered the /KEEP=n qualifier and the Dispatch() E  *              routine has determined the number of file versions is E  *              greater than the KEEP value. Determine which files to C  *              retain, and save older file version names in array. H  *              Then use filespecs in array to purge the older versions./  *              Display a list of files purged.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void PurgeFiles(char *filespec)  {      int HighNum;4     int LowNum;             /* currently not used */D     int count = 0;          /* determines file versions to remove */L     int curvers = 0;        /* version of filename specified in *filespec */U     int localalloc = 0;     /* blocks allocated of filename specified in *filespec */ P     int localused = 0;      /* blocks used of filename specified in *filespec */>     int lowvers = 0;        /* lowest version of input file */H     int tempminimum = 0;    /* possibly adjusted value from /MIN qual */3     int rms_stat;           /* rms return status */         char filename[80];     char fullspec[132];      char PurgEsa[132];     char PurgRsa[132];     char *ptr;        struct FAB PurgFab;      struct NAM PurgNam;         FILE_LST  *PurgList;7     FILE_LST  *FilePtr;         /* FilePtr->FileName */            PurgFab = cc$rms_fab;      PurgNam = cc$rms_nam;    H         /* if group of files to purge has versions both greater than andH            less than MinimumValue, we adjust a local minimumvalue so allH            needed version can be purged. This does not change the actual'            MinimumValue entered by user           */         ptr = strchr(filespec, ';');
     if(ptr) {          ptr++;$         sscanf(ptr, "%d", &curvers);%         lowvers = curvers - NumFiles;          if(MinimumFlg) {;             if(MinimumValue && (curvers >= MinimumValue)) { A                 if(lowvers < MinimumValue) tempminimum = lowvers; 0                 else tempminimum = MinimumValue;-                 if(lowvers <= 0) lowvers = 1; 
             } L             else return;    /* version less than MinimumValue, do nothing */	         } (         else tempminimum = MinimumValue;     }   3         /* reserve memory for array of filespecs */   A     PurgList = (FILE_LST *) calloc(NumFiles+1, sizeof(FILE_LST));      FilePtr = PurgList;         HighNum = NumFiles + 1; !     LowNum = HighNum - KeepValue;      strcpy(fullspec, filespec);       ptr = strchr(fullspec, ';');     if(ptr) *ptr = 0;      strcat(fullspec, ";*");   F     PurgFab.fab$l_dna = fullspec;            /* address of fullspec */E     PurgFab.fab$b_dns = strlen(fullspec);    /* assign the length. */ G     PurgFab.fab$l_nam = &PurgNam;            /* address of NAM block */    E     PurgNam.nam$l_esa = PurgEsa;             /* address of PurgEsa */ D     PurgNam.nam$b_ess = sizeof(PurgEsa);     /* length of PurgEsa */E     PurgNam.nam$l_rsa = PurgRsa;             /* address of PurgRsa */ D     PurgNam.nam$b_rss = sizeof(PurgRsa);     /* length of PurgRsa */  n)     rms_stat = sys$parse(&PurgFab, 0, 0); &     PurgEsa[PurgNam.nam$b_esl] = '\0';  I         /* fill the array with full filespec of the files to be purged */   $     while(rms_stat == RMS$_NORMAL) {.         rms_stat = sys$search(&PurgFab, 0, 0);*         if(rms_stat != RMS$_NORMAL) break;*         PurgRsa[PurgNam.nam$b_rsl] = '\0';         count++;L         if(count > HighNum) {           /* pseudo number of file versions */6             rms_stat = 99018;           /* RMS$_NMF */             break;	         }*M         if(count > KeepValue) {         /* if true, save filespec in array */r/             strcpy(FilePtr->FileName, PurgRsa);              FilePtr++;	         };     }*  G     FilePtr = PurgList;     /* pointer back to the top of purge list */s  [1         /* see if we need to show where we are */[  ;     if(ElipsisFlg) {         if(!strlen(CurPath)) {%             strcpy(CurPath, PurgRsa); '             ptr = strchr(CurPath, ']');t             if(ptr) {                  ptr++;                 *ptr = 0;P
             } '             printf("\n %s\n", CurPath);m	         }a         else {%             strcpy(NewPath, PurgRsa); '             ptr = strchr(NewPath, ']');n             if(ptr) {t                 ptr++;                 *ptr = 0;,
             }p/             if(strcmp(CurPath, NewPath) != 0) { +                 printf("\n %s\n", NewPath);r)                 strcpy(CurPath, NewPath); 
             }f	         }o     }a  I         /* read each filespec from the array, get file sizes and version. H            Check for valid version and remove the file, displaying stats3            and update global size and count info */   &     while(strlen(FilePtr->FileName)) {?         rms_stat = GetBlockValues(FilePtr->FileName, &curvers);f%         if(rms_stat != RMS$_NORMAL) {fH             if(rms_stat == RMS$_FLK) printf("    %s    <file locked>\n",#                 FilePtr->FileName);               else exit(rms_stat);	         }b.         PurgFab.fab$l_dna = FilePtr->FileName;6         PurgFab.fab$b_dns = strlen(FilePtr->FileName);'         if(MinimumFlg && tempminimum) {l(             if(curvers >= tempminimum) {5                 rms_stat = sys$erase(&PurgFab, 0, 0); 2                 PurgRsa[PurgNam.nam$b_rsl] = '\0';E                 printf("%%%s-I-PURGE, purged %s    (%d/%d blocks)\n",RH                     CmdVerb, PurgNam.nam$l_name, used_size, alloc_size);)                 localalloc += alloc_size;a'                 localused += used_size;a)                 TotalAlloc += alloc_size;a'                 TotalUsed += used_size;y                 FilePtr++;                 PurgeCount++;)
             } 	         }t5         else {      /* minimum value not specified */+1             rms_stat = sys$erase(&PurgFab, 0, 0);a.             PurgRsa[PurgNam.nam$b_rsl] = '\0';A             printf("%%%s-I-PURGE, purged %s    (%d/%d blocks)\n",vD                 CmdVerb, PurgNam.nam$l_name, used_size, alloc_size);%             localalloc += alloc_size;t#             localused += used_size;h%             TotalAlloc += alloc_size;m#             TotalUsed += used_size;,             FilePtr++;             PurgeCount++; 	         }-     }      cfree(PurgList); }t  ;   N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  * Function: CheckLnm L  * Description: Function to translate a provided logical name to the definedK  *              equivalence string. Only the current JOB logical name table+D  *              is searched for a match. If successful, the returnedK  *              equivalence string is copied to the memory location used tovL  *              provide the input logical name (*lnmstr) so caller must makeG  *              certain the buffer containing the input logical name is F  *              large enough to contain the full equivalence string orG  *              this routine returns SS$_BUFFEROVF. In all other cases, F  *              the return status of SYS$TRNLNM is returned to caller.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */ & int CheckLnm(char *lnmstr, int buflen) { I     int nocase = LNM$M_CASE_BLIND;  /* resolve lnm without case issues */,K     int eqvattrb = 0;               /* returned attributes of eqv string */r     int lnmstat = 0;     short eqv_len = 0;     short tbl_len = 0;<     char acmode;                    /* requires exec mode */<     char LnmTable[40];              /* logical name table */=     char LnmDef[40];                /* logical name string */ I     char LnmEqv[80];                /* logical name equivalence string */o  d>     struct {short len, code; int *bufadr, *retlen;} lnmitm[4];   &     $DESCRIPTOR(dsc_tabnam, LnmTable);$     $DESCRIPTOR(dsc_lognam, LnmDef);$     $DESCRIPTOR(dsc_eqvnam, LnmEqv);   
 #ifdef SECUREr     acmode = PSL$C_EXEC; #elsee     acmode = PSL$C_USER; #endif   '     memset(&LnmEqv, 0, sizeof(LnmEqv));*     strcpy(LnmDef, lnmstr);*      strcpy(LnmTable, "LNM$JOB");  c/     dsc_tabnam.dsc$w_length = strlen(LnmTable);e-     dsc_lognam.dsc$w_length = strlen(LnmDef); -     dsc_eqvnam.dsc$w_length = sizeof(LnmEqv);l  e%     lnmitm[0].len = sizeof(eqvattrb);n%     lnmitm[0].code = LNM$_ATTRIBUTES;t!     lnmitm[0].bufadr = &eqvattrb;e     lnmitm[0].retlen = 0;n%     lnmitm[1].len = sizeof(LnmTable);s      lnmitm[1].code = LNM$_TABLE;!     lnmitm[1].bufadr = &LnmTable;       lnmitm[1].retlen = &tbl_len;#     lnmitm[2].len = sizeof(LnmEqv);*!     lnmitm[2].code = LNM$_STRING;      lnmitm[2].bufadr = &LnmEqv;       lnmitm[2].retlen = &eqv_len;     lnmitm[3].len = 0;     lnmitm[3].code = 0;n  oN     lnmstat = sys$trnlnm(&nocase, &dsc_tabnam, &dsc_lognam, &acmode, &lnmitm);     if(lnmstat == SS$_NORMAL) {e         LnmEqv[eqv_len] = '\0';o!         LnmTable[tbl_len] = '\0';e4         if(eqv_len < buflen) strcpy(lnmstr, LnmEqv);#         else return(SS$_BUFFEROVF);e     }e8     if(eqvattrb & LNM$M_CONCEALED) return(SS$_IVLOGNAM);     else return(lnmstat);/ }   nN /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: DispatchI  * Description: The main() routine has identified a file having multiple PM  *              versions or a version higher than 1 within the user specifiedbG  *              filepath. Using flags set by parsing the command line,  K  *              dispatch control to appropriate subfunctions based on which J  *              flags are set, the values which the user assigned to thoseM  *              flags, and the number of versions of a file. This routine canl>  *              be called multiple times for a given filepath.  *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  void Dispatch(char *filespec)e {'     int stat = 0;      char thispath[80];       char *ptr;       strcpy(thispath, filespec);v      ptr = strchr(thispath, ']');
     if(ptr) {          ptr++;         *ptr = 0;=     }m+     if(strcmp(TargetPath, thispath) != 0) {m%         strcpy(TargetPath, thispath);          PathFlg = TRUE;m     }mC     NumFiles++;             /* assumed to be off by one at entry */    C     if(ExcludeFlg) {        /* see if this file type is excluded */h'         stat = CheckExcludes(filespec);m-         if(stat == SS$_OBJECT_EXISTS) return;e     }    ;     if(CheckFlg) {        /* if true, ignore other flags */N         ShowCheck(filespec);         return;u     }    I         /* we would not get here if /CHECK was specified, so assume /KEEPcK            was entered or defaulted. If NumFiles is greater than Keepvalue,=F            call PurgeFiles() which will remove lower versions of files@            based on KeepValue and, if specified, MinimumValue */  2     if(NumFiles > KeepValue) PurgeFiles(filespec);  M         /* lastly, we revert the file(s) to the lowest version(s) possible */a       RevertFiles(filespec);     PathFlg = FALSE; }      u  aN /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: CheckExcludes I  * Description: We are passed a filespec which we must parse to determine*J  *              if it contains an excluded file type. Extract filename andL  *              from that extract the file type string, removing all versionI  *              information. Compare this string with the contents of the J  *              exclude values from the command line. If we do not find anI  *              exact match, return SS$_NORMAL, else return some positive +  *              integer value other than 1.   *O  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */  int CheckExcludes(target)% {%
     int stat;|  *     char filename[60];     char filetype[20];     char *ptr;   D     ptr = strchr(target, ']');              /* strip off filename */
     if(ptr) {          ptr++;         strcpy(filename, ptr);D         ptr = strchr(filename, '.');        /* strip off filetype */         if(ptr) {              ptr++;"             strcpy(filetype, ptr);A             ptr = strchr(filetype, ';');    /* and verion info */o             *ptr = 0;rL             strcat(filetype, ",");          /* append a comma to filetype */	         }      }s     else return(SS$_NORMAL);  c?     if(strstr(ExcludeStr, filetype)) return(SS$_OBJECT_EXISTS);f     else return(SS$_NORMAL); }a    N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetBlockValuesD  * Description: the filename about to be deleted is specified by theA  *              input argument 'FileSpec'. Initialize fab and xabtE  *              structures then open and close specified file to fill>E  *              in the structures. Extract number of blocks allocatedc;  *              and used and the file version, then return.i  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */s3 int GetBlockValues(char *FileSpec, int *targetvers)f {      int rms_stat;      char AllocRsa[132];i     char AllocEsa[132];    @     struct FAB AllocFab;            /* file alloccation block */     struct NAM AllocNam;H     struct XABFHC XabFhc;           /* file header characteristic XAB */  n<     AllocFab = cc$rms_fab;          /* init FAB structure */<     AllocNam = cc$rms_nam;          /* init NAM structure */>     XabFhc = cc$rms_xabfhc;         /* init XABFHC structure*/  l"     AllocFab.fab$l_fna = FileSpec;*     AllocFab.fab$b_fns = strlen(FileSpec);#     AllocFab.fab$b_fac = FAB$M_GET; #     AllocFab.fab$l_fop = FAB$V_NAM;nG     AllocFab.fab$l_nam = &AllocNam;          /* address of NAM block */xL     AllocFab.fab$l_xab = (char *) &XabFhc;   /* chain the file header xab */  nF     AllocNam.nam$l_esa = AllocEsa;           /* address of AllocEsa */E     AllocNam.nam$b_ess = sizeof(AllocEsa);   /* length of AllocEsa *//F     AllocNam.nam$l_rsa = AllocRsa;           /* address of AllocRsa */E     AllocNam.nam$b_rss = sizeof(AllocRsa);   /* length of AllocRsa */f  *     rms_stat = sys$parse(&AllocFab, 0, 0);(     AllocEsa[AllocNam.nam$b_esl] = '\0';+     rms_stat = sys$search(&AllocFab, 0, 0);r(     AllocRsa[AllocNam.nam$b_rsl] = '\0';  #     rms_stat = SYS$OPEN(&AllocFab);0I     if(rms_stat != RMS$_NORMAL) return(rms_stat); /* SYSTEM-E-BADPARAM */s$     rms_stat = SYS$CLOSE(&AllocFab);I     if(rms_stat != RMS$_NORMAL) return(rms_stat); /* SYSTEM-E-BADPARAM */_  A5     sscanf(AllocNam.nam$l_ver + 1, "%d", targetvers);N$     alloc_size = AllocFab.fab$l_alq;!     used_size = XabFhc.xab$l_ebk;x  n     return(RMS$_NORMAL); }l  u    EH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *  *    Function: GetCmdLineI  * Description: Retrieve the last command entered from the command recall H  *              buffer in the users process space, the command which wasJ  *              used to invoke this image. The contents of this recall bufK  *              are saved in a user specified buffer. In the unlikely event H  *              that the command line is longer than callers buffer, setM  *              length to -1 and return SS$_BUFFEROVF. Else return SS$_NORMAL   *J  *              This routine is aware of buffer length changes implemented'  *              in VMS 7.3-2 and above.c  *I  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */lA int GetCmdLine(struct dsc$descriptor_s *DscTarget, short *length)i { <     char    *Sptr = 0;      /* last recall buffer pointer */D     char    *Dptr = 0;      /* callers string destination pointer */        short   ExpBuf = 0;e@     short   *Lptr = 0;      /* pointer to callers length word */  t     int     BufSize;     int     RecallAddr = 0;t     int     ppd = 0;     int     prc = 0;A     int     *Iptr = 0;      /* integer pointer for indirection */i  lD         /* recall buffer larger for V7.3-2 and higher. Use this infoD            to determine whether recall buffer length is presented to$            us as a byte or a word */   =     BufSize = PRC_S_COMMANDS;       /* get size of rcl buf */      if(BufSize > 4100)D         ExpBuf = TRUE;              /* if < 4100, osvers <= 7.3-1 */   8     RecallAddr = CTL$AG_CLIDATA;    /* address of ppd */8     RecallAddr += PPD$L_PRC;        /* address of prc */A     prc = PRC_L_RECALLPTR;          /* current command pointer */VA     Iptr = RecallAddr;              /* pseudo pointer register */s     RecallAddr = *Iptr;n0     RecallAddr += prc;              /* offset */B     Iptr = RecallAddr;              /* copy to pointer register */L     RecallAddr = *Iptr;             /* RecallAddr points to end of buffer */  nA         /* here we use recall allocation to determine the size oflB            the recall buffer length field, changed at vms 7.3.2 */  nE     if(ExpBuf) RecallAddr -= 2;     /* length is 16 bits at 7.3-2+ */ ?     else RecallAddr--;              /* else length is 8 bits */o     Sptr = RecallAddr;$     Dptr = DscTarget->dsc$a_pointer;  nB         /* be sure cmd line not longer than callers buffer. If so,6            ignore cmd line and return SS$_BUFFEROVF */  e     if(ExpBuf) {         Lptr = Sptr;O         if(*Lptr < DscTarget->dsc$w_length-1) *length = *Lptr; /* 16 bit val */n         else {             *length = -1;e"             return(SS$_BUFFEROVF);	         }E     } 2     else *length = *Sptr;       /*  8 bit value */   C         /* get buffer length and copy cmd line to callers buffer */)        Sptr -= *length;!     strncpy(Dptr, Sptr, *length);r     return(SS$_NORMAL);r }f  t  tH /* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *  *B  *  ShowVers - displays current installed version, build date, andB  *             required privs for interactive usage and/or the VMS  *             install utility.h  *K  * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */t void ShowVers()a {s1     printf("\n\t\t%s by Lyle W West\n", CmdVerb); F     printf("\t\tVersion: %s (%s)\n", VERSION, ARCH ? "Alpha" : "Vax");;     printf("\t\tImage Build: %s (%s)\n", __DATE__, "DecC");   n
 #ifdef SECUREe6     printf("\t\tRequired Privs: SETPRV [Secure]\n\n"); #elsen4     printf("\t\tRequired Privs: None [SYSPRV]\n\n"); #endif     exit(1); }n  "  t  eec with multiple versions are subject to being \n");H     printf("\t\treverted to lower versions, subject to the value of\n");9     printf("\t\tspecified for the /KEEP qualifier.\n\n"); /     printf("\t/HELP - Displays this text\n\n"); G     printf("\t/VERSION - %s displays version, build date,\n", CmdVerb); B     printf("\t\tand required privs for VMS Install utility.\n\n");     exit(1); }          N /* * * * * * * * * * * * * * * * * * * * * * * * * * * * *                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                