	Program Mlsearch
*
*** V3.0 edited 7 july 1991 by Kevin
***		Add Wsrv routine
*
	Implicit None
	Character*160 File
	Integer Fillen
	Integer LibIdx
	Integer Status
	Logical ISAM
	Logical Open_Mail
*
*	Search mail files for specific strings
*	PRSCOM parses global qualifiers for the command, and
*	sets up info in common block /QUALCOM/
*	PRSTARGET gets the target strings, and initializes the
*	strings pointed to by /TRGCOM/
*	PRSFIL parses the input file names, and any /FOLDER qualifiers,
*	and returns one filename and folder stuff on each call.
*
	Call Prscom
	Call PrsTarget

	Call PrsFil(File,Fillen)
*
*	Main loop - Call PRSFIL, get next file name to look at.
*	Open_Mail opens the file, and sets up context info, like whether
*	it is sequential. Search_Mail sets up the loop to search each folder.
*	Open_Folder builds up context info for a folder, then calls
*	search_folder to do the work. This calls search_message for
*	each message.
*
	Do While (Fillen .gt. 0)

		If(Open_Mail(File(1:Fillen),Libidx,Isam)) Then
		  Call Search_Mail(Libidx,Isam)
		Endif
		Call PrsFil(File,Fillen)

  	Enddo

	Call Stat_Rep(Status)
	Call Exit(Status)

	End

	Subroutine Search_Mail(Libidx,ISAM)
*
*	Search one mail file for specified text.
*	We are passed the mail file context, and it is up to us to decide
*	how to proceed. ISAM files use folder action routines -
*	sequential mail files use our own more primitive stuff.
*	**** NOTE **** Sequential mail files are dropped at the moment
*
	Implicit None
	Integer Libidx
	Logical ISAM

	Integer Status
	External Search_Folder
	Integer Mail$Mailfile_Info_File,Mail$Message_begin,Mail$Message_end
	Integer Msctx
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure
	Logical Close_mail

	Record /Itmlst/ InItm(5),Oitm(5),Nullitm
	Include '($MAILDEF)'
	Include 'FILCOM.INC'
	EXTERNAL MLSEARCH_NOSEQMAI
*-------------------------------------------------------------

*	Store mailfile handle for co-routine

	FilIdx = Libidx

	Nullitm.code = 0
	Nullitm.Blen = 0
	Nullitm.Bufadr = 0
	Nullitm.Retlenadr = 0

	If(ISAM) Then
*
*	First, set up a message context for the folder action routine.
*
		Msctx = 0
		Initm(1).Code = Mail$_Message_file_ctx
		Initm(1).Blen = 4
		Initm(1).Bufadr = %loc(Filidx)
		Initm(1).Retlenadr = 0
		Initm(2) = Nullitm
		Oitm(1) = Nullitm
		Status = Mail$Message_Begin(Msctx,Initm,Oitm)
*
*	Now ask the mailer to call Search_folder for each folder.
*
		Initm(1).Code = Mail$_Mailfile_Folder_Routine
		Initm(1).Blen = 4
		Initm(1).Bufadr = %Loc(Search_Folder)
		Initm(2).Code = Mail$_Mailfile_User_Data
		Initm(2).Blen = 4
		Initm(2).Bufadr = %Loc(Msctx)
		Initm(3) = Nullitm
*
*	Should pick up filename here, and store in Current_File
*
		Status = Mail$Mailfile_Info_File(Libidx,Initm,Nullitm)
		Call Stchek(Status)
		Initm(1) = Nullitm
		Oitm(1) = Nullitm
		Status = Mail$Message_End(Msctx,Initm,Oitm)
		Call Stchek(Status)
	Else
		Call Lib$Signal(MLSEARCH_NOSEQMAI,%Val(1),
     $               Current_File(1:Cfilnaml))
		Status = Close_Mail(Libidx)
		Return
	Endif
*
*	Accumulate file statistics, and possibly do some logging
*
	Call File_end(Status)

	Status = Close_Mail(Libidx)

	Return
	End

	Logical Function Open_Mail(Filename,Mfctx,Isam)
*
*	Open the named mailfile, and return the file context and a flag
*	indicating whether it is folder-structured or sequential.
*
	Implicit None
	Character*(*) Filename
	Integer Mfctx
	Logical ISAM
	External MLSEARCH_OPENIN

	Integer Mail$Mailfile_Begin
	Integer Mail$Mailfile_Open
	INclude 'FILCOM.INC'
	Include '($MAILDEF)'
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure

	Record /Itmlst/ Itm(5),Oitm(5),Nullitm
	Integer Status
	Logical Debuging
	Integer LogLvl
	External MLSEARCH_INICALMAI,MLSEARCH_DONE,MLSEARCH_OPEMAIFIL
*-------------------------------------------------------------

	Nullitm.code = 0
	Nullitm.Blen = 0
	Nullitm.Bufadr = 0
	Nullitm.Retlenadr = 0

	If(Loglvl() .ge. 3) Call Lib$Signal(MLSEARCH_INICALMAI)
	Status = Mail$Mailfile_Begin(Mfctx,Nullitm,Nullitm)
	Call StChek(Status)
	If(Debuging())  Call Lib$Signal(MLSEARCH_DONE)
	Itm(1).Code = Mail$_Mailfile_Name
	Itm(1).Blen = Len(Filename)
	Itm(1).Bufadr = %Loc(Filename)
	Itm(2) = Nullitm
	Oitm(1).Code = Mail$_Mailfile_Indexed
	Oitm(1).Bufadr = %Loc(Isam)
	Oitm(1).Blen = 4
	Oitm(1).Retlenadr = 0
	Oitm(2).Code = Mail$_Mailfile_Resultspec
	Oitm(2).Bufadr = %Loc(Current_file)
	Oitm(2).Blen = Min(Len(Current_File),255)
	Oitm(2).Retlenadr = %loc(Cfilnaml)
	Oitm(3) = Nullitm
	If(Loglvl() .gt. 1)  Call Lib$Signal(MLSEARCH_OPEMAIFIL)
	Status = Mail$Mailfile_Open(Mfctx,Itm,Oitm)
	If(Debuging())  Call Lib$Signal(MLSEARCH_DONE)

	Open_Mail = .False.
*
*	If error, signal warning and continue
*
	If(.not. Status) Then
		Call Lib$Signal(MLSEARCH_OPENIN,%val(1),Filename,
     $                    %val(Status))
		Return
	Endif

	Open_Mail = .True.
	Return
	End

	Logical Function Close_mail(Mfctx)
	Implicit None
	Integer Mfctx
	Integer Mail$Mailfile_Close
	Integer Mail$Mailfile_End
	Include '($MAILDEF)'
	Structure /Itmlst/
	   Integer*2 Blen
	   Integer*2 Code
	   Integer Bufadr
	   Integer RetlenAdr
	End Structure

	Record /Itmlst/ Nullitm
	Logical Debuging
	Integer LogLvl
	External MLSEARCH_CLOMAIFIL,MLSEARCH_DONE
	Nullitm.code = 0
	Nullitm.Blen = 0
	Nullitm.Bufadr = 0
	Nullitm.Retlenadr = 0
*
*	Close up current file
*
	If(Loglvl() .ge. 1) Call Lib$Signal(MLSEARCH_CLOMAIFIL)
	Call Srv(Mail$Mailfile_Close(Mfctx,Nullitm,Nullitm))
	Call Srv(Mail$Mailfile_End(Mfctx,Nullitm,Nullitm))
	If(Debuging()) Call Lib$Signal(MLSEARCH_DONE)
	Close_Mail = .True.

	Return
	End

	Subroutine StChek(Status)
	Implicit None
	Integer Status

	If(.Not. Status) Call Lib$Signal(%val(Status))
	Return
	End

	Logical Function Gtr_Times(Time1,Time2)
	Implicit None
	Integer Time1(2),Time2(2)
	Integer Timer(2)
	Include '($Libdef)'
	Integer Lib$Sub_Times

	If(Time1(1) .eq. Time2(1) .and. Time1(2) .eq. Time2(2)) Then
		Gtr_Times = .False.
		Return
	Endif

	Gtr_Times = Lib$Sub_Times(Time1,Time2,Timer) .eq. Lib$_Negtim
	Return
	End

	Subroutine Srv(Value)
	Integer Value

	If(.Not. Value) Call Lib$Signal(%Val(Value))
	Return
	End

	Subroutine WSrv(Value)
*
*	Exit on warning
*
	Integer Value

	If(.Not. Value) Then
		Call Lib$Signal(%Val(Value))
		Call Exit(Value)
	Endif
	End

	Logical Function Debuging()
	Implicit None
	Integer Loglvl

	Debuging = Loglvl() .gt. 8
	Return
	End

	Integer Function LogLvl()
	Implicit None

	Integer Log_Level
	Common/LOGCOM/Log_Level

	Loglvl = Log_level
	Return
	End
