 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mksub.c B This file contains the routines which control the sub-process that@ make uses to execute commands.  If the symbol SUB_STAND_ALONE isA defined at compilation time, this file will compile into a remote ? CLI -- commands typed by the user are sent to a sub-process for ) execution.  This is for testing purposes.  */  @ /* This code makes heavy use of VMS system calls for mailbox andA subprocess control.  The goal is to ensure that no message (i.e., @ DCL command line) will ever be written to the mailbox unless the> subprocess is trying to read one.  By default, a process which> writes a message to a mailbox will block until that message is? read from the mailbox.  This is the desired behavior here.  But ? if the subprocess exits for any reason, the main program should > also exit.  This is accomplished by an AST routine in the mainA program which is called when the subprocess dies.  Unfortunately, ? the AST is necessarily in user mode.  When the main program has C written a message to the mailbox and is blocking until that message = is read, it is in supervisor mode -- no user mode ASTs can be ? delivered.  The result is that the main program blocks forever. @ If the main program is trapping CTRL/C and CTRL/Y, as MAKE does,> it cannot be interrupted while blocking in supervisor mode, so? it completely locks up the user's terminal.  To avoid this, the > sub_write() routine checks a boolean to see if there is a read< request pending on the mailbox.  If there is, it immediately< writes the string it is given to the mailbox.  Otherwise, it? hibernates until a wake-up is scheduled by the same AST routine ' which sets the read request boolean. */ 3                                                      #include <iodef.h> #include <dvidef.h>  #include <jpidef.h>  #include <ssdef.h>  H #define TERM_INFO_LEN	84	/* length of termination information message */   #ifdef SUB_STAND_ALONE   #define ___		0 #define NULL		0  #define FALSE		0 #define TRUE		1  #define NORMAL_EXIT	1 # #define ERRSTAT(stat)	(~(stat) & 1) K #define ENDLIST(list)	*(int *)&list[sizeof(list) / sizeof(list[0]) - 1] = 0  typedef struct { 	int sd_len; 	char *sd_str; } STR_DESC;  int Sub_ign_err, Num_cmd_sent;   #else    #include "make.h"    #endif  K #define SET_RD_ATTN()	set_attn_ast(Mbx_chan, IO$M_READATTN, save_rd_req, 0) F int save_rd_req();	/* AST routine called for mailbox read attention */   static int Mbx_chan; static int Sub_pid;  static char Opened = FALSE;  static char Closed = FALSE; % static char Got_read_request = FALSE;    #ifdef SUB_STAND_ALONE main() {  	char *strend();# 	static char prompt[] = "Remote> ";  	char str[260];   , 	sub_write("on severe_error then continue");: 	for (printf(prompt); gets(str); printf("\n%s", prompt)) {  ( 		/* Write user's command to mailbox. */   		sub_write(str);   3 		/* If this command is not continued on next line, 3 		write a blank line to wait for it to complete. */   $ 		if (str[strlen(str) - 1] != '-') { 			sub_write("");  		}  	}
 	sub_close();  }  #endif  % /* Write a line to the subprocess. */    sub_write(string) 
 char *string;  { 
 	int stat;  ' 	/* Make sure the subprocess exists. */    	if (!Opened || Closed) { 
 		sub_open();  	}  0 	/* Wait for a read request from the mailbox. */   	while (!Got_read_request) { 		sys$hiber(); 	} 	Got_read_request = FALSE;  < 	/* Do the write.  Note that this write will block until the< 	message being written is read from the mailbox. This should8 	happen immediately, since a read request is pending. */   	stat = sys$qiow( $ 	    ___,			/* default event flag */& 	    Mbx_chan,			/* mailbox channel */5 	    IO$_WRITEVBLK | IO$M_NOW,	/* write to mailbox */  	    ___,			/* no iosb */ ( 	    ___, ___,			/* no completion AST */1 	    string,			/* P1; pointer to line to write */ . 	    strlen(string),		/* P2; length of line */, 	    ___,			/* P3; no disk address needed */< 	    ___, ___, ___);		/* P4, P5, P6; not used by this QIO */ 	if (ERRSTAT(stat)) {  #ifdef VMS_ERROR 		lib$signal(&Mak_errwrtsub);  #else 2 		printf("  ** Unable to write to subprocess.\n"); #endif 		sub_zap(); 		lib$stop(stat);  	} 	SET_RD_ATTN();  	Num_cmd_sent++; }    /* Create the subprocess. */   static
 sub_open() {  	int sub_died(); 	int stat, make_pid; 	char *username;2 	STR_DESC name, indesc, outdesc, errdesc, imgdesc; 	char namestr[16];  - 	/* Get information about current process. */   ; 	stat = proc_info(&make_pid, namestr, sizeof(namestr) - 1);  	if (ERRSTAT(stat)) {  		lib$stop(stat);  	}   	/* Create mailbox. */  C 	sprintf(&namestr[strlen(namestr)], "_MAK%04X", make_pid & 0xFFFF);  #ifndef SUB_STAND_ALONE  	if (Verbose) {  		print_prefix(); 2 		printf("Creating subprocess \"%s\"\n", namestr); 	} #endif- 	name.sd_len = strlen(name.sd_str = namestr);  	stat = sys$crembx(   	    0,		/* temporary mailbox */3 	    &Mbx_chan,	/* mailbox communication channel */ # 	    ___,	/* default max message */  	    ___,	/* default quota */ > 	    0xFF0F,	/* full access for owner, no access for others */# 	    ___,	/* default access mode */ ' 	    &name);	/* mailbox logical name */  	if (ERRSTAT(stat)) {  #ifdef VMS_ERROR 		lib$signal(&Mak_errcrembx);  #else = 		printf("  ** Unable to create mailbox, status %d\n", stat);  #endif 		lib$stop(stat);  	}   	/* Create subprocess. */    7 	errdesc.sd_len = strlen(errdesc.sd_str = "SYS$ERROR");  	sys$setast(0);  	stat = lib$spawn( 	    ___,		/* no command */ ( 	    &name,		/* read from the mailbox */( 	    &errdesc,		/* write to sys$error */  	    &1,			/* NOWAIT flag set */ 	    &name,		/* process name */ 2 	    &Sub_pid,		/* get process ID for later use */. 	    ___, ___,		/* no completion status, EF */2 	    sub_died, ___);	/* call sub_died() on exit */ 	sys$setast(1);  	Opened = !ERRSTAT(stat);   9 	/* Check on subprocess creation.  If the process already 8 	exists, put out a warning, and assume we can use it. */   	if (stat == SS$_DUPLNAM) { ? 		printf("WARNING: Subprocess exists.  Will try to use it.\n");  	} else if (ERRSTAT(stat)) { #ifdef VMS_ERROR 		lib$signal(&Mak_errcresub);  #else < 		printf("\n  ** Unable to create subprocess, status: %d\n", 		    stat); #endif 		lib$stop(stat);  	} 	SET_RD_ATTN(); ( 	sub_write("on warning then stop/id=0"); 	Sub_ign_err = FALSE;  	Num_cmd_sent = 0; }   / /* Kill the subprocess, whatever it's doing. */   	 sub_zap()  { 
 	int stat;   	if (Opened && !Closed) {  		if (Sub_pid) {$ 			stat = sys$delprc(&Sub_pid, ___); 			if (ERRSTAT(stat)) { 1 				printf("[sub_zap] Can't kill subprocess.\n");  				lib$stop(stat);  			} 			Opened = FALSE; 			Closed = TRUE; 
 		} else {= 			printf("[sub_zap] Subprocess pid is zero; can't kill.\n");  		}  	} #ifndef SUB_STAND_ALONE  	del_curr(); #endif }   0 /* Called by an AST when the subprocess dies. */   static
 sub_died() {  	if (Opened && !Closed) {  		Sub_pid = 0; #ifdef SUB_STAND_ALONE! 		printf("\nSubprocess died.\n");  #else 
 		del_curr();  		if (Verbose) { 			putchar('\n');  			print_prefix();" 			printf("\nSubprocess died.\n"); 		}  #endif 		Opened = FALSE;  		Closed = TRUE; 		exit(NORMAL_EXIT); 	} }   & /* Gracefully close the subprocess. */   sub_close()  {  	if (!Opened || Closed) { 	 		return;  	}    	/* Send the suicide command. */   	sub_write("stop/id=0"); 	Closed = TRUE;  	Opened = FALSE;
 	Sub_pid = 0;  }    save_rd_req(arg). int arg;	/* AST parameter, currently unused */ {  	int abstime[2];   	Got_read_request = TRUE;  	abstime[0] = abstime[1] = 0; * 	arg = sys$schdwk(___, ___, abstime, ___); }   F /* Enable AST for delivery when a read or write request is sent to theD indicated mailbox. The attnmask value can be either IO$M_READATTN orA IO$M_WRTATTN.  NOTE: this is a one-time enable -- the AST must be - explicitly re-enabled after each delivery. */    static, set_attn_ast(chan, attnmask, astadr, astprm)  int chan;		/* mailbox channel */6 int attnmask;		/* read attention or write attention */- int (*astadr)();	/* address of AST routine */ * int astprm;		/* argument to AST routine */ { 
 	int stat;   	stat = sys$qiow( # 	    ___,		/* default event flag */ ( 	    chan,		/* which mailbox to watch */9 	    IO$_SETMODE | attnmask,	/* watch for read request */  	    ___,		/* no iosb */' 	    ___, ___,		/* no completion AST */ > 	    astadr,		/* P1; AST routine to call when a read occurs */1 	    astprm,		/* P2; parameter for AST routine */ # 	    1,			/* P3; AST access mode */ ; 	    ___, ___, ___);	/* P4, P5, P6; not used by this QIO */  	if (ERRSTAT(stat)) {  #ifdef VMS_ERROR 		lib$signal(&Mak_errmbxast);  #else 9 		printf("  ** Can't enable mailbox %s attention AST.\n", 6 		    (attnmask == IO$M_READATTN ? "read" : "write")); #endif 		lib$stop(stat);  	} }    #ifndef SUB_STAND_ALONE $ /* Delete current target, if any. */  
 del_curr() { 1 	if (Curr_targ != NULL && !precious(Curr_targ)) {  		delete_file(Curr_targ);  		Curr_targ = NULL;  	} }  #endif  K /* Get information about current process for use in creating subprocess. */   $ proc_info(pidptr, namebuf, nmbuflen)0 int *pidptr;		/* id number of current process */ char *namebuf;		/* user name */ - int nmbuflen;		/* size of user name buffer */  {  	register char *trimptr; 	int stat, unamelen,ucount;  	struct jpi_item {9 		short jp_buflen;	/* size of buffer to return item in */ / 		short jp_itemcode;	/* which item to return */ - 		char *jp_buffer;	/* where to return item */ 4 		int *jp_retlen;		/* where to return item length */
 	} itmlst[3];   , 	/* Set up item list to get needed items. */  ' 	itmlst[0].jp_itemcode = JPI$_USERNAME;   	itmlst[0].jp_buflen = nmbuflen; 	itmlst[0].jp_buffer = namebuf; ! 	itmlst[0].jp_retlen = &unamelen; ? 	unamelen = 0;	/* sys$getjpi() ADDS the length to this value */   " 	itmlst[1].jp_itemcode = JPI$_PID;# 	itmlst[1].jp_buflen = sizeof(int);  	itmlst[1].jp_buffer = pidptr; 	itmlst[1].jp_retlen = NULL;   	/* Terminate item list. */    	ENDLIST(itmlst);   - 	/* Get information about current process. */    	stat = sys$getjpiw(# 	    ___,		/* default event flag */ 5 	    ___, ___,		/* default (i.e., current) process */ ) 	    itmlst,		/* list of things to get */  	    ___,		/* no iosb */( 	    ___, ___);		/* no completion AST */ 	if (ERRSTAT(stat)) {  		return (stat); 	}  9 	/* Fix: AWP - ensure username is no more than 7 chars */   8         for (ucount = 7; ucount <= unamelen; ucount++) {"             namebuf[ucount] = ' ';	         }   " 	/* Terminate user name string. */ 	namebuf[unamelen] = '\0';@ 	for (trimptr = namebuf; *trimptr && *trimptr != ' '; trimptr++) 		;  	*trimptr = '\0';   " 	/* Return sys$getjpi() status. */   	return (stat);  } 