 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.  	 mkmacro.c B This file contains the routines which handle macros, in particular@ the code to expand both named macros and special macros is here.   Modifications: SAM		Stephen A. Meadows  	 E SAM 89-May-9	Added the '%' Macro to extract the target file name only ; 		(ie. removed the type/ext, device, and path names).  This = 		proves useful when src/obj/map/lis files exist in different  		paths. */   #include "make.h"    char *macro_instance();   G /* This routine looks for the named macro in the macro definition list. F It returns a pointer to the macro definition, if found, or NULL if the1 name given doesn't match anything in the list. */   
 MAKE_TARGET *  macro_find(macname, maclist) char *macname; register MAKE_TARGET *maclist; { 	 	int cmp;   	 	cmp = 1; % 	while (maclist != NULL && cmp > 0) { @ 		if ((cmp = strcmp(macname, maclist->tg_name->mt_text)) == 0) { 			return (maclist); 		}  		maclist = maclist->tg_next;  	} 	return (NULL);  }   I /* Add a MACRO to the macro definition list.  Return TRUE for success. */    macro_add(macptr, maclistptr)  register MAKE_TARGET *macptr;  MAKE_TARGET **maclistptr;  {  	register MAKE_TOKEN *defptr; ) 	register MAKE_TARGET *maclist, *prevptr; 	 	int cmp;   > 	/* Scan through sorted macro list to find place to insert. */  
 	cmp = -1; 	prevptr = NULL; 	maclist = *maclistptr; B 	while (maclist != NULL && (cmp = strcmp(macptr->tg_name->mt_text,' 	    maclist->tg_name->mt_text)) > 0) {  		prevptr = maclist; 		maclist = maclist->tg_next;  	}  ? 	/* Check for duplicate addition.  If macro is already defined, < 	return success -- this allows redefinition of macros (e.g.,< 	DEBUG) on the command line or in the default rules file. */   	if (cmp == 0) { 		return (TRUE); 	}  & 	/* Get length of macro definition. */   	macptr->tg_ndep = 0;  	defptr = macptr->tg_dep;  	while (defptr != NULL) {  		macptr->tg_ndep++; 		defptr = defptr->mt_next;  	}   	/* Insert MACRO in list. */   	if (prevptr == NULL) {   		macptr->tg_next = *maclistptr; 		*maclistptr = macptr; 	 	} else { % 		macptr->tg_next = prevptr->tg_next;  		prevptr->tg_next = macptr; 	} 	return (TRUE);  }   0 /* Expand any named macros in a command line. */   cmd_expand(cmdptr, maclist)  MAKE_COMMAND *cmdptr;  MAKE_TARGET *maclist;  {  	int retval; 	MAKE_COMMAND *next_cmd;   	retval = EXP_SIMPLE;  	while (cmdptr != NULL) { = 		if (macro_expand(cmdptr->cmd_word, maclist) == EXP_ERROR) {  			retval = EXP_ERROR; 		}  		cmdptr = cmdptr->cmd_next; 	} #ifdef NAME_EXP_DEBUG  	if (retval == EXP_ERROR) { , 		printf("[cmd_expand] Returning error.\n"); 	} #endif 	return (retval);  }   J /* Expand any named macros in the text of each token in the list given. */   macro_expand(tokptr, maclist)  MAKE_TOKEN *tokptr;  MAKE_TARGET *maclist;  {  	int retval; 	MAKE_TOKEN *next_token;   	retval = EXP_SIMPLE;  	while (tokptr != NULL) {  		next_token = tokptr->mt_next; 3 		if (token_expand(tokptr, maclist) == EXP_ERROR) {  			retval = EXP_ERROR; 		}  		tokptr = next_token; 	} #ifdef NAME_EXP_DEBUG  	if (retval == EXP_ERROR) { . 		printf("[macro_expand] Returning error.\n"); 	} #endif 	return (retval);  }   J /* This routine scans a token for named macro invocations.  It expands anyJ which it finds and converts the single token passed into a list of tokens,K each of which is a simple string produced by one instance of the expansion. F NOTE:  this routine does NOT expand the special macros for the currentK target or the current dependency list; it only expands invocations of NAMED  macros.  Example: H   If the input token is "$(DISK)\:[dir]$,(MOO).obj", and DISK is a macroH   defined as "user4", and MOO is a macro defined as "xx yy zz", then the0   output tokens produced by macro expansion are:H   "user4\:[dir]xx.obj,", "user4\:[dir]yy.obj,", and "user4\:[dir]zz.obj"<   Notice that the last token does not have a trailing comma.H The return value is EXP_SIMPLE if every token in the expansion is simpleH text, EXP_SPECIAL if any token contains a special macro, or EXP_ERROR if" any error occurs during expansion. */   static token_expand(tokptr, maclist)  MAKE_TOKEN *tokptr;  MAKE_TARGET *maclist;  { 8 	int any_special, n_item, n_instance, orig_line, sepchr; 	char *iptr; 	MAKE_TOKEN *orig_next; ( 	MACRO_ITEM item_list[MAX_EXP_INSTANCE];  4 	if (tokptr->mt_text == NULL || tokptr->mt_simple) { 		return (EXP_SIMPLE); 	}   #ifdef NAME_EXP_DEBUG ; printf("[token_expand] Expanding '%s'\n", tokptr->mt_text);  #endif  1 	n_item = create_item(tokptr, maclist, item_list, ; 	    sizeof(item_list) / sizeof(item_list[0]), &n_instance,  	    &sepchr, &any_special);$ 	if (n_item < 0 || n_instance < 0) { #ifdef NAME_EXP_DEBUG I printf("[token_expand] Returning error, n_item = %d, n_instance = %d.\n",  n_item, n_instance); #endif 		return (EXP_ERROR);  	}  D 	/* Check for empty macro.  THIS IS ONLY A TEMPORARY HACK, RIGHT? */  & 	if (n_item == 0 || n_instance == 0) { 		*tokptr->mt_text = '\0'; 		tokptr->mt_simple = TRUE;  		return (EXP_NONE); 	}   #ifdef NAME_EXP_DEBUG < printf("[token_expand] %d item%s, %d instance%s.\n", n_item,0 PLURAL(n_item), n_instance, PLURAL(n_instance)); #endif  - 	/* Create each instance of the expansion. */    	free(tokptr->mt_text);  	orig_line = tokptr->mt_line;  	tokptr->mt_simple = TRUE;= 	tokptr->mt_text = macro_instance(item_list, n_item, sepchr);  #ifdef NAME_EXP_DEBUG $ printf("    %s\n", tokptr->mt_text); #endif 	if (--n_instance <= 0) {  		return (EXP_SIMPLE); 	} 	orig_next = tokptr->mt_next;  	while (n_instance-- > 0) {  		if (n_instance == 0) { 			sepchr = '\0';  		} ( 		tokptr->mt_next = E_ALLOC(MAKE_TOKEN); 		tokptr = tokptr->mt_next; > 		tokptr->mt_text = macro_instance(item_list, n_item, sepchr); 		tokptr->mt_next = NULL;  		tokptr->mt_line = orig_line; 		tokptr->mt_simple = TRUE;  #ifdef NAME_EXP_DEBUG $ printf("    %s\n", tokptr->mt_text); #endif 	} 	tokptr->mt_next = orig_next;    	free_item(item_list, n_item);1 	return (any_special ? EXP_SPECIAL : EXP_SIMPLE);  }   J /* Parse the string to be expanded, which is pointed to by expstr.  CreateG the expansion item list using the macro definitions in maclist.  Return L the number of items in the expansion list, or -1 if an error is detected. */   staticL create_item(tokptr, maclist, item_list, max_item, ninstptr, sepptr, specptr) MAKE_TOKEN *tokptr;  MAKE_TARGET *maclist;  MACRO_ITEM *item_list;
 int max_item; ! int *ninstptr, *sepptr, *specptr;  { * 	int fill_len, n_item, n_instance, nmstat; 	int sep_chk, separator; 	char *expstr; 	MAKE_TARGET *macptr; % 	char macro_name[MACRO_NAME_LEN + 1]; # 	char filler[MAX_EXP_INSTANCE + 1];   @ 	/* Return 0 expansion items if there is no string to expand. */   	*ninstptr = 0;  	*sepptr = '\0'; 	*specptr = FALSE;< 	if (tokptr == NULL || (expstr = tokptr->mt_text) == NULL) {
 		return (0);  	}  ; 	/* Break input string into "items".  Each item is either a ; 	string of ordinary text or an invocation of a named macro. ; 	If it is a named macro, the corresponding item is the list / 	of tokens which are the macro's definition. */    	n_instance = 0; 	n_item = 0; 	while (*expstr) {  % 		/* Check for item list overflow. */    		if (n_item >= max_item) { N 			printf("FATAL ERROR:  item list overflow in expansion of '%s', line %d.\n",) 			    tokptr->mt_text, tokptr->mt_line);  			make_exit(NORMAL_EXIT); 		}   : 		/* Get next (possibly empty) string of ordinary text. */  ( 		fill_len = get_filler(&expstr, filler,! 		    sizeof(filler) - 1, FALSE);  		if (fill_len > 0) { 8 			item_list[n_item].it_text = newstr(filler, fill_len);) 			item_list[n_item].it_type = ITEM_TEXT;  			n_item++; 			if (n_instance < 1) { 				n_instance = 1;  			} #ifdef NAME_EXP_DEBUG . printf("  Item %d is '%s'\n", n_item, filler); #endif 		}     		/* Check current character. */   		if (*expstr == '\0') {	 			break; ' 		} else if (*expstr != INVOKE_MACRO) { , 			continue;	/* get another filler string */ 		} 2 		expstr++;	/* skip past INVOKE_MACRO character */  - 		/* Scan to OPEN_DELIM, saving the separator   		character, if one is given. */  / 		sep_chk = get_delim(&expstr, sepptr, tokptr);  		if (sep_chk < 0) {  			free_item(item_list, n_item); #ifdef NAME_EXP_DEBUG 2 printf("[create_item] Error from get_delim().\n"); #endif* 			return (-1);	/* error in named macro */ 		} else if (sep_chk > 0) {  			*specptr = TRUE; % 			continue;	/* special macro used */  		}   , 		/* Get name of macro.  The first character) 		of the name is pointed to by expstr. */   . 		nmstat = get_macro_name(&expstr, macro_name, 		    sizeof(macro_name) - 1); 		if (nmstat < 0) {  #ifdef VMS_ERROR2 			lib$signal(&Mak_chrequired, 5, 1, &CLOSE_DELIM,1 			    FAO_AD(tokptr->mt_text), tokptr->mt_line);  #else 2 			printf("  ** Missing '%c' in '%s', line %d.\n",6 			    CLOSE_DELIM, tokptr->mt_text, tokptr->mt_line); #endif  			free_item(item_list, n_item); 			return (-1);  		}    		/* Look up named macro. */  + 		macptr = macro_find(macro_name, maclist);  		if (macptr == NULL) {  #ifdef VMS_ERROR3 			lib$signal(&Mak_unrecmac, 5, FAO_AD(macro_name), 1 			    FAO_AD(tokptr->mt_text), tokptr->mt_line);  #else B 			printf("  ** Unknown macro name '%s' used in '%s', line %d.\n",5 			    macro_name, tokptr->mt_text, tokptr->mt_line);  #endif  			free_item(item_list, n_item); 			return (-1);  		}   9 		/* Check macro definition length against n_instance. */    		if (macptr->tg_ndep == 0) { $ 			continue;	/* skip empty macros */ 		} 8 		if (n_instance > 1 && n_instance != macptr->tg_ndep) { #ifdef VMS_ERROR! 			lib$signal(&Mak_maclendiff, 6, 0 			    FAO_AD(tokptr->mt_text), tokptr->mt_line,, 			    FAO_AD(macro_name), macptr->tg_ndep); #else E 			printf("  ** Macro definition lengths differ in '%s', line %d.\n", ) 			    tokptr->mt_text, tokptr->mt_line); A 			printf("       Detected at macro '%s' which has length %d.\n", $ 			    macro_name, macptr->tg_ndep); #endif  			free_item(item_list, n_item); 			return (-1);  		} % 		if (macptr->tg_ndep > n_instance) {   			n_instance = macptr->tg_ndep; 		}   1 		/* Save pointer to macro definition as item. */    		if (n_instance <= 1) {C 			item_list[n_item].it_text = newstr(macptr->tg_dep->mt_text, -1); ) 			item_list[n_item].it_type = ITEM_TEXT;  			if (n_instance < 1) { 				n_instance = 1;  			} #ifdef NAME_EXP_DEBUG E printf("  Item %d is '%s'\n", n_item + 1, item_list[n_item].it_text);  #endif
 		} else {* 			item_list[n_item].it_type = ITEM_TOKEN;/ 			item_list[n_item].it_token = macptr->tg_dep;  #ifdef NAME_EXP_DEBUG % printf("  Item %d is: ", n_item + 1); . show_token(item_list[n_item].it_token, FALSE); putchar('\n'); #endif 		}  		n_item++;  	} 	if (n_instance <= 1) {  		*sepptr = '\0';  	} #ifdef NAME_EXP_DEBUG  if (*sepptr) {) printf("  Separator is '%c'\n", *sepptr);  } else {& printf("  No separator character.\n"); }  #endif 	*ninstptr = n_instance; 	return (n_item);  }   8 /* Expand all special macros in a list of command lines.6 Return EXP_SIMPLE for success, EXP_ERROR for error. */  ( cmd_exp_special(cmdptr, target, deplist) MAKE_COMMAND *cmdptr;  MAKE_TOKEN *target, *deplist;  {  	int retval;   	retval = EXP_SIMPLE;  	while (cmdptr != NULL) {  #ifdef SPEC_EXP_DEBUG 6 printf("[cmd_exp_special] Expanding command line:\n");$ show_token(cmdptr->cmd_word, FALSE); putchar('\n'); #endif& 		if (expand_special(cmdptr->cmd_word,& 		    target, deplist) == EXP_ERROR) { #ifdef SPEC_EXP_DEBUG 6 printf("[cmd_exp_special] Error during expansion.\n"); #endif 			retval = EXP_ERROR; 		}  		cmdptr = cmdptr->cmd_next; 	} 	return (retval);  }   Q /* Expand all special macros in a list of tokens.  Return EXP_SIMPLE if there are P no more special macros in any token in the list, EXP_SPECIAL if any macro in the@ list has an unexpanded special macro, or EXP_ERROR for error. */  & expand_special(tokptr, tname, deplist)% MAKE_TOKEN *tokptr, *tname, *deplist;  { @ 	int any_special, n_item, n_instance, orig_line, retval, sepchr;# 	MAKE_TOKEN *orig_list, *orig_next; ( 	MACRO_ITEM item_list[MAX_EXP_INSTANCE];   	retval = EXP_SIMPLE;  	orig_list = tokptr; 	while (tokptr != NULL) {   ! 		if (*tokptr->mt_text == '\0') {  			tokptr = tokptr->mt_next; 			continue; 		}    		orig_next = tokptr->mt_next; #ifdef SPEC_EXP_DEBUG O printf("[expand_special] Expanding special macros in '%s'\n", tokptr->mt_text);  printf("  (Rest of list is ");# show_token(tokptr->mt_next, FALSE);  printf(")\n"); #endif/ 		n_item = cr_spec_item(tokptr, tname, deplist, : 		    item_list, sizeof(item_list) / sizeof(item_list[0]),* 		    &n_instance, &sepchr, &any_special);& 		if (n_item < 0 || n_instance <= 0) { #ifdef SPEC_EXP_DEBUG K printf("[expand_special] Returning error, n_item = %d, n_instance = %d.\n",  n_item, n_instance); #endif 			return (EXP_ERROR); 		}  #ifdef SPEC_EXP_DEBUG > printf("[expand_special] %d item%s, %d instance%s.\n", n_item,0 PLURAL(n_item), n_instance, PLURAL(n_instance)); #endif  . 		/* Create each instance of the expansion. */   		free(tokptr->mt_text); 		orig_line = tokptr->mt_line; 		tokptr->mt_simple = TRUE; > 		tokptr->mt_text = macro_instance(item_list, n_item, sepchr); #ifdef SPEC_EXP_DEBUG $ printf("    %s\n", tokptr->mt_text); #endif 		while (--n_instance > 0) { 			if (n_instance == 1) {  				sepchr = '\0'; 			}) 			tokptr->mt_next = E_ALLOC(MAKE_TOKEN);  			tokptr = tokptr->mt_next;? 			tokptr->mt_text = macro_instance(item_list, n_item, sepchr);  			tokptr->mt_next = NULL; 			tokptr->mt_line = orig_line;  			tokptr->mt_simple = TRUE; #ifdef SPEC_EXP_DEBUG $ printf("    %s\n", tokptr->mt_text); #endif 		}  		tokptr->mt_next = orig_next;   		free_item(item_list, n_item);    		if (any_special) { 			retval = EXP_SPECIAL; 		}    		tokptr = orig_next;  	} 	return (retval);  }   K /* Scan the token for special macros.  Create item list to expand these. */    staticT cr_spec_item(tokptr, tname, deplist, item_list, max_item, ninstptr, sepptr, specptr)% MAKE_TOKEN *tokptr, *tname, *deplist;  MACRO_ITEM *item_list;
 int max_item; ! int *ninstptr, *sepptr, *specptr;  { > 	int fill_len, n_item, n_instance, sep_chk, spec_chr, speclen; 	register char *expstr;  	MAKE_TOKEN *spptr; # 	char filler[MAX_EXP_INSTANCE + 1];   @ 	/* Return 0 expansion items if there is no string to expand. */   	*ninstptr = 0;  	*sepptr = '\0'; 	*specptr = FALSE;< 	if (tokptr == NULL || (expstr = tokptr->mt_text) == NULL) {
 		return (0);  	}  ; 	/* Break input string into "items".  Each item is either a = 	string of ordinary text or an invocation of a special macro. = 	If it is a special macro, the corresponding item is the list / 	of tokens which are the macro's definition. */    	n_instance = 0; 	n_item = 0; 	while (*expstr) {  % 		/* Check for item list overflow. */    		if (n_item >= max_item) { N 			printf("FATAL ERROR:  item list overflow in expansion of '%s', line %d.\n",) 			    tokptr->mt_text, tokptr->mt_line);  			make_exit(NORMAL_EXIT); 		}   : 		/* Get next (possibly empty) string of ordinary text. */  ( 		fill_len = get_filler(&expstr, filler,  		    sizeof(filler) - 1, TRUE); 		if (fill_len > 0) { 8 			item_list[n_item].it_text = newstr(filler, fill_len);) 			item_list[n_item].it_type = ITEM_TEXT;  			n_item++; 			if (n_instance < 1) { 				n_instance = 1;  			} #ifdef SPEC_EXP_DEBUG . printf("  Item %d is '%s'\n", n_item, filler); #endif 		}     		/* Check current character. */   		if (*expstr == '\0') {	 			break; ' 		} else if (*expstr != INVOKE_MACRO) {  #ifdef SPEC_EXP_DEBUG Q printf("[cr_spec_item] Getting second filler string in a row, first char '%c'\n", 	 *expstr);  #endif, 			continue;	/* get another filler string */ 		} 2 		expstr++;	/* skip past INVOKE_MACRO character */  , 		/* Scan to special macro character, saving* 		separator character, if one is given. */  / 		sep_chk = get_delim(&expstr, sepptr, tokptr);  		if (sep_chk < 0) {  			free_item(item_list, n_item); #ifdef SPEC_EXP_DEBUG 3 printf("[cr_spec_item] Error from get_delim().\n");  #endif* 			return (-1);	/* error in named macro */ 		} else if (sep_chk == 0) { #ifdef SPEC_EXP_DEBUGEO printf("[cr_spec_item] Error; found a named macro in '%s'\n", tokptr->mt_text);vB printf("\tAll named macros should have been expanded earlier.\n"); #endif 			continue; 		}c   #ifdef SPEC_EXP_DEBUGoN printf("[cr_spec_item] Found use of special macro '%c' in '%s' on line %d.\n",+ *expstr, tokptr->mt_text, tokptr->mt_line);d #endif  % 		/* Get special macro definition. */l   		spec_chr = *expstr++;/ 		switch (spec_chr) {a 		case CURRENT_TARGET:: 			item_list[n_item].it_text = newstr(tname->mt_text, -1);) 			item_list[n_item].it_type = ITEM_TEXT;_ #ifdef SPEC_EXP_DEBUG I printf("[cr_spec_item] Replacing %c%c by '%s'\n", INVOKE_MACRO, spec_chr,s item_list[n_item].it_text);i #endif 			n_item++; 			if (n_instance == 0) {t 				n_instance = 1;e 			}	 			break;E  7 		case CURR_TARG_FILE:		/* SAM 890509 file name only */e? 			item_list[n_item].it_text = file_name(tname->mt_text, NULL);e) 			item_list[n_item].it_type = ITEM_TEXT;p #ifdef SPEC_EXP_DEBUGiI printf("[cr_spec_item] Replacing %c%c by '%s'\n", INVOKE_MACRO, spec_chr,l item_list[n_item].it_text);N #endif 			n_item++; 			if (n_instance == 0) {i 				n_instance = 1;  			}	 			break;    		case CURR_TARG_NO_EXT:B 			item_list[n_item].it_text = rm_file_type(tname->mt_text, NULL);) 			item_list[n_item].it_type = ITEM_TEXT;  #ifdef SPEC_EXP_DEBUGpI printf("[cr_spec_item] Replacing %c%c by '%s'\n", INVOKE_MACRO, spec_chr,  item_list[n_item].it_text);e #endif 			n_item++; 			if (n_instance == 0) {a 				n_instance = 1;  			}	 			break;t   		case DEPENDENCY_LIST:i 			speclen = 0;e 			spptr = deplist;t 			while (spptr != NULL) { 				speclen++; 				spptr = spptr->mt_next;t 			}   			if (speclen > 0) {y 				if (speclen == 1) {s> 					item_list[n_item].it_text = newstr(deplist->mt_text, -1);+ 					item_list[n_item].it_type = ITEM_TEXT;  #ifdef SPEC_EXP_DEBUGeI printf("[cr_spec_item] Replacing %c%c by '%s'\n", INVOKE_MACRO, spec_chr,d item_list[n_item].it_text);g #endif 					if (n_instance == 0) {	 						n_instance = 1;e 					} 				} else {* 					item_list[n_item].it_token = deplist;, 					item_list[n_item].it_type = ITEM_TOKEN; 					if (n_instance <= 1) {a 						n_instance = speclen;>( 					} else if (n_instance != speclen) {W 						printf("FATAL ERROR, Special macros have different definition lengths in '%s'\n",e 						    tokptr->mt_text);c 						make_exit(NORMAL_EXIT);  					} 				}c
 				n_item++;t 			}	 			break;O   		case OUT_OF_DATE_DEPS:9 printf("  ** $%c is unimplemented.\n", OUT_OF_DATE_DEPS);a	 			break;c   		case UP_TO_DATE_DEPS:R8 printf("  ** $%c is unimplemented.\n", UP_TO_DATE_DEPS);	 			break;}  
 		default: #ifdef VMS_ERROR  			lib$signal(&Mak_unrecspec, 7,& 			    1, &INVOKE_MACRO, 1, &spec_chr,1 			    FAO_AD(tokptr->mt_text), tokptr->mt_line);e #elsesE 			printf("  ** Unrecognized special macro %c%c in '%s', line %d.\n",,A 			    INVOKE_MACRO, spec_chr, tokptr->mt_text, tokptr->mt_line);r #endif 		}_ 	} 	if (n_instance <= 1) {  		*sepptr = '\0';i 	} #ifdef SPEC_EXP_DEBUGe if (*sepptr) {) printf("  Separator is '%c'\n", *sepptr);c } else {& printf("  No separator character.\n"); }  #endif 	*ninstptr = n_instance; 	return (n_item);i }r  - /* Free all space allocated for item_list. */R   static free_item(itptr, n_item) MACRO_ITEM *itptr; int n_item;o {n 	while (n_item-- > 0) { > 		if (itptr->it_type == ITEM_TEXT && itptr->it_text != NULL) { 			free(itptr->it_text); 			itptr++;t 		}, 	} }o  I /* strptr points to a pointer to the current position in the string being G expanded.  This routine copies characters from the string into fillbuf,oH stopping when a null or INVOKE_MACRO is found.  The number of characters copied is returned. */   static1 get_filler(strptr, fillbuf, buflen, name_is_fill)c char **strptr; char *fillbuf; int buflen, name_is_fill;  {z 	register char *exp, *fillptr; 	int prev_literal, named_macro;    	prev_literal = FALSE; 	fillptr = fillbuf;n 	exp = *strptr;.  > 	/* This loop copies characters from the input string into the; 	buffer given.  It stops when it finds the end of the inputi; 	string, or the buffer is filled, or it finds a named macroa 	invocation. */R  - 	while (*exp && fillptr - fillbuf < buflen) {   / 		/* Check for any type of macro invocation. */*  . 		if (*exp == INVOKE_MACRO && !prev_literal) {  , 			/* Check for a named macro invocation. */  ) 			named_macro = (exp[1] == OPEN_DELIM ||I7 			    (!IS_SPECIAL(exp[1]) && exp[2] == OPEN_DELIM) ||=9 			    (exp[1] == NEXT_LITERAL && exp[3] == OPEN_DELIM)); ( 			if ((!name_is_fill && named_macro) ||( 			    (name_is_fill && !named_macro)) {
 				break; 			} 		} 9 		prev_literal = !prev_literal && (*exp == NEXT_LITERAL);l 		*fillptr++ = *exp++; 	}$ 	if (prev_literal && *exp != '\0') { 		exp--; 		fillptr--; 	} 	(*strptr) = exp;i 	*fillptr = '\0';  	return (fillptr - fillbuf); }g  E /* strptr points to a pointer to the first character of the name in a G named macro invocation.  This routine copies the macro name into nmbuf,TG checking the name length.  It sets the pointer to the name to the firstkF character after the CLOSE_DELIM which terminates the macro name, or toG the null which terminates the input string if no CLOSE_DELIM is found. a3 The return value is -1 for error, 0 for success. */L   static& get_macro_name(strptr, nmbuf, max_len) char **strptr; char *nmbuf; int max_len; {) 	register char *expstr, *nmptr;    	expstr = *strptr; 	nmptr = nmbuf;m, 	while (*expstr && *expstr != CLOSE_DELIM) {  		if (nmptr - nmbuf < max_len) { 			*nmptr++ = *expstr; 		}e 		expstr++;  	} 	*nmptr = '\0';0 	*strptr = expstr; 	if (*expstr != CLOSE_DELIM) {! 		return (-1);	/* return error */> 	}
 	(*strptr)++;t! 	return (0);	/* return success */	 }   H /* strptr is address of pointer to current position in string to expand.I An INVOKE_MACRO character was just found; **strptr is the character afterxF it.  This routine reads the separator character (if any) and saves it.G It also skips past the OPEN_DELIM character.  It returns -1 on error, 0}H if everything is okay, or 1 if the INVOKE_MACRO prefaced a special macroG invocation.  (In this last case, the string pointer is set to the firstoB character after the special macro character.)  Possible errors areA missing OPEN_DELIM, unexpected end of input string, and separatorb character conflict. */   static! get_delim(strptr, sepptr, tokptr)  char **strptr; int *sepptr; MAKE_TOKEN *tokptr;a {t 	int c;p   #ifdef SPEC_EXP_DEBUGE: printf("[get_delim] Starting, string is '%s'\n", *strptr); #endif   	c = **strptr;
 	(*strptr)++;p
 	switch (c) {   ? 	/* NEXT_LITERAL means following character is separator; end ofaD 	input string after NEXT_LITERAL causes fall-through to case '\0' */   	case NEXT_LITERAL:i 		c = **strptr;A 		(*strptr)++; 		if (c != '\0') {$ 			if (bad_sep(sepptr, c, tokptr)) { 				return (-1); 			}	 			break;= 		};  ; 	/* End of input string; last character is INVOKE_MACRO. */m   	case '\0':)- 		(*strptr)--;	/* back up to point at null */g #ifdef VMS_ERROR 		lib$signal(&Mak_nodelim, 7,f' 		    1, &OPEN_DELIM, 1, &INVOKE_MACRO,d0 		    FAO_AD(tokptr->mt_text), tokptr->mt_line); #else < 		printf("  ** Missing '%c' after '%c' in '%s', line %d.\n",B 		    OPEN_DELIM, INVOKE_MACRO, tokptr->mt_text, tokptr->mt_line); #endif 		return (-1);  0 	/* No separator character used; return okay. */   	case OPEN_DELIM:o
 		return (0);n  2 	/* Special macro character after INVOKE_MACRO. */   	case CURRENT_TARGET:_7 	case CURR_TARG_FILE:			/* SAM 890509 file name only */) 	case CURR_TARG_NO_EXT:  	case DEPENDENCY_LIST: 	case OUT_OF_DATE_DEPS:	> 		(*strptr)--;	/* back up one to point at special character */ #ifdef SPEC_EXP_DEBUG=< printf("[get_delim] Found special macro:  '%s'\n", *strptr); #endif
 		return (1);   4 	/* Any other character is an ordinary separator. */  	 	default:_# 		if (bad_sep(sepptr, c, tokptr)) {  			return (-1);  		}f 		break; 	}  , 	/* Get delimiter or special macro character& 	which follows separator character. */   	c = **strptr;
 	(*strptr)++;u 	if (IS_SPECIAL(c)) {r 		(*strptr)--;
 		return (1);* 	} 	if (c != OPEN_DELIM) {c #ifdef VMS_ERROR0 		lib$signal(&Mak_chrequired, 5, 1, &OPEN_DELIM,0 		    FAO_AD(tokptr->mt_text), tokptr->mt_line); #elses1 		printf("  ** Missing '%c' in '%s', line %d.\n",m4 		    OPEN_DELIM, tokptr->mt_text, tokptr->mt_line); #endif 		return (-1); 	} 	return (0); }e  ? /* Check for conflicting separator characters.  Return TRUE forc; conflict.  Save new separator if no old separator given. */r   static bad_sep(oldptr, new, tokptr) int *oldptr; int new; MAKE_TOKEN *tokptr;i {d) 	if (*oldptr != '\0' && *oldptr != new) {n #ifdef VMS_ERROR2 		lib$signal(&Mak_sepclash, 7, 1, oldptr, 1, &new,0 		    FAO_AD(tokptr->mt_text), tokptr->mt_line); #else,I 		printf("  ** Conflicting separators '%c' and '%c' in '%s', line %d.\n",e6 		    *oldptr, new, tokptr->mt_text, tokptr->mt_line); #endif 		return (TRUE); 	} 	*oldptr = new;m 	return (FALSE); }f  G /* Combine the current items to create the latest instance of the macromD string being expanded.  Allocate a copy of the string and return its0 address, or NULL if the item list is used up. */   static char *, macro_instance(item_list, n_item, separator) MACRO_ITEM *item_list; int n_item, separator; {n 	int i_len, last_instance; 	char *i_ptr, *text;% 	char instance[MAX_EXP_INSTANCE + 2];r   	i_ptr = instance; 	last_instance = FALSE;_ 	while (n_item-- > 0) { ( 		if (item_list->it_type == ITEM_TEXT) { 			text = item_list->it_text;f
 		} else {% 			if (item_list->it_token == NULL) {p 				return (NULL); 			}' 			text = item_list->it_token->mt_text;g6 			item_list->it_token = item_list->it_token->mt_next;% 			if (item_list->it_token == NULL) {  				last_instance = TRUE;O 			} 		}a 		item_list++;> 		if (strlen(text) + (i_ptr - instance) >= sizeof(instance)) { 			*i_ptr = '\0';"6 			printf("FATAL ERROR, macro expansion too long:\n");( 			printf("%s%s ...\n", instance, text); 			make_exit(NORMAL_EXIT); 		}m 		i_ptr = strecpy(text, i_ptr);f 	}  , 	/* Check for use of separator character. */   	if (separator != '\0') {n+ 		text = err_alloc((i_ptr - instance) + 2); " 		i_ptr = strecpy(instance, text); 		*i_ptr++ = separator;  		*i_ptr = '\0'; 		return (text); 	}  9 	/* If no separator used, or this is the last instance ofe; 	the macro expansion, return the instance without appending{ 	a separator. */  - 	return (newstr(instance, i_ptr - instance));m } 