 /* MAKE version 1.1, April 1987" Copyright (C) 1987 by Jesse Perry.; MAKE is in the public domain and may be freely distributed, 8 used, and modified, provided this notice is not removed.   mkfile.cD This file contains the routines which parse makefiles and create the1 named macro, default rule, and target statements.    Modifications: SAM		Stephen A. Meadows  	 C SAM 88-May-17	Corrected bug in parsing logic.  C does not guarentee : 		order of evalution (or if an argument will be evaluate). */   #include "make.h"   2 /* Read the named makefile, placing definitions of4 targets, macros, and rules in the lists provided. */  ) get_make_file(fname, mlptr, rlptr, tlptr)  char *fname;& MAKE_TARGET **mlptr, **rlptr, **tlptr; {  	MAKE_TOKEN *toklist;  	FILE *mkfptr;   	/* Open named makefile. */   ' 	if (fname == NULL || *fname == '\0') {  		mkfptr = NULL;3 	} else if ((mkfptr = fopen(fname, "r")) == NULL) {   ) 		/* Try to add default makefile type. */       - 		if ((mkfptr = fopen(fname, "r")) == NULL) {  			if (Verbose) {  				print_prefix(); , 				printf("Can't open file '%s'\n", fname); 			} 			return (0); 		}  	}  ' 	/* Read makefile in for processing. */   # 	toklist = make_token_list(mkfptr);  	if (mkfptr != NULL) { 		fclose(mkfptr);  	}  * 	/* Parse token list, appending results to+ 	rule list, macro list, and target list. */   3 	return (parse_file(toklist, mlptr, rlptr, tlptr));  }   C /* Check the syntax of a list of tokens representing a makefile. */   ' parse_file(tokptr, mlptr, rlptr, tlptr)  register MAKE_TOKEN *tokptr;& MAKE_TARGET **mlptr, **rlptr, **tlptr; {  	register MAKE_TARGET *tgptr;  	register MAKE_COMMAND *cmdptr; ) 	int c, parse_state, parse_error, experr;  	char *errptr; 	MAKE_TOKEN *prevtok, *alttok; 	MAKE_COMMAND *prevcmd;    #ifdef FILE_DEBUG 0 printf("\n[parse_file] Starting, lists are:\n");  show_target(*mlptr, STMT_MACRO); show_target(*rlptr, STMT_RULE); ! show_target(*tlptr, STMT_TARGET); . printf(".................................\n"); #endif  $ 	/* Initialize to parse makefile. */   	tgptr = NULL; 	parse_error = FALSE;  	parse_state = P_START_LINE;  & 	/* Scan through entire token list. */  * 	while (tokptr != NULL || tgptr != NULL) { #ifdef PARSE_DEBUG0 if (tokptr != NULL && tokptr->mt_text != NULL) {N printf("[parse] State = %s, token '%s', line %d\n", P_state_name[parse_state],G (*tokptr->mt_text == '\n' ? "\\n" : tokptr->mt_text), tokptr->mt_line);  }  #endif 		switch (parse_state) {  6 		/* This state is entered whenever a newline token is4 		followed by anything but a space token.  On entry,2 		tokptr points at the token after the newline. */   		case P_START_LINE:   			if (tgptr != NULL) {  #ifdef PARSE_DEBUGC printf("  ** Warning, tgptr not NULL on entering P_START_LINE.\n");  #endif 				free_target(tgptr);  			} 			tgptr = NULL;  # 			/* Skip consecutive newlines. */   7 			while (tokptr != NULL && *tokptr->mt_text == '\n') { & 				tokptr = free_first_token(tokptr); 			}  ( 			/* Check for tokens which are invalid 			at the start of a line. */   9 			while (tokptr != NULL && tokptr->mt_text[1] == '\0' && ( 			    ((c = *tokptr->mt_text) == ' ' ||/ 			    c == DEPENDENCY || c == DEFINE_MACRO)) {  #ifdef VMS_ERROR! 				lib$signal(&Mak_badinitch, 3,   				    1, &c, tokptr->mt_line); #else D 				printf("  ** Bad initial character '%c' on line %d, deleted.\n", 				    c, tokptr->mt_line); #endif 				parse_error = TRUE; & 				tokptr = free_first_token(tokptr); 			}  6 			/* Change state to read list of targets.  Note that4 			the current token is left in the input list to be1 			processed with any following target tokens. */   4 			if (tokptr != NULL && *tokptr->mt_text != '\n') {$ 				parse_state = P_GET_TARGET_LIST; 			}	 			break;   : 		/* This state reads any number of target tokens from the9 		input list.  The target token list ends when a newline, 0 		DEPENDENCY, or DEFINE_MACRO token is found. */   		case P_GET_TARGET_LIST:   6 			/* Create a MAKE_TARGET to hold the target list. */    			tgptr = E_ALLOC(MAKE_TARGET); 			tgptr->tg_next = NULL;  			tgptr->tg_name = NULL;  			tgptr->tg_dep = NULL; 			tgptr->tg_cmd = NULL; 			tgptr->tg_ndep = 0;  2 			/* Read target tokens until reaching a newline,( 			DEPENDENCY, or DEFINE_MACRO token. */   			prevtok = NULL;' 			while (tokptr->mt_text[1] != '\0' || ) 			    ((c = *tokptr->mt_text) != '\n' && / 			    c != DEPENDENCY && c != DEFINE_MACRO)) { ! 				if (tgptr->tg_name == NULL) {  					tgptr->tg_name = tokptr;  				}  				prevtok = tokptr;  				tokptr = tokptr->mt_next;  				if (tokptr == NULL) {  #ifdef VMS_ERROR  					lib$signal(&Mak_nodepch, 5, 					    1, &DEPENDENCY," 					    FAO_AD(prevtok->mt_text), 					    prevtok->mt_line);  					lib$signal(&Mak_unexpeof);  #else 8 					printf("  ** Expected '%c' after '%s', line %d.\n",9 					    DEPENDENCY, prevtok->mt_text, prevtok->mt_line); ; 					printf("  ** End of file not preceded by newline.\n");  #endif 					parse_error = TRUE; 					break;  				}  			} 			if (tokptr == NULL) {
 				break; 			} 			if (prevtok != NULL) {  				prevtok->mt_next = NULL; 			}  * 			/* Decide what to do next based on what# 			token ended target name list. */    			alttok = tokptr;  			tokptr = tokptr->mt_next; 			alttok->mt_next = NULL;" 			switch (c = *alttok->mt_text) {
 			case '\n':  #ifdef VMS_ERROR! 				lib$signal(&Mak_depneeded, 3, * 				    1, &DEPENDENCY, prevtok->mt_line); #else F 				printf("  ** Missing '%c' on line %d; inserted at end of line.\n",& 				    DEPENDENCY, prevtok->mt_line); #endif 				parse_error = TRUE; & 				tokptr = free_first_token(tokptr); 				parse_state = P_GET_CMD;
 				break; 			case ' ': 			case DEPENDENCY:  			case DEFINE_MACRO:  				if (tokptr == NULL) {  					if (c == ' ') { #ifdef VMS_ERROR" 						lib$signal(&Mak_invblank, 1, 						    alttok->mt_line);  #else F 						printf("  ** Blank invalid in target specification, line %d.\n", 						    alttok->mt_line);  #endif" 					} else if (c == DEPENDENCY) { #ifdef VMS_ERROR  						lib$signal(&Mak_depeof, 3, 						    1, &DEPENDENCY,  						    alttok->mt_line);  #else I 						printf("  ** No dependencies or commands after '%c' on line %d.\n", ' 						    DEPENDENCY, alttok->mt_line);  #endif
 					} else {  #ifdef VMS_ERROR# 						lib$signal(&Mak_notextmac, 3, # 						    FAO_AD(prevtok->mt_text),  						    prevtok->mt_line); #else 6 						printf("  ** No text for macro '%s', line %d\n",. 						    prevtok->mt_text, prevtok->mt_line); #endif 					} 					parse_error = TRUE; 					break;  				}  				if (c == DEPENDENCY) {) 					parse_state = P_GET_DEPENDENCY_LIST;  				} else {$ 					parse_state = P_GET_MACRO_TEXT; 				} 
 				break; 			default: I 				printf("FATAL ERROR, line %d: target name list terminated at '%s'\n", * 				    alttok->mt_line, alttok->mt_text); 				make_exit(NORMAL_EXIT);  			} 			free_token(alttok);	 			break;   = 		/* This state is reached after reading the DEPENDENCY token ; 		in a target definition.  It reads all following names, up = 		to a newline, into the dependency list for the target being > 		created.  DEPENDENCY and DEFINE_MACRO tokens are not allowed9 		in the dependency list.  On entry, tokptr is set to the 9 		first token after the DEPENDENCY in the input list, and 8 		tgptr points to a MAKE_TARGET which has been given the/ 		list of targets the dependencies apply to. */    		case P_GET_MACRO_TEXT: 		case P_GET_DEPENDENCY_LIST:  			if (tgptr == NULL) { 6 				printf("FATAL ERROR, tgptr is NULL in P_GET_%s\n",. 				    parse_state == P_GET_DEPENDENCY_LIST ?* 				    "DEPENDENCY_LIST" : "MACRO_TEXT"); 				make_exit(NORMAL_EXIT);  			} 			prevtok = NULL;= 			while (tokptr != NULL && (c = *tokptr->mt_text) != '\n') { % 				if (tokptr->mt_text[1] == '\0' && 1 				    (c == DEPENDENCY || c == DEFINE_MACRO)) {   					errptr = "dependency list";+ 					if (parse_state == P_GET_MACRO_TEXT) {  						errptr = "macro text"; 					} #ifdef VMS_ERROR% 					lib$signal(&Mak_invch, 5, 1, &c, * 					    FAO_AD(errptr), tokptr->mt_line); #else > 					printf("  ** '%c' invalid in %s, on line %d; deleted.\n",% 					    c, errptr, tokptr->mt_line);  #endif 					parse_error = TRUE;' 					tokptr = free_first_token(tokptr);  					if (prevtok != NULL) {   						prevtok->mt_next = tokptr; 					} 				} else {! 					if (tgptr->tg_dep == NULL) {  						tgptr->tg_dep = tokptr;  					} 					prevtok = tokptr; 					tokptr = tokptr->mt_next; 				}  			}   			if (tokptr == NULL) { #ifdef VMS_ERROR 				lib$signal(&Mak_unexpeof); #else : 				printf("  ** End of file not preceded by newline.\n"); #endif 				parse_error = TRUE; 
 				break; 			} 			if (prevtok != NULL) {  				prevtok->mt_next = NULL; 			}% 			tokptr = free_first_token(tokptr); ) 			if (parse_state == P_GET_MACRO_TEXT) {   				parse_state = P_CHECK_MACRO; 			} else {  				parse_state = P_GET_CMD; 			}	 			break;    		case P_CHECK_MACRO: 1 			experr = macro_expand(tgptr->tg_name, *mlptr); ) 			if (tgptr->tg_name->mt_next != NULL) {  #ifdef VMS_ERROR" 				lib$signal(&Mak_multmacdef, 1,! 				    tgptr->tg_name->mt_line);  #else E 				printf("  ** More than one name in macro definition, line %d.\n", ! 				    tgptr->tg_name->mt_line);  #endif 				parse_error = TRUE;  				free_target(tgptr); % 			} else if (experr != EXP_SIMPLE) {   				if (experr == EXP_SPECIAL) { #ifdef VMS_ERROR  					lib$signal(&Mak_specdef, 1," 					    tgptr->tg_name->mt_line); #else = 					printf("  ** Redefinition of special macro, line %d.\n", " 					    tgptr->tg_name->mt_line); #endif 				}  				parse_error = TRUE;  				free_target(tgptr); 4 			} else if (macro_expand(tgptr->tg_dep, *mlptr) ==/ 			    EXP_ERROR || !macro_add(tgptr, mlptr)) {  				parse_error = TRUE;  				free_target(tgptr);  			} 			tgptr = NULL; 			parse_state = P_START_LINE;	 			break;   > 		/* This state is reached after reading a dependency line and? 		any associated command lines.  It expands any named macros in A 		the dependency or command lines and error checks the result. */    		case P_EXPAND_TARGET:  			if (tgptr == NULL) {  #ifdef PARSE_DEBUG; 				printf("FATAL ERROR:  tgptr is NULL on entering %s.\n", # 				    P_state_name[parse_state]);  #endif 				make_exit(NORMAL_EXIT);  			}1 			experr = macro_expand(tgptr->tg_name, *mlptr);  			if (experr == EXP_SPECIAL) {  #ifdef VMS_ERROR0 				lib$signal(&Mak_spectarg, 3, FAO_AD("name"),! 				    tgptr->tg_name->mt_line);  #else @ 				printf("  ** Special macro used in target name, line %d.\n",! 				    tgptr->tg_name->mt_line);  #endif 				parse_error = TRUE;  				free_target(tgptr); ' 			} else if (tgptr->tg_name == NULL) {  #ifdef VMS_ERROR 				lib$signal(&Mak_notarg, 1,! 				    tgptr->tg_name->mt_line);  #else 3 				printf("  ** No target name given, line %d.\n", ! 				    tgptr->tg_name->mt_line);  #endif 				parse_error = TRUE;  				free_target(tgptr); $ 			} else if (experr == EXP_ERROR ||: 			    macro_expand(tgptr->tg_dep, *mlptr) == EXP_ERROR ||8 			    cmd_expand(tgptr->tg_cmd, *mlptr) == EXP_ERROR) { 				parse_error = TRUE;  				free_target(tgptr); 5 			} else if (save_target(tgptr, rlptr, tlptr) < 0) {  				parse_error = TRUE;  			} 			tgptr = NULL; 			parse_state = P_START_LINE;	 			break;   ; 		/* This state is reached after reading a dependency line. ; 		It checks to see if the next line is a command line which 8 		tells how to update the target.  If the next line is a< 		command line, it changes state to read the line, otherwise< 		the current target is completely read, so it changes state 		to expand and save it. */    		case P_GET_CMD: 6 			if (tokptr != NULL && tokptr->mt_text[1] == '\0' &&, 			    *tokptr->mt_text == BEGIN_CMD_LINE) {& 				tokptr = free_first_token(tokptr);  				if (tgptr->tg_cmd == NULL) { 					prevcmd = NULL; 				} ! 				parse_state = P_GET_CMD_FLAG;  			} else { " 				parse_state = P_EXPAND_TARGET; 			}	 			break;   ? 		/* This state is reached after finding a BEGIN_CMD_LINE after 7 		a newline.  It reads the rest of the command line. */    		case P_GET_CMD_FLAG:" 			cmdptr = E_ALLOC(MAKE_COMMAND);. 			cmdptr->cmd_next = cmdptr->cmd_word = NULL; 			cmdptr->cmd_flag = 0;' 			while (tokptr->mt_text[1] == '\0') {  				c = *tokptr->mt_text;  				if (c == MC_IGN_ERROR) {' 					cmdptr->cmd_flag |= CMD_IGN_ERROR; ! 				} else if (c == MC_NO_ECHO) { % 					cmdptr->cmd_flag |= CMD_NO_ECHO;  				} else if (c == '\n') {  #ifdef VMS_ERROR 					lib$signal(&Mak_nocmd, 1, 					    tokptr->mt_line); #else 1 					printf("  ** No command text on line %d.\n",  					    tokptr->mt_line); #endif; /* this could be made a warning only */	parse_error = TRUE; ' 					tokptr = free_first_token(tokptr);  					parse_state = P_GET_CMD;  					free(cmdptr); 					cmdptr = NULL;  					break;  				} else { 					break;  				} & 				tokptr = free_first_token(tokptr); 			}  0 			/* Check for error during flag processing. */   			if (cmdptr == NULL) {
 				break; 			}  ; 			/* Get words in command.  First token is not newline. */    			prevtok = NULL; 			cmdptr->cmd_word = tokptr; 7 			while (tokptr != NULL && *tokptr->mt_text != '\n') {  				prevtok = tokptr;  				tokptr = tokptr->mt_next;  			} 			prevtok->mt_next = NULL;  			if (tokptr != NULL) {& 				tokptr = free_first_token(tokptr); 			}  6 			/* Append latest command to current MAKE_TARGET. */   			if (prevcmd == NULL) {  				tgptr->tg_cmd = cmdptr;  			} else {  				prevcmd->cmd_next = cmdptr;  			} 			prevcmd = cmdptr; 			cmdptr = NULL;   8 			/* Change state to check for another command line. */   			parse_state = P_GET_CMD; 	 			break;   
 		default:9 			printf("FATAL ERROR, line %d: bad parser state %d.\n", % 			    tokptr->mt_line, parse_state);  			make_exit(NORMAL_EXIT); 		}  	}  6 	/* See if any errors were found in the token list. */   	if (parse_error) {  		return (-1); 	} 	return (0); }   I /* The target pointed to by tgptr contains no named macros (they have all J been previously expanded.  It may contain special macros.  The target nameC list may contain more than one file name, and/or more than one rule G definition.  This routine splits these multiple target definitions into J single target/rule definitions and merges them with any previously created target/rule definitions. */    static  save_target(tgptr, rlptr, tlptr) MAKE_TARGET *tgptr;  MAKE_TARGET **rlptr, **tlptr;  { & 	register MAKE_TOKEN *nmptr, *nextptr; 	int target_type;  	MAKE_COMMAND *cmd;  	MAKE_TARGET *newtg;  G 	/* Create a new target for each valid name in the target name list. */   ? 	for (nmptr = tgptr->tg_name; nmptr != NULL; nmptr = nextptr) {   : 		/* Detach first target name token from list of names. */   		nextptr = nmptr->mt_next;  		nmptr->mt_next = NULL;  ( 		/* Check for errors in target name. */  < 		target_type = check_tname(nmptr->mt_text, nmptr->mt_line);  + 		/* If error found in name, don't save. */   ! 		if (target_type < STMT_ERROR) {  			return (-1);  		}   : 		/* Since name is valid, perform final clean-up on it. */   		char_process(nmptr, FALSE);    		/* Create new MAKE_TARGET. */    		newtg = E_ALLOC(MAKE_TARGET);  		newtg->tg_name = nmptr;  		newtg->tg_cmd = NULL;  		newtg->tg_next = NULL;  3 		/* Copy dependency list and expand special macros ) 		in it using the current target name. */   A 		new_copy_token(tgptr->tg_dep, &newtg->tg_dep, &newtg->tg_ndep); # 		if (expand_special(newtg->tg_dep, + 		    newtg->tg_name, NULL) == EXP_ERROR) {  			return (-1);  		} % 		char_process(newtg->tg_dep, FALSE);   < 		/* Copy update commands and expand special macros in them 7 		using the current target name and dependency list. */   . 		new_copy_cmd(tgptr->tg_cmd, &newtg->tg_cmd);  0 		/* Save target or rule in appropriate list. */  # 		if (target_type == STMT_TARGET) { % 			if (cmd_exp_special(newtg->tg_cmd, 5 			    newtg->tg_name, newtg->tg_dep) != EXP_ERROR) { # 				add_target(newtg, tlptr, TRUE);  			} else {  #ifdef VMS_ERROR" 				lib$signal(&Mak_cmdspecexp, 3,( 				    FAO_AD(newtg->tg_name->mt_text),! 				    newtg->tg_name->mt_line);  #else Y 				printf("  ** Error expanding special macros in command line of target %s, line %d\n", : 				    newtg->tg_name->mt_text, newtg->tg_name->mt_line); #endif 				return (-1); 			}
 		} else {# 			add_target(newtg, rlptr, FALSE);  		}e 	} 	return (0);	/* success */ }s  K /* Scan the name of a target.  Return STMT_ERROR if it is invalid (containscJ a macro), STMT_TARGET if it is an ordinary target name, or STMT_RULE if it' is a default rule target (.xxx.yyy). */n   static check_tname(tname, line) char *tname;	 int line;M {1 	register char *namestr;* 	int prev_literal, first_ch_rule, is_rule;  8 	/* Make sure target name has at least one character. */  ' 	if (tname == NULL || *tname == '\0') {  #ifdef VMS_ERROR% 		lib$signal(&Mak_notgname, 1, line);  #elser5 		printf("  ** No name in target, line %d.\n", line);  #endif 		return (STMT_ERROR); 	}   	/* Scan the name. */M   	prev_literal = FALSE; 	namestr = tname;p 	is_rule = FALSE;*. 	first_ch_rule = (*namestr == FILE_TYPE_CHAR); 	if (first_ch_rule) {s 		namestr++; 	} 	while (*namestr) {U 		switch (*namestr) {d 		case INVOKE_MACRO: 			if (prev_literal) {
 				break; 			} #ifdef VMS_ERROR5 			lib$signal(&Mak_spectarg, 3, FAO_AD(tname), line);" #elsep: 			printf("  ** Special macro in target '%s', line %d.\n", 			    tname, line); #endif 			return (STMT_ERROR);m	 			break;i 		case FILE_TYPE_CHAR: 			if (prev_literal) {
 				break; 			} 			if (first_ch_rule) {d 				is_rule = TRUE;  			}	 			break;  		}a= 		prev_literal = !prev_literal && (*namestr == NEXT_LITERAL);p= 		namestr++;	/* SAM 880517 corrects bug in literals on VMS */i 	}, 	return (is_rule ? STMT_RULE : STMT_TARGET); },  J /* Copy the list of commands pointed to by srctrg.  Allocate space for theH copy and set the command pointer pointed to by dsttrgptr to point at the new list. */  " new_copy_target(srctrg, dsttrgptr) MAKE_TARGET *srctrg; MAKE_TARGET **dsttrgptr; {  	register MAKE_TARGET *dsttrg;   	*dsttrgptr = NULL;] 	while (srctrg != NULL) { - 		dsttrg = *dsttrgptr = E_ALLOC(MAKE_TARGET);r 		dsttrg->tg_next = NULL;r: 		new_copy_token(srctrg->tg_name, &dsttrg->tg_name, NULL);1 		new_copy_token(srctrg->tg_dep, &dsttrg->tg_dep,a 		    &dsttrg->tg_ndep);0 		new_copy_cmd(srctrg->tg_cmd, &dsttrg->tg_cmd); 		dsttrgptr = &dsttrg->tg_next;  		srctrg = srctrg->tg_next;p 	} }U  J /* Copy the list of commands pointed to by srccmd.  Allocate space for theH copy and set the command pointer pointed to by dstcmdptr to point at the new list. */   new_copy_cmd(srccmd, dstcmdptr)  MAKE_COMMAND *srccmd;) MAKE_COMMAND **dstcmdptr;e {f 	register MAKE_COMMAND *dstcmd;*   	*dstcmdptr = NULL;w 	while (srccmd != NULL) { . 		dstcmd = *dstcmdptr = E_ALLOC(MAKE_COMMAND); 		dstcmd->cmd_next = NULL;& 		dstcmd->cmd_flag = srccmd->cmd_flag;5 		new_copy_token(srccmd->cmd_word, &dstcmd->cmd_word,D 		    &dstcmd->cmd_length);g  		dstcmdptr = &dstcmd->cmd_next; 		srccmd = srccmd->cmd_next; 	} }g  G /* Copy the list of tokens pointed to by srctk.  Allocate space for the	E copy and set the token pointer pointed to by dsttkptr to point at thee new list. */  ' new_copy_token(srctk, dsttkptr, lenptr)i MAKE_TOKEN *srctk; MAKE_TOKEN **dsttkptr; LISTLEN *lenptr; {r 	register MAKE_TOKEN *dsttk;   	*dsttkptr = NULL; 	if (lenptr != NULL) { 		*lenptr = 0; 	} 	while (srctk != NULL) {* 		dsttk = *dsttkptr = E_ALLOC(MAKE_TOKEN); 		dsttk->mt_next = NULL;. 		dsttk->mt_text = newstr(srctk->mt_text, -1);& 		dsttk->mt_simple = srctk->mt_simple;" 		dsttk->mt_line = srctk->mt_line; 		if (lenptr != NULL) {	 			*(lenptr)++;R 		}  		dsttkptr = &dsttk->mt_next;o 		srctk = srctk->mt_next;e 	} }t  G /* Append a new target to the target list.  If the target is already inuF the list, don't add the new one, but merge the dependency lists if the merge argument is non-zero. */   static! add_target(ntptr, listptr, merge)G MAKE_TARGET *ntptr;e MAKE_TARGET **listptr;
 int merge; {r 	register MAKE_COMMAND *cmd;( 	register MAKE_TARGET *otptr, *prevtptr;  5 	/* Perform final processing on command line text. */u  > 	for (cmd = ntptr->tg_cmd; cmd != NULL; cmd = cmd->cmd_next) {5 		cmd->cmd_flag |= char_process(cmd->cmd_word, TRUE);_ 	}  = 	/* Scan list to see if new target was defined previously. */t   	prevtptr = NULL; @ 	for (otptr = *listptr; otptr != NULL; otptr = otptr->tg_next) {& 		if (COMPARE(ntptr->tg_name->mt_text,& 		    otptr->tg_name->mt_text) == 0) { 			if (otptr->tg_cmd == NULL) {o" 				otptr->tg_cmd = ntptr->tg_cmd; 			} 			if (merge) {), 				merge_dep(ntptr->tg_dep, &otptr->tg_dep, 				    &otptr->tg_ndep);g 			}
 			return; 		}  		prevtptr = otptr;  	}   	/* Add new target to list. */   	if (prevtptr == NULL) { 		ntptr->tg_next = *listptr; 		*listptr = ntptr;R	 	} else {b 		ntptr->tg_next = NULL; 		prevtptr->tg_next = ntptr; 	} }O  L /* Merge the list of tokens pointed to by new into the list whose address isM pointed to by old.  Set the length of the resulting list in the value pointed  to by lenptr. */   merge_dep(new, old, lenptr)) MAKE_TOKEN *new; MAKE_TOKEN **old;  LISTLEN *lenptr; {n 	MAKE_TOKEN *ocurr, *oprev;r   	while (new != NULL) { 		oprev = NULL;  		ocurr = *old;{B 		while (ocurr != NULL && COMPARE(ocurr->mt_text, new->mt_text)) { 			oprev = ocurr;	 			ocurr = ocurr->mt_next; 		}o 		if (ocurr == NULL) { 			ocurr = new->mt_next; 			if (oprev == NULL) {k 				new->mt_next = *old; 				*old = new;= 			} else {i" 				new->mt_next = oprev->mt_next; 				oprev->mt_next = new;  			} 			if (lenptr != NULL) { 				(*lenptr)++; 			} 			new = ocurr;i
 		} else { 			new = new->mt_next; 		}c 	} }n  ? /* Delete all instances of single NEXT_LITERALs.  Convert pairs_> of NEXT_LITERALs into single NEXT_LITERALs.  If a command line? is passed, scan for leading command control characters, and fors= a trailing '-' (the DCL line continuation character).  Returno# the flags for this command line. */{   char_process(tokptr, is_cmd) register MAKE_TOKEN *tokptr; int is_cmd;t {n! 	register int cmdflag, startline;a 	register char *str, *copy;a  
 	cmdflag = 0;, 	startline = TRUE;3 	for (; tokptr != NULL; tokptr = tokptr->mt_next) {{ 		copy = str = tokptr->mt_text;n 		while (*str) { 			if (startline) {D 				if (*str == MC_IGN_ERROR) {) 					cmdflag |= CMD_IGN_ERROR; 					str++;s 					continue;$ 				} else if (*str == MC_NO_ECHO) { 					cmdflag |= CMD_NO_ECHO; 					str++;} 					continue; 				} else { 					startline = FALSE;t 				}  			} 			if (*str == NEXT_LITERAL) { 				if (*++str == '\0') {e 					break;	 				}n 			} 			*copy++ = *str++; 		}l 		*copy = '\0';	 	}( 	if (is_cmd && *--copy == MC_CONTINUE) { 		cmdflag |= CMD_CONTINUE; 	} 	return (cmdflag); }	