 /*         REPORT_LISTEN_TABLE   J         This program reads a LISTEN_TABLE file and produces reports on its         contents.     COPYRIGHT NOTICE   4  This software is COPYRIGHT  1997,2005, Ian Miller.  3  Released under licence described in aaareadme.txt      DISCLAIMER   J  This software is provided "AS IS". The author makes no representations orN  warranties with respect to the software and specifically disclaim any impliedE  warranties of merchantability or fitness for any particular purpose.    History	 =======   ' 26-Jun-1997 I.Miller  V1.0-000	Created  ; 30-Jun-1997 I.Miller  V1.0-001	Add basic IP address report. @ 16-Sep-1997 I.Miller  V1.0-002  Add basic DECnet address report. */   #define VERSION "V1.0-002"
 #if __DECC* #pragma module REPORT_LISTEN_TABLE VERSION #else $ #module REPORT_LISTEN_TABLE VERSION  #endif   #include <stdio.h> #include <stdlib.h>  #include <string.h>  #include <unixio.h>  #include <file.h>  #include <descrip.h> #include <starlet.h> #include "ethernet.h"  #include "listen_table.h"  #include "sysid.h" #include "listen_subs.h"  2 /* local data used for reporting workgroups     */2 /* one node                                     */ typedef struct   { B         int inuse;              /* true if this entry in use    */B         char workgroup[16];     /* workgroup name               */B         char pcname[256];       /* PC name                      */B         char username[256];     /* usernames                    */ } WNODE;   static WNODE wnodes[MAX_NODES];  static int wnode_count;   + /* local data used for IP address report	*/  typedef struct   {  	int node_index;- 	unsigned char ip_address[LT_ADDRESS_IP_LEN];  } INODE;- static INODE inodes[MAX_NODES*MAX_ADDRESSES];  static int inode_count;   2 /* local data used for DECnet address report    */ typedef struct   {  	int node_index;5 	unsigned char decnet_address[LT_ADDRESS_DECNET_LEN];  } DNODE;- static DNODE dnodes[MAX_NODES*MAX_ADDRESSES];  static int dnode_count;    /* local functions	*/ . static void output_report_header(FILE *fpOut);+ static void report_workgroups(FILE *fpOut); % static void collect_workgroups(void); + static void output_workgroups(FILE *fpOut); - static void display_wnode(FILE *fpOut,int i); # static void report_ip(FILE *fpOut);  static void collect_ip(void); # static void output_ip(FILE *fpOut); ' static void report_decnet(FILE *fpOut); ! static void collect_decnet(void); ' static void output_decnet(FILE *fpOut);     int main(int argc, char *argv[]) {  	char outfile[256];          FILE *fpOut;   	/* get name of output file	*/ 	if (argc > 1) 	{ 		strcpy(outfile,argv[1]); 	} 	else  	{% 		printf("Enter output filename : ");  		gets(outfile); 		if (outfile[0] == '\0')  		{ 3 			strcpy(outfile,"TT:");	/* default to terminal */  		}  	}
 	puts(" \n");  	/* open output file		*// 	fpOut = fopen(outfile,"w","rfm=var","rat=cr");  	if (fpOut == NULL)  	{' 		perror("Failed to open output file");  		exit (1);  	}	   *         /* load up the node table       */         read_table();   *         /* report header                */$         output_report_header(fpOut);  *         /* report on workgroups         */!         report_workgroups(fpOut);   ! 	/* report on IP address usage	*/  	report_ip(fpOut);         # 	/* report on DECnet addresses   */  	report_decnet(fpOut);                  fclose(fpOut); }    static void ! output_report_header(FILE *fpOut)  { .         fprintf(fpOut,"REPORT generated at ");%         display_datetime(fpOut,NULL);          fputc('\n',fpOut); }    static void  report_workgroups(FILE *fpOut) {   +         memset(wnodes,'\0',sizeof(wnodes));          wnode_count = 0;           collect_workgroups();          if (wnode_count > 0))                 output_workgroups(fpOut);    }   B /* loop though the nodes collecting the info about workgroups   */ static void  collect_workgroups(void) {          int n,i,j;  "         /* look at all nodes    */%         for (n=0; n < MAX_NODES; n++) 	         { $                 if (!nodes[n].inuse)                         break;Q                 /* first scan the names for this node looking for the workgroup*/ -                 for (j=0; j < MAX_NAMES; j++)                  { E                         if (nodes[n].names[j].type == LT_NAME_UNUSED) &                                 break;I                         if ((nodes[n].names[j].type == LT_NAME_WORKGROUP) I                         ||  (nodes[n].names[j].type == LT_NAME_NETBIOSG))                          { E                                 memcpy(wnodes[wnode_count].workgroup, C                                         nodes[n].names[j].name,15); I                                 wnodes[wnode_count].workgroup[15] = '\0';                          }                  } 2                 /* now look for the PC name     */-                 for (j=0; j < MAX_NAMES; j++)                  { E                         if (nodes[n].names[j].type == LT_NAME_UNUSED) &                                 break;F                         if (nodes[n].names[j].type == LT_NAME_NETBUEI)                         { H                                 if ((nodes[n].names[j].name[15] == 0x00)k                                 &&  (memcmp(nodes[n].names[j].name,wnodes[wnode_count].workgroup,15) != 0)) !                                 { Z                                         /* type 0 name different from workgroup name    */O                                         if (wnodes[wnode_count].pcname[0] != 0) )                                         { T                                                 strtrim(wnodes[wnode_count].pcname);W                                                 strcat(wnodes[wnode_count].pcname,","); )                                         } J                                         strcat(wnodes[wnode_count].pcname,H                                                 nodes[n].names[j].name);!                                 }                          }                  } 2                 /* now if we found a pc name    */:                 if (wnodes[wnode_count].pcname[0] != '\0')                 { :                         /* check for any usernames      */5                         for (j=0; j < MAX_NAMES; j++)                          { M                                 if (nodes[n].names[j].type == LT_NAME_UNUSED) .                                         break;N                                 if (nodes[n].names[j].type == LT_NAME_NETBUEI)!                                 { P                                         if ((nodes[n].names[j].name[15] == 0x03)p                                         &&  (memcmp(nodes[n].names[j].name,wnodes[wnode_count].pcname,15) != 0)))                                         { `                                                 /* type 3 name different from pc name name    */Y                                                 if (wnodes[wnode_count].username[0] != 0) 1                                                 { ^                                                         strtrim(wnodes[wnode_count].username);a                                                         strcat(wnodes[wnode_count].username,","); 1                                                 } T                                                 strcat(wnodes[wnode_count].username,P                                                         nodes[n].names[j].name);)                                         } !                                 }                          } >                         strtrim(wnodes[wnode_count].username);9                         wnodes[wnode_count].inuse = TRUE; &                         wnode_count++;                 }                  else                 { :                         wnodes[wnode_count].inuse = FALSE;                 } 	         }  }    static void  output_workgroups(FILE *fpOut) {          int n,i;i         static const char *hdr1="Address           PC Name                                  Usernames\n"; i         static const char *hdr2="-------           -------                                  ---------\n";   '         for (n=0; n < wnode_count; n++) 	         { $                 if (wnodes[n].inuse)                 { Q                         fprintf(fpOut,"\n\nWorkgroup: %s\n",wnodes[n].workgroup); ,                         fprintf(fpOut,hdr1);,                         fprintf(fpOut,hdr2);/                         display_wnode(fpOut,n); 0                         wnodes[n].inuse = FALSE;7                         for (i=0; i < wnode_count; i++)                          { 5                                 if ((wnodes[i].inuse) ^                                 &&  (memcmp(wnodes[i].workgroup,wnodes[n].workgroup,15) == 0))!                                 { ?                                         display_wnode(fpOut,i); @                                         wnodes[i].inuse = FALSE;!                                 }                          }                  } 	         }  }    static void   display_wnode(FILE *fpOut,int i) { *         display_addr(fpOut,nodes[i].addr);         fputc(' ',fpOut); 3         fprintf(fpOut,"%-40.40s",wnodes[i].pcname);          fputc(' ',fpOut); 1         fprintf(fpOut,"%s\n",wnodes[i].username);  }   
 static int& cmp_inode(const void *a,const void *b) { 
 	INODE *x,*y;    	x = (INODE *)a; 	y = (INODE *)b;  @ 	return (memcmp(x->ip_address,y->ip_address,LT_ADDRESS_IP_LEN)); }    static void  report_ip(FILE *fpOut) { F         static const char *hdr1="IP Address	IP Name			Node Address\n";G         static const char *hdr2="----------	-------			-------------\n";    	inode_count = 0;  	collect_ip();   	if (inode_count != 0) 	{ 		/* sort by IP address	*/< 		qsort((void *)inodes,inode_count,sizeof(INODE),cmp_inode);   		/* output IP addresses	*/  		fputc('\f',fpOut); 		fputc('\n',fpOut); 		fprintf(fpOut,hdr1); 		fprintf(fpOut,hdr2);   		output_ip(fpOut);  	} }    static void  collect_ip(void) { 	 	int n,i;   "         /* look at all nodes    */%         for (n=0; n < MAX_NODES; n++) 	         { $                 if (!nodes[n].inuse)                         break;  # 		for (i=0; i < MAX_ADDRESSES; i++)  		{ 3 			if (nodes[n].addresses[i].type == LT_ADDRESS_IP)  			{' 				inodes[inode_count].node_index = n; * 				memcpy(inodes[inode_count].ip_address,  					nodes[n].addresses[i].addr, 					LT_ADDRESS_IP_LEN); 				inode_count++; 			} 		}  	} }    static void  output_ip(FILE *fpOut) {  	int i;  	char name[256];    	for (i=0; i < inode_count; i++) 	{1 		display_ip_address(fpOut,inodes[i].ip_address);  		name[0] = '\0'; ) 		get_ip_name(inodes[i].ip_address,name); % 		fprintf(fpOut,"\t%-30.30s\t",name); > 	        display_addr(fpOut,nodes[inodes[i].node_index].addr);/ 		fprintf(fpOut,"(%d)\n",inodes[i].node_index);  	} }   
 static int& cmp_dnode(const void *a,const void *b) { 
 	DNODE *x,*y;    	x = (DNODE *)a; 	y = (DNODE *)b;  L 	return (memcmp(x->decnet_address,y->decnet_address,LT_ADDRESS_DECNET_LEN)); }    static void  report_decnet(FILE *fpOut) { +         static const char *hdr0="DECnet\n"; L         static const char *hdr1="Address Name	Node Index      HW Address\n";N         static const char *hdr2="------- ------	----------      ----------\n";   	dnode_count = 0;  	collect_decnet();   	if (dnode_count != 0) 	{ 		/* sort by address	*/ < 		qsort((void *)dnodes,dnode_count,sizeof(DNODE),cmp_dnode);   		/* output DECnet addresses	*/  		fputc('\f',fpOut); 		fputc('\n',fpOut); 		fprintf(fpOut,hdr0); 		fprintf(fpOut,hdr1); 		fprintf(fpOut,hdr2);   		output_decnet(fpOut);  	} }    static void  collect_decnet(void) { 	 	int n,i;   "         /* look at all nodes    */%         for (n=0; n < MAX_NODES; n++) 	         { $                 if (!nodes[n].inuse)                         break;  # 		for (i=0; i < MAX_ADDRESSES; i++)  		{ 7 			if (nodes[n].addresses[i].type == LT_ADDRESS_DECNET)  			{' 				dnodes[dnode_count].node_index = n; . 				memcpy(dnodes[dnode_count].decnet_address,  					nodes[n].addresses[i].addr, 					LT_ADDRESS_DECNET_LEN); 				dnode_count++; 			} 		}  	} }    static void  output_decnet(FILE *fpOut) { 	 	int i,j;  	char name[256];         unsigned short dnet; 	unsigned char hw_addr[6];    	for (i=0; i < dnode_count; i++) 	{M                 memcpy(&dnet,dnodes[i].decnet_address,LT_ADDRESS_DECNET_LEN); $ 		display_dnet_address(fpOut,&dnet);1 		fprintf(fpOut,"\t%-6.6s\t",get_nodename(dnet)); + 		fprintf(fpOut,"%d",dnodes[i].node_index);                  if (get_hw_address(nodes[dnodes[i].node_index].mop_sysid,nodes[dnodes[i].node_index].mop_sysid_length,hw_addr))                  { *                         fputc('\t',fpOut);*                         fputc('\t',fpOut);4                         display_addr(fpOut,hw_addr);/                         j = find_node(hw_addr); #                         if (j >= 0) 8                                 fprintf(fpOut,"(%d)",j);                 } "                 fputc('\n',fpOut); 	} } 