#include	<stdio.h>			/* standard I/O definitions */
#include	<descrip.h>			/* descriptor definitions */
#include	<ssdef.h>			/* system service definitions */
#include	<varargs.h>			/* variable arguments */

/*
 *	Send "To:" list to remote node
 *
 *	mai$ax_to_list		Text of the "To:" list to display at remote end
 *	mai$ax_node		Node name from address (to the right of the
 *				'%') if a '::' was found, else a blank string
 *
 * Return: System service code for success/failure
 *
 */

PROTO_OUT_TO(
	long	*mai$al_context,		/* Context field for protocol */
	long	mai$l_operation,		/* LNK_C_OUT_TO	*/
	va_list	arglist)			/* remainder of arguments */
{
	struct	dsc$descriptor *mai$ax_node ;	/* Node to connect to */
	struct	dsc$descriptor *mai$ax_to_list ;/* To: list */

	mai$ax_node =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;
	mai$ax_to_list =
	  (struct dsc$descriptor *) va_arg(arglist, struct dsc$descriptor *) ;

	printf( "* Operation type = %d (LNK_C_OUT_TO)\n", mai$l_operation );
	printf( "  Context field  = 0x%08x\n", *mai$al_context );
	printf( "  Node name      = %.*s\n", mai$ax_node->dsc$w_length, mai$ax_node->dsc$a_pointer );
	printf( "  To:            = %.*s\n", mai$ax_to_list->dsc$w_length, mai$ax_to_list->dsc$a_pointer );

	return(SS$_NORMAL) ;			/* Return success to caller */
}
